/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.EventListenerList;

public class RadioButtonPanel
extends JPanel {
    private ButtonGroup _buttons = new ButtonGroup();
    private ActionListener _listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RadioButtonPanel.this.setSelection(RadioButtonPanel.this.getSelectedItem());
        }
    };
    private EventListenerList _listeners = new EventListenerList();
    private Object _selection;

    public RadioButtonPanel(Object[] options) {
        super(new FlowLayout(0, 5, 2));
        for (Object object : options) {
            if (object == null) continue;
            AbstractButton button = this.createButton(object);
            this._buttons.add(button);
            this.add(button);
        }
        if (options.length > 0) {
            this.setSelectedItem(options[0]);
        }
    }

    private void setSelection(Object selectedItem) {
        if (!(this._selection == selectedItem || this._selection != null && selectedItem != null && selectedItem.equals(this._selection))) {
            this.fireValueChanged();
            this._selection = selectedItem;
        }
    }

    protected void fireValueChanged() {
        ActionEvent e = new ActionEvent(this, 0, "selected");
        for (ActionListener listener : (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
            listener.actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener listener) {
        this._listeners.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this._listeners.remove(ActionListener.class, listener);
    }

    private AbstractButton createButton(Object value) {
        ObjectButton button = new ObjectButton(value);
        button.addActionListener(this._listener);
        return button;
    }

    public void setSelectedItem(Object item) {
        this._selection = item;
        if (item == null) {
            this._buttons.clearSelection();
        } else {
            Enumeration<AbstractButton> e = this._buttons.getElements();
            while (e.hasMoreElements()) {
                ObjectButton button = (ObjectButton)e.nextElement();
                if (!button.getData().equals(item)) continue;
                button.setSelected(true);
                return;
            }
        }
    }

    public Object getSelectedItem() {
        Object[] selection = this._buttons.getSelection().getSelectedObjects();
        if (selection == null || selection.length == 0) {
            return null;
        }
        return ((ObjectButton)selection[0]).getData();
    }

    private static class ObjectButton
    extends JRadioButton {
        private Object _data;

        public ObjectButton(Object data) {
            super(data.toString());
            this._data = data;
        }

        public Object getData() {
            return this._data;
        }

        public void setData(Object data) {
            this._data = data;
        }
    }
}

