/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.collections;

import com.paterva.maltego.util.collections.CompoundIterator;
import java.util.Collection;
import java.util.Iterator;

public class CompoundReadonlyCollection<T>
implements Collection<T> {
    private Collection<T>[] _collections;

    public CompoundReadonlyCollection(Collection<T> ... collections) {
        this._collections = collections;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<T> c : this._collections) {
            size += c.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> c : this._collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int index = 0;
        for (Collection<T> c : this._collections) {
            Object[] cArray = c.toArray();
            CompoundReadonlyCollection.copy(cArray, array, index);
            index += cArray.length;
        }
        return array;
    }

    private static <T> void copy(T[] src, T[] dest, int start) {
        System.arraycopy(src, 0, dest, start, src.length);
    }

    @Override
    public <A> A[] toArray(A[] a) {
        int index = 0;
        for (Collection<T> c : this._collections) {
            Object[] cArray = c.toArray();
            CompoundReadonlyCollection.copy(cArray, a, index);
            index += cArray.length;
        }
        return a;
    }

    @Override
    public void clear() {
    }

    @Override
    public Iterator<T> iterator() {
        return new CompoundIterator<T>(this._collections);
    }

    @Override
    public boolean add(T e) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> collection : this._collections) {
            if (!collection.contains(o)) continue;
            return true;
        }
        return false;
    }
}

