/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table;

import com.paterva.maltego.graph.table.HeaderTypeOptions;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.TabularGraphUtils;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TabularGraph {
    public static final String PROP_ENTITY_ADDED = "entityAdded";
    public static final String PROP_ENTITY_REMOVED = "entityRemoved";
    public static final String PROP_ENTITY_UPDATED = "entityUpdated";
    public static final String PROP_LINK_ADDED = "linkAdded";
    public static final String PROP_LINK_REMOVED = "linkRemoved";
    public static final String PROP_LINK_UPDATED = "linkUpdated";
    public static final String PROP_COLUMN_ADDED = "columnAdded";
    public static final String PROP_COLUMN_REMOVED = "columnRemoved";
    public static final String PROP_COLUMN_NAMES = "columnNamesChanged";
    public static final String PROP_HAS_HEADERS = "hasHeaderRowChanged";
    public static final String NEW_MAPPING_NAME = "New mapping";
    private final PropertyChangeSupport _support = new PropertyChangeSupport(this);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract boolean isExisting();

    public abstract void setExisting(boolean var1);

    public abstract Date getSavedDate();

    public abstract void setSavedDate(Date var1);

    public abstract List<TabularGraphEntity> getEntities();

    public abstract List<TabularGraphLink> getLinks();

    public abstract Map<String, Set<String>> getTypeStrictProperties();

    public abstract void putEntityWithProperty(String var1, int[] var2, PropertyDescriptor[] var3);

    public abstract void putEntity(String var1, int ... var2);

    public abstract void putEntity(TabularGraphEntity var1);

    public abstract void putLink(TabularGraphLink var1);

    public abstract void addColumns(TabularGraphLink var1, int ... var2);

    public abstract void removeLink(TabularGraphLink var1);

    public abstract void removeColumnsFromEntities(int ... var1);

    public abstract void removeColumnsFromLinks(int ... var1);

    public abstract int getColumnCount();

    public abstract void setColumnCount(int var1);

    public abstract String[] getColumnNames();

    public abstract void setColumnNames(String[] var1);

    public abstract boolean isReadOnly();

    public abstract void setReadOnly(boolean var1);

    public abstract boolean hasHeaderRow();

    public abstract int getHeaderRowIndex();

    public abstract boolean hasTypeRow();

    public abstract int getTypeRowIndex();

    public abstract HeaderTypeOptions getHeaderTypeOption();

    public abstract void setHeaderTypeOptions(HeaderTypeOptions var1);

    public abstract TabularGraphLink findLink(TabularGraphEntity var1, TabularGraphEntity var2);

    public int getDataStartRowIndex() {
        int dataStartIndex = 0;
        dataStartIndex += this.hasHeaderRow() ? 1 : 0;
        return dataStartIndex += this.hasTypeRow() ? 1 : 0;
    }

    public boolean isCopyOf(TabularGraph graph) {
        return TabularGraphUtils.isEqual(this, graph);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._support.removePropertyChangeListener(pcl);
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._support.firePropertyChange(property, oldValue, newValue);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TabularGraph other = (TabularGraph)obj;
        return !(this.getName() != null ? !this.getName().equals(other.getName()) : other.getName() != null);
    }
}

