/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.labels;

import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelDescriptor;
import java.io.IOException;
import org.openide.filesystems.FileObject;

class EntityPropertyLabelReader {
    private static final String ATTR_PROPERTY = "property";
    private static final String ATTR_MODEL = "model";
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_FONT = "font";
    private static final String ATTR_COLOR = "color";

    EntityPropertyLabelReader() {
    }

    public EntityPropertyLabelDescriptor read(FileObject entityLabel) throws IOException {
        EntityPropertyLabelDescriptor descriptor = new EntityPropertyLabelDescriptor();
        descriptor.setProperty(this.readString(entityLabel, ATTR_PROPERTY, false));
        descriptor.setModel(this.readString(entityLabel, ATTR_MODEL, false));
        descriptor.setPosition(this.readString(entityLabel, ATTR_POSITION, false));
        descriptor.setFont(this.readString(entityLabel, ATTR_FONT, true));
        descriptor.setColor(this.readString(entityLabel, ATTR_COLOR, true));
        return descriptor;
    }

    private String readString(FileObject entityLabel, String attrName, boolean optional) throws IOException {
        Object attribute = entityLabel.getAttribute(attrName);
        String attrStr = null;
        if (attribute == null) {
            if (!optional) {
                throw new IOException("Missing \"" + attrName + "\" attribute for entity property label descriptor.");
            }
        } else if (attribute instanceof String) {
            attrStr = (String)attribute;
            if (attrStr.isEmpty()) {
                throw new IOException("Attribute \"" + attrName + "\" for entity property label descriptor may not be empty.");
            }
        } else {
            throw new IOException("Attribute \"" + attrName + "\" for entity property label descriptor should be of type string.");
        }
        return attrStr;
    }
}

