/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.BookmarkUtils;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.LabelViewMode;
import java.util.Collections;
import java.util.Set;
import org.openide.awt.StatusDisplayer;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.gB;

public class BookmarkClickViewMode
extends LabelViewMode {
    public boolean isOverLabel(U view, double x2, double y2) {
        return this.getLabel(view, x2, y2, 3) != null;
    }

    public void mouseReleasedLeft(double x2, double y2) {
        super.mouseReleasedLeft(x2, y2);
        gB label = this.getLabel(this.view, x2, y2, 3);
        if (label != null) {
            this.bookmarkClicked(label);
        }
        this.reactivateParent();
    }

    private void bookmarkClicked(gB label) {
        int newBookmark;
        Y yNode = label.getNode();
        SA graph2D = label.getGraph2D();
        MaltegoEntity entity = this.getEntity(yNode);
        BookmarkFactory bookmarkFactory = BookmarkFactory.getDefault();
        int oldBookmark = entity.getBookmark();
        if (this.lastReleaseEvent.isControlDown()) {
            newBookmark = bookmarkFactory.getPrevious(oldBookmark);
        } else {
            newBookmark = bookmarkFactory.getNext(oldBookmark);
            if (newBookmark < 0) {
                StatusDisplayer.getDefault().setStatusText("Hint: hold <Ctrl> to cycle bookmarks in reverse");
            }
        }
        GraphID graphID = GraphIDProvider.forGraph((SA)graph2D);
        if (!graph2D.g(yNode)) {
            Set<MaltegoEntity> entities = Collections.singleton(entity);
            GraphTransactionHelper.doChangeBookmark(graphID, entities, newBookmark);
        } else {
            BookmarkUtils.setBookmarkForSelection(graphID, newBookmark);
        }
        this.view.getGraph2D().\u0107();
    }

    private MaltegoEntity getEntity(Y yNode) {
        return MaltegoGraphManager.getWrapper((D)yNode.H()).entity(yNode);
    }
}

