/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.ctc.wstx.stax.WstxInputFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.ui.graph.imex.StaxEntityReader;
import com.paterva.maltego.ui.graph.imex.StaxHelper;
import com.paterva.maltego.ui.graph.imex.StaxLinkReader;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openide.util.Exceptions;
import yguard.A.A.Y;

public class StaxGraphReader {
    private static final Logger LOG = Logger.getLogger(StaxGraphReader.class.getName());
    private static final int BATCH_SIZE = 10000;
    private final GraphID _graphID;
    private final EntityFactory _entityFactory;
    private final Map<String, EntityID> _nodeEntityMap = new HashMap<String, EntityID>();
    private final List<EntityNode> _entityBatch = new ArrayList<EntityNode>();
    private final List<LinkEdge> _linkBatch = new ArrayList<LinkEdge>();
    private GraphStore _graphStore;
    private GraphLayoutWriter _layoutWriter;
    private XMLStreamReader _staxReader;
    private StaxEntityReader _entityReader;
    private StaxLinkReader _linkReader;

    public StaxGraphReader(GraphID graphID, EntityFactory entityFactory) {
        this._graphID = graphID;
        this._entityFactory = entityFactory;
        try {
            this._graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            this._layoutWriter = this._graphStore.getGraphLayoutStore().getLayoutWriter();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void read(InputStream is) throws IOException {
        try {
            this._graphStore.beginUpdate();
            WstxInputFactory inputFactory = new WstxInputFactory();
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this._staxReader = inputFactory.createXMLStreamReader(is);
            this._entityReader = new StaxEntityReader(this._staxReader, this._entityFactory);
            this._linkReader = new StaxLinkReader(this._staxReader);
            if (StaxHelper.skipToElement(this._staxReader, "graph")) {
                this.readGraph();
            }
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        finally {
            this._graphStore.endUpdate();
        }
    }

    private void readGraph() throws XMLStreamException, IOException {
        do {
            this._staxReader.next();
            if (!this._staxReader.isStartElement()) continue;
            this.readGraphChild();
        } while (!StaxHelper.isEndElement(this._staxReader, "graph"));
        this.flushEntities();
        this.flushLinks();
    }

    private void readGraphChild() throws XMLStreamException, IOException {
        String name;
        switch (name = this._staxReader.getLocalName()) {
            case "node": {
                EntityNode entityNode = this.readNode();
                this.handleEntityNode(entityNode);
                break;
            }
            case "edge": {
                this.flushEntities();
                LinkEdge linkEdge = this.readEdge();
                this.handleLinkEdge(linkEdge);
            }
        }
    }

    private void handleEntityNode(EntityNode entityNode) {
        this._entityBatch.add(entityNode);
        if (this._entityBatch.size() >= 10000) {
            this.flushEntities();
        }
    }

    private void flushEntities() {
        if (!this._entityBatch.isEmpty()) {
            ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(this._entityBatch.size());
            HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>(this._entityBatch.size());
            for (EntityNode entityNode : this._entityBatch) {
                MaltegoEntity entity = entityNode.getEntity();
                EntityID entityID = (EntityID)entity.getID();
                entities.add(entity);
                Point2D.Double center = entityNode.getCenter();
                centers.put(entityID, new Point((int)center.x, (int)center.y));
                this._nodeEntityMap.put(entityNode.getNodeID(), entityID);
            }
            GraphStoreWriter.addEntities((GraphID)this._graphID, entities);
            try {
                this._layoutWriter.setCenters(centers);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this._entityBatch.clear();
        }
    }

    public static Map<MaltegoEntity, Y> getNodes(GraphWrapper wrapper, Collection<MaltegoEntity> entities) {
        HashMap<MaltegoEntity, Y> map = new HashMap<MaltegoEntity, Y>(entities.size());
        for (MaltegoEntity entity : entities) {
            map.put(entity, wrapper.node((EntityID)entity.getID()));
        }
        return map;
    }

    private void handleLinkEdge(LinkEdge linkEdge) {
        this._linkBatch.add(linkEdge);
        if (this._linkBatch.size() >= 10000) {
            this.flushLinks();
        }
    }

    private void flushLinks() {
        if (!this._linkBatch.isEmpty()) {
            HashMap<MaltegoLink, LinkEntityIDs> links = new HashMap<MaltegoLink, LinkEntityIDs>(this._linkBatch.size());
            for (LinkEdge linkEdge : this._linkBatch) {
                MaltegoLink link = linkEdge.getLink();
                String edgeID = linkEdge.getEdgeID();
                String sourceNodeID = linkEdge.getSourceNodeID();
                EntityID sourceID = this._nodeEntityMap.get(sourceNodeID);
                if (sourceID == null) {
                    LOG.log(Level.SEVERE, "No source ({0}) for link: {1}/{2}", new Object[]{sourceNodeID, edgeID, link.getID()});
                    continue;
                }
                String targetNodeID = linkEdge.getTargetNodeID();
                EntityID targetID = this._nodeEntityMap.get(targetNodeID);
                if (targetID == null) {
                    LOG.log(Level.SEVERE, "No source ({0}) for link: {1}/{2}", new Object[]{targetNodeID, edgeID, link.getID()});
                    continue;
                }
                links.put(link, new LinkEntityIDs(sourceID, targetID));
            }
            GraphStoreWriter.addLinks((GraphID)this._graphID, links);
            this._linkBatch.clear();
        }
    }

    private EntityNode readNode() throws XMLStreamException, IOException {
        String nodeID = StaxHelper.getRequiredAttribute(this._staxReader, "id");
        MaltegoEntity entity = null;
        Point2D.Double center = null;
        do {
            String name;
            int event;
            if ((event = this._staxReader.next()) != 1) continue;
            switch (name = this._staxReader.getLocalName()) {
                case "MaltegoEntity": {
                    entity = this._entityReader.readEntity();
                    break;
                }
                case "EntityRenderer": {
                    center = this._entityReader.readEntityRenderer();
                }
            }
        } while (!StaxHelper.isEndElement(this._staxReader, "node"));
        return new EntityNode(nodeID, entity, center);
    }

    private LinkEdge readEdge() throws IOException, XMLStreamException {
        String edgeID = StaxHelper.getRequiredAttribute(this._staxReader, "id");
        String sourceNodeID = StaxHelper.getRequiredAttribute(this._staxReader, "source");
        String targetNodeID = StaxHelper.getRequiredAttribute(this._staxReader, "target");
        MaltegoLink link = null;
        do {
            this._staxReader.next();
            if (!StaxHelper.isStartElement(this._staxReader, "MaltegoLink")) continue;
            link = this._linkReader.readLink();
        } while (!StaxHelper.isEndElement(this._staxReader, "edge"));
        if (link == null) {
            link = LinkFactory.getDefault().createInstance(MaltegoLinkSpec.getManualSpec(), false);
        }
        return new LinkEdge(edgeID, sourceNodeID, targetNodeID, link);
    }

    private static class LinkEdge {
        private final String _edgeID;
        private final String _sourceNodeID;
        private final String _targetNodeID;
        private final MaltegoLink _link;

        public LinkEdge(String edgeID, String sourceNodeID, String targetNodeID, MaltegoLink link) {
            this._edgeID = edgeID;
            this._sourceNodeID = sourceNodeID;
            this._targetNodeID = targetNodeID;
            this._link = link;
        }

        public String getEdgeID() {
            return this._edgeID;
        }

        public String getSourceNodeID() {
            return this._sourceNodeID;
        }

        public String getTargetNodeID() {
            return this._targetNodeID;
        }

        public MaltegoLink getLink() {
            return this._link;
        }
    }

    private static class EntityNode {
        private final String _nodeID;
        private final MaltegoEntity _entity;
        private final Point2D.Double _center;

        public EntityNode(String nodeID, MaltegoEntity entity, Point2D.Double center) {
            this._nodeID = nodeID;
            this._entity = entity;
            this._center = center;
        }

        public String getNodeID() {
            return this._nodeID;
        }

        public MaltegoEntity getEntity() {
            return this._entity;
        }

        public Point2D.Double getCenter() {
            return this._center;
        }
    }
}

