/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.windows.TopComponent;
import yguard.A.J.U;

public class MouseGraphUtils {
    private MouseGraphUtils() {
    }

    public static Point2D.Double getMouseOrCenterPoint() {
        GraphViewCookie cookie;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null && (cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null) {
            return MouseGraphUtils.getMouseOrCenterPoint(cookie);
        }
        return null;
    }

    public static Point2D.Double getMouseOrCenterPoint(GraphViewCookie cookie) throws HeadlessException {
        Point2D.Double point = null;
        JComponent viewControl = cookie.getGraphView().getViewControl();
        if (viewControl.isShowing() && viewControl instanceof U) {
            double baseY;
            double baseX;
            U view = (U)viewControl;
            Point cursorPosition = MouseInfo.getPointerInfo().getLocation();
            Point min = viewControl.getLocationOnScreen();
            Rectangle bounds = viewControl.getBounds();
            bounds.translate(min.x, min.y);
            if (!bounds.contains(cursorPosition)) {
                SwingUtilities.convertPointFromScreen(min, viewControl);
                baseX = view.toWorldCoordX(min.x + bounds.width / 2);
                baseY = view.toWorldCoordY(min.y + bounds.height / 2);
            } else {
                SwingUtilities.convertPointFromScreen(cursorPosition, viewControl);
                baseX = view.toWorldCoordX(cursorPosition.x);
                baseY = view.toWorldCoordY(cursorPosition.y);
            }
            point = new Point2D.Double(baseX, baseY);
        }
        return point;
    }
}

