/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.licensing.ApiKeyProvider;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.rest.A;
import com.paterva.maltego.seeds.api.HubSeedBadge;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedHelp;
import com.paterva.maltego.seeds.api.HubSeedIcon;
import com.paterva.maltego.seeds.api.HubSeedPricing;
import com.paterva.maltego.seeds.api.HubSeedProvider;
import com.paterva.maltego.seeds.api.HubSeedRegistration;
import com.paterva.maltego.seeds.api.HubSeedTag;
import com.paterva.maltego.seeds.api.HubSeedTagType;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.json.JsonHubBadge;
import com.paterva.maltego.seeds.api.json.JsonHubFiltersResponse;
import com.paterva.maltego.seeds.api.json.JsonHubInput;
import com.paterva.maltego.seeds.api.json.JsonHubItem;
import com.paterva.maltego.seeds.api.json.JsonHubResponse;
import com.paterva.maltego.seeds.api.json.JsonHubTag;
import com.paterva.maltego.seeds.api.json.JsonHubUrl;
import com.paterva.maltego.seeds.api.registry.HubProvider;
import com.paterva.maltego.seeds.api.serialize.HubSeedReader;
import com.paterva.maltego.seeds.api.test.TestHubJson;
import com.paterva.maltego.seeds.api.test.TestHubXml;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListInputDescriptor;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.Version;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseModeHubProvider
extends HubProvider {
    private static final Logger LOG = Logger.getLogger(LicenseModeHubProvider.class.getName());
    private final ObjectMapper mapper = new ObjectMapper();
    private final int timeoutMillis = 20000;

    public HubSeeds getHubSeeds() {
        LOG.info("Loading Maltego Data Hub");
        CloudAuth cloudAuth = CloudAuth.getDefault();
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        if (licenseMode.L() || licenseMode.U()) {
            if (cloudAuth.isAuthorized()) {
                return this.getHubFromJson(cloudAuth);
            }
            return null;
        }
        return this.getHubFromXml();
    }

    private HubSeeds getHubFromXml() {
        return ApiKeyProvider.get().map(apiKey -> {
            HubSeeds hubSeeds = null;
            try {
                String hubXml;
                String string = hubXml = TestHubXml.isEnabled() ? TestHubXml.loadXml() : A.E((String)apiKey);
                if (Version.getCurrent().isDevBuild()) {
                    LOG.fine(hubXml);
                }
                HubSeedReader reader = new HubSeedReader();
                hubSeeds = reader.read(hubXml);
                this.hubSeedsValid(hubSeeds);
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            return hubSeeds;
        }).orElse(null);
    }

    private void hubSeedsValid(HubSeeds hubSeeds) throws IOException {
        for (HubSeedDescriptor seed : hubSeeds.getSeeds()) {
            if (seed.getName() == null) {
                throw new IOException("Seed must have a unique name. Display name: " + seed.getDisplayName());
            }
            if (!seed.getGrantedHubSeedUrls().isEmpty() || seed.getRestrictionReason() != null) continue;
            throw new IOException("Seed must have either a URL or a restriction reason. Display name: " + seed.getDisplayName());
        }
    }

    private HubSeeds getHubFromJson(CloudAuth cloudAuth) {
        HubSeeds hubSeeds;
        block13: {
            boolean isDevBuild = Version.getCurrent().isDevBuild();
            hubSeeds = null;
            if (TestHubJson.isEnabled()) {
                try {
                    String hubJson = TestHubJson.loadHubJson();
                    if (isDevBuild) {
                        LOG.fine(hubJson);
                    }
                    JsonHubResponse hubResponse = (JsonHubResponse)this.mapper.readValue(hubJson, JsonHubResponse.class);
                    List<JsonHubItem> hubItems = Optional.ofNullable(hubResponse.geHubItems()).orElse(Collections.emptyList());
                    String hubFilterJson = TestHubJson.loadHubFiltersJson();
                    JsonHubFiltersResponse hubFiltersResponse = (JsonHubFiltersResponse)this.mapper.readValue(hubFilterJson, JsonHubFiltersResponse.class);
                    List<JsonHubTag> hubTags = Optional.ofNullable(hubFiltersResponse.getTags()).orElse(Collections.emptyList());
                    List<JsonHubBadge> hubBadges = Optional.ofNullable(hubFiltersResponse.getBadges()).orElse(Collections.emptyList());
                    hubSeeds = LicenseModeHubProvider.translate(hubItems, hubTags, hubBadges);
                    this.hubSeedsValid(hubSeeds);
                }
                catch (Exception ex) {
                    NormalException.logStackTrace((Throwable)ex);
                }
            } else {
                try {
                    HttpAgent httpAgent = this.createHttpAgent(cloudAuth, MaltegoUrl.getCurrent().getLicenseHubJson() + "?includeRestricted=true&platformVisibility=DESKTOP_CLIENT&sort=sort%2Casc&page=0&size=1000000");
                    httpAgent.doGet();
                    int responseCode = httpAgent.getResponseCode();
                    if (responseCode == 200) {
                        String json = httpAgent.getContentAsString();
                        if (isDevBuild) {
                            LOG.fine(json);
                        }
                        JsonHubResponse hubResponse = (JsonHubResponse)this.mapper.readValue(json, JsonHubResponse.class);
                        List<JsonHubItem> hubItems = Optional.ofNullable(hubResponse.geHubItems()).orElse(Collections.emptyList());
                        try {
                            httpAgent = this.createHttpAgent(cloudAuth, MaltegoUrl.getCurrent().getLicenseHubFilterJson() + "?orderTagsBy=tagType&orderBadgesBy=value");
                            httpAgent.doGet();
                            responseCode = httpAgent.getResponseCode();
                            if (responseCode == 200) {
                                json = httpAgent.getContentAsString();
                                if (isDevBuild) {
                                    LOG.fine(json);
                                }
                                JsonHubFiltersResponse hubFiltersResponse = (JsonHubFiltersResponse)this.mapper.readValue(json, JsonHubFiltersResponse.class);
                                List<JsonHubTag> hubTags = Optional.ofNullable(hubFiltersResponse.getTags()).orElse(Collections.emptyList());
                                List<JsonHubBadge> hubBadges = Optional.ofNullable(hubFiltersResponse.getBadges()).orElse(Collections.emptyList());
                                hubSeeds = LicenseModeHubProvider.translate(hubItems, hubTags, hubBadges);
                                this.hubSeedsValid(hubSeeds);
                                break block13;
                            }
                            LOG.log(Level.WARNING, "Hub filter request returned response code {0}", responseCode);
                        }
                        catch (Exception exHubFilter) {
                            NormalException.logStackTrace((Throwable)exHubFilter);
                        }
                        break block13;
                    }
                    LOG.log(Level.WARNING, "Hub request returned response code {0}", responseCode);
                }
                catch (Exception exHub) {
                    NormalException.logStackTrace((Throwable)exHub);
                }
            }
        }
        return hubSeeds;
    }

    static HubSeeds translate(List<JsonHubItem> hubItems, List<JsonHubTag> hubTags, List<JsonHubBadge> hubBadges) {
        ArrayList<HubSeedDescriptor> seeds = new ArrayList<HubSeedDescriptor>();
        for (JsonHubItem jsonHubItem : hubItems) {
            Object hubTagId22;
            Object grantedSeedUrl22;
            Instant instant;
            HubSeedDescriptor descriptor = new HubSeedDescriptor();
            descriptor.setDescription(jsonHubItem.getDescription());
            descriptor.setDetails(jsonHubItem.getDetails());
            descriptor.setDisplayName(jsonHubItem.getDisplay());
            descriptor.setPreInstall(jsonHubItem.getPreInstall());
            descriptor.setId(jsonHubItem.getId());
            descriptor.setName(jsonHubItem.getName());
            descriptor.setPos(jsonHubItem.getSort());
            descriptor.setRestrictionReason(jsonHubItem.getRestrictedInformation());
            String updatedAt = jsonHubItem.getUpdatedAt();
            long modified = 0L;
            if (updatedAt != null && (instant = Instant.parse(updatedAt)) != null) {
                modified = instant.getEpochSecond() * 1000L;
            }
            descriptor.setModified(modified);
            ArrayList<HubSeedUrl> seedUrls = new ArrayList<HubSeedUrl>();
            for (Object grantedSeedUrl22 : jsonHubItem.getGrantedSeedUrls()) {
                HubSeedUrl seedUrl = new HubSeedUrl((String)grantedSeedUrl22);
                seedUrls.add(seedUrl);
            }
            descriptor.setGrantedHubSeedUrls(seedUrls);
            HubSeedHelp help = new HubSeedHelp();
            grantedSeedUrl22 = jsonHubItem.getUrls().iterator();
            while (grantedSeedUrl22.hasNext()) {
                JsonHubUrl url = (JsonHubUrl)grantedSeedUrl22.next();
                String urlType = url.getUrlType();
                if (urlType.equals("IMAGE_ICON")) {
                    HubSeedIcon icon = new HubSeedIcon();
                    icon.setUrl(url.getUrl());
                    descriptor.setIcon(icon);
                    continue;
                }
                if (urlType.equals("IMAGE_PREVIEW")) {
                    descriptor.setPreviewImageUrl(url.getUrl());
                    continue;
                }
                if (urlType.equals("HELP_MACHINE")) {
                    help.setMachineUrl(url.getUrl());
                    continue;
                }
                if (urlType.equals("HELP_TRANSFORM")) {
                    help.setTransformUrl(url.getUrl());
                    continue;
                }
                if (urlType.equals("PRICING")) {
                    HubSeedPricing pricing = new HubSeedPricing();
                    pricing.setWebsite(url.getUrl());
                    descriptor.setPricing(pricing);
                    continue;
                }
                if (!urlType.equals("REGISTRATION")) continue;
                HubSeedRegistration registration = new HubSeedRegistration();
                registration.setWebsite(url.getUrl());
                descriptor.setRegistration(registration);
            }
            descriptor.setHelp(help);
            ArrayList<HubSeedTag> tags = new ArrayList<HubSeedTag>();
            for (Object hubTagId22 : jsonHubItem.getTagIds()) {
                for (JsonHubTag hubTag : hubTags) {
                    if (!((String)hubTagId22).equals(hubTag.getId())) continue;
                    String tagType = Optional.ofNullable(hubTag.getTagType()).orElse("Default");
                    tags.add(new HubSeedTag(tagType, hubTag.getValue()));
                }
            }
            descriptor.setTags(tags);
            ArrayList<HubSeedBadge> badges = new ArrayList<HubSeedBadge>();
            hubTagId22 = jsonHubItem.getBadgeIds().iterator();
            while (hubTagId22.hasNext()) {
                String hubBadgeId = (String)hubTagId22.next();
                HubSeedBadge badge = new HubSeedBadge();
                for (JsonHubBadge hubBadge : hubBadges) {
                    if (!hubBadgeId.equals(hubBadge.getId())) continue;
                    badge.setBgColor(hubBadge.getBgColor());
                    badge.setFgColor(hubBadge.getFgColor());
                    badge.setLocation(hubBadge.getLocation());
                    badge.setValue(hubBadge.getValue());
                    badges.add(badge);
                }
            }
            descriptor.setBadges(badges);
            if (jsonHubItem.getProvider() != null) {
                HubSeedProvider provider = new HubSeedProvider();
                provider.setName(jsonHubItem.getProvider().getName());
                provider.setWebsite(jsonHubItem.getProvider().getWebsite());
                provider.setEmail(jsonHubItem.getProvider().getEmail());
                provider.setPhone(jsonHubItem.getProvider().getPhone());
                descriptor.setProvider(provider);
            }
            ArrayList<TransformListInputDescriptor> hubInputs = new ArrayList<TransformListInputDescriptor>();
            for (JsonHubInput input : jsonHubItem.getInputs()) {
                TransformListInputDescriptor hubInput = new TransformListInputDescriptor();
                hubInput.setAuth(input.isAuth());
                hubInput.setDisplayName(input.getDisplayName());
                hubInput.setName(input.getName());
                hubInput.setOptional(input.isOptional());
                hubInput.setTypeName(input.getType());
                hubInputs.add(hubInput);
            }
            descriptor.setTransformInputs(hubInputs);
            seeds.add(descriptor);
        }
        Collections.sort(seeds);
        LinkedHashMap<String, HubSeedTagType> tagTypes = new LinkedHashMap<String, HubSeedTagType>();
        for (JsonHubTag hubTag : hubTags) {
            String tagType = Optional.ofNullable(hubTag.getTagType()).orElse("Default");
            if (tagTypes.get(tagType) != null) continue;
            tagTypes.put(tagType, new HubSeedTagType(tagType, tagType));
        }
        if (Version.getCurrent().isDevBuild()) {
            boolean bl;
            boolean bl2 = false;
            HashMap<String, String> urlNamedisplayMap = new HashMap<String, String>();
            for (HubSeedDescriptor seed : seeds) {
                for (HubSeedUrl grantedHubSeedUrl : seed.getGrantedHubSeedUrls()) {
                    String url = grantedHubSeedUrl.getUrl().toLowerCase();
                    String displayName = (String)urlNamedisplayMap.get(url);
                    if (displayName != null) {
                        LOG.log(Level.WARNING, "URL {0} already in hub item {1}", new Object[]{url, displayName});
                        bl = true;
                        continue;
                    }
                    urlNamedisplayMap.put(url, seed.getDisplayName());
                }
            }
            if (bl) {
                throw new IllegalStateException("Multiple hub items contain the same URL");
            }
        }
        return new HubSeeds(seeds, new ArrayList(tagTypes.values()));
    }

    private HttpAgent createHttpAgent(CloudAuth cloudAuth, String urlStr) throws Exception {
        String accessToken = cloudAuth.getAccessTokenString();
        if (accessToken == null) {
            throw new IOException("Access token missing for Maltego ID login");
        }
        URL url = new URL(urlStr);
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(20000);
        httpAgent.setReadTimeout(20000);
        httpAgent.setAccessToken(accessToken);
        return httpAgent;
    }
}

