/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api;

import com.google.gson.annotations.SerializedName;
import com.paterva.maltego.seeds.api.HubSeedBadge;
import com.paterva.maltego.seeds.api.HubSeedHelp;
import com.paterva.maltego.seeds.api.HubSeedIcon;
import com.paterva.maltego.seeds.api.HubSeedPricing;
import com.paterva.maltego.seeds.api.HubSeedProvider;
import com.paterva.maltego.seeds.api.HubSeedRegistration;
import com.paterva.maltego.seeds.api.HubSeedStatistics;
import com.paterva.maltego.seeds.api.HubSeedTag;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListInputDescriptor;
import com.paterva.maltego.util.StringUtilities;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="Seed", strict=false)
public class HubSeedDescriptor
implements Comparable<HubSeedDescriptor> {
    public static final String TRANSFORM_HELP_URL_CONSTANT = "${transformId}";
    public static final String MACHINE_HELP_URL_CONSTANT = "${machineId}";
    private String _fallbackName = null;
    @Attribute(name="HubItemId", required=false)
    @SerializedName(value="HubItemId")
    private String _id;
    @Attribute(name="Name", required=false)
    @SerializedName(value="Name")
    private String _name;
    @Attribute(name="Pos", required=true)
    @SerializedName(value="Pos")
    private int _pos;
    @Attribute(name="Display", required=true)
    @SerializedName(value="Display")
    private String _displayName;
    @Element(name="Url", required=false)
    @SerializedName(value="Url")
    private HubSeedUrl _url;
    @ElementList(name="GrantedHubSeedUrls", type=HubSeedUrl.class, required=false)
    @SerializedName(value="GrantedHubSeedUrls")
    private List<HubSeedUrl> _grantedHubSeedUrls;
    @Element(name="Description", required=false)
    @SerializedName(value="Description")
    private String _description;
    @Element(name="Details", required=false)
    @SerializedName(value="Details")
    private String _details;
    @Element(name="Modified", required=false)
    @SerializedName(value="Modified")
    private long _modified;
    @Element(name="Restricted", required=false)
    @SerializedName(value="Restricted")
    private String _restrictionReason;
    @Element(name="Icon", required=false)
    @SerializedName(value="Icon")
    private HubSeedIcon _icon;
    @Element(name="Provider", required=false)
    @SerializedName(value="Provider")
    private HubSeedProvider _provider;
    @Element(name="Registration", required=false)
    @SerializedName(value="Registration")
    private HubSeedRegistration _registration;
    @Element(name="Pricing", required=false)
    @SerializedName(value="Pricing")
    private HubSeedPricing _pricing;
    @Element(name="Custom", required=false)
    @SerializedName(value="Custom")
    private boolean _custom = false;
    @ElementList(name="Inputs", type=TransformListInputDescriptor.class, required=false)
    @SerializedName(value="Inputs")
    private List<TransformListInputDescriptor> _txinputs;
    @Element(name="PreviewImageUrl", required=false)
    @SerializedName(value="PreviewImageUrl")
    private String _previewImageUrl;
    @Element(name="Help", required=false)
    @SerializedName(value="Help")
    private HubSeedHelp _help;
    @Element(name="Statistics", required=false)
    @SerializedName(value="Statistics")
    private HubSeedStatistics _statistics;
    @ElementList(name="Badges", type=HubSeedBadge.class, required=false)
    @SerializedName(value="Badges")
    private List<HubSeedBadge> _badges;
    @ElementList(name="Tags", type=HubSeedTag.class, required=false)
    @SerializedName(value="Tags")
    private List<HubSeedTag> _tags;
    @Element(name="PreInstall", required=false)
    @SerializedName(value="PreInstall")
    private boolean _preInstall = false;

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getName() {
        if (StringUtilities.isNullOrEmpty((String)this._name)) {
            this.setName(this.generateUrlHash());
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getPos() {
        return this._pos;
    }

    public void setPos(int pos) {
        this._pos = pos;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    @Deprecated
    public void setUrl(HubSeedUrl url) {
        this._url = url;
    }

    public void setGrantedHubSeedUrls(List<HubSeedUrl> grantedHubSeedUrls) {
        this._grantedHubSeedUrls = grantedHubSeedUrls;
    }

    public List<HubSeedUrl> getGrantedHubSeedUrls() {
        if (this._grantedHubSeedUrls == null) {
            this._grantedHubSeedUrls = new ArrayList<HubSeedUrl>();
            if (this._url != null && this._url.getUrl() != null) {
                this._grantedHubSeedUrls.add(this._url);
            }
        }
        return this._grantedHubSeedUrls;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDetails() {
        return this._details;
    }

    public void setDetails(String details) {
        this._details = details;
    }

    public Date getModified() {
        return new Date(this._modified);
    }

    public void setModified(long modified) {
        this._modified = modified;
    }

    public String getRestrictionReason() {
        return this._restrictionReason;
    }

    public void setRestrictionReason(String restrictionReason) {
        this._restrictionReason = restrictionReason;
    }

    public HubSeedIcon getIcon() {
        return this._icon;
    }

    public void setIcon(HubSeedIcon icon) {
        this._icon = icon;
    }

    public void setProvider(HubSeedProvider provider) {
        this._provider = provider;
    }

    public HubSeedProvider getProvider() {
        return this._provider;
    }

    public HubSeedRegistration getRegistration() {
        return this._registration;
    }

    public void setRegistration(HubSeedRegistration registration) {
        this._registration = registration;
    }

    public HubSeedPricing getPricing() {
        return this._pricing;
    }

    public void setPricing(HubSeedPricing pricing) {
        this._pricing = pricing;
    }

    public void setCustom(boolean custom) {
        this._custom = custom;
    }

    public boolean isCustom() {
        return this._custom;
    }

    public void setTransformInputs(List<TransformListInputDescriptor> txinputs) {
        this._txinputs = txinputs;
    }

    public List<TransformListInputDescriptor> getTransformInputs() {
        return this._txinputs;
    }

    public void setPreviewImageUrl(String previewImageUrl) {
        this._previewImageUrl = previewImageUrl;
    }

    public String getPreviewImageUrl() {
        return this._previewImageUrl;
    }

    public void setHelp(HubSeedHelp help) {
        this._help = help;
    }

    public HubSeedHelp getHelp() {
        return this._help;
    }

    public HubSeedStatistics getStatistics() {
        return this._statistics;
    }

    public void setBadges(List<HubSeedBadge> badges) {
        this._badges = badges;
    }

    public List<HubSeedBadge> getBadges() {
        return this._badges != null ? this._badges : Collections.emptyList();
    }

    public void setTags(List<HubSeedTag> tags) {
        this._tags = tags;
    }

    public List<HubSeedTag> getTags() {
        return this._tags != null ? this._tags : Collections.emptyList();
    }

    public void setPreInstall(boolean preInstall) {
        this._preInstall = preInstall;
    }

    public boolean isPreInstall() {
        return this._preInstall;
    }

    @Override
    public int compareTo(HubSeedDescriptor o) {
        if (this.isCustom()) {
            if (!o.isCustom()) {
                return -1;
            }
            return this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
        }
        if (o.isCustom()) {
            return 1;
        }
        return this._pos - o.getPos();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this._name != null ? this._name.hashCode() : 0);
        return hash;
    }

    public boolean isSame(String name, HubSeedUrl url) {
        return this.isSame(name, url != null ? url.getUrl() : null);
    }

    public boolean isSame(String name, String url) {
        if (!StringUtilities.isNullOrEmpty((String)this.getName()) && !StringUtilities.isNullOrEmpty((String)name)) {
            return this.getName().equals(name);
        }
        for (HubSeedUrl seedUrl : this.getGrantedHubSeedUrls()) {
            if (seedUrl == null || seedUrl.getUrl() == null || url == null || !seedUrl.getUrl().equalsIgnoreCase(url)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HubSeedDescriptor other = (HubSeedDescriptor)obj;
        return this.isSame(other.getName(), other.getGrantedHubSeedUrls().isEmpty() ? null : other.getGrantedHubSeedUrls().get(0));
    }

    public String toString() {
        return "{Name:" + this.getName() + ";DisplayName:" + this._displayName + "}";
    }

    private String generateUrlHash() {
        if (this._fallbackName == null) {
            String hash;
            String id = "renamedtransforms" + new Random().nextInt(10000);
            if (this._grantedHubSeedUrls != null && !this._grantedHubSeedUrls.isEmpty()) {
                id = String.join((CharSequence)";", this._grantedHubSeedUrls.stream().map(s -> s.getUrl()).collect(Collectors.toList()));
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] hashBytes = digest.digest(id.getBytes());
                hash = Base64.getEncoder().encodeToString(hashBytes);
                hash = hash.substring(0, Math.min(10, hash.length()));
            }
            catch (NoSuchAlgorithmException ex) {
                hash = id;
            }
            this._fallbackName = hash;
        }
        return this._fallbackName;
    }
}

