/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.matching;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.IdentityProvider;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.util.Utilities;

public interface MatchingRule {
    public static final int MATCH = 1;
    public static final int MISMATCH = -1;
    public static final int INDETERMINATE = 0;
    public static final MatchingRule Id = new Id();
    public static final MatchingRule Type = new Type();
    public static final MatchingRule Value = new Value();
    public static final MatchingRule Default = new Default();
    public static final MatchingRule PropertiesExceptAttachments = new PropertiesExceptAttachments();

    public int getMatch(SpecRegistry var1, TypedPropertyBag var2, TypedPropertyBag var3);

    public static class Filtered
    implements MatchingRule {
        private final Collection<? extends Guid> _noMatchParts;
        private final MatchingRule _delegate;

        public Filtered(MatchingRule delegate, Collection<? extends Guid> noMatchParts) {
            this._noMatchParts = noMatchParts;
            this._delegate = delegate;
        }

        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            if (this.isNoMatchPart(n1) || this.isNoMatchPart(n2)) {
                return -1;
            }
            return this._delegate.getMatch(registry, n1, n2);
        }

        private boolean isNoMatchPart(TypedPropertyBag n1) {
            IdentityProvider id;
            Guid guid;
            return n1 instanceof IdentityProvider && this._noMatchParts.contains(guid = (id = (IdentityProvider)n1).getID());
        }
    }

    public static class PropertiesExceptAttachments
    implements MatchingRule {
        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            PropertyDescriptorCollection p1 = n1.getProperties();
            PropertyDescriptorCollection p2 = n2.getProperties();
            if (p1.size() != p2.size()) {
                return -1;
            }
            for (PropertyDescriptor pd1 : p1) {
                if (pd1 == null || Attachments.class.equals((Object)pd1.getType())) continue;
                PropertyDescriptor pd2 = n2.getProperties().get(pd1.getName());
                if (pd2 != null) {
                    Object v2;
                    Object v1 = n1.getValue(pd1);
                    if (Utilities.compareObjects((Object)v1, (Object)(v2 = n2.getValue(pd2)))) continue;
                    return -1;
                }
                return -1;
            }
            return 1;
        }
    }

    public static class Property
    implements MatchingRule {
        private String _property;

        public Property(String property) {
            this._property = property;
        }

        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            Object v2;
            Object v1;
            PropertyDescriptor pd2;
            PropertyDescriptor pd1 = n1.getProperties().get(this._property);
            if (pd1 != null && (pd2 = n2.getProperties().get(this._property)) != null && (v1 = n1.getValue(pd1)) != null && (v2 = n2.getValue(pd2)) != null) {
                return v1.equals(v2) ? 1 : -1;
            }
            return 0;
        }
    }

    public static class Value
    implements MatchingRule {
        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            Object v1 = InheritanceHelper.getValue((SpecRegistry)registry, (TypedPropertyBag)n1);
            Object v2 = InheritanceHelper.getValue((SpecRegistry)registry, (TypedPropertyBag)n2);
            if (v1 != null) {
                if (v2 != null) {
                    return v1.equals(v2) ? 1 : -1;
                }
                if (StringUtilities.isNullString((Object)v1)) {
                    return 1;
                }
            } else if (v2 == null || StringUtilities.isNullString((Object)v2)) {
                return 1;
            }
            return 0;
        }
    }

    public static class Default
    implements MatchingRule {
        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            int value = Id.getMatch(registry, n1, n2);
            if (value != 1 && (value = Type.getMatch(registry, n1, n2)) == 1) {
                value = Value.getMatch(registry, n1, n2);
            }
            return value;
        }
    }

    public static class And
    implements MatchingRule {
        private MatchingRule[] _rules;

        public And(MatchingRule ... rules) {
            this._rules = rules;
        }

        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            boolean mismatch = false;
            for (MatchingRule rule : this._rules) {
                int value = rule.getMatch(registry, n1, n2);
                if (value == 0) {
                    return 0;
                }
                if (value != -1) continue;
                mismatch = true;
                break;
            }
            if (mismatch) {
                return -1;
            }
            return 1;
        }
    }

    public static class Type
    implements MatchingRule {
        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            return n1.getTypeName().equals(n2.getTypeName()) ? 1 : -1;
        }
    }

    public static class Id
    implements MatchingRule {
        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            if (n1 instanceof IdentityProvider && n2 instanceof IdentityProvider) {
                IdentityProvider id1 = (IdentityProvider)n1;
                IdentityProvider id2 = (IdentityProvider)n2;
                Guid guid1 = id1.getID();
                Guid guid2 = id2.getID();
                if (guid1 == null) {
                    return guid2 == null ? 1 : -1;
                }
                return guid1.equals((Object)guid2) ? 1 : -1;
            }
            return 0;
        }
    }

    public static class TypeToPropertiesMap
    extends TypeMap {
        public void update(String type, Collection<String> strictProperties, boolean matchValue) {
            ArrayList<MatchingRule> rules = new ArrayList<MatchingRule>();
            if (matchValue) {
                rules.add(Value);
            }
            if (strictProperties != null) {
                for (String property : strictProperties) {
                    Property rule = new Property(property);
                    rules.add(rule);
                }
            }
            if (rules.size() > 0) {
                this.put(type, new Layered(new And(rules.toArray(new MatchingRule[rules.size()]))));
            }
        }
    }

    public static class TypeMap
    implements MatchingRule {
        private SortedMap<String, MatchingRule> _map;

        public void put(String type, MatchingRule rule) {
            if (this._map == null) {
                this._map = new TreeMap<String, MatchingRule>();
            }
            this._map.put(type, rule);
        }

        public MatchingRule get(String type) {
            return this._map != null ? (MatchingRule)this._map.get(type) : null;
        }

        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            if (!n1.getTypeName().equals(n2.getTypeName())) {
                return -1;
            }
            if (this._map == null) {
                return 0;
            }
            MatchingRule rule = (MatchingRule)this._map.get(n1.getTypeName());
            if (rule == null) {
                return 0;
            }
            return rule.getMatch(registry, n1, n2);
        }
    }

    public static class Layered
    implements MatchingRule {
        private MatchingRule[] _rules;

        public Layered(MatchingRule ... rules) {
            this._rules = rules;
        }

        @Override
        public int getMatch(SpecRegistry registry, TypedPropertyBag n1, TypedPropertyBag n2) {
            for (MatchingRule rule : this._rules) {
                int value = rule.getMatch(registry, n1, n2);
                if (value == 0) continue;
                return value;
            }
            return 0;
        }
    }
}

