/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io;

import java.util.Objects;

public final class EntityHitCounter
implements Comparable<EntityHitCounter> {
    private final String typeName;
    private int count;

    public EntityHitCounter(String typeName) {
        this.typeName = typeName;
        this.count = 0;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.typeName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityHitCounter other = (EntityHitCounter)obj;
        return Objects.equals(this.typeName, other.typeName);
    }

    @Override
    public int compareTo(EntityHitCounter o) {
        int compareTo = new Integer(this.count).compareTo(o.count) * -1;
        if (compareTo == 0) {
            compareTo = this.typeName.compareTo(o.typeName);
        }
        return compareTo;
    }

    public String toString() {
        return "EntityHitCounter{typeName=" + this.typeName + ", count=" + this.count + '}';
    }
}

