/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.CloudGraphRegistry;
import com.maltego.cloud.data.GraphMetadata;
import com.maltego.cloud.lock.CloudGraphQueryResult;
import com.maltego.cloud.lock.CloudGraphQueryState;
import com.maltego.cloud.lock.CloudGraphQueryUtils;
import com.maltego.cloud.ui.open.CloudGraphOpenAction;
import com.maltego.cloud.ui.open.CloudGraphOpenOperation;
import com.maltego.cloud.ui.open.OpenFromCloudController;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class OpenFromCloudAction
extends SystemAction {
    private static final Logger LOG = Logger.getLogger(OpenFromCloudAction.class.getName());
    private static final boolean TEST_OPENED_FROM_NETBEANS = false;
    private final CloudAuth cloudAuth = CloudAuth.getDefault();
    private String cloudGraphId;
    private String cloudGraphVersion;
    private Boolean editable;

    public OpenFromCloudAction() {
        this.putValue("visible", false);
    }

    public String getName() {
        return "Open From Cloud";
    }

    protected String iconResource() {
        return "com/maltego/cloud/ui/save/SaveToCloud.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    void setCloudGraphId(String cloudGraphId) {
        this.cloudGraphId = cloudGraphId;
    }

    void setCloudGraphVersion(String cloudGraphVersion) {
        this.cloudGraphVersion = cloudGraphVersion;
    }

    void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.cloudAuth.isCloudAuthEnabled()) {
            if (this.cloudGraphId == null) {
                Objects.requireNonNull(this.cloudGraphId, "cloudGraphId must not be null");
                OpenFromCloudController controller = new OpenFromCloudController();
                EditDialogDescriptor descriptor = new EditDialogDescriptor(this.getName(), (WizardDescriptor.Panel)controller);
                Object notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (DialogDescriptor.OK_OPTION.equals(notify)) {
                    this.openFromCloud(controller.getCloudGraphId(), null, null);
                }
            } else {
                String tmpId = this.cloudGraphId;
                this.cloudGraphId = null;
                String tmpVersion = this.cloudGraphVersion;
                this.cloudGraphVersion = null;
                Boolean tmpEditable = this.editable;
                this.editable = null;
                this.openFromCloud(tmpId, tmpEditable, tmpVersion);
            }
        } else {
            new Thread(() -> SwingUtilities.invokeLater(() -> {
                A licenseMode = LicenseManager.A().A(false);
                if (licenseMode.B()) {
                    String msgString = "Currently activated with a License Key. Cloud Graphs require activation with Maltego ID. Please switch to a Maltego ID plan.";
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgString);
                    msg.setMessageType(2);
                    msg.setTitle("Maltego ID Plan Required");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    LOG.log(Level.WARNING, msgString);
                } else if (licenseMode.W()) {
                    String msgString = "Cloud Graph feature only available on the Maltego Beta program.";
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)msgString);
                    msg.setMessageType(2);
                    msg.setTitle("Maltego Beta Program Required");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    LOG.log(Level.WARNING, msgString);
                } else {
                    LOG.log(Level.WARNING, "Cannot open cloud graph - seems to be unlicensed.");
                }
            }), "Cannot Open Cloud Graph").start();
        }
    }

    private void openFromCloud(String cloudGraphIdString, Boolean editable, String cloudGraphVersion) {
        try {
            GraphID maltegoGraphID;
            Objects.requireNonNull(cloudGraphIdString, "cloudGraphId must not be null");
            GraphID cloudGraphID = GraphID.parse((String)cloudGraphIdString);
            if (Boolean.FALSE.equals(editable)) {
                GraphID maltegoVersionGraphID = CloudGraphRegistry.getDefault().getSameVersionOfCloudGraph(cloudGraphID, cloudGraphVersion);
                if (maltegoVersionGraphID != null) {
                    TopComponent topComponent = GraphDataUtils.getTopComponent((GraphID)maltegoVersionGraphID);
                    if (topComponent != null) {
                        topComponent.requestActive();
                        LOG.log(Level.WARNING, "Cloud graph version already open - cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphID, maltegoVersionGraphID});
                        StatusDisplayer.getDefault().setStatusText("Cloud graph version already open");
                    } else {
                        LOG.log(Level.WARNING, "Cloud graph version - open tab not found - cloud ID: {0}, open but not found ID: {1}", new Object[]{cloudGraphID, maltegoVersionGraphID});
                        StatusDisplayer.getDefault().setStatusText("Cloud graph version - open tab not found");
                    }
                    return;
                }
                maltegoGraphID = GraphID.create();
                LOG.log(Level.INFO, "Cloud graph - opening copy as read-only - cloud ID: {0}, new ID: {1}", new Object[]{cloudGraphID, maltegoGraphID});
                StatusDisplayer.getDefault().setStatusText("Cloud graph - opening copy as read-only");
            } else {
                if (GraphStoreRegistry.getDefault().isExistingAndOpen(cloudGraphID)) {
                    TopComponent topComponent = GraphDataUtils.getTopComponent((GraphID)cloudGraphID);
                    if (topComponent != null) {
                        topComponent.requestActive();
                        LOG.log(Level.WARNING, "Cloud graph already open - cloud ID: {0}", cloudGraphID);
                        StatusDisplayer.getDefault().setStatusText("Cloud graph already open");
                    } else {
                        LOG.log(Level.WARNING, "Cloud graph - open tab not found - cloud open but not found ID: {0}", cloudGraphID);
                        StatusDisplayer.getDefault().setStatusText("Cloud graph - open tab not found");
                    }
                    return;
                }
                maltegoGraphID = cloudGraphID;
            }
            new Thread(() -> {
                try {
                    if (!this.cloudAuth.isAuthorized()) {
                        String problemMessage = this.cloudAuth.getProblemMessage(true);
                        throw new Exception("Browser authentication failed - token invalid: " + problemMessage);
                    }
                    this.openFromCloud(maltegoGraphID, cloudGraphID, editable, cloudGraphVersion);
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(() -> {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Cloud graph could not open. " + ex.getMessage()));
                        msg.setMessageType(2);
                        msg.setTitle(this.getName());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        NormalException.logStackTrace((Throwable)ex);
                    });
                }
            }, "Open From Cloud").start();
        }
        catch (GraphStoreException ex) {
            SwingUtilities.invokeLater(() -> {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Error: " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
                msg.setMessageType(0);
                msg.setTitle(this.getName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                NormalException.logStackTrace((Throwable)ex);
            });
        }
    }

    private void openFromCloud(GraphID maltegoGraphID, GraphID cloudGraphId, Boolean editable, String cloudGraphVersion) throws Exception {
        CloudGraphQueryResult queryResult;
        block20: {
            CloudGraphQueryState state;
            block19: {
                if (editable != null) break block19;
                queryResult = CloudGraphQueryUtils.lock((CloudAuth)this.cloudAuth, (GraphID)cloudGraphId);
                editable = false;
                state = queryResult.getQueryState();
                switch (state) {
                    case FAILED: 
                    case ERROR__GRAPH_DOES_NOT_EXIST_YET: {
                        LOG.log(Level.WARNING, state.getMsg() + " Cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphId, maltegoGraphID});
                        throw new IllegalStateException(state.getMsg());
                    }
                    case GRAPH_EXISTS_AND_USER_HAS_LOCK: {
                        editable = true;
                        break;
                    }
                    case ERROR_LOCKPUT__GRAPH_EXISTS_BUT_USER_CANNOT_LOCK1: 
                    case LOCKPUT_GRAPH_EXISTS_BUT_USER_CANNOT_LOCK2: 
                    case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: {
                        if (maltegoGraphID.equals((Object)cloudGraphId)) {
                            maltegoGraphID = GraphID.create();
                            break;
                        }
                        break block20;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
                break block20;
            }
            if (Boolean.TRUE.equals(editable)) {
                queryResult = CloudGraphQueryUtils.findGraph((CloudAuth)this.cloudAuth, (GraphID)cloudGraphId);
                editable = false;
                state = queryResult.getQueryState();
                switch (state) {
                    case FAILED: 
                    case ERROR__GRAPH_DOES_NOT_EXIST_YET: 
                    case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: 
                    case FIND__GRAPH_EXISTS_BUT_NOT_LOCKED: {
                        LOG.log(Level.WARNING, state.getMsg() + " Cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphId, maltegoGraphID});
                        throw new IllegalStateException(state.getMsg());
                    }
                    case GRAPH_EXISTS_AND_USER_HAS_LOCK: {
                        editable = true;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
            } else {
                queryResult = CloudGraphQueryUtils.findGraph((CloudAuth)this.cloudAuth, (GraphID)cloudGraphId);
                state = queryResult.getQueryState();
                switch (state) {
                    case FAILED: 
                    case ERROR__GRAPH_DOES_NOT_EXIST_YET: {
                        LOG.log(Level.WARNING, state.getMsg() + " Cloud ID: {0}, open ID: {1}", new Object[]{cloudGraphId, maltegoGraphID});
                        throw new IllegalStateException(state.getMsg());
                    }
                    case GRAPH_EXISTS_AND_USER_HAS_LOCK: 
                    case GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK: 
                    case FIND__GRAPH_EXISTS_BUT_NOT_LOCKED: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
            }
        }
        try {
            StatusDisplayer.getDefault().setStatusText("Syncing graph...");
            GraphMetadata graphMetadata = queryResult.getGraphMetadata();
            CloudGraph cloudGraph = new CloudGraph(maltegoGraphID, cloudGraphId, cloudGraphVersion, graphMetadata.getName(), editable, null);
            CloudGraphOpenOperation operation = CloudGraphOpenOperation.createFromMetadata(graphMetadata, cloudGraph);
            operation.perform();
            SwingUtilities.invokeLater(() -> {
                try {
                    WindowUtil.showWaitCursor();
                    this.openGraph(cloudGraph);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    WindowUtil.hideWaitCursor();
                }
            });
        }
        catch (Exception ex) {
            this.closeGraphStore(maltegoGraphID);
            if (ex instanceof UserCancelException) {
                NormalException.logStackTrace((Throwable)ex);
            }
            throw ex;
        }
    }

    private void closeGraphStore(GraphID maltegoGraphID) throws GraphStoreException {
        GraphLifeCycleManager.getDefault().fireGraphClosing(maltegoGraphID);
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(maltegoGraphID);
            if (graphStore != null && graphStore.isOpen()) {
                graphStore.close(true);
                GraphLifeCycleManager.getDefault().fireGraphClosed(maltegoGraphID);
            }
        }
        catch (GraphStoreException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
    }

    private void openGraph(CloudGraph cloudGraph) {
        GraphID maltegoGraphID = cloudGraph.getMaltegoGraphID();
        GraphID cloudGraphID = cloudGraph.getCloudGraphId();
        String graphName = cloudGraph.getName();
        CloudGraphOpenAction openAction = (CloudGraphOpenAction)SystemAction.get(CloudGraphOpenAction.class);
        openAction.setGraph(cloudGraph.getMaltegoGraphID(), graphName);
        openAction.performAction();
        if (maltegoGraphID.equals((Object)cloudGraphID)) {
            CloudGraphRegistry.getDefault().addCloudGraph(cloudGraphID, cloudGraph);
            RecentCloudGraphs.getDefault().addCloudGraph(cloudGraphID.toString(), graphName);
        } else {
            CloudGraphRegistry.getDefault().addVersionOfCloudGraph(maltegoGraphID, cloudGraph);
        }
    }
}

