/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.props;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.StringUtilities;

public class CachedPropertiesUtil {
    private CachedPropertiesUtil() {
    }

    public static void updateCachedProperties(SpecRegistry registry, MaltegoPart part) {
        part.setValueString(InheritanceHelper.getValueString((SpecRegistry)registry, (TypedPropertyBag)part));
        part.setDisplayString(CachedPropertiesUtil.getDisplayString(registry, part));
        if (part instanceof MaltegoEntity) {
            MaltegoEntity entity = (MaltegoEntity)part;
            Object imgKey = InheritanceHelper.getImageKey((EntityRegistry)((EntityRegistry)registry), (MaltegoEntity)entity).orElse(null);
            entity.setCachedImageKey(imgKey);
        }
        part.setHasAttachments(Boolean.valueOf(CachedPropertiesUtil.hasAttachments((PropertyBag)part)));
        part.setLabelReadonly(CachedPropertiesUtil.isLabelReadonly(registry, part));
    }

    private static String getDisplayString(SpecRegistry registry, MaltegoPart part) {
        String displayString = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)part);
        if (StringUtilities.isNullOrEmpty((String)displayString) && part instanceof MaltegoLink) {
            displayString = "maltego.link.transform-link".equals(part.getTypeName()) ? "transform" : "link";
        }
        if (displayString == null) {
            displayString = "";
        }
        return displayString;
    }

    public static boolean hasAttachments(PropertyBag propertyBag) {
        for (PropertyDescriptor pd : propertyBag.getProperties()) {
            Attachments atts;
            if (!Attachments.class.equals((Object)pd.getType()) || (atts = (Attachments)propertyBag.getValue(pd)) == null || atts.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean isLabelReadonly(SpecRegistry registry, MaltegoPart part) {
        String dispExpr = InheritanceHelper.getDisplayValueExpression((SpecRegistry)registry, (TypedPropertyBag)part);
        PropertyDescriptor pd = part.getProperties().get(dispExpr);
        return pd != null && pd.isReadonly();
    }
}

