/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.find;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.find.ShowFindBarAction;
import com.paterva.maltego.ui.graph.find.ShowFindBarListViewAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class ShowFindBarActionSingleton
extends SystemAction {
    private static ShowFindBarActionSingleton _instance;

    public ShowFindBarActionSingleton() {
        _instance = this;
    }

    public static synchronized ShowFindBarActionSingleton getInstance() {
        if (_instance != null) {
            return _instance;
        }
        return (ShowFindBarActionSingleton)SystemAction.get(ShowFindBarActionSingleton.class);
    }

    public void register(GraphID graphID, AbstractAction showFindBarAction) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        if (gud.get((Object)(key = showFindBarAction.getClass().getName())) == null) {
            gud.put((Object)key, (Object)showFindBarAction);
        }
    }

    public ShowFindBarAction deregister(GraphID graphID) {
        return (ShowFindBarAction)this.deregister(graphID, ShowFindBarAction.class.getName());
    }

    public AbstractAction deregister(GraphID graphID, AbstractAction showFindBarAction) {
        return this.deregister(graphID, showFindBarAction.getClass().getName());
    }

    public AbstractAction deregister(GraphID graphID, String key) {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID, (boolean)false);
        if (gud != null) {
            return (AbstractAction)gud.remove((Object)key);
        }
        return null;
    }

    public void actionPerformed(ActionEvent e2) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (ShowFindBarActionSingleton.isPaletteInFocus(focusOwner)) {
            KeyEvent ke = new KeyEvent(focusOwner, 400, System.currentTimeMillis(), 0, 0, '\n');
            focusOwner.dispatchEvent(ke);
        } else {
            GraphUserData gud;
            GraphID graphID;
            GraphCookie cookie;
            TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
            if (topmost != null && (cookie = (GraphCookie)topmost.getLookup().lookup(GraphCookie.class)) != null && (graphID = cookie.getGraphID()) != null && (gud = GraphUserData.forGraph((GraphID)graphID, (boolean)false)) != null) {
                String key = ShowFindBarListViewAction.class.getName();
                AbstractAction action = (AbstractAction)gud.get((Object)key);
                if (action != null) {
                    action.actionPerformed(e2);
                } else {
                    key = ShowFindBarAction.class.getName();
                    action = (AbstractAction)gud.get((Object)key);
                    if (action != null) {
                        action.actionPerformed(e2);
                    }
                }
            }
        }
    }

    private static boolean isPaletteInFocus(Component c) {
        String refClassName = "org.netbeans.modules.palette.ui";
        boolean value = false;
        if (c != null) {
            if (c instanceof JComponent && c.getClass().getName().startsWith(refClassName)) {
                value = true;
            } else {
                Container parent = c.getParent();
                if (parent != null && parent instanceof JComponent) {
                    value = parent.getClass().getName().startsWith(refClassName) ? true : ShowFindBarActionSingleton.isPaletteInFocus(parent);
                }
            }
        }
        return value;
    }

    public String getName() {
        return "Find";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

