/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.progress;

import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.image.RotatableImage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.openide.util.ImageUtilities;

public class GearAnimation
extends JPanel {
    private RotatableImage _topImage;
    private RotatableImage _bottomImage;
    private final Image _staticImage;
    private final int _iconSizeSmall24 = IconSize.SMALL.getSize();
    private final Timer _timer;
    private int _degrees;
    private int _degreesIncrement;

    public GearAnimation(int delay, int degreesIncrement) {
        super(null);
        this._degreesIncrement = degreesIncrement;
        this.setOpaque(false);
        Dimension d = new Dimension(8 + this._iconSizeSmall24, 8 + this._iconSizeSmall24);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this._topImage = new RotatableImage(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/MachineTop.png"));
        this._bottomImage = new RotatableImage(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/MachineBottom.png"));
        this._staticImage = ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Machine32.png");
        this._timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GearAnimation.this._degrees = GearAnimation.this._degrees + GearAnimation.this._degreesIncrement;
                GearAnimation.this._degrees = GearAnimation.this._degrees % 360;
                GearAnimation.this._topImage.setRotation(-GearAnimation.this._degrees);
                GearAnimation.this._bottomImage.setRotation(GearAnimation.this._degrees + 10);
                GearAnimation.this.repaint();
            }
        });
        this.add((Component)this._topImage);
        this.add((Component)this._bottomImage);
        this._topImage.setBounds(-2, -2, this._iconSizeSmall24, this._iconSizeSmall24);
        this._bottomImage.setBounds(10, 10, this._iconSizeSmall24, this._iconSizeSmall24);
        this._timer.setInitialDelay(0);
    }

    public void start() {
        this._timer.start();
    }

    public void stop() {
        this._timer.stop();
        this.repaint();
    }

    public void pause() {
        this.stop();
    }

    @Override
    public void paint(Graphics g) {
        if (this._timer.isRunning()) {
            super.paint(g);
        } else {
            g.drawImage(this._staticImage, this.getX(), this.getY(), null);
        }
    }
}

