/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.outline;

import com.paterva.maltego.util.ui.outline.Filterable;
import java.util.Optional;

public class FilterableHierarchySupport
implements Filterable {
    private final Filterable filterable;
    private Optional<Filterable> parent = Optional.empty();
    private Optional<Filterable> child = Optional.empty();

    private FilterableHierarchySupport(Filterable filterable) {
        this.filterable = filterable;
    }

    @Override
    public boolean match(String filter) {
        return this.isParentMatching(filter) || this.filterable.match(filter) || this.isChildMatching(filter);
    }

    private boolean isParentMatching(String filter) {
        return this.parent.isPresent() && this.parent.get().match(filter);
    }

    private boolean isChildMatching(String filter) {
        return this.child.isPresent() && this.child.get().match(filter);
    }

    public static class Builder {
        private final FilterableHierarchySupport support;

        public Builder(Filterable filterable) {
            this.support = new FilterableHierarchySupport(filterable);
        }

        public Builder parent(Filterable parent) {
            this.support.parent = Optional.ofNullable(parent);
            return this;
        }

        public Builder child(Filterable child) {
            this.support.child = Optional.ofNullable(child);
            return this;
        }

        public FilterableHierarchySupport build() {
            return this.support;
        }
    }
}

