/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.options;

import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.options.OptionsContainerPanelController;
import com.paterva.maltego.util.ui.options.OptionsSubPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdesktop.swingx.VerticalLayout;

public abstract class OptionsContainerPanel<T extends OptionsContainerPanelController>
extends JPanel {
    private final List<OptionsSubPanel> subPanelList = new ArrayList<OptionsSubPanel>();

    protected abstract Collection<? extends OptionsSubPanel.Factory> getSubPanelFactories();

    public OptionsContainerPanel(T controller) {
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setGap(10);
        this.setLayout((LayoutManager)verticalLayout);
        Collection<OptionsSubPanel.Factory> factorys = this.getSubPanelFactories();
        Iterator<OptionsSubPanel.Factory> it = factorys.iterator();
        while (it.hasNext()) {
            OptionsSubPanel.Factory factory = it.next();
            Object subPanel = factory.create();
            this.subPanelList.add((OptionsSubPanel)subPanel);
            ((OptionsSubPanel)subPanel).setChangeListener(() -> controller.change());
            ((JComponent)subPanel).setBorder(this.createTitledBorder(((OptionsSubPanel)subPanel).getTitle()));
            this.add((Component)subPanel);
            if (!it.hasNext()) continue;
            this.add(new JSeparator());
        }
    }

    private Border createTitledBorder(String title) {
        MatteBorderLeft matteBorderLeft = new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor"));
        return BorderFactory.createTitledBorder(matteBorderLeft, title);
    }

    public void update() {
        for (OptionsSubPanel subPanel : this.subPanelList) {
            subPanel.update();
        }
    }

    public void applyChange() {
        for (OptionsSubPanel subPanel : this.subPanelList) {
            subPanel.applyChange();
        }
    }
}

