/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.update;

import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import com.paterva.maltego.welcome.update.wizard.UpdateWizardConstants;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class UpdateUtils {
    private static final boolean DEBUG = false;

    public static Collection<UpdateElement> getAvailableUpdates() {
        HashSet<UpdateElement> updateElements = new HashSet<UpdateElement>();
        List updateUnits = UpdateManager.getDefault().getUpdateUnits();
        for (UpdateUnit unit : updateUnits) {
            if (unit.getInstalled() == null || unit.getAvailableUpdates().isEmpty()) continue;
            UpdateElement update = (UpdateElement)unit.getAvailableUpdates().get(0);
            updateElements.add(update);
        }
        System.out.println("Found " + updateElements.size() + " updates.");
        return updateElements;
    }

    public static long getDownloadSize(Collection<UpdateElement> updateElements) {
        long size = 0L;
        for (UpdateElement updateElement : updateElements) {
            size += (long)updateElement.getDownloadSize();
        }
        return size;
    }

    public static void runWizard(WizardDescriptor wd) {
        boolean finish = WizardUtilities.runWizard((WizardDescriptor)wd);
        InstallSupport support = (InstallSupport)wd.getProperty(UpdateWizardConstants.PROP_INSTALL_SUPPORT);
        if (finish) {
            OperationSupport.Restarter restarter = (OperationSupport.Restarter)wd.getProperty(UpdateWizardConstants.PROP_RESTARTER);
            Boolean restartNow = (Boolean)wd.getProperty(UpdateWizardConstants.PROP_RESTART_NOW);
            if (restarter != null && restartNow != null) {
                if (restartNow.booleanValue()) {
                    try {
                        support.doRestart(restarter, null);
                    }
                    catch (OperationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    support.doRestartLater(restarter);
                }
            }
        } else if (support != null) {
            try {
                support.doCancel();
            }
            catch (OperationException operationException) {
                // empty catch block
            }
        }
    }

    public static void debugSleep() {
    }
}

