/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.compact;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.compact.CompactGraphNameMappings;
import com.paterva.maltego.serializers.compact.DeserializedGraph;
import com.paterva.maltego.serializers.compact.stubs.DisplayInfoStub;
import com.paterva.maltego.serializers.compact.stubs.DynamicPropertyStub;
import com.paterva.maltego.serializers.compact.stubs.EntityStub;
import com.paterva.maltego.serializers.compact.stubs.GraphSnippetStub;
import com.paterva.maltego.serializers.compact.stubs.LinkStub;
import com.paterva.maltego.serializers.compact.stubs.PartStub;
import com.paterva.maltego.serializers.compact.stubs.PathStub;
import com.paterva.maltego.serializers.compact.stubs.PositionStub;
import com.paterva.maltego.serializers.compact.stubs.PropertyStub;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;

public class CompactGraphReader {
    private CompactGraphNameMappings _mappings = null;

    public CompactGraphReader(CompactGraphNameMappings mappings) {
        this._mappings = mappings;
    }

    public CompactGraphReader() {
    }

    public DeserializedGraph translate(GraphSnippetStub from, GraphID graphID, boolean createUpdateParts, boolean allowMultipleDeletes) throws GraphSerializationException {
        DeserializedGraph deserializedGraph = new DeserializedGraph();
        EntityRegistry entityRegistry = EntityRegistry.forGraphID((GraphID)graphID);
        Collection<MaltegoEntity> entities = deserializedGraph.getEntities();
        HashMap<EntityID, MaltegoEntity> entityMap = new HashMap<EntityID, MaltegoEntity>();
        HashMap<Integer, MaltegoEntity> entityOrderMap = new HashMap<Integer, MaltegoEntity>();
        Map<String, Map<EntityID, Point>> centers = deserializedGraph.getCenters();
        for (EntityStub es : from.getEntities()) {
            boolean createUpdate = createUpdateParts && es.getID() != null;
            EntityID id = es.getID() != null ? EntityID.parse((String)es.getID()) : EntityID.create();
            MaltegoEntity entity = this.createEntity(id, es.getType(), graphID, createUpdate, allowMultipleDeletes);
            this.translate(es, entity, entityRegistry, graphID, allowMultipleDeletes);
            this.addCenters(centers, entity, es.getCenters());
            entities.add(entity);
            entityMap.put((EntityID)entity.getID(), entity);
            if (es.getNum() != null) {
                entityOrderMap.put(es.getNum(), entity);
            }
            deserializedGraph.add(es, entity);
            Boolean pinned = es.isPinned();
            if (pinned == null) continue;
            deserializedGraph.getGraphSnippet().getPinned().put(id, pinned);
        }
        LinkRegistry linkRegistry = LinkRegistry.getDefault();
        Map<LinkID, LinkEntityIDs> connections = deserializedGraph.getConnections();
        Collection<MaltegoLink> links = deserializedGraph.getLinks();
        Map<String, Map<LinkID, List<Point>>> paths = deserializedGraph.getPaths();
        for (LinkStub ls : from.getLinks()) {
            LinkID linkID;
            MaltegoLink link;
            if (ls.getID() != null && ls.getType() == null && (link = GraphStoreHelper.getLink((GraphID)graphID, (LinkID)(linkID = LinkID.parse((String)ls.getID())))) != null) {
                ls.setType(link.getTypeName());
            }
            if (ls.getType() == null) {
                ls.setType("maltego.link.manual-link");
            }
            boolean createUpdate = createUpdateParts && ls.getID() != null;
            this.convertLinkNames(ls);
            LinkID linkGuid = ls.getID() != null ? LinkID.parse((String)ls.getID()) : LinkID.create();
            MaltegoLink link2 = this.createLink(linkGuid, ls.getType(), graphID, createUpdate, allowMultipleDeletes);
            this.translate(ls, link2, connections, linkRegistry, linkGuid, entityMap, entityOrderMap, graphID, allowMultipleDeletes);
            this.addPaths(paths, link2, ls.getPaths());
            links.add(link2);
            deserializedGraph.add(ls, link2);
        }
        return deserializedGraph;
    }

    public void translate(EntityStub es, MaltegoEntity entity, EntityRegistry entityRegistry, GraphID graphID, boolean allowMultipleDeletes) throws GraphSerializationException {
        String type = es.getType();
        if (type == null && es.getID() != null && !allowMultipleDeletes) {
            EntityID destEntityID = EntityID.parse((String)es.getID());
            if (!this.exists(graphID, destEntityID)) {
                throw new GraphSerializationException("Entity not found with id=" + es.getID(), true);
            }
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                type = dataReader.getEntityType(destEntityID);
            }
            catch (GraphStoreException ex) {
                throw new GraphSerializationException(ex, true);
            }
        }
        List<PropertyStub> props = es.getProperties();
        if (type == null && !props.isEmpty()) {
            throw new GraphSerializationException("Type is required for entity", true);
        }
        if (type != null) {
            DisplayDescriptorCollection descriptors = InheritanceHelper.getAggregatedProperties((SpecRegistry)entityRegistry, (String)type);
            this.copyStaticProperties(es, (MaltegoPart)entity, descriptors);
        }
        this.copyDynamicProperties(es, (MaltegoPart)entity);
        entity.setWeight(es.getWeight());
        entity.setBookmark(es.getBookmark());
        String note = XMLEscapeUtils.unescapeUnicode((String)es.getNoteText());
        if (!StringUtilities.isNullOrEmpty((String)note) || !es.isNoteVisibleSet()) {
            entity.setNotes(note);
        }
        entity.setShowNotes(es.getNoteVisible());
        this.copyDisplayInformation(es, (MaltegoPart)entity);
        this.copyPropertyMappings(es, (MaltegoPart)entity);
    }

    public void translate(LinkStub ls, MaltegoLink link, Map<LinkID, LinkEntityIDs> connections, LinkRegistry linkRegistry, LinkID linkGuid, Map<EntityID, MaltegoEntity> entities, Map<Integer, MaltegoEntity> entityOrderMap, GraphID graphID, boolean allowMultipleDeletes) throws GraphSerializationException {
        String msg;
        String linkId;
        String type = ls.getType();
        if (type == null && ls.getID() != null && !allowMultipleDeletes) {
            LinkID linkID = LinkID.parse((String)ls.getID());
            MaltegoLink destLink = GraphStoreHelper.getLink((GraphID)graphID, (LinkID)linkID);
            if (destLink == null) {
                throw new GraphSerializationException("Link not found with id=" + ls.getID(), true);
            }
            type = destLink.getTypeName();
        }
        List<PropertyStub> props = ls.getProperties();
        if (type == null && !props.isEmpty()) {
            throw new GraphSerializationException("Type is required for link", true);
        }
        if (type != null) {
            DisplayDescriptorCollection descriptors = InheritanceHelper.getAggregatedProperties((SpecRegistry)linkRegistry, (String)type);
            this.copyStaticProperties(ls, (MaltegoPart)link, descriptors);
        }
        this.copyDynamicProperties(ls, (MaltegoPart)link);
        this.copyDisplayInformation(ls, (MaltegoPart)link);
        this.copyPropertyMappings(ls, (MaltegoPart)link);
        link.setReversed(ls.isReversed());
        boolean newLink = ls.getID() == null;
        MaltegoEntity fromEntity = null;
        if (ls.getFrom() != null) {
            EntityID fromID = EntityID.parse((String)ls.getFrom());
            fromEntity = this.getEntity(fromID, entities);
        } else if (ls.getFromN() != null && (fromEntity = entityOrderMap.get(ls.getFromN())) == null) {
            String linkId2 = this.getErrorLinkId(ls);
            String msg2 = String.format("Source entity (%s) not found for link (%s)", ls.getFromN(), linkId2);
            throw new GraphSerializationException(msg2, true);
        }
        if (fromEntity == null) {
            if (newLink) {
                String linkId3 = this.getErrorLinkId(ls);
                String msg3 = String.format("Source entity must be specified for link (%s)", linkId3);
                throw new GraphSerializationException(msg3, true);
            }
            try {
                LinkID linkID = LinkID.parse((String)ls.getID());
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                if (structureReader.exists(linkID)) {
                    EntityID sourceID = structureReader.getSource(linkID);
                    GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                    MaltegoEntity source = dataReader.getEntity(sourceID);
                    fromEntity = new EntityUpdate(source);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        MaltegoEntity toEntity = null;
        if (ls.getTo() != null) {
            EntityID toID = EntityID.parse((String)ls.getTo());
            toEntity = this.getEntity(toID, entities);
        } else if (ls.getToN() != null && (toEntity = entityOrderMap.get(ls.getToN())) == null) {
            linkId = this.getErrorLinkId(ls);
            msg = String.format("Target entity (%s) not found for link (%s)", ls.getToN(), linkId);
            throw new GraphSerializationException(msg, true);
        }
        if (toEntity == null) {
            if (newLink) {
                linkId = this.getErrorLinkId(ls);
                msg = String.format("Target entity must be specified for link (%s)", linkId);
                throw new GraphSerializationException(msg, true);
            }
            try {
                LinkID linkID = LinkID.parse((String)ls.getID());
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                if (structureReader.exists(linkID)) {
                    EntityID targetID = structureReader.getTarget(linkID);
                    GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                    MaltegoEntity target = dataReader.getEntity(targetID);
                    toEntity = new EntityUpdate(target);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (fromEntity != null && toEntity != null) {
            connections.put(linkGuid, new LinkEntityIDs((EntityID)fromEntity.getID(), (EntityID)toEntity.getID()));
        }
    }

    private void convertLinkNames(LinkStub ls) {
        if (this._mappings != null) {
            boolean manualLink = ls.getType().contains("manual");
            ls.setDisplayValueExpression(this._mappings.linkPropNameToLongName(ls.getDisplayValueExpression(), manualLink));
            ls.setValuePropertyName(this._mappings.linkPropNameToLongName(ls.getValuePropertyName(), manualLink));
            for (PropertyStub propertyStub : ls.getProperties()) {
                propertyStub.setName(this._mappings.linkPropNameToLongName(propertyStub.getName(), manualLink));
            }
            for (PropertyStub propertyStub : ls.getDynamicProperties()) {
                propertyStub.setName(this._mappings.linkPropNameToLongName(propertyStub.getName(), manualLink));
            }
            ls.setType(this._mappings.linkTypeNameToLongName(ls.getType()));
        }
    }

    private String getErrorLinkId(LinkStub ls) {
        String linkId = ls.getID();
        if (linkId == null) {
            linkId = ls.getNum() != null ? Integer.toString(ls.getNum()) : "new";
        }
        return linkId;
    }

    private MaltegoLink createLink(LinkID guid, String type, GraphID graphID, boolean createUpdate, boolean allowMultipleDeletes) throws GraphSerializationException {
        if (!createUpdate) {
            if (type == null) {
                throw new GraphSerializationException("Type required for link", true);
            }
            return LinkFactory.forGraphID((GraphID)graphID).createInstance(type, guid, false);
        }
        if (!allowMultipleDeletes && !this.exists(graphID, guid)) {
            throw new GraphSerializationException("Link not found with id=" + guid, true);
        }
        return new LinkUpdate(guid, type);
    }

    private MaltegoEntity createEntity(EntityID guid, String type, GraphID graphID, boolean createUpdate, boolean allowMultipleDeletes) throws GraphSerializationException {
        if (!createUpdate) {
            try {
                if (type == null) {
                    throw new GraphSerializationException("Type required for entity", true);
                }
                return EntityFactory.forGraphID((GraphID)graphID).createInstance(type, false, guid, false);
            }
            catch (TypeInstantiationException ex) {
                throw new GraphSerializationException("Unable to create entity " + type, ex, true);
            }
        }
        if (!allowMultipleDeletes && !this.exists(graphID, guid)) {
            throw new GraphSerializationException("Entity not found with id=" + guid, true);
        }
        return new EntityUpdate(guid, type);
    }

    private boolean exists(GraphID graphID, EntityID entityID) {
        boolean exists = false;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            exists = structureReader.exists(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return exists;
    }

    private boolean exists(GraphID graphID, LinkID linkID) {
        boolean exists = false;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            exists = structureReader.exists(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return exists;
    }

    private void addCenters(Map<String, Map<EntityID, Point>> centers, MaltegoEntity entity, Collection<PositionStub> stubs) {
        for (PositionStub ps : stubs) {
            Map<EntityID, Point> view = this.getOrCreateView(centers, ps.getView());
            view.put((EntityID)entity.getID(), this.parsePoint(ps.getCenter()));
        }
    }

    private void addPaths(Map<String, Map<LinkID, List<Point>>> paths, MaltegoLink link, Collection<PathStub> stubs) {
        for (PathStub ps : stubs) {
            Map<LinkID, List<Point>> view = this.getOrCreatePathView(paths, ps.getView());
            view.put((LinkID)link.getID(), this.parsePath(ps.getPath()));
        }
    }

    private Map<EntityID, Point> getOrCreateView(Map<String, Map<EntityID, Point>> centers, String viewName) {
        Map<EntityID, Point> view = centers.get(viewName);
        if (view == null) {
            view = new HashMap<EntityID, Point>();
            centers.put(viewName, view);
        }
        return view;
    }

    private Map<LinkID, List<Point>> getOrCreatePathView(Map<String, Map<LinkID, List<Point>>> paths, String viewName) {
        Map<LinkID, List<Point>> view = paths.get(viewName);
        if (view == null) {
            view = new HashMap<LinkID, List<Point>>();
            paths.put(viewName, view);
        }
        return view;
    }

    private List<Point> parsePath(String path) {
        String[] points;
        ArrayList<Point> result = new ArrayList<Point>();
        for (String point : points = path.split(";")) {
            result.add(this.parsePoint(point));
        }
        return result;
    }

    private Point parsePoint(String center) {
        int pos = center.indexOf(44);
        if (pos > 0) {
            int x = Integer.parseInt(center.substring(0, pos));
            int y = Integer.parseInt(center.substring(pos + 1, center.length()));
            return new Point(x, y);
        }
        return new Point();
    }

    public void copyDisplayInformation(PartStub from, MaltegoPart to) {
        List<DisplayInfoStub> di = from.getDisplayInfo();
        if (di != null) {
            for (DisplayInfoStub stub : di) {
                String name = XMLEscapeUtils.unescapeUnicode((String)stub.getName());
                String value = XMLEscapeUtils.unescapeUnicode((String)stub.getValue());
                to.getOrCreateDisplayInformation().add(name, value);
            }
        }
    }

    public void copyStaticProperties(PartStub stub, MaltegoPart part, DisplayDescriptorCollection descriptors) throws GraphSerializationException {
        for (PropertyStub ps : stub.getProperties()) {
            DisplayDescriptor dd = descriptors.get(ps.getName());
            if (dd == null) {
                stub.add(new DynamicPropertyStub(ps));
                continue;
            }
            String valueStr = XMLEscapeUtils.unescapeUnicode((String)ps.getValue());
            if (valueStr == null) {
                valueStr = "";
            }
            Object value = dd.getTypeDescriptor().convert(valueStr);
            part.addProperty((PropertyDescriptor)dd);
            part.setValue((PropertyDescriptor)dd, value, false, false);
        }
    }

    public void copyDynamicProperties(PartStub stub, MaltegoPart part) throws GraphSerializationException {
        List<DynamicPropertyStub> dprops = stub.getDynamicProperties();
        if (dprops == null) {
            return;
        }
        for (DynamicPropertyStub ps : dprops) {
            TypeDescriptor td = TypeRegistry.getDefault().getType(ps.getType());
            if (td == null) {
                throw new GraphSerializationException(String.format("No type descriptor found for type=%s.", stub.getType()), true);
            }
            String displayName = XMLEscapeUtils.unescapeUnicode((String)ps.getDisplayName());
            PropertyDescriptor descriptor = new PropertyDescriptor(td.getType(), ps.getName(), displayName);
            descriptor.setHidden(this.getBoolean(ps.getHidden(), false));
            descriptor.setNullable(this.getBoolean(ps.getNullable(), true));
            descriptor.setReadonly(this.getBoolean(ps.getReadOnly(), false));
            Object value = td.convert(XMLEscapeUtils.unescapeUnicode((String)ps.getValue()));
            part.addProperty(descriptor);
            part.setValue(descriptor, value, false, false);
        }
    }

    public void copyPropertyMappings(PartStub from, MaltegoPart to) {
        if (from.getValuePropertyName() != null) {
            to.setValueProperty(new PropertyDescriptor(String.class, from.getValuePropertyName()));
        }
        if (from.getDisplayValueExpression() != null) {
            to.setDisplayValueExpression(from.getDisplayValueExpression());
        }
        if (from instanceof EntityStub && to instanceof MaltegoEntity) {
            EntityStub es = (EntityStub)from;
            MaltegoEntity entity = (MaltegoEntity)to;
            if (es.getImageExpression() != null) {
                entity.setImageExpression(es.getImageExpression());
            }
        }
    }

    private MaltegoEntity getEntity(EntityID id, Map<EntityID, MaltegoEntity> entities) {
        MaltegoEntity entity = entities.get(id);
        if (entity == null) {
            entity = new EntityUpdate(id);
        }
        return entity;
    }

    private boolean getBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

