/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.transforms;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.manager.imex.transforms.TransformDescriptorWrapper;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransformDescriptorEntry
extends Entry<TransformDescriptor> {
    public static final String DefaultFolder = "TransformRepositories";
    public static final String Type = "transform";

    public TransformDescriptorEntry(TransformDefinition transform) {
        super((Object)transform, "TransformRepositories/" + transform.getRepositoryName(), transform.getName() + "." + Type, transform.getName());
    }

    public TransformDescriptorEntry(String path) {
        super(path);
    }

    protected TransformDescriptor read(InputStream is) throws IOException {
        String folder = this.getFolder();
        String repositoryName = folder.substring(folder.indexOf("/") + 1);
        try {
            TransformDescriptor descriptor = new TransformDescriptorSerializer().read(is);
            TransformDescriptorWrapper wrapper = new TransformDescriptorWrapper(descriptor, repositoryName);
            return wrapper;
        }
        catch (XmlSerializationException ex) {
            throw new IOException(ex);
        }
    }

    protected void write(TransformDescriptor data, OutputStream os) throws IOException {
        new TransformDescriptorSerializer().write(data, os);
    }
}

