/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.actions;

import com.paterva.maltego.graph.table.io.exp.TabularGraphFileExporter;
import com.paterva.maltego.graph.table.ui.exp.wizard.ExportWizard;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportSettings;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.util.Arrays;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class TabularGraphExportAction
extends TopGraphAction {
    public static final String ICON_RESOURCE = "com/paterva/maltego/graph/table/ui/resources/ExportTabularGraph.png";

    public String getName() {
        return "Export Graph to Table";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.FALSE);
    }

    protected void actionPerformed(TopComponent tc) {
        TabularGraphFileExporter[] exporters = TabularGraphFileExporter.getAll((Lookup)Lookup.getDefault());
        if (exporters.length == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The chosen export operation is not available in this version of Maltego."));
        } else {
            this.sortExporters(exporters);
            WizardDescriptor wd = ExportWizard.create(this.getTopViewGraph(), exporters);
            if (WizardUtilities.runWizard((WizardDescriptor)wd)) {
                TabularExportSettings.setSelectionOnly((Boolean)wd.getProperty("exportSelection"));
                TabularExportSettings.setRemoveDuplicateRows((Boolean)wd.getProperty("removeDuplicates"));
            }
        }
    }

    private void sortExporters(TabularGraphFileExporter[] exporters) {
        Arrays.sort(exporters, (o1, o2) -> o1.getFileTypeDescription().compareToIgnoreCase(o2.getFileTypeDescription()));
    }
}

