/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio;

import gov.nist.isg.pyramidio.DziFile;
import gov.nist.isg.pyramidio.PartialImageReader;
import gov.nist.isg.pyramidio.tools.BufferedImageHelper;
import gov.nist.isg.pyramidio.tools.ImageResizingHelper;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;

public class DeepZoomImageReader
implements PartialImageReader {
    private final File dziFile;
    private final File filesFolder;
    private final int tileSize;
    private final int overlap;
    private final String format;
    private final int width;
    private final int height;
    private final int maxLevel;
    private final ImageTypeSpecifier rawImageType;

    public DeepZoomImageReader(File dziFile) throws IOException {
        this(dziFile, null);
    }

    public DeepZoomImageReader(File dziFile, File tileExample) throws IOException {
        this.dziFile = dziFile;
        String name = FilenameUtils.getBaseName((String)dziFile.getName());
        this.filesFolder = new File(dziFile.getParent(), name + "_files");
        if (!this.filesFolder.exists()) {
            throw new IOException("No files folder found: " + this.filesFolder);
        }
        DziFile df = new DziFile(dziFile);
        this.tileSize = df.getTileSize();
        this.overlap = df.getOverlap();
        this.format = df.getFormat();
        this.width = df.getWidth();
        this.height = df.getHeight();
        if (tileExample == null) {
            tileExample = this.getFilesOfLevel(0).get(0);
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(tileExample);){
            ImageReader reader = DeepZoomImageReader.getImageReader(iis);
            reader.setInput(iis);
            this.rawImageType = reader.getRawImageType(0);
        }
        int maxDim = Math.max(this.width, this.height);
        this.maxLevel = (int)Math.ceil(Math.log(maxDim) / Math.log(2.0));
    }

    public File getDziFile() {
        return this.dziFile;
    }

    public File getFilesFolder() {
        return this.filesFolder;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public BufferedImage read(Rectangle rectangle) throws IOException {
        return this.getRegion(rectangle, 1.0);
    }

    public BufferedImage getWholeImage(double zoom) throws IOException {
        return this.getRegion(new Rectangle(this.width, this.height), zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getRegion(Rectangle region, double zoom) throws IOException {
        BufferedImage result;
        if (region == null || region.isEmpty()) {
            throw new IllegalArgumentException("Region cannot be empty.");
        }
        int resultWidth = (int)Math.round((double)region.width * zoom);
        int resultHeight = (int)Math.round((double)region.height * zoom);
        if (resultWidth < 1 || resultHeight < 1) {
            throw new IllegalArgumentException("Zoom too small for width or height.");
        }
        Rectangle imageArea = new Rectangle(this.width, this.height);
        Rectangle intersection = imageArea.intersection(region);
        if (region.equals(intersection)) {
            return this.getSubImage(region, zoom);
        }
        DeepZoomImageReader deepZoomImageReader = this;
        synchronized (deepZoomImageReader) {
            result = this.rawImageType.createBufferedImage(resultWidth, resultHeight);
        }
        if (!intersection.isEmpty()) {
            BufferedImage subimage = this.getSubImage(intersection, zoom);
            int intersectionX = region.x < 0 ? (int)Math.round((double)(-region.x) * zoom) : 0;
            int intersectionY = region.y < 0 ? (int)Math.round((double)(-region.y) * zoom) : 0;
            result.getRaster().setRect(intersectionX, intersectionY, subimage.getRaster());
            subimage.flush();
        }
        return result;
    }

    public BufferedImage getSubImage(Rectangle region, double zoom) throws IOException {
        if (region == null || region.isEmpty()) {
            throw new IllegalArgumentException("Region cannot be empty.");
        }
        Rectangle wholeImage = new Rectangle(this.width, this.height);
        if (!wholeImage.contains(region)) {
            throw new IllegalArgumentException("Region outside image.");
        }
        int resultWidth = (int)Math.round((double)region.width * zoom);
        int resultHeight = (int)Math.round((double)region.height * zoom);
        if (resultWidth < 1 || resultHeight < 1) {
            throw new IllegalArgumentException("Zoom too small for width or height.");
        }
        int level = this.getClosestLevel(zoom);
        double zoomOfLevel = this.getZoomOfLevel(level);
        int x = (int)Math.round((double)region.x * zoomOfLevel);
        int y = (int)Math.round((double)region.y * zoomOfLevel);
        int w = (int)Math.round((double)region.width * zoomOfLevel);
        int h = (int)Math.round((double)region.height * zoomOfLevel);
        BufferedImage image = this.readRegionOfLevel(new Rectangle(x, y, w, h), level);
        return ImageResizingHelper.resizeImage(image, resultWidth, resultHeight);
    }

    public BufferedImage readRegionOfLevel(Rectangle region, int level) throws IOException {
        int lastTileRow;
        int lastTileColumn;
        int firstTileRow;
        int firstTileColumn = region.x / this.tileSize;
        if (this.tileSize * (firstTileColumn + 1) - this.overlap <= region.x) {
            ++firstTileColumn;
        }
        if (this.tileSize * ((firstTileRow = region.y / this.tileSize) + 1) - this.overlap <= region.y) {
            ++firstTileRow;
        }
        if (this.tileSize * (lastTileColumn = (region.x + region.width) / this.tileSize) + this.overlap >= region.x + region.width && lastTileColumn != 0) {
            --lastTileColumn;
        }
        if (this.tileSize * (lastTileRow = (region.y + region.height) / this.tileSize) + this.overlap >= region.y + region.height && lastTileRow != 0) {
            --lastTileRow;
        }
        BufferedImage result = null;
        WritableRaster raster = null;
        int dx = 0;
        for (int i = firstTileColumn; i <= lastTileColumn; ++i) {
            int w;
            int x;
            if (i == firstTileColumn) {
                x = region.x - firstTileColumn * this.tileSize;
                w = i == lastTileColumn ? region.width : this.tileSize - x;
                if (firstTileColumn != 0) {
                    x += this.overlap;
                }
            } else {
                x = this.overlap;
                w = i == lastTileColumn ? region.width - dx : this.tileSize;
            }
            int dy = 0;
            for (int j = firstTileRow; j <= lastTileRow; ++j) {
                int h;
                int y;
                if (j == firstTileRow) {
                    y = region.y - firstTileRow * this.tileSize;
                    h = j == lastTileRow ? region.height : this.tileSize - y;
                    if (firstTileRow != 0) {
                        y += this.overlap;
                    }
                } else {
                    y = this.overlap;
                    h = j == lastTileRow ? region.height - dy : this.tileSize;
                }
                Rectangle area = new Rectangle(x, y, w, h);
                BufferedImage tile = this.readRegionOfTile(area, level, i, j);
                if (i == firstTileColumn && j == firstTileRow) {
                    result = BufferedImageHelper.createBufferedImage(region.width, region.height, tile);
                    raster = result.getRaster();
                }
                raster.setRect(dx, dy, tile.getRaster());
                tile.flush();
                dy += h;
            }
            dx += w;
        }
        return result;
    }

    private BufferedImage readRegionOfTile(Rectangle region, int level, int column, int row) throws IOException {
        File levelFolder = new File(this.filesFolder, Integer.toString(level));
        File tile = new File(levelFolder, column + "_" + row + "." + this.format);
        try (ImageInputStream iis = ImageIO.createImageInputStream(tile);){
            ImageReader reader = DeepZoomImageReader.getImageReader(iis);
            reader.setInput(iis);
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceRegion(region);
            BufferedImage bufferedImage = reader.read(0, param);
            return bufferedImage;
        }
    }

    private int getClosestLevel(double zoom) {
        if (zoom > 0.5) {
            return this.maxLevel;
        }
        return this.maxLevel + (int)Math.ceil(Math.log(zoom) / Math.log(2.0));
    }

    private double getZoomOfLevel(int level) {
        return Math.pow(2.0, level - this.maxLevel);
    }

    private List<File> getFilesOfLevel(int level) {
        int widthOfLevel = 1;
        int heightOfLevel = 1;
        if (level != 0) {
            widthOfLevel = Math.min(2 * level, this.width);
            heightOfLevel = Math.min(2 * level, this.height);
        }
        int numColumns = (int)Math.ceil((float)widthOfLevel / (float)this.tileSize);
        int numRows = (int)Math.ceil((float)heightOfLevel / (float)this.tileSize);
        File levelFolder = new File(this.filesFolder, Integer.toString(level));
        ArrayList<File> result = new ArrayList<File>(numColumns * numRows);
        for (int i = 0; i < numColumns; ++i) {
            for (int j = 0; j < numRows; ++j) {
                File file = new File(levelFolder, i + "_" + j + "." + this.format);
                result.add(file);
            }
        }
        return result;
    }

    private static ImageReader getImageReader(ImageInputStream iis) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (!readers.hasNext()) {
            throw new IOException("No compatible image reader found.");
        }
        return readers.next();
    }
}

