/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.collab.session.xmpp.Utils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.MultiUserChat;

class XmppCollaborationConnection {
    private XMPPConnection _cn;
    private Map<String, PacketListener> _listeners;
    private static final Logger LOGGER = Logger.getLogger(XmppCollaborationConnection.class.getName());
    private boolean _authenticated = false;
    private boolean _connected = false;

    public XmppCollaborationConnection(XMPPConnection connection) {
        this._cn = connection;
        this._listeners = new ConcurrentHashMap<String, PacketListener>();
        this._cn.addPacketListener((PacketListener)new MessageListener(), null);
        this._connected = connection.isConnected();
    }

    public synchronized void connect() throws XMPPException {
        if (!this._connected) {
            this._cn.connect();
            this._connected = true;
        }
    }

    public synchronized void login(String user, String password) throws XMPPException {
        if (!this._authenticated) {
            this._cn.login(user, password, "Maltego");
            this._authenticated = true;
        }
    }

    public synchronized void sendPacket(Packet packet) {
        this._cn.sendPacket(packet);
    }

    public synchronized void addConnectionListener(ConnectionListener listener) {
        this._cn.addConnectionListener(listener);
    }

    public synchronized void removeConnectionListener(ConnectionListener listener) {
        this._cn.removeConnectionListener(listener);
    }

    public void addMessageListener(String room, PacketListener listener) {
        this._listeners.put(room, listener);
    }

    public void removeMessageListener(String room) {
        this._listeners.remove(room);
    }

    private void handleMessage(Message message) {
        String from = message.getFrom();
        String room = Utils.getRoom(from);
        PacketListener listener = this._listeners.get(room);
        if (listener != null) {
            listener.processPacket((Packet)message);
        }
    }

    public synchronized void disconnect() {
        if (this._connected) {
            this._cn.disconnect();
            this._connected = false;
        }
    }

    public synchronized MultiUserChat createChatRoom(String room) {
        return new MultiUserChat((Connection)this._cn, room);
    }

    public synchronized ServiceDiscoveryManager getDisoveryManager() {
        return ServiceDiscoveryManager.getInstanceFor((Connection)this._cn);
    }

    public synchronized PacketCollector createPacketCollector(PacketFilter filter) {
        return this._cn.createPacketCollector(filter);
    }

    public synchronized boolean isConnected() {
        return this._cn.isConnected();
    }

    private class MessageListener
    implements PacketListener {
        private MessageListener() {
        }

        public void processPacket(Packet packet) {
            try {
                if (packet instanceof Message) {
                    Message message = (Message)packet;
                    XmppCollaborationConnection.this.handleMessage(message);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

