/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.propertygrid.PropertyDescriptorProperty;
import com.paterva.maltego.typing.types.BinaryFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;

class BinaryFileProperty
extends PropertyDescriptorProperty {
    private File _lastFile;

    public BinaryFileProperty(DisplayDescriptor descriptor, DataSource data) {
        super(File.class, (PropertyDescriptor)descriptor, data);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.updateFile((BinaryFile)this.getDataSource().getValue((PropertyDescriptor)descriptor));
    }

    @Override
    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this._lastFile;
    }

    @Override
    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this._lastFile = (File)object;
        if (this._lastFile != null) {
            if (!this._lastFile.isDirectory()) {
                try {
                    this.updateFile(this._lastFile);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        } else {
            this.updateFile(null, (Icon)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(BinaryFile file) {
        if (file == null) {
            this.updateFile(null, (Icon)null);
        } else {
            File temp = null;
            try {
                try {
                    temp = File.createTempFile("temp", file.getExtension());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.updateFile(file, temp);
            }
            finally {
                if (temp != null) {
                    temp.delete();
                }
            }
        }
    }

    private void updateFile(File file) throws IOException {
        this.updateFile(BinaryFile.create((File)file), file);
    }

    private void updateFile(BinaryFile file, File originalFile) {
        Icon icon = null;
        if (originalFile != null) {
            icon = FileSystemView.getFileSystemView().getSystemIcon(originalFile);
        }
        this.updateFile(file, icon);
    }

    private void updateFile(BinaryFile file, Icon icon) {
        this.getDataSource().setValue(this.getPropertyDescriptor(), (Object)file);
        String display = file == null ? "(none)" : file.getFilename();
        if (icon == null) {
            icon = new ImageIcon();
        }
        this.setValue("htmlDisplayValue", display);
        this.setValue("valueIcon", icon);
    }
}

