/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.impl;

import com.paterva.maltego.find.files.FindInFilesInput;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class FindInputSerializer {
    private static final String PREF_TEXT = "fifText";
    private static final String PREF_RECURSIVE = "fifRecursive";
    private static final String PREF_CASE = "fifCaseSensitive";
    private static final String PREF_ENTITIES = "fifEntities";
    private static final String PREF_LINKS = "fifLinks";
    private static final String PREF_VALUE = "fifValue";
    private static final String PREF_PROPERTIES = "fifProperties";
    private static final String PREF_DISPLAY_INFO = "fifDisplayInfo";
    private static final String PREF_NOTES = "fifNotes";
    private static final String PREF_REGEX = "fifRegex";

    public static void save(FindInFilesInput settings) {
        Preferences prefs = FindInputSerializer.getPreferences();
        prefs.put(PREF_TEXT, settings.getPattern().toString());
        prefs.putBoolean(PREF_REGEX, settings.isRegex());
        prefs.putBoolean(PREF_RECURSIVE, settings.isRecursive());
        prefs.putBoolean(PREF_CASE, settings.isCaseSensitive());
        prefs.putBoolean(PREF_ENTITIES, settings.isSearchEntities());
        prefs.putBoolean(PREF_LINKS, settings.isSearchLinks());
        prefs.putBoolean(PREF_VALUE, settings.isSearchValue());
        prefs.putBoolean(PREF_PROPERTIES, settings.isSearchProperties());
        prefs.putBoolean(PREF_DISPLAY_INFO, settings.isSearchDisplayInfo());
        prefs.putBoolean(PREF_NOTES, settings.isSearchNotes());
    }

    public static FindInFilesInput load() {
        Preferences prefs = FindInputSerializer.getPreferences();
        FindInFilesInput settings = new FindInFilesInput();
        settings.setText(prefs.get(PREF_TEXT, ""));
        settings.setIsRegex(prefs.getBoolean(PREF_REGEX, false));
        settings.setRecursive(prefs.getBoolean(PREF_RECURSIVE, false));
        settings.setCaseSensitive(prefs.getBoolean(PREF_CASE, false));
        settings.setSearchEntities(prefs.getBoolean(PREF_ENTITIES, true));
        settings.setSearchLinks(prefs.getBoolean(PREF_LINKS, false));
        settings.setSearchValue(prefs.getBoolean(PREF_VALUE, true));
        settings.setSearchProperties(prefs.getBoolean(PREF_PROPERTIES, false));
        settings.setSearchDisplayInfo(prefs.getBoolean(PREF_DISPLAY_INFO, false));
        settings.setSearchNotes(prefs.getBoolean(PREF_NOTES, false));
        return settings;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(FindInputSerializer.class);
    }
}

