/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.jai;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.jai.TileInfo;
import com.paterva.maltego.util.jai.TileSupplier;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import com.sun.media.jai.util.CacheDiagnostics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RecyclingTileFactory;
import javax.media.jai.SourcelessOpImage;
import javax.media.jai.TileCache;

public class TilingAdapter {
    private static final Logger LOG = Logger.getLogger(TilingAdapter.class.getName());
    private static final long TILE_CACHE_SIZE_64MB = 0x4000000L;
    private static final long TILE_CACHE_SIZE_128MB = 0x8000000L;
    private static final long TILE_CACHE_SIZE_256MB = 0x10000000L;
    private static final long TILE_CACHE_SIZE_512MB = 0x20000000L;
    private static final long DEFAULT_TILE_CACHE_SIZE = 0x20000000L;
    private final int tileSizeX;
    private final int tileSizeY;
    private final int totalImageWidth;
    private final int totalImageHeight;
    private final TileSupplier supplier;

    public TilingAdapter(int tileSizeX, int tileSizeY, int totalImageWidth, int totalImageHeight, TileSupplier supplier) {
        this.tileSizeX = tileSizeX;
        this.tileSizeY = tileSizeY;
        this.totalImageWidth = totalImageWidth;
        this.totalImageHeight = totalImageHeight;
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(File outFile, BufferedImage template, String formatName) throws IOException {
        long timeStart;
        block3: {
            ImageLayout layout = new ImageLayout(0, 0, this.totalImageWidth, this.totalImageHeight);
            layout.setTileWidth(this.tileSizeX);
            layout.setTileHeight(this.tileSizeY);
            HashMap<Object, Object> conf = this.setupConfig();
            TileCache cache = (TileCache)conf.get(JAI.KEY_TILE_CACHE);
            this.supplier.setCache(cache);
            ConfigurableSourcelessOpImage op = new ConfigurableSourcelessOpImage(layout, conf, template.getSampleModel(), 0, 0, this.totalImageWidth, this.totalImageHeight, this.supplier);
            timeStart = System.currentTimeMillis();
            try {
                ImageIO.write((RenderedImage)((Object)op), formatName, outFile);
                if (cache == null) break block3;
            }
            catch (Throwable throwable) {
                if (cache != null) {
                    cache.flush();
                    cache = null;
                }
                long delta = System.currentTimeMillis() - timeStart;
                LOG.log(Level.INFO, "Image writing time: {0} ms", new Object[]{delta});
                throw throwable;
            }
            cache.flush();
            cache = null;
        }
        long delta = System.currentTimeMillis() - timeStart;
        LOG.log(Level.INFO, "Image writing time: {0} ms", new Object[]{delta});
    }

    private HashMap<Object, Object> setupConfig() {
        HashMap<Object, Object> conf = new HashMap<Object, Object>();
        long memCapacity = (long)(0.5 * (double)Runtime.getRuntime().maxMemory());
        memCapacity = Math.min(memCapacity, 0x20000000L);
        TileCache cache = JAI.createTileCache((long)memCapacity);
        cache.setMemoryThreshold(0.75f);
        conf.put(JAI.KEY_TILE_CACHE, cache);
        conf.put(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, Boolean.TRUE);
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        conf.put(JAI.KEY_TILE_FACTORY, recyclingFactory);
        conf.put(JAI.KEY_TILE_RECYCLER, recyclingFactory);
        return conf;
    }

    public static void printDiagnostics(TileSupplier supplier, String name, double percentage) {
        TileCache tileCache = supplier.getCache();
        if (tileCache instanceof CacheDiagnostics) {
            CacheDiagnostics diagnostics = (CacheDiagnostics)CacheDiagnostics.class.cast(tileCache);
            long cacheHitCount = diagnostics.getCacheHitCount();
            long cacheMissCount = diagnostics.getCacheMissCount();
            long cacheMemoryUsed = diagnostics.getCacheMemoryUsed();
            long cacheTileCount = diagnostics.getCacheTileCount();
            double hitPercentage = cacheHitCount == 0L ? 0.0 : (double)cacheHitCount / (double)(cacheHitCount + cacheMissCount) * 100.0;
            LOG.log(Level.INFO, "Writing {0} ({1}%, tile-cache: {2}% hit rate ({3}/{4}), {5} tiles, {6})...", new Object[]{name, String.format("%.2f", percentage), String.format("%.2f", hitPercentage), cacheHitCount, cacheMissCount, cacheTileCount, StringUtilities.bytesToString(cacheMemoryUsed)});
        }
    }

    private static class ConfigurableSourcelessOpImage
    extends SourcelessOpImage {
        private final TileSupplier supplier;

        public ConfigurableSourcelessOpImage(ImageLayout layout, Map configuration, SampleModel sampleModel, int imageMinX, int imageMinY, int totalImageWidth, int totalImageHeight, TileSupplier supplier) {
            super(layout, configuration, sampleModel, imageMinX, imageMinY, totalImageWidth, totalImageHeight);
            this.supplier = supplier;
        }

        public Raster computeTile(int tileIndexX, int tileIndexY) {
            TileInfo tileInfo = this.supplier.getTile(tileIndexX, tileIndexY);
            BufferedImage bi = tileInfo.getTile();
            return RasterFactory.createRaster((SampleModel)bi.getSampleModel(), (DataBuffer)bi.getData().getDataBuffer(), (Point)new Point(tileInfo.getImageOffsetX(), tileInfo.getImageOffsetY()));
        }
    }
}

