/* SPDX-FileCopyrightText: 2024 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import React from 'react';
import Filter, {RESULTS_FILTER_FILTER} from 'gmp/models/filter';
import DashboardControls from 'web/components/dashboard/Controls';
import {ResultIcon} from 'web/components/icon';
import ManualIcon from 'web/components/icon/ManualIcon';
import Layout from 'web/components/layout/Layout';
import PageTitle from 'web/components/layout/PageTitle';
import EntitiesPage from 'web/entities/EntitiesPage';
import withEntitiesContainer from 'web/entities/withEntitiesContainer';
import useTranslation from 'web/hooks/useTranslation';
import ResultsDashboard, {
  RESULTS_DASHBOARD_ID,
} from 'web/pages/results/dashboard';
import ResultFilterDialog from 'web/pages/results/ResultFilterDialog';
import ResultsTable from 'web/pages/results/ResultsTable';
import {
  loadEntities,
  selector as entitiesSelector,
} from 'web/store/entities/results';
import PropTypes from 'web/utils/PropTypes';

export const ToolBarIcons = () => {
  const [_] = useTranslation();
  return (
    <Layout>
      <ManualIcon
        anchor="displaying-all-existing-results"
        page="reports"
        title={_('Help: Results')}
      />
    </Layout>
  );
};

const Page = ({filter, onFilterChanged, ...props}) => {
  const [_] = useTranslation();
  return (
    <React.Fragment>
      <PageTitle title={_('Results')} />
      <EntitiesPage
        {...props}
        dashboard={() => (
          <ResultsDashboard filter={filter} onFilterChanged={onFilterChanged} />
        )}
        dashboardControls={() => (
          <DashboardControls dashboardId={RESULTS_DASHBOARD_ID} />
        )}
        filter={filter}
        filterEditDialog={ResultFilterDialog}
        filtersFilter={RESULTS_FILTER_FILTER}
        sectionIcon={<ResultIcon size="large" />}
        table={ResultsTable}
        title={_('Results')}
        toolBarIcons={ToolBarIcons}
        onFilterChanged={onFilterChanged}
      />
    </React.Fragment>
  );
};

Page.propTypes = {
  filter: PropTypes.filter,
  onFilterChanged: PropTypes.func.isRequired,
};

const fallbackFilter = Filter.fromString('sort-reverse=severity');

export default withEntitiesContainer('result', {
  entitiesSelector,
  loadEntities,
  fallbackFilter,
})(Page);
