"""Initial migration

Revision ID: initial
Revises: 
Create Date: 2023-01-01 00:00:00.000000

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'initial'
down_revision = None
branch_labels = None
depends_on = None

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('vm_migrations',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('vm_id', sa.String(length=36), nullable=False),
        sa.Column('vm_name', sa.String(length=255), nullable=False),
        sa.UniqueConstraint('vm_id', name='uniq_vm_id'),
        sa.Column('scheduled_time', sa.DateTime(), nullable=True),
        sa.Column('state', sa.Enum('SCHEDULED', 'MIGRATING', 'MIGRATED', 'ERROR', name='migrationstate'), nullable=True),
        sa.Column('workflow_exec', sa.String(length=36), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('vm_migrations')
    # ### end Alembic commands ###
