// Code generated by go generate; DO NOT EDIT.
package digitalocean

import "errors"

type Permission int

const (
    Invalid Permission = iota
    OneClickRead Permission = iota
    OneClickCreate Permission = iota
    ActionRead Permission = iota
    AppRead Permission = iota
    AppCreate Permission = iota
    AppUpdate Permission = iota
    AppDelete Permission = iota
    BillingRead Permission = iota
    BlockStorageRead Permission = iota
    BlockStorageCreate Permission = iota
    BlockStorageDelete Permission = iota
    CdnEndpointRead Permission = iota
    CdnEndpointCreate Permission = iota
    CdnEndpointUpdate Permission = iota
    CdnEndpointDelete Permission = iota
    CertificateRead Permission = iota
    CertificateCreate Permission = iota
    CertificateDelete Permission = iota
    ContainerRegistryRead Permission = iota
    ContainerRegistryCreate Permission = iota
    DatabaseRead Permission = iota
    DatabaseCreate Permission = iota
    DatabaseUpdate Permission = iota
    DatabaseDelete Permission = iota
    DomainRecordRead Permission = iota
    DomainRecordCreate Permission = iota
    DomainRecordUpdate Permission = iota
    DomainRecordDelete Permission = iota
    DomainRead Permission = iota
    DomainCreate Permission = iota
    DomainDelete Permission = iota
    DropletRead Permission = iota
    DropletCreate Permission = iota
    DropletDelete Permission = iota
    DropletAutoscalePoolRead Permission = iota
    DropletAutoscalePoolCreate Permission = iota
    DropletAutoscalePoolUpdate Permission = iota
    DropletAutoscalePoolDelete Permission = iota
    FirewallRead Permission = iota
    FirewallCreate Permission = iota
    FirewallUpdate Permission = iota
    FirewallDelete Permission = iota
    FloatingIpRead Permission = iota
    FloatingIpCreate Permission = iota
    FloatingIpDelete Permission = iota
    NamespaceRead Permission = iota
    NamespaceCreate Permission = iota
    NamespaceDelete Permission = iota
    GenaiAgentRead Permission = iota
    GenaiAgentCreate Permission = iota
    GenaiAgentUpdate Permission = iota
    GenaiAgentDelete Permission = iota
    ImageRead Permission = iota
    ImageCreate Permission = iota
    ImageUpdate Permission = iota
    ImageDelete Permission = iota
    KubernetesRead Permission = iota
    KubernetesCreate Permission = iota
    KubernetesUpdate Permission = iota
    KubernetesDelete Permission = iota
    LoadBalancerRead Permission = iota
    LoadBalancerCreate Permission = iota
    LoadBalancerUpdate Permission = iota
    LoadBalancerDelete Permission = iota
    MonitoringRead Permission = iota
    MonitoringCreate Permission = iota
    MonitoringUpdate Permission = iota
    MonitoringDelete Permission = iota
    ProjectRead Permission = iota
    ProjectCreate Permission = iota
    ProjectUpdate Permission = iota
    ProjectDelete Permission = iota
    RegionRead Permission = iota
    ReservedIpRead Permission = iota
    ReservedIpCreate Permission = iota
    ReservedIpDelete Permission = iota
    SizeRead Permission = iota
    SnapshotRead Permission = iota
    SnapshotDelete Permission = iota
    SshKeyRead Permission = iota
    SshKeyCreate Permission = iota
    SshKeyUpdate Permission = iota
    SshKeyDelete Permission = iota
    TagRead Permission = iota
    TagCreate Permission = iota
    TagDelete Permission = iota
    UptimeRead Permission = iota
    UptimeCreate Permission = iota
    UptimeUpdate Permission = iota
    UptimeDelete Permission = iota
    VpcPeeringRead Permission = iota
    VpcPeeringCreate Permission = iota
    VpcPeeringUpdate Permission = iota
    VpcPeeringDelete Permission = iota
    VpcRead Permission = iota
    VpcCreate Permission = iota
    VpcUpdate Permission = iota
    VpcDelete Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        OneClickRead: "one_click:read",
        OneClickCreate: "one_click:create",
        ActionRead: "action:read",
        AppRead: "app:read",
        AppCreate: "app:create",
        AppUpdate: "app:update",
        AppDelete: "app:delete",
        BillingRead: "billing:read",
        BlockStorageRead: "block_storage:read",
        BlockStorageCreate: "block_storage:create",
        BlockStorageDelete: "block_storage:delete",
        CdnEndpointRead: "cdn_endpoint:read",
        CdnEndpointCreate: "cdn_endpoint:create",
        CdnEndpointUpdate: "cdn_endpoint:update",
        CdnEndpointDelete: "cdn_endpoint:delete",
        CertificateRead: "certificate:read",
        CertificateCreate: "certificate:create",
        CertificateDelete: "certificate:delete",
        ContainerRegistryRead: "container_registry:read",
        ContainerRegistryCreate: "container_registry:create",
        DatabaseRead: "database:read",
        DatabaseCreate: "database:create",
        DatabaseUpdate: "database:update",
        DatabaseDelete: "database:delete",
        DomainRecordRead: "domain_record:read",
        DomainRecordCreate: "domain_record:create",
        DomainRecordUpdate: "domain_record:update",
        DomainRecordDelete: "domain_record:delete",
        DomainRead: "domain:read",
        DomainCreate: "domain:create",
        DomainDelete: "domain:delete",
        DropletRead: "droplet:read",
        DropletCreate: "droplet:create",
        DropletDelete: "droplet:delete",
        DropletAutoscalePoolRead: "droplet_autoscale_pool:read",
        DropletAutoscalePoolCreate: "droplet_autoscale_pool:create",
        DropletAutoscalePoolUpdate: "droplet_autoscale_pool:update",
        DropletAutoscalePoolDelete: "droplet_autoscale_pool:delete",
        FirewallRead: "firewall:read",
        FirewallCreate: "firewall:create",
        FirewallUpdate: "firewall:update",
        FirewallDelete: "firewall:delete",
        FloatingIpRead: "floating_ip:read",
        FloatingIpCreate: "floating_ip:create",
        FloatingIpDelete: "floating_ip:delete",
        NamespaceRead: "namespace:read",
        NamespaceCreate: "namespace:create",
        NamespaceDelete: "namespace:delete",
        GenaiAgentRead: "genai_agent:read",
        GenaiAgentCreate: "genai_agent:create",
        GenaiAgentUpdate: "genai_agent:update",
        GenaiAgentDelete: "genai_agent:delete",
        ImageRead: "image:read",
        ImageCreate: "image:create",
        ImageUpdate: "image:update",
        ImageDelete: "image:delete",
        KubernetesRead: "kubernetes:read",
        KubernetesCreate: "kubernetes:create",
        KubernetesUpdate: "kubernetes:update",
        KubernetesDelete: "kubernetes:delete",
        LoadBalancerRead: "load_balancer:read",
        LoadBalancerCreate: "load_balancer:create",
        LoadBalancerUpdate: "load_balancer:update",
        LoadBalancerDelete: "load_balancer:delete",
        MonitoringRead: "monitoring:read",
        MonitoringCreate: "monitoring:create",
        MonitoringUpdate: "monitoring:update",
        MonitoringDelete: "monitoring:delete",
        ProjectRead: "project:read",
        ProjectCreate: "project:create",
        ProjectUpdate: "project:update",
        ProjectDelete: "project:delete",
        RegionRead: "region:read",
        ReservedIpRead: "reserved_ip:read",
        ReservedIpCreate: "reserved_ip:create",
        ReservedIpDelete: "reserved_ip:delete",
        SizeRead: "size:read",
        SnapshotRead: "snapshot:read",
        SnapshotDelete: "snapshot:delete",
        SshKeyRead: "ssh_key:read",
        SshKeyCreate: "ssh_key:create",
        SshKeyUpdate: "ssh_key:update",
        SshKeyDelete: "ssh_key:delete",
        TagRead: "tag:read",
        TagCreate: "tag:create",
        TagDelete: "tag:delete",
        UptimeRead: "uptime:read",
        UptimeCreate: "uptime:create",
        UptimeUpdate: "uptime:update",
        UptimeDelete: "uptime:delete",
        VpcPeeringRead: "vpc_peering:read",
        VpcPeeringCreate: "vpc_peering:create",
        VpcPeeringUpdate: "vpc_peering:update",
        VpcPeeringDelete: "vpc_peering:delete",
        VpcRead: "vpc:read",
        VpcCreate: "vpc:create",
        VpcUpdate: "vpc:update",
        VpcDelete: "vpc:delete",
    }

    StringToPermission = map[string]Permission{
        "one_click:read": OneClickRead,
        "one_click:create": OneClickCreate,
        "action:read": ActionRead,
        "app:read": AppRead,
        "app:create": AppCreate,
        "app:update": AppUpdate,
        "app:delete": AppDelete,
        "billing:read": BillingRead,
        "block_storage:read": BlockStorageRead,
        "block_storage:create": BlockStorageCreate,
        "block_storage:delete": BlockStorageDelete,
        "cdn_endpoint:read": CdnEndpointRead,
        "cdn_endpoint:create": CdnEndpointCreate,
        "cdn_endpoint:update": CdnEndpointUpdate,
        "cdn_endpoint:delete": CdnEndpointDelete,
        "certificate:read": CertificateRead,
        "certificate:create": CertificateCreate,
        "certificate:delete": CertificateDelete,
        "container_registry:read": ContainerRegistryRead,
        "container_registry:create": ContainerRegistryCreate,
        "database:read": DatabaseRead,
        "database:create": DatabaseCreate,
        "database:update": DatabaseUpdate,
        "database:delete": DatabaseDelete,
        "domain_record:read": DomainRecordRead,
        "domain_record:create": DomainRecordCreate,
        "domain_record:update": DomainRecordUpdate,
        "domain_record:delete": DomainRecordDelete,
        "domain:read": DomainRead,
        "domain:create": DomainCreate,
        "domain:delete": DomainDelete,
        "droplet:read": DropletRead,
        "droplet:create": DropletCreate,
        "droplet:delete": DropletDelete,
        "droplet_autoscale_pool:read": DropletAutoscalePoolRead,
        "droplet_autoscale_pool:create": DropletAutoscalePoolCreate,
        "droplet_autoscale_pool:update": DropletAutoscalePoolUpdate,
        "droplet_autoscale_pool:delete": DropletAutoscalePoolDelete,
        "firewall:read": FirewallRead,
        "firewall:create": FirewallCreate,
        "firewall:update": FirewallUpdate,
        "firewall:delete": FirewallDelete,
        "floating_ip:read": FloatingIpRead,
        "floating_ip:create": FloatingIpCreate,
        "floating_ip:delete": FloatingIpDelete,
        "namespace:read": NamespaceRead,
        "namespace:create": NamespaceCreate,
        "namespace:delete": NamespaceDelete,
        "genai_agent:read": GenaiAgentRead,
        "genai_agent:create": GenaiAgentCreate,
        "genai_agent:update": GenaiAgentUpdate,
        "genai_agent:delete": GenaiAgentDelete,
        "image:read": ImageRead,
        "image:create": ImageCreate,
        "image:update": ImageUpdate,
        "image:delete": ImageDelete,
        "kubernetes:read": KubernetesRead,
        "kubernetes:create": KubernetesCreate,
        "kubernetes:update": KubernetesUpdate,
        "kubernetes:delete": KubernetesDelete,
        "load_balancer:read": LoadBalancerRead,
        "load_balancer:create": LoadBalancerCreate,
        "load_balancer:update": LoadBalancerUpdate,
        "load_balancer:delete": LoadBalancerDelete,
        "monitoring:read": MonitoringRead,
        "monitoring:create": MonitoringCreate,
        "monitoring:update": MonitoringUpdate,
        "monitoring:delete": MonitoringDelete,
        "project:read": ProjectRead,
        "project:create": ProjectCreate,
        "project:update": ProjectUpdate,
        "project:delete": ProjectDelete,
        "region:read": RegionRead,
        "reserved_ip:read": ReservedIpRead,
        "reserved_ip:create": ReservedIpCreate,
        "reserved_ip:delete": ReservedIpDelete,
        "size:read": SizeRead,
        "snapshot:read": SnapshotRead,
        "snapshot:delete": SnapshotDelete,
        "ssh_key:read": SshKeyRead,
        "ssh_key:create": SshKeyCreate,
        "ssh_key:update": SshKeyUpdate,
        "ssh_key:delete": SshKeyDelete,
        "tag:read": TagRead,
        "tag:create": TagCreate,
        "tag:delete": TagDelete,
        "uptime:read": UptimeRead,
        "uptime:create": UptimeCreate,
        "uptime:update": UptimeUpdate,
        "uptime:delete": UptimeDelete,
        "vpc_peering:read": VpcPeeringRead,
        "vpc_peering:create": VpcPeeringCreate,
        "vpc_peering:update": VpcPeeringUpdate,
        "vpc_peering:delete": VpcPeeringDelete,
        "vpc:read": VpcRead,
        "vpc:create": VpcCreate,
        "vpc:update": VpcUpdate,
        "vpc:delete": VpcDelete,
    }

    PermissionIDs = map[Permission]int{
        OneClickRead: 1,
        OneClickCreate: 2,
        ActionRead: 3,
        AppRead: 4,
        AppCreate: 5,
        AppUpdate: 6,
        AppDelete: 7,
        BillingRead: 8,
        BlockStorageRead: 9,
        BlockStorageCreate: 10,
        BlockStorageDelete: 11,
        CdnEndpointRead: 12,
        CdnEndpointCreate: 13,
        CdnEndpointUpdate: 14,
        CdnEndpointDelete: 15,
        CertificateRead: 16,
        CertificateCreate: 17,
        CertificateDelete: 18,
        ContainerRegistryRead: 19,
        ContainerRegistryCreate: 20,
        DatabaseRead: 21,
        DatabaseCreate: 22,
        DatabaseUpdate: 23,
        DatabaseDelete: 24,
        DomainRecordRead: 25,
        DomainRecordCreate: 26,
        DomainRecordUpdate: 27,
        DomainRecordDelete: 28,
        DomainRead: 29,
        DomainCreate: 30,
        DomainDelete: 31,
        DropletRead: 32,
        DropletCreate: 33,
        DropletDelete: 34,
        DropletAutoscalePoolRead: 35,
        DropletAutoscalePoolCreate: 36,
        DropletAutoscalePoolUpdate: 37,
        DropletAutoscalePoolDelete: 38,
        FirewallRead: 39,
        FirewallCreate: 40,
        FirewallUpdate: 41,
        FirewallDelete: 42,
        FloatingIpRead: 43,
        FloatingIpCreate: 44,
        FloatingIpDelete: 45,
        NamespaceRead: 46,
        NamespaceCreate: 47,
        NamespaceDelete: 48,
        GenaiAgentRead: 49,
        GenaiAgentCreate: 50,
        GenaiAgentUpdate: 51,
        GenaiAgentDelete: 52,
        ImageRead: 53,
        ImageCreate: 54,
        ImageUpdate: 55,
        ImageDelete: 56,
        KubernetesRead: 57,
        KubernetesCreate: 58,
        KubernetesUpdate: 59,
        KubernetesDelete: 60,
        LoadBalancerRead: 61,
        LoadBalancerCreate: 62,
        LoadBalancerUpdate: 63,
        LoadBalancerDelete: 64,
        MonitoringRead: 65,
        MonitoringCreate: 66,
        MonitoringUpdate: 67,
        MonitoringDelete: 68,
        ProjectRead: 69,
        ProjectCreate: 70,
        ProjectUpdate: 71,
        ProjectDelete: 72,
        RegionRead: 73,
        ReservedIpRead: 74,
        ReservedIpCreate: 75,
        ReservedIpDelete: 76,
        SizeRead: 77,
        SnapshotRead: 78,
        SnapshotDelete: 79,
        SshKeyRead: 80,
        SshKeyCreate: 81,
        SshKeyUpdate: 82,
        SshKeyDelete: 83,
        TagRead: 84,
        TagCreate: 85,
        TagDelete: 86,
        UptimeRead: 87,
        UptimeCreate: 88,
        UptimeUpdate: 89,
        UptimeDelete: 90,
        VpcPeeringRead: 91,
        VpcPeeringCreate: 92,
        VpcPeeringUpdate: 93,
        VpcPeeringDelete: 94,
        VpcRead: 95,
        VpcCreate: 96,
        VpcUpdate: 97,
        VpcDelete: 98,
    }

    IdToPermission = map[int]Permission{
        1: OneClickRead,
        2: OneClickCreate,
        3: ActionRead,
        4: AppRead,
        5: AppCreate,
        6: AppUpdate,
        7: AppDelete,
        8: BillingRead,
        9: BlockStorageRead,
        10: BlockStorageCreate,
        11: BlockStorageDelete,
        12: CdnEndpointRead,
        13: CdnEndpointCreate,
        14: CdnEndpointUpdate,
        15: CdnEndpointDelete,
        16: CertificateRead,
        17: CertificateCreate,
        18: CertificateDelete,
        19: ContainerRegistryRead,
        20: ContainerRegistryCreate,
        21: DatabaseRead,
        22: DatabaseCreate,
        23: DatabaseUpdate,
        24: DatabaseDelete,
        25: DomainRecordRead,
        26: DomainRecordCreate,
        27: DomainRecordUpdate,
        28: DomainRecordDelete,
        29: DomainRead,
        30: DomainCreate,
        31: DomainDelete,
        32: DropletRead,
        33: DropletCreate,
        34: DropletDelete,
        35: DropletAutoscalePoolRead,
        36: DropletAutoscalePoolCreate,
        37: DropletAutoscalePoolUpdate,
        38: DropletAutoscalePoolDelete,
        39: FirewallRead,
        40: FirewallCreate,
        41: FirewallUpdate,
        42: FirewallDelete,
        43: FloatingIpRead,
        44: FloatingIpCreate,
        45: FloatingIpDelete,
        46: NamespaceRead,
        47: NamespaceCreate,
        48: NamespaceDelete,
        49: GenaiAgentRead,
        50: GenaiAgentCreate,
        51: GenaiAgentUpdate,
        52: GenaiAgentDelete,
        53: ImageRead,
        54: ImageCreate,
        55: ImageUpdate,
        56: ImageDelete,
        57: KubernetesRead,
        58: KubernetesCreate,
        59: KubernetesUpdate,
        60: KubernetesDelete,
        61: LoadBalancerRead,
        62: LoadBalancerCreate,
        63: LoadBalancerUpdate,
        64: LoadBalancerDelete,
        65: MonitoringRead,
        66: MonitoringCreate,
        67: MonitoringUpdate,
        68: MonitoringDelete,
        69: ProjectRead,
        70: ProjectCreate,
        71: ProjectUpdate,
        72: ProjectDelete,
        73: RegionRead,
        74: ReservedIpRead,
        75: ReservedIpCreate,
        76: ReservedIpDelete,
        77: SizeRead,
        78: SnapshotRead,
        79: SnapshotDelete,
        80: SshKeyRead,
        81: SshKeyCreate,
        82: SshKeyUpdate,
        83: SshKeyDelete,
        84: TagRead,
        85: TagCreate,
        86: TagDelete,
        87: UptimeRead,
        88: UptimeCreate,
        89: UptimeUpdate,
        90: UptimeDelete,
        91: VpcPeeringRead,
        92: VpcPeeringCreate,
        93: VpcPeeringUpdate,
        94: VpcPeeringDelete,
        95: VpcRead,
        96: VpcCreate,
        97: VpcUpdate,
        98: VpcDelete,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
