#!/usr/bin/python3

import os,sys

if not sys.argv[1]:
    exit(0)

IS_WRAPPED=False

if "IS_RUNNING_UNDER_CALLER_SCRIPT" in os.environ:
    IS_WRAPPED=os.environ['IS_RUNNING_UNDER_CALLER_SCRIPT']=="1"

def print_normal(msg):

    if IS_WRAPPED:
        return
    print(msg)    

def print_err(file,line_number):
   
    if IS_WRAPPED:
        print("E,%s,%s"%(file,line_number))

def print_warn(file,line_number):
   
    if IS_WRAPPED:
        print("W,%s,%s"%(file,line_number))    

print_normal("[+] Entries starting with slash checker")
if IS_WRAPPED:
    print("Entries starting with slash check")
    print("The warning are more for informative purposes and does not actually serve as a check. You can ignore this.")

files=sys.argv[1].split(" ")

for i in files:
    if not os.path.isfile(i):
        print_err(i,0)
        print_normal("[!] %s does not exist!"%(i))
        exit(2)

pass_status=True

for i in files:
    contents=open(i,"rb").read()
    counter=1

    for line in contents.splitlines():
        if line.startswith(b'/'):
            print_normal("[!] Warning: %s starts with a slash on line %i!"%(i,counter))
            print_warn(i,counter)
            pass_status=False

        counter+=1
    print_normal("[+] %s passed no starting slash check!"%(i))

if pass_status:
    print_normal("[+] All files passed checks")
    exit(0)

print_normal("[!] Warning: One or more files failed to pass the checks")

if IS_WRAPPED:
    exit(0)
else:
    exit(2)