
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                    User Interface                     //
//                                                       //
//                    Program: SAGA                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                    WKSP_Grids.h                       //
//                                                       //
//          Copyright (C) 2017 by Olaf Conrad            //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#ifndef _HEADER_INCLUDED__SAGA_GUI__WKSP_Grids_H
#define _HEADER_INCLUDED__SAGA_GUI__WKSP_Grids_H


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include "wksp_layer.h"
#include "wksp_layer_classify.h"


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CWKSP_Grids : public CWKSP_Layer
{
public:
	CWKSP_Grids(CSG_Grids *pGrids);

	virtual TWKSP_Item			Get_Type				(void)	{	return( WKSP_ITEM_Grids );	}

	CSG_Grids *					Get_Grids				(void)	{	return( (CSG_Grids *)m_pObject );	}

	CSG_Grid *					Get_Grid				(void);
	CSG_Grid *					Get_Grid				(int Band);

	virtual wxString			Get_Description			(void);

	virtual wxToolBarBase *		Get_ToolBar				(void);
	virtual wxMenu *			Get_Menu				(void);

	virtual bool				On_Command				(int Cmd_ID);
	virtual bool				On_Command_UI			(wxUpdateUIEvent &event);

	virtual wxString			Get_Value				(CSG_Point ptWorld, double Epsilon);

	virtual TSG_Rect			Edit_Get_Extent			(void)	{	return( Get_Extent() );	}
	virtual bool				Edit_Set_Attributes		(void);

	virtual bool				Set_Stretch_Extent		(const CSG_Rect &Extent);

	virtual bool				asImage					(CSG_Grid *pImage);

	virtual bool				Update					(CWKSP_Layer *pChanged);


protected:

	bool						Get_Image				(wxImage  &Image , bool bFitSize = true, int Width = 0, int Height = 0);
	bool						Get_Bitmap				(wxBitmap &Bitmap, bool bFitSize = true, int Width = 0, int Height = 0);
	bool						Get_Bitmap_Legend		(wxBitmap &Bitmap, double Zoom);

	bool						Set_Grid_Choices		(CSG_Parameters *pParameters);

	virtual void				On_Create_Parameters	(void);
	virtual void				On_DataObject_Changed	(void);
	virtual void				On_Parameters_Changed	(void);

	virtual int					On_Parameter_Changed	(CSG_Parameters *pParameters, CSG_Parameter *pParameter, int Flags);

	virtual void				On_Draw					(CSG_Map_DC &dc_Map, int Flags);


private:

	int							m_Stretch_Extent = -1;

	CTransparency				m_Alpha;

	CWKSP_Layer_Classify		m_Classify[3];


	CSG_String					_Get_List_Attributes	(void);
	CSG_String					_Get_List_Bands			(int Attribute = -1);

	CSG_Grid *					_Get_Grid				(int Band, const CSG_Parameters &Parameters);

	bool						_Get_Stretch_Extent		(const CSG_Rect &Extent, CSG_Data_Object *pObject, double &Minimum, double &Maximum) const;

	bool						_Save_Image				(void);
	bool						_Save_Image_Clipboard	(void);

	void						_Draw_Cells				(CSG_Map_DC &dc_Map);
	void						_Draw_Points			(CSG_Map_DC &dc_Map);

	bool						_Draw_Get_Color			(int &Color, int x, int y          );
	bool						_Draw_Get_Color			(int &Color, const CSG_Point &Point);


private:

	class CBands
	{
	public:

		bool					bOverlay, bBandStatistics;

		CSG_Grid_Resampling		Resampling;

		CSG_Grid				*pBands[3];

		void					Set_Bands				(CSG_Grid *pB0, CSG_Grid *pB1, CSG_Grid *pB2) { pBands[0] = pB0; pBands[1] = pB1; pBands[2] = pB2; }

		CSG_Grid *				operator []				(int i) { return( pBands[i] ); }
	};

	CBands						m_Bands;

};


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#endif // #ifndef _HEADER_INCLUDED__SAGA_GUI__WKSP_Grids_H
