---
created: 2021-11-02T15:04:03.000+00:00
source_url: https://www.patreon.com/posts/potential-change-58206692
---

# Potential breaking change in next Joplin Server update (2.5.10)

Just a head up that the next Joplin Server update could potentially include a breaking change, depending on your data.

One of the database migration is going to add an "owner_id" column to the "items" table (where all notes, notebooks, etc. are stored), and automatically populate it. Normally that shouldn't take too long but you might want to make sure you won't need the server right away when you process this.

The second database migration will add a unique constraint on items.name and items.owner_id and that's where the breaking change might be. Normally this data is already unique because that's enforced by the application but in some rare cases, due a race condition, there could be duplicate data in there. If that happens the migration will fail and the server will not start.

If that happens, you'll need to decide what to do with the data, as it's not possible to automatically decide. You can find all duplicates using this query:

<code>**select** count(*), name, owner_id
**from** items **group** **by** name, owner_id
**having** count(*) > 1;</code>

Once you have the list of IDs you have a few options:

- Find the corresponding item in Joplin (it can unfortunately be anything - a note, resource, folder, etc.), then delete it and sync.
- Or, just delete the data directly in the database. You'll want to delete the corresponding item\_id from the user\_items table too.

But really in most cases you should be fine. Especially if you don't have that many notes it's unlikely you have duplicates.