/**
 * @file
 * @brief Functions for serving up NOAA parameter abbreviations and
 * GRIB1/GRIB2 translations.
 *
 * @author Ed Hartnett @date 9/19/22
 */
#include "grib2_int.h"

/** The name of the CSV file which contains the NOAA abbreviations. */
#define CSV_FILE "noaa_grib2_params.csv"

/** An array of parameter information. */
static G2C_PARAM_T param[G2C_MAX_NOAA_PARAMS] = {
    {1, 2, 0, 3, 0, "PRES"},
    {2, 2, 0, 3, 1, "PRMSL"},
    {3, 2, 0, 3, 2, "PTEND"},
    {4, 2, 0, 2, 14, "PVORT"},
    {5, 2, 0, 3, 3, "ICAHT"},
    {6, 2, 0, 3, 4, "GP"},
    {7, 2, 0, 3, 5, "HGT"},
    {8, 2, 0, 3, 6, "DIST"},
    {9, 2, 0, 3, 7, "HSTDV"},
    {10, 2, 0, 14, 0, "TOZNE"},
    {11, 2, 0, 0, 0, "TMP"},
    {12, 2, 0, 0, 1, "VTMP"},
    {13, 2, 0, 0, 2, "POT"},
    {14, 2, 0, 0, 3, "EPOT"},
    {15, 2, 0, 0, 4, "TMAX"},
    {16, 2, 0, 0, 5, "TMIN"},
    {17, 2, 0, 0, 6, "DPT"},
    {18, 2, 0, 0, 7, "DEPR"},
    {19, 2, 0, 0, 8, "LAPR"},
    {20, 2, 0, 19, 0, "VIS"},
    {21, 2, 0, 15, 6, "RDSP1"},
    {22, 2, 0, 15, 7, "RDSP2"},
    {23, 2, 0, 15, 8, "RDSP3"},
    {24, 2, 0, 7, 0, "PLI"},
    {25, 2, 0, 0, 9, "TMPA"},
    {26, 2, 0, 3, 8, "PRESA"},
    {27, 2, 0, 3, 9, "GPA"},
    {28, 2, 10, 0, 0, "WVSP1"},
    {29, 2, 10, 0, 1, "WVSP2"},
    {30, 2, 10, 0, 2, "WVSP3"},
    {31, 2, 0, 2, 0, "WDIR"},
    {32, 2, 0, 2, 1, "WIND"},
    {33, 2, 0, 2, 2, "UGRD"},
    {34, 2, 0, 2, 3, "VGRD"},
    {35, 2, 0, 2, 4, "STRM"},
    {36, 2, 0, 2, 5, "VPOT"},
    {37, 2, 0, 2, 6, "MNTSF"},
    {38, 2, 0, 2, 7, "SGCVV"},
    {39, 2, 0, 2, 8, "VVEL"},
    {40, 2, 0, 2, 9, "DZDT"},
    {41, 2, 0, 2, 10, "ABSV"},
    {42, 2, 0, 2, 11, "ABSD"},
    {43, 2, 0, 2, 12, "RELV"},
    {44, 2, 0, 2, 13, "RELD"},
    {45, 2, 0, 2, 15, "VUCSH"},
    {46, 2, 0, 2, 16, "VVCSH"},
    {47, 2, 10, 1, 0, "DIRC"},
    {48, 2, 10, 1, 1, "SPC"},
    {49, 2, 10, 1, 2, "UOGRD"},
    {50, 2, 10, 1, 3, "VOGRD"},
    {51, 2, 0, 1, 0, "SPFH"},
    {52, 2, 0, 1, 1, "RH"},
    {53, 2, 0, 1, 2, "MIXR"},
    {54, 2, 0, 1, 3, "PWAT"},
    {55, 2, 0, 1, 4, "VAPP"},
    {56, 2, 0, 1, 5, "SATD"},
    {57, 2, 0, 1, 6, "EVP"},
    {58, 2, 0, 6, 0, "CICE"},
    {59, 2, 0, 1, 7, "PRATE"},
    {60, 2, 0, 19, 2, "TSTM"},
    {61, 2, 0, 1, 8, "APCP"},
    {62, 2, 0, 1, 9, "NCPCP"},
    {63, 2, 0, 1, 10, "ACPCP"},
    {64, 2, 0, 1, 12, "SRWEQ"},
    {65, 2, 0, 1, 13, "WEASD"},
    {66, 2, 0, 1, 11, "SNOD"},
    {67, 2, 0, 19, 3, "MIXHT"},
    {68, 2, 10, 4, 2, "TTHDP"},
    {69, 2, 10, 4, 0, "MTHD"},
    {70, 2, 10, 4, 1, "MTHA"},
    {71, 2, 0, 6, 1, "TCDC"},
    {72, 2, 0, 6, 2, "CDCON"},
    {73, 2, 0, 6, 3, "LCDC"},
    {74, 2, 0, 6, 4, "MCDC"},
    {75, 2, 0, 6, 5, "HCDC"},
    {76, 2, 0, 6, 6, "CWAT"},
    {77, 2, 0, 7, 1, "BLI"},
    {78, 2, 0, 1, 14, "SNOC"},
    {79, 2, 0, 1, 15, "SNOL"},
    {80, 2, 10, 3, 0, "WTMP"},
    {81, 2, 2, 0, 0, "LAND"},
    {82, 2, 10, 3, 1, "DSLM"},
    {83, 2, 2, 0, 1, "SFCR"},
    {84, 2, 0, 19, 1, "ALBDO"},
    {85, 2, 2, 0, 2, "TSOIL"},
    {86, 2, 2, 0, 3, "SOILM"},
    {87, 2, 2, 0, 4, "VEG"},
    {88, 2, 10, 4, 3, "SALTY"},
    {89, 2, 0, 3, 10, "DEN"},
    {90, 2, 2, 0, 5, "WATR"},
    {91, 2, 10, 2, 0, "ICEC"},
    {92, 2, 10, 2, 1, "ICETK"},
    {93, 2, 10, 2, 2, "DICED"},
    {94, 2, 10, 2, 3, "SICED"},
    {95, 2, 10, 2, 4, "UICE"},
    {96, 2, 10, 2, 5, "VICE"},
    {97, 2, 10, 2, 6, "ICEG"},
    {98, 2, 10, 2, 7, "ICED"},
    {99, 2, 0, 1, 16, "SNOM"},
    {100, 2, 10, 0, 3, "HTSGW"},
    {101, 2, 10, 0, 4, "WVDIR"},
    {102, 2, 10, 0, 5, "WVHGT"},
    {103, 2, 10, 0, 6, "WVPER"},
    {104, 2, 10, 0, 7, "SWDIR"},
    {105, 2, 10, 0, 8, "SWELL"},
    {106, 2, 10, 0, 9, "SWPER"},
    {107, 2, 10, 0, 10, "DIRPW"},
    {108, 2, 10, 0, 11, "PERPW"},
    {109, 2, 10, 0, 12, "DIRSW"},
    {110, 2, 10, 0, 13, "PERSW"},
    {111, 2, 0, 4, 0, "NSWRS"},
    {112, 2, 0, 5, 0, "NLWRS"},
    {113, 2, 0, 4, 1, "NSWRT"},
    {114, 2, 0, 5, 1, "NLWRT"},
    {115, 2, 0, 5, 2, "LWAVR"},
    {116, 2, 0, 4, 2, "SWAVR"},
    {117, 2, 0, 4, 3, "GRAD"},
    {118, 2, 0, 4, 4, "BRTMP"},
    {119, 2, 0, 4, 5, "LWRAD"},
    {120, 2, 0, 4, 6, "SWRAD"},
    {121, 2, 0, 0, 10, "LHTFL"},
    {122, 2, 0, 0, 11, "SHTFL"},
    {123, 2, 0, 2, 20, "BLYDP"},
    {124, 2, 0, 2, 17, "UFLX"},
    {125, 2, 0, 2, 18, "VFLX"},
    {126, 2, 0, 2, 19, "WMIXE"},
    {127, 2, 255, 255, 255, "IMGD"},
    {229, 2, 0, 0, 192, "SNOHF"},
    {153, 2, 0, 1, 22, "CLWMR"},
    {140, 2, 0, 1, 192, "CRAIN"},
    {141, 2, 0, 1, 193, "CFRZR"},
    {142, 2, 0, 1, 194, "CICEP"},
    {143, 2, 0, 1, 195, "CSNOW"},
    {214, 2, 0, 1, 196, "CPRAT"},
    {135, 2, 0, 1, 197, "MCONV"},
    {194, 2, 1, 1, 193, "CPOFP"},
    {228, 2, 0, 1, 199, "PEVAP"},
    {136, 2, 0, 2, 192, "VWSH"},
    {172, 2, 0, 2, 193, "MFLX"},
    {196, 2, 0, 2, 194, "USTM"},
    {197, 2, 0, 2, 195, "VSTM"},
    {252, 2, 0, 2, 196, "CD"},
    {253, 2, 0, 2, 197, "FRICV"},
    {130, 2, 0, 3, 192, "MSLET"},
    {204, 2, 0, 4, 192, "DSWRF"},
    {211, 2, 0, 4, 193, "USWRF"},
    {205, 2, 0, 5, 192, "DLWRF"},
    {212, 2, 0, 5, 193, "ULWRF"},
    {213, 2, 0, 6, 192, "CDLYR"},
    {132, 2, 0, 7, 193, "4LFTX"},
    {157, 2, 0, 7, 6, "CAPE"},
    {156, 2, 0, 7, 7, "CIN"},
    {190, 2, 0, 7, 8, "HLCY"},
    {131, 2, 0, 7, 192, "LFTX"},
    {158, 2, 0, 19, 11, "TKE"},
    {176, 2, 0, 191, 192, "NLAT"},
    {177, 2, 0, 191, 193, "ELON"},
    {234, 2, 1, 0, 192, "BGRUN"},
    {235, 2, 1, 0, 193, "SSRUN"},
    {144, 2, 2, 0, 192, "SOILW"},
    {155, 2, 2, 0, 193, "GFLUX"},
    {207, 2, 2, 0, 194, "MSTAV"},
    {208, 2, 2, 0, 195, "SFEXC"},
    {223, 2, 2, 0, 196, "CNWAT"},
    {226, 2, 2, 0, 197, "BMIXL"},
    {154, 2, 0, 14, 192, "O3MR"},
    {222, 2, 0, 3, 193, "5WAVH"},
    {145, 2, 0, 1, 200, "PEVPR"},
    {146, 2, 0, 6, 193, "CWORK"},
    {147, 2, 0, 3, 194, "U-GWD"},
    {148, 2, 0, 3, 195, "V-GWD"},
    {221, 2, 0, 3, 196, "HPBL"},
    {230, 2, 0, 3, 197, "5WAVA"},
    {160, 130, 2, 3, 192, "SOILL"},
    {171, 130, 2, 3, 193, "RLYRS"},
    {219, 130, 2, 0, 201, "WILT"},
    {222, 130, 2, 3, 194, "SLTYP"},
    {224, 2, 2, 3, 0, "SOTYP"},
    {225, 2, 2, 0, 198, "VGTYP"},
    {230, 130, 2, 3, 195, "SMREF"},
    {231, 130, 2, 3, 196, "SMDRY"},
    {238, 2, 0, 1, 201, "SNOWC"},
    {240, 130, 2, 3, 197, "POROS"},
    {131, 129, 0, 1, 202, "FRAIN"},
    {132, 129, 0, 6, 199, "FICE"},
    {133, 129, 0, 1, 203, "RIME"},
    {134, 129, 0, 6, 194, "CUEFI"},
    {135, 129, 0, 6, 195, "TCOND"},
    {136, 129, 0, 6, 196, "TCOLW"},
    {137, 129, 0, 6, 197, "TCOLI"},
    {138, 129, 0, 1, 204, "TCOLR"},
    {139, 129, 0, 1, 205, "TCOLS"},
    {140, 129, 0, 6, 198, "TCOLC"},
    {159, 130, 0, 19, 192, "MXSALB"},
    {170, 130, 0, 19, 193, "SNFALB"},
    {170, 2, 0, 1, 24, "RWMR"},
    {171, 2, 0, 1, 25, "SNMR"},
    {181, 130, 2, 0, 199, "CCOND"},
    {203, 130, 2, 0, 200, "RSMIN"},
    {246, 130, 2, 0, 202, "RCS"},
    {247, 130, 2, 0, 203, "RCT"},
    {248, 130, 2, 0, 204, "RCQ"},
    {249, 130, 2, 0, 205, "RCSOL"},
    {254, 2, 0, 7, 194, "RI"},
    {190, 129, 3, 1, 192, "USCT"},
    {191, 129, 3, 1, 193, "VSCT"},
    {171, 129, 0, 191, 194, "TSEC"},
    {180, 129, 0, 14, 193, "OZCON"},
    {181, 129, 0, 14, 194, "OZCAT"},
    {193, 2, 1, 1, 2, "POP"},
    {195, 2, 1, 1, 192, "CPOZP"},
    {180, 2, 0, 2, 22, "GUST"},
    {31, 0, 0, 2, 0, "WDIR"},
    {32, 0, 0, 2, 1, "WIND"},
    {33, 0, 0, 2, 2, "UGRD"},
    {34, 0, 0, 2, 3, "VGRD"},
    {100, 0, 10, 0, 3, "HTSGW"},
    {101, 0, 10, 0, 4, "WVDIR"},
    {103, 0, 10, 0, 6, "WVPER"},
    {107, 0, 10, 0, 10, "DIRPW"},
    {108, 0, 10, 0, 11, "PERPW"},
    {109, 0, 10, 0, 12, "DIRSW"},
    {110, 0, 10, 0, 13, "PERSW"},
    {156, 129, 0, 13, 192, "PMTC"},
    {157, 129, 0, 13, 193, "PMTF"},
    {11, 3, 0, 0, 0, "TMP"},
    {129, 2, 0, 3, 198, "MSLMA"},
    {163, 129, 0, 13, 194, "LPMTF"},
    {164, 129, 0, 13, 195, "LIPMF"},
    {178, 2, 0, 1, 23, "ICMR"},
    {179, 2, 0, 1, 32, "GRMR"},
    {186, 2, 0, 1, 206, "TIPD"},
    {187, 2, 0, 17, 192, "LTNG"},
    {188, 2, 2, 0, 206, "RDRIP"},
    {189, 2, 0, 0, 15, "VPTMP"},
    {198, 2, 0, 1, 207, "NCIP"},
    {239, 2, 0, 1, 208, "SNOT"},
    {128, 2, 0, 3, 1, "MSLSA"},
    {137, 2, 0, 3, 199, "TSLSA"},
    {141, 129, 0, 3, 200, "PLPL"},
    {200, 129, 0, 4, 194, "DUVB"},
    {201, 129, 0, 4, 195, "CDUVB"},
    {201, 2, 2, 0, 207, "ICWAT"},
    {209, 2, 0, 19, 204, "MIXLY"},
    {216, 2, 0, 0, 193, "TTRAD"},
    {211, 129, 0, 16, 195, "REFD"},
    {212, 129, 0, 16, 196, "REFC"},
    {161, 2, 0, 4, 196, "CSDSF"},
    {168, 129, 0, 1, 209, "TCLSW"},
    {169, 129, 0, 1, 210, "TCOLM"},
    {181, 2, 0, 3, 201, "LPSX"},
    {182, 2, 0, 3, 202, "LPSY"},
    {183, 2, 0, 3, 203, "HGTX"},
    {184, 2, 0, 3, 204, "HGTY"},
    {254, 128, 0, 0, 194, "REV"},
    {91, 1, 10, 2, 0, "ICEC"},
    {49, 0, 10, 1, 2, "UOGRD"},
    {50, 0, 10, 1, 3, "VOGRD"},
    {80, 0, 10, 3, 0, "WTMP"},
    {82, 0, 10, 3, 1, "DSLM"},
    {88, 0, 10, 4, 3, "SALTY"},
    {49, 1, 10, 1, 2, "UOGRD"},
    {50, 1, 10, 1, 3, "VOGRD"},
    {80, 1, 10, 3, 0, "WTMP"},
    {88, 1, 10, 4, 3, "SALTY"},
    {40, 1, 0, 2, 9, "DZDT"},
    {67, 1, 0, 19, 3, "MIXHT"},
    {2, 3, 0, 3, 1, "PRMSL"},
    {7, 3, 0, 3, 5, "HGT"},
    {130, 128, 10, 3, 194, "ELEV"},
    {217, 129, 0, 1, 198, "MINRH"},
    {218, 129, 0, 1, 27, "MAXRH"},
    {161, 130, 0, 1, 29, "ASNOW"},
    {165, 129, 0, 16, 192, "REFZR"},
    {166, 129, 0, 16, 193, "REFZI"},
    {167, 129, 0, 16, 194, "REFZC"},
    {192, 129, 0, 2, 198, "LAUV"},
    {193, 129, 0, 2, 199, "LOUV"},
    {188, 129, 0, 2, 200, "LAVV"},
    {189, 129, 0, 2, 201, "LOVV"},
    {207, 129, 0, 2, 202, "LAPP"},
    {208, 129, 0, 2, 203, "LOPP"},
    {198, 129, 10, 3, 195, "SSHG"},
    {33, 1, 0, 2, 2, "UGRD"},
    {34, 1, 0, 2, 3, "VGRD"},
    {2, 1, 0, 3, 1, "PRMSL"},
    {7, 1, 0, 3, 5, "HGT"},
    {186, 128, 10, 4, 192, "WTMPC"},
    {187, 128, 10, 4, 193, "SALIN"},
    {177, 128, 10, 3, 196, "P2OMLT"},
    {178, 128, 10, 1, 192, "OMLU"},
    {179, 128, 10, 1, 193, "OMLV"},
    {183, 128, 10, 1, 194, "UBARO"},
    {184, 128, 10, 1, 195, "VBARO"},
    {179, 129, 0, 19, 205, "FLGHT"},
    {185, 129, 0, 19, 206, "CICEL"},
    {186, 129, 0, 19, 207, "CIVIS"},
    {187, 129, 0, 19, 208, "CIFLT"},
    {177, 129, 0, 19, 209, "LAVNI"},
    {178, 129, 0, 19, 210, "HAVNI"},
    {189, 130, 0, 19, 211, "SBSALB"},
    {190, 130, 0, 19, 212, "SWSALB"},
    {191, 130, 0, 19, 213, "NBSALB"},
    {192, 130, 0, 19, 214, "NWSALB"},
    {149, 129, 10, 0, 192, "WSTP"},
    {188, 128, 0, 1, 211, "EMNP"},
    {192, 128, 0, 3, 205, "LAYTH"},
    {219, 129, 0, 6, 13, "CEIL"},
    {220, 129, 0, 19, 12, "PBLREG"},
    {179, 130, 2, 0, 228, "ACOND"},
    {198, 130, 0, 1, 212, "SBSNO"},
    {199, 2, 2, 3, 198, "EVBS"},
    {200, 2, 2, 0, 229, "EVCW"},
    {210, 2, 2, 0, 230, "TRANS"},
    {182, 129, 0, 2, 204, "VEDH"},
    {241, 2, 0, 0, 195, "LRGHR"},
    {242, 2, 0, 0, 196, "CNVHR"},
    {168, 140, 0, 19, 20, "ICIP"},
    {169, 140, 0, 19, 20, "ICIP"},
    {170, 140, 0, 19, 21, "CTP"},
    {171, 140, 0, 19, 21, "CTP"},
    {172, 140, 0, 19, 22, "CAT"},
    {173, 140, 0, 19, 22, "CAT"},
    {174, 140, 0, 6, 25, "CBHE"},
    {175, 140, 255, 255, 255, "IMGD"},
    {176, 140, 255, 255, 255, "IMGD"},
    {177, 140, 255, 255, 255, "IMGD"},
    {178, 140, 255, 255, 255, "IMGD"},
    {179, 140, 0, 3, 3, "ICAHT"},
    {180, 140, 0, 3, 3, "ICAHT"},
    {181, 140, 255, 255, 255, "IMGD"},
    {182, 140, 255, 255, 255, "IMGD"},
    {76, 129, 0, 6, 6, "CWAT"},
    {104, 0, 10, 0, 7, "SWDIR"},
    {105, 0, 10, 0, 8, "SWELL"},
    {106, 0, 10, 0, 9, "SWPER"},
    {102, 0, 10, 0, 5, "WVHGT"},
    {213, 129, 3, 192, 0, "SBT122"},
    {214, 129, 3, 192, 1, "SBT123"},
    {215, 129, 3, 192, 2, "SBT124"},
    {216, 129, 3, 192, 3, "SBT126"},
    {221, 129, 3, 192, 4, "SBC123"},
    {222, 129, 3, 192, 5, "SBC124"},
    {228, 129, 10, 3, 192, "SURGE"},
    {229, 129, 10, 3, 193, "ETSRG"},
    {149, 2, 0, 2, 14, "PVORT"},
    {150, 2, 0, 192, 1, "COVMZ"},
    {151, 2, 0, 192, 2, "COVTZ"},
    {152, 2, 0, 192, 3, "COVTM"},
    {202, 129, 0, 0, 197, "THFLX"},
    {33, 3, 0, 2, 2, "UGRD"},
    {34, 3, 0, 2, 3, "VGRD"},
    {40, 3, 0, 2, 9, "DZDT"},
    {124, 3, 0, 2, 17, "UFLX"},
    {125, 3, 0, 2, 18, "VFLX"},
    {8, 3, 0, 3, 6, "DIST"},
    {13, 3, 0, 0, 2, "POT"},
    {88, 3, 10, 4, 3, "SALTY"},
    {49, 3, 10, 1, 2, "UOGRD"},
    {50, 3, 10, 1, 3, "VOGRD"},
    {215, 2, 0, 0, 198, "TTDIA"},
    {217, 2, 0, 0, 199, "TTPHY"},
    {154, 130, 2, 3, 199, "LSPA"},
    {250, 2, 0, 4, 197, "SWHR"},
    {251, 2, 0, 5, 194, "LWHR"},
    {160, 2, 0, 4, 198, "CSUSF"},
    {162, 2, 0, 5, 195, "CSULF"},
    {163, 2, 0, 5, 196, "CSDLF"},
    {164, 2, 0, 4, 199, "CFNSF"},
    {165, 2, 0, 5, 197, "CFNLF"},
    {166, 2, 0, 4, 200, "VBDSF"},
    {167, 2, 0, 4, 201, "VDDSF"},
    {168, 2, 0, 4, 202, "NBDSF"},
    {169, 2, 0, 4, 203, "NDDSF"},
    {206, 2, 0, 7, 196, "UVI"},
    {219, 2, 0, 0, 200, "TSD1D"},
    {220, 2, 0, 3, 206, "NLGSP"},
    {244, 2, 0, 0, 201, "SHAHR"},
    {246, 2, 0, 0, 202, "VDFHR"},
    {243, 2, 0, 1, 213, "CNVMR"},
    {245, 2, 0, 1, 214, "SHAMR"},
    {249, 2, 0, 1, 215, "VDFMR"},
    {247, 2, 0, 2, 208, "VDFUA"},
    {248, 2, 0, 2, 209, "VDFVA"},
    {202, 3, 0, 7, 195, "CWDI"},
    {232, 2, 0, 4, 204, "DTRF"},
    {233, 2, 0, 4, 205, "UTRF"},
    {231, 2, 0, 6, 200, "MFLUX"},
    {202, 2, 0, 7, 195, "CWDI"},
    {203, 2, 0, 19, 232, "VAFTD"},
    {238, 3, 0, 1, 201, "SNOWC"},
    {66, 3, 0, 1, 11, "SNOD"},
    {133, 2, 0, 7, 2, "KX"},
    {134, 2, 0, 7, 5, "SX"},
    {191, 128, 10, 4, 194, "BKENG"},
    {195, 129, 10, 4, 195, "DBSS"},
    {171, 128, 10, 3, 197, "AOHFLX"},
    {180, 128, 10, 3, 198, "ASHFL"},
    {193, 128, 10, 3, 199, "SSTT"},
    {194, 128, 10, 3, 200, "SSST"},
    {190, 128, 10, 3, 201, "KENG"},
    {185, 128, 10, 4, 196, "INTFD"},
    {199, 129, 10, 3, 202, "SLTFL"},
    {197, 129, 10, 4, 197, "OHC"},
    {159, 2, 0, 1, 216, "CONP"},
    {175, 2, 0, 191, 195, "MLYNO"},
    {223, 129, 0, 1, 65, "RPRATE"},
    {224, 129, 0, 1, 66, "SPRATE"},
    {225, 129, 0, 1, 67, "FPRATE"},
    {226, 129, 0, 1, 68, "IPRATE"},
    {227, 129, 0, 7, 197, "UPHL"},
    {87, 3, 2, 0, 4, "VEG"},
    {130, 129, 1, 1, 195, "CWR"},
    {240, 2, 0, 192, 4, "COVTW"},
    {164, 133, 0, 192, 5, "COVZZ"},
    {165, 133, 0, 192, 6, "COVMM"},
    {166, 133, 0, 192, 7, "COVQZ"},
    {167, 133, 0, 192, 8, "COVQM"},
    {168, 133, 0, 192, 9, "COVTVV"},
    {169, 133, 0, 192, 10, "COVQVV"},
    {203, 133, 0, 192, 11, "COVPSPS"},
    {206, 133, 0, 192, 12, "COVQQ"},
    {220, 133, 0, 192, 13, "COVVVVV"},
    {234, 133, 0, 192, 14, "COVTT"},
    {201, 133, 0, 0, 203, "THZ0"},
    {195, 133, 0, 1, 218, "QZ0"},
    {204, 133, 0, 1, 219, "QMAX"},
    {205, 133, 0, 1, 220, "QMIN"},
    {181, 133, 0, 2, 210, "GWDU"},
    {182, 133, 0, 2, 211, "GWDV"},
    {183, 133, 0, 2, 212, "CNVU"},
    {184, 133, 0, 2, 213, "CNVV"},
    {236, 133, 0, 2, 214, "WTEND"},
    {154, 133, 0, 2, 215, "OMGALF"},
    {196, 133, 0, 2, 216, "CNGWDU"},
    {197, 133, 0, 2, 217, "CNGWDV"},
    {202, 133, 0, 3, 207, "CNVUMF"},
    {209, 133, 0, 3, 208, "CNVDMF"},
    {219, 133, 0, 3, 209, "CNVDEMF"},
    {173, 133, 0, 1, 217, "LRGMR"},
    {174, 133, 0, 14, 195, "VDFOZ"},
    {175, 133, 0, 14, 196, "POZ"},
    {188, 133, 0, 14, 197, "TOZ"},
    {139, 133, 0, 14, 198, "POZT"},
    {239, 133, 0, 14, 199, "POZO"},
    {185, 133, 2, 0, 208, "AKHS"},
    {186, 133, 2, 0, 209, "AKMS"},
    {193, 133, 0, 19, 218, "EPSR"},
    {229, 130, 0, 0, 192, "SNOHF"},
    {194, 129, 0, 0, 204, "TCHP"},
    {185, 2, 0, 19, 219, "TPFI"},
    {182, 130, 0, 7, 198, "LAI"},
    {173, 2, 0, 3, 210, "LMH"},
    {174, 2, 0, 2, 218, "LMV"},
    {1, 131, 0, 3, 0, "PRES"},
    {2, 131, 0, 3, 1, "PRMSL"},
    {3, 131, 0, 3, 2, "PTEND"},
    {4, 131, 0, 2, 14, "PVORT"},
    {5, 131, 0, 3, 3, "ICAHT"},
    {6, 131, 0, 3, 4, "GP"},
    {7, 131, 0, 3, 5, "HGT"},
    {8, 131, 0, 3, 6, "DIST"},
    {9, 131, 0, 3, 7, "HSTDV"},
    {10, 131, 0, 14, 0, "TOZNE"},
    {11, 131, 0, 0, 0, "TMP"},
    {12, 131, 0, 0, 1, "VTMP"},
    {13, 131, 0, 0, 2, "POT"},
    {14, 131, 0, 0, 3, "EPOT"},
    {15, 131, 0, 0, 4, "TMAX"},
    {16, 131, 0, 0, 5, "TMIN"},
    {17, 131, 0, 0, 6, "DPT"},
    {18, 131, 0, 0, 7, "DEPR"},
    {19, 131, 0, 0, 8, "LAPR"},
    {20, 131, 0, 19, 0, "VIS"},
    {21, 131, 0, 15, 6, "RDSP1"},
    {22, 131, 0, 15, 7, "RDSP2"},
    {23, 131, 0, 15, 8, "RDSP3"},
    {24, 131, 0, 7, 0, "PLI"},
    {25, 131, 0, 0, 9, "TMPA"},
    {26, 131, 0, 3, 8, "PRESA"},
    {27, 131, 0, 3, 9, "GPA"},
    {28, 131, 10, 0, 0, "WVSP1"},
    {29, 131, 10, 0, 1, "WVSP2"},
    {30, 131, 10, 0, 2, "WVSP3"},
    {31, 131, 0, 2, 0, "WDIR"},
    {32, 131, 0, 2, 1, "WIND"},
    {33, 131, 0, 2, 2, "UGRD"},
    {34, 131, 0, 2, 3, "VGRD"},
    {35, 131, 0, 2, 4, "STRM"},
    {36, 131, 0, 2, 5, "VPOT"},
    {37, 131, 0, 2, 6, "MNTSF"},
    {38, 131, 0, 2, 7, "SGCVV"},
    {39, 131, 0, 2, 8, "VVEL"},
    {40, 131, 0, 2, 9, "DZDT"},
    {41, 131, 0, 2, 10, "ABSV"},
    {42, 131, 0, 2, 11, "ABSD"},
    {43, 131, 0, 2, 12, "RELV"},
    {44, 131, 0, 2, 13, "RELD"},
    {45, 131, 0, 2, 15, "VUCSH"},
    {46, 131, 0, 2, 16, "VVCSH"},
    {47, 131, 10, 1, 0, "DIRC"},
    {48, 131, 10, 1, 1, "SPC"},
    {49, 131, 10, 1, 2, "UOGRD"},
    {50, 131, 10, 1, 3, "VOGRD"},
    {51, 131, 0, 1, 0, "SPFH"},
    {52, 131, 0, 1, 1, "RH"},
    {53, 131, 0, 1, 2, "MIXR"},
    {54, 131, 0, 1, 3, "PWAT"},
    {55, 131, 0, 1, 4, "VAPP"},
    {56, 131, 0, 1, 5, "SATD"},
    {57, 131, 0, 1, 6, "EVP"},
    {58, 131, 0, 6, 0, "CICE"},
    {59, 131, 0, 1, 7, "PRATE"},
    {60, 131, 0, 19, 2, "TSTM"},
    {61, 131, 0, 1, 8, "APCP"},
    {62, 131, 0, 1, 9, "NCPCP"},
    {63, 131, 0, 1, 10, "ACPCP"},
    {64, 131, 0, 1, 12, "SRWEQ"},
    {65, 131, 0, 1, 13, "WEASD"},
    {66, 131, 0, 1, 11, "SNOD"},
    {67, 131, 0, 19, 3, "MIXHT"},
    {68, 131, 10, 4, 2, "TTHDP"},
    {69, 131, 10, 4, 0, "MTHD"},
    {70, 131, 10, 4, 1, "MTHA"},
    {71, 131, 0, 6, 1, "TCDC"},
    {72, 131, 0, 6, 2, "CDCON"},
    {73, 131, 0, 6, 3, "LCDC"},
    {74, 131, 0, 6, 4, "MCDC"},
    {75, 131, 0, 6, 5, "HCDC"},
    {76, 131, 0, 6, 6, "CWAT"},
    {77, 131, 0, 7, 1, "BLI"},
    {78, 131, 0, 1, 14, "SNOC"},
    {79, 131, 0, 1, 15, "SNOL"},
    {80, 131, 10, 3, 0, "WTMP"},
    {81, 131, 2, 0, 0, "LAND"},
    {82, 131, 10, 3, 1, "DSLM"},
    {83, 131, 2, 0, 1, "SFCR"},
    {84, 131, 0, 19, 1, "ALBDO"},
    {85, 131, 2, 0, 2, "TSOIL"},
    {86, 131, 2, 0, 3, "SOILM"},
    {87, 131, 2, 0, 4, "VEG"},
    {88, 131, 10, 4, 3, "SALTY"},
    {89, 131, 0, 3, 10, "DEN"},
    {90, 131, 2, 0, 5, "WATR"},
    {91, 131, 10, 2, 0, "ICEC"},
    {92, 131, 10, 2, 1, "ICETK"},
    {93, 131, 10, 2, 2, "DICED"},
    {94, 131, 10, 2, 3, "SICED"},
    {95, 131, 10, 2, 4, "UICE"},
    {96, 131, 10, 2, 5, "VICE"},
    {97, 131, 10, 2, 6, "ICEG"},
    {98, 131, 10, 2, 7, "ICED"},
    {99, 131, 0, 1, 16, "SNOM"},
    {100, 131, 10, 0, 3, "HTSGW"},
    {101, 131, 10, 0, 4, "WVDIR"},
    {102, 131, 10, 0, 5, "WVHGT"},
    {103, 131, 10, 0, 6, "WVPER"},
    {104, 131, 10, 0, 7, "SWDIR"},
    {105, 131, 10, 0, 8, "SWELL"},
    {106, 131, 10, 0, 9, "SWPER"},
    {107, 131, 10, 0, 10, "DIRPW"},
    {108, 131, 10, 0, 11, "PERPW"},
    {109, 131, 10, 0, 12, "DIRSW"},
    {110, 131, 10, 0, 13, "PERSW"},
    {111, 131, 0, 4, 0, "NSWRS"},
    {112, 131, 0, 5, 0, "NLWRS"},
    {113, 131, 0, 4, 1, "NSWRT"},
    {114, 131, 0, 5, 1, "NLWRT"},
    {115, 131, 0, 5, 2, "LWAVR"},
    {116, 131, 0, 4, 2, "SWAVR"},
    {117, 131, 0, 4, 3, "GRAD"},
    {118, 131, 0, 4, 4, "BRTMP"},
    {119, 131, 0, 4, 5, "LWRAD"},
    {120, 131, 0, 4, 6, "SWRAD"},
    {121, 131, 0, 0, 10, "LHTFL"},
    {122, 131, 0, 0, 11, "SHTFL"},
    {123, 131, 0, 2, 20, "BLYDP"},
    {124, 131, 0, 2, 17, "UFLX"},
    {125, 131, 0, 2, 18, "VFLX"},
    {126, 131, 0, 2, 19, "WMIXE"},
    {127, 131, 255, 255, 255, "IMGD"},
    {128, 131, 0, 3, 1, "MSLSA"},
    {130, 131, 0, 3, 192, "MSLET"},
    {131, 131, 0, 7, 192, "LFTX"},
    {132, 131, 0, 7, 193, "4LFTX"},
    {134, 131, 0, 3, 212, "PRESN"},
    {135, 131, 0, 1, 197, "MCONV"},
    {136, 131, 0, 2, 192, "VWSH"},
    {137, 131, 0, 2, 219, "PVMWW"},
    {140, 131, 0, 1, 192, "CRAIN"},
    {141, 131, 0, 1, 193, "CFRZR"},
    {142, 131, 0, 1, 194, "CICEP"},
    {143, 131, 0, 1, 195, "CSNOW"},
    {144, 131, 2, 0, 192, "SOILW"},
    {145, 131, 0, 1, 200, "PEVPR"},
    {146, 131, 2, 0, 210, "VEGT"},
    {147, 131, 2, 3, 200, "BARET"},
    {148, 131, 2, 3, 201, "AVSFT"},
    {149, 131, 2, 3, 202, "RADT"},
    {150, 131, 2, 0, 211, "SSTOR"},
    {151, 131, 2, 0, 212, "LSOIL"},
    {152, 131, 2, 0, 213, "EWATR"},
    {153, 131, 0, 1, 22, "CLWMR"},
    {155, 131, 2, 0, 193, "GFLUX"},
    {156, 131, 0, 7, 7, "CIN"},
    {157, 131, 0, 7, 6, "CAPE"},
    {158, 131, 0, 19, 11, "TKE"},
    {159, 131, 0, 19, 192, "MXSALB"},
    {160, 131, 2, 3, 192, "SOILL"},
    {161, 131, 0, 1, 29, "ASNOW"},
    {162, 131, 0, 1, 221, "ARAIN"},
    {163, 131, 2, 0, 214, "GWREC"},
    {164, 131, 2, 0, 215, "QREC"},
    {165, 131, 0, 1, 222, "SNOWT"},
    {166, 131, 0, 4, 200, "VBDSF"},
    {167, 131, 0, 4, 201, "VDDSF"},
    {168, 131, 0, 4, 202, "NBDSF"},
    {169, 131, 0, 4, 203, "NDDSF"},
    {170, 131, 0, 19, 193, "SNFALB"},
    {171, 131, 2, 3, 193, "RLYRS"},
    {172, 131, 0, 2, 193, "MFLX"},
    {173, 131, 0, 3, 210, "LMH"},
    {174, 131, 0, 2, 218, "LMV"},
    {175, 131, 0, 191, 195, "MLYNO"},
    {176, 131, 0, 191, 192, "NLAT"},
    {177, 131, 0, 191, 193, "ELON"},
    {178, 131, 0, 1, 23, "ICMR"},
    {179, 131, 2, 0, 228, "ACOND"},
    {180, 131, 0, 1, 17, "SNOAG"},
    {181, 131, 2, 0, 199, "CCOND"},
    {182, 131, 0, 7, 198, "LAI"},
    {183, 131, 2, 0, 216, "SFCRH"},
    {184, 131, 0, 19, 19, "SALBD"},
    {187, 131, 2, 0, 217, "NDVI"},
    {188, 131, 2, 0, 206, "RDRIP"},
    {189, 131, 2, 0, 218, "LANDN"},
    {190, 131, 0, 7, 8, "HLCY"},
    {191, 131, 0, 191, 196, "NLATN"},
    {192, 131, 0, 191, 197, "ELONN"},
    {194, 131, 1, 1, 193, "CPOFP"},
    {196, 131, 0, 2, 194, "USTM"},
    {197, 131, 0, 2, 195, "VSTM"},
    {198, 131, 0, 1, 212, "SBSNO"},
    {199, 131, 2, 3, 198, "EVBS"},
    {200, 131, 2, 0, 229, "EVCW"},
    {202, 131, 0, 1, 223, "APCPN"},
    {203, 131, 2, 0, 200, "RSMIN"},
    {204, 131, 0, 4, 192, "DSWRF"},
    {205, 131, 0, 5, 192, "DLWRF"},
    {206, 131, 0, 1, 224, "ACPCPN"},
    {207, 131, 2, 0, 194, "MSTAV"},
    {208, 131, 2, 0, 195, "SFEXC"},
    {210, 131, 2, 0, 230, "TRANS"},
    {211, 131, 0, 4, 193, "USWRF"},
    {212, 131, 0, 5, 193, "ULWRF"},
    {213, 131, 0, 6, 192, "CDLYR"},
    {214, 131, 0, 1, 196, "CPRAT"},
    {216, 131, 0, 0, 193, "TTRAD"},
    {218, 131, 0, 3, 211, "HGTN"},
    {219, 131, 2, 0, 201, "WILT"},
    {220, 130, 2, 3, 203, "FLDCP"},
    {221, 131, 0, 3, 196, "HPBL"},
    {222, 131, 2, 3, 194, "SLTYP"},
    {223, 131, 2, 0, 196, "CNWAT"},
    {224, 131, 2, 3, 0, "SOTYP"},
    {225, 131, 2, 0, 198, "VGTYP"},
    {226, 131, 2, 0, 197, "BMIXL"},
    {227, 131, 2, 0, 219, "AMIXL"},
    {228, 131, 0, 1, 199, "PEVAP"},
    {229, 131, 0, 0, 192, "SNOHF"},
    {230, 131, 2, 3, 195, "SMREF"},
    {231, 131, 2, 3, 196, "SMDRY"},
    {232, 131, 2, 0, 220, "WVINC"},
    {233, 131, 2, 0, 221, "WCINC"},
    {234, 131, 1, 0, 192, "BGRUN"},
    {235, 131, 1, 0, 193, "SSRUN"},
    {237, 131, 2, 0, 222, "WVCONV"},
    {238, 131, 0, 1, 201, "SNOWC"},
    {239, 131, 0, 1, 208, "SNOT"},
    {240, 131, 2, 3, 197, "POROS"},
    {241, 131, 2, 0, 223, "WCCONV"},
    {242, 131, 2, 0, 224, "WVUFLX"},
    {243, 131, 2, 0, 225, "WVVFLX"},
    {244, 131, 2, 0, 226, "WCUFLX"},
    {245, 131, 2, 0, 227, "WCVFLX"},
    {246, 131, 2, 0, 202, "RCS"},
    {247, 131, 2, 0, 203, "RCT"},
    {248, 131, 2, 0, 204, "RCQ"},
    {249, 131, 2, 0, 205, "RCSOL"},
    {250, 131, 0, 4, 197, "SWHR"},
    {251, 131, 0, 5, 194, "LWHR"},
    {252, 131, 0, 2, 196, "CD"},
    {253, 131, 0, 2, 197, "FRICV"},
    {254, 131, 0, 7, 194, "RI"},
    {62, 129, 0, 1, 9, "NCPCP"},
    {63, 129, 0, 1, 10, "ACPCP"},
    {220, 131, 2, 3, 203, "FLDCP"},
    {231, 129, 0, 14, 200, "OZMAX1"},
    {232, 129, 0, 14, 201, "OZMAX8"},
    {240, 129, 0, 16, 197, "RETOP"},
    {191, 133, 0, 6, 201, "SUNSD"},
    {233, 129, 0, 14, 202, "PDMAX1"},
    {234, 129, 0, 14, 203, "PDMAX24"},
    {242, 129, 10, 3, 242, "TCSRG20"},
    {243, 129, 10, 3, 243, "TCSRG30"},
    {244, 129, 10, 3, 244, "TCSRG40"},
    {245, 129, 10, 3, 245, "TCSRG50"},
    {246, 129, 10, 3, 246, "TCSRG60"},
    {247, 129, 10, 3, 247, "TCSRG70"},
    {248, 129, 10, 3, 248, "TCSRG80"},
    {249, 129, 10, 3, 249, "TCSRG90"},
    {1, 3, 0, 3, 0, "PRES"},
    {52, 3, 0, 1, 1, "RH"},
    {63, 3, 0, 1, 10, "ACPCP"},
    {61, 3, 0, 1, 8, "APCP"},
    {41, 3, 0, 2, 10, "ABSV"},
    {100, 3, 10, 0, 3, "HTSGW"},
    {101, 3, 10, 0, 4, "WVDIR"},
    {103, 3, 10, 0, 6, "WVPER"},
    {104, 3, 10, 0, 7, "SWDIR"},
    {105, 3, 10, 0, 8, "SWELL"},
    {107, 3, 10, 0, 10, "DIRPW"},
    {108, 3, 10, 0, 11, "PERPW"},
    {109, 3, 10, 0, 12, "DIRSW"},
    {110, 3, 10, 0, 13, "PERSW"},
    {192, 133, 10, 191, 1, "MOSF"},
    {193, 130, 0, 1, 225, "FRZR"},
    {194, 130, 0, 1, 227, "FROZR"},
    {195, 130, 0, 1, 241, "TSNOW"},
    {196, 130, 2, 0, 7, "MTERH"},
    {195, 128, 10, 4, 4, "OVHD"},
    {196, 128, 10, 4, 5, "OVSD"},
    {197, 128, 10, 4, 6, "OVMD"},
    {64, 130, 0, 1, 12, "SRWEQ"},
    {241, 130, 3, 192, 6, "SBT112"},
    {242, 130, 3, 192, 7, "SBT113"},
    {243, 130, 3, 192, 8, "SBT114"},
    {244, 130, 3, 192, 9, "SBT115"},
    {235, 129, 0, 16, 198, "MAXREF"},
    {236, 129, 0, 7, 199, "MXUPHL"},
    {237, 129, 0, 2, 220, "MAXUVV"},
    {238, 129, 0, 2, 221, "MAXDVV"},
    {253, 129, 0, 2, 222, "MAXUW"},
    {254, 129, 0, 2, 223, "MAXVW"},
    {241, 129, 0, 2, 224, "VRATE"},
    {250, 129, 2, 4, 2, "HINDEX"},
    {175, 129, 0, 19, 234, "ICSEV"},
    {176, 129, 0, 19, 233, "ICPRB"},
    {236, 2, 0, 19, 217, "SIPD"},
    {230, 129, 0, 1, 242, "RHPW"},
    {206, 130, 0, 15, 3, "VIL"},
    {255, 255, 0, 0, 255, "MISSING"},
    {255, 255, 0, 20, 102, "AOTK"},
    {255, 255, 0, 20, 103, "SSALBK"},
    {255, 255, 0, 20, 104, "ASYSFK"},
    {255, 255, 0, 20, 105, "AECOEF"},
    {255, 255, 0, 20, 106, "AACOEF"},
    {255, 255, 0, 20, 107, "ALBSAT"},
    {255, 255, 0, 20, 108, "ALBGRD"},
    {255, 255, 0, 20, 109, "ALESAT"},
    {255, 255, 0, 20, 110, "ALEGRD"},
    {255, 255, 0, 20, 9, "WLSMFLX"},
    {255, 255, 0, 20, 10, "WDCPMFLX"},
    {255, 255, 0, 20, 11, "SEDMFLX"},
    {255, 255, 0, 20, 12, "DDMFLX"},
    {255, 255, 0, 20, 13, "TRANHH"},
    {255, 255, 0, 20, 14, "TRSDS"},
    {255, 255, 0, 20, 59, "ANCON"},
    {193, 131, 0, 0, 21, "APTMP"},
    {137, 131, 0, 17, 0, "LTNGSD"},
    {194, 131, 0, 1, 39, "CPOFP"},
    {144, 128, 10, 3, 203, "LCH"},
    {255, 255, 0, 20, 101, "ATMTK"},
    {214, 131, 0, 1, 37, "CPRAT"},
    {255, 255, 10, 2, 8, "ICETMP"},
    {255, 255, 0, 0, 28, "UCTMP"},
    {255, 255, 0, 0, 29, "TMPADV"},
    {255, 255, 0, 1, 129, "EFRCWAT"},
    {255, 255, 0, 1, 130, "EFRRAIN"},
    {255, 255, 0, 1, 131, "EFRCICE"},
    {255, 255, 0, 1, 132, "EFRSNOW"},
    {255, 255, 0, 1, 133, "EFRGRL"},
    {255, 255, 0, 1, 134, "EFRHAIL"},
    {255, 255, 0, 1, 135, "EFRSLC"},
    {255, 255, 0, 1, 136, "EFRSICEC"},
    {255, 255, 0, 1, 137, "EFARRAIN"},
    {255, 255, 0, 1, 138, "EFARCICE"},
    {255, 255, 0, 1, 139, "EFARSNOW"},
    {255, 255, 0, 1, 140, "EFARGRL"},
    {255, 255, 0, 1, 141, "EFARHAIL"},
    {255, 255, 0, 1, 142, "EFARSIC"},
    {255, 255, 0, 1, 231, "PPINDX"},
    {255, 255, 0, 1, 232, "PROBCIP"},
    {255, 255, 0, 1, 233, "SNOWLR"},
    {255, 255, 0, 1, 234, "PCPDUR"},
    {255, 255, 0, 1, 235, "CLLMR"},
    {255, 255, 0, 2, 231, "TPWDIR"},
    {255, 255, 0, 2, 232, "TPWSPD"},
    {255, 255, 0, 2, 36, "AFRWE"},
    {255, 255, 0, 3, 20, "SDSGSO"},
    {255, 255, 0, 3, 21, "AOSGSO"},
    {255, 255, 0, 3, 22, "SSGSO"},
    {255, 255, 0, 3, 23, "GWD"},
    {255, 255, 0, 3, 24, "ASGSO"},
    {255, 255, 0, 3, 25, "NLPRES"},
    {255, 255, 0, 3, 26, "EXPRES"},
    {255, 255, 0, 3, 27, "UMFLX"},
    {255, 255, 0, 3, 28, "DMFLX"},
    {255, 255, 0, 3, 29, "UDRATE"},
    {255, 255, 0, 3, 30, "DDRATE"},
    {255, 255, 0, 3, 31, "UCLSPRS"},
    {255, 255, 0, 4, 50, "UVIUCS"},
    {255, 255, 0, 4, 52, "DSWRFCS"},
    {255, 255, 0, 4, 53, "USWRFCS"},
    {255, 255, 0, 5, 5, "NLWRF"},
    {255, 255, 0, 5, 6, "NLWRCS"},
    {255, 255, 0, 5, 7, "BRTEMP"},
    {255, 255, 0, 5, 8, "DLWRFCS"},
    {255, 255, 0, 6, 34, "SLWTC"},
    {255, 255, 0, 6, 35, "SSWTC"},
    {255, 255, 0, 6, 36, "FSTRPC"},
    {255, 255, 0, 6, 37, "FCONPC"},
    {255, 255, 0, 6, 38, "MASSDCD"},
    {255, 255, 0, 6, 39, "MASSDCI"},
    {255, 255, 0, 6, 40, "MDCCWD"},
    {255, 255, 0, 6, 47, "VFRCWD"},
    {255, 255, 0, 6, 48, "VFRCICE"},
    {255, 255, 0, 6, 49, "VFRCIW"},
    {255, 255, 0, 7, 19, "CONAPES"},
    {255, 255, 0, 7, 203, "DCAPE"},
    {255, 255, 0, 7, 204, "EFHL"},
    {255, 255, 0, 7, 205, "ESP"},
    {255, 255, 0, 7, 206, "CANGLE"},
    {255, 255, 0, 7, 206, "CANGLE"},
    {255, 255, 0, 15, 9, "RFCD"},
    {255, 255, 0, 15, 10, "RFCI"},
    {255, 255, 0, 15, 11, "RFSNOW"},
    {255, 255, 0, 15, 12, "RFRAIN"},
    {255, 255, 0, 15, 13, "RFGRPL"},
    {255, 255, 0, 15, 14, "RFHAIL"},
    {255, 255, 0, 15, 15, "HSR"},
    {255, 255, 0, 15, 16, "HSRHT"},
    {255, 255, 0, 17, 1, "LTPINX"},
    {255, 255, 0, 17, 2, "CDGDLTFD"},
    {255, 255, 0, 17, 3, "CDCDLTFD"},
    {255, 255, 0, 17, 4, "TLGTFD"},
    {255, 255, 0, 18, 0, "ACCES"},
    {255, 255, 0, 18, 1, "ACIOD"},
    {255, 255, 0, 18, 2, "ACRADP"},
    {255, 255, 0, 19, 28, "MWTURB"},
    {255, 255, 0, 19, 29, "CATEDR"},
    {255, 255, 0, 19, 30, "EDPARM"},
    {255, 255, 0, 19, 31, "MXEDPRM"},
    {255, 255, 0, 19, 32, "HIFREL"},
    {255, 255, 0, 19, 33, "VISLFOG"},
    {255, 255, 0, 19, 34, "VISIFOG"},
    {255, 255, 0, 19, 35, "VISBSN"},
    {255, 255, 0, 19, 36, "PSNOWS"},
    {255, 255, 0, 19, 37, "ICESEV"},
    {255, 255, 0, 19, 238, "ELLINX"},
    {255, 255, 1, 0, 7, "DISRS"},
    {255, 255, 1, 0, 8, "GWUPS"},
    {255, 255, 1, 0, 9, "GWLOWS"},
    {255, 255, 1, 0, 10, "SFLORC"},
    {255, 255, 1, 0, 11, "RVERSW"},
    {255, 255, 1, 0, 12, "FLDPSW"},
    {255, 255, 1, 0, 13, "DEPWSS"},
    {255, 255, 1, 0, 14, "UPAPCP"},
    {255, 255, 1, 0, 15, "UPASM"},
    {255, 255, 1, 0, 16, "PERRATE"},
    {255, 255, 1, 2, 0, "WDPTHIL"},
    {255, 255, 1, 2, 1, "WTMPIL"},
    {255, 255, 1, 2, 2, "WFRACT"},
    {255, 255, 1, 2, 3, "SEDTK"},
    {255, 255, 1, 2, 4, "SEDTMP"},
    {255, 255, 1, 2, 5, "ICTKIL"},
    {255, 255, 1, 2, 6, "ICETIL"},
    {255, 255, 1, 2, 7, "ICECIL"},
    {255, 255, 1, 2, 8, "LANDIL"},
    {255, 255, 1, 2, 9, "SFSAL"},
    {255, 255, 1, 2, 10, "SFTMP"},
    {255, 255, 1, 2, 11, "ACWSR"},
    {255, 255, 1, 2, 12, "SALTIL"},
    {255, 255, 1, 2, 13, "CSAFC"},
    {255, 255, 2, 0, 35, "TCLASS"},
    {255, 255, 2, 0, 36, "TFRCT"},
    {255, 255, 2, 0, 37, "TPERCT"},
    {255, 255, 2, 0, 38, "SOILVIC"},
    {255, 255, 2, 0, 39, "EVAPTRAT"},
    {255, 255, 2, 1, 192, "CANL"},
    {255, 255, 2, 3, 18, "SOILTMP"},
    {255, 255, 2, 3, 19, "SOILMOI"},
    {255, 255, 2, 3, 20, "CISOILM"},
    {255, 255, 2, 3, 21, "SOILICE"},
    {255, 255, 2, 3, 22, "CISICE"},
    {255, 255, 2, 3, 23, "LWSNWP"},
    {255, 255, 2, 3, 24, "FRSTINX"},
    {255, 255, 2, 3, 25, "SNWDEB"},
    {255, 255, 2, 3, 26, "SHFLX"},
    {255, 255, 2, 3, 27, "SOILDEP"},
    {255, 255, 2, 4, 0, "FIREOLK"},
    {255, 255, 2, 4, 1, "FIREODT"},
    {255, 255, 2, 4, 3, "FBAREA"},
    {255, 255, 2, 4, 4, "FOSINDX"},
    {255, 255, 2, 4, 5, "FWINX"},
    {255, 255, 2, 4, 6, "FFMCODE"},
    {255, 255, 2, 4, 7, "DUFMCODE"},
    {255, 255, 2, 4, 8, "DRTCODE"},
    {255, 255, 2, 4, 9, "INFSINX"},
    {255, 255, 2, 4, 10, "FBUPINX"},
    {255, 255, 2, 4, 11, "FDSRTE"},
    {255, 255, 2, 5, 1, "GLACTMP"},
    {255, 255, 3, 0, 0, "SRAD"},
    {255, 255, 3, 0, 1, "SALBEDO"},
    {255, 255, 3, 0, 2, "SBTMP"},
    {255, 255, 3, 0, 3, "SPWAT"},
    {255, 255, 3, 0, 4, "SLFTI"},
    {255, 255, 3, 0, 5, "SCTPRES"},
    {255, 255, 3, 0, 6, "SSTMP"},
    {255, 255, 3, 0, 7, "CLOUDM"},
    {255, 255, 3, 0, 8, "PIXST"},
    {255, 255, 3, 0, 9, "FIREDI"},
    {255, 255, 3, 1, 194, "SWQI"},
    {255, 255, 3, 2, 0, "CSKPROB"},
    {255, 255, 3, 192, 53, "SBTAGR8"},
    {255, 255, 3, 192, 54, "SBTAGR9"},
    {255, 255, 3, 192, 55, "SBTAGR10"},
    {255, 255, 3, 192, 56, "SBTAGR11"},
    {255, 255, 3, 192, 57, "SBTAGR12"},
    {255, 255, 3, 192, 58, "SBTAGR13"},
    {255, 255, 3, 192, 59, "SBTAGR14"},
    {255, 255, 3, 192, 60, "SBTAGR15"},
    {255, 255, 3, 192, 61, "SBTAGR16"},
    {255, 255, 10, 0, 14, "WWSDIR"},
    {255, 255, 10, 0, 15, "MWSPER"},
    {255, 255, 10, 0, 16, "CDWW"},
    {255, 255, 10, 0, 17, "FRICV"},
    {255, 255, 10, 0, 18, "WSTR"},
    {255, 255, 10, 0, 19, "NWSTR"},
    {255, 255, 10, 0, 20, "MSSW"},
    {255, 255, 10, 0, 21, "USSD"},
    {255, 255, 10, 0, 22, "VSSD"},
    {255, 255, 10, 0, 23, "PMAXWH"},
    {255, 255, 10, 0, 24, "MAXWH"},
    {255, 255, 10, 0, 25, "IMWF"},
    {255, 255, 10, 0, 26, "IMFWW"},
    {255, 255, 10, 0, 27, "IMFTSW"},
    {255, 255, 10, 0, 28, "MZWPER"},
    {255, 255, 10, 0, 29, "MZPWW"},
    {255, 255, 10, 0, 30, "MZPTSW"},
    {255, 255, 10, 0, 31, "WDIRW"},
    {255, 255, 10, 0, 32, "DIRWWW"},
    {255, 255, 10, 0, 33, "DIRWTS"},
    {255, 255, 10, 0, 34, "PWPER"},
    {255, 255, 10, 0, 35, "PPERWW"},
    {255, 255, 10, 0, 36, "PPERTS"},
    {255, 255, 10, 0, 37, "ALTWH"},
    {255, 255, 10, 0, 38, "ALCWH"},
    {255, 255, 10, 0, 39, "ALRRC"},
    {255, 255, 10, 0, 40, "MNWSOW"},
    {255, 255, 10, 0, 41, "MWDIRW"},
    {255, 255, 10, 0, 42, "WESP"},
    {255, 255, 10, 0, 43, "KSSEW"},
    {255, 255, 10, 0, 44, "BENINX"},
    {255, 255, 10, 0, 45, "SPFTR"},
    {255, 255, 10, 0, 46, "PWAVEDIR"},
    {255, 255, 10, 0, 47, "SWHFSWEL"},
    {255, 255, 10, 0, 48, "SWHSSWEL"},
    {255, 255, 10, 0, 49, "SWHTSWEL"},
    {255, 255, 10, 0, 50, "MWPFSWEL"},
    {255, 255, 10, 0, 51, "MWPSSWEL"},
    {255, 255, 10, 0, 52, "MWPTSWEL"},
    {255, 255, 10, 0, 53, "MWDFSWEL"},
    {255, 255, 10, 0, 54, "MWDSSWEL"},
    {255, 255, 10, 0, 55, "MWDTSWEL"},
    {255, 255, 10, 0, 56, "WDWFSWEL"},
    {255, 255, 10, 0, 57, "WDWSSWEL"},
    {255, 255, 10, 0, 58, "WDWTSWEL"},
    {255, 255, 10, 0, 59, "WFWFSWEL"},
    {255, 255, 10, 0, 60, "WFWSSWEL"},
    {255, 255, 10, 0, 61, "WFWTSWEL"},
    {255, 255, 10, 0, 62, "WAVEFREW"},
    {255, 255, 10, 0, 63, "FREWWW"},
    {255, 255, 10, 0, 64, "FREWTSW"},
    {255, 255, 10, 1, 4, "RIPCOP"},
    {255, 255, 10, 2, 9, "ICEPRS"},
    {255, 255, 10, 2, 10, "ZVCICEP"},
    {255, 255, 10, 2, 11, "MVCICEP"},
    {255, 255, 10, 2, 12, "CICES"},
    {255, 255, 10, 3, 2, "CH"},
    {255, 255, 10, 3, 3, "PRACTSAL"},
    {255, 255, 10, 3, 204, "FRZSPR"},
    {255, 255, 10, 4, 13, "ACWSRD"},
    {255, 255, 10, 3, 205, "TWLWAV"},
    {255, 255, 10, 3, 206, "RUNUP"},
    {255, 255, 10, 3, 207, "SETUP"},
    {255, 255, 10, 3, 208, "SWASH"},
    {255, 255, 10, 3, 209, "TWLDT"},
    {255, 255, 10, 3, 210, "TWLDC"},
    {255, 255, 10, 3, 250, "ETCWL"},
    {255, 255, 10, 3, 251, "TIDE"},
    {255, 255, 10, 3, 252, "EROSNP"},
    {255, 255, 10, 3, 253, "OWASHP"},
    {255, 255, 10, 4, 14, "WDEPTH"},
    {255, 255, 10, 4, 15, "WTMPSS"},
    {255, 255, 10, 4, 16, "WATERDEN"},
    {255, 255, 10, 4, 17, "WATDENA"},
    {255, 255, 10, 4, 18, "WATPTEMP"},
    {255, 255, 10, 4, 19, "WATPDEN"},
    {255, 255, 10, 4, 20, "WATPDENA"},
    {255, 255, 10, 4, 21, "PRTSAL"},
    {240, 129, 0, 16, 3, "RETOP"},
    {234, 2, 1, 0, 5, "BGRUN"},
    {235, 2, 1, 0, 6, "SSRUN"},
    {160, 130, 2, 3, 5, "SOILL"},
    {255, 255, 0, 21, 0, "POTINTENG"},
    {255, 255, 0, 21, 1, "KINENG"},
    {255, 255, 0, 21, 2, "TOTENG"},
    {255, 255, 0, 21, 3, "ENTHALPY"},
    {255, 255, 0, 21, 4, "WATENTHALPY"},
    {255, 255, 0, 21, 5, "EASTENTFLUX"},
    {255, 255, 0, 21, 6, "NRTHENTFLUX"},
    {255, 255, 0, 21, 7, "EASTPOTFLUX"},
    {255, 255, 0, 21, 8, "NRTHPOTFLUX"},
    {255, 255, 0, 21, 9, "EASTKINFLUX"},
    {255, 255, 0, 21, 10, "NRTHKINFLUX"},
    {255, 255, 0, 21, 11, "EASTTOTFLUX"},
    {255, 255, 0, 21, 12, "NRTHTOTFLUX"},
    {255, 255, 0, 21, 13, "DIVENTFLUX"},
    {255, 255, 0, 21, 14, "DIVPOTFLUX"},
    {255, 255, 0, 21, 15, "DIVWPOTFLUX"},
    {255, 255, 0, 21, 16, "DIVKENGFLUX"},
    {255, 255, 0, 21, 17, "DIVTOTFLUX"},
    {255, 255, 0, 21, 18, "DIVWENTFLUX"},
    {255, 255, 0, 21, 19, "EASTHFLUX"},
    {255, 255, 0, 21, 20, "NRTHHFLUX"},
    {255, 255, 0, 21, 21, "PILENERGY"},
    {255, 255, 0, 21, 22, "EADYGR"},
    {255, 255, 0, 22, 0, "SPI"},
    {255, 255, 0, 22, 1, "SPEI"},
    {255, 255, 0, 22, 2, "SSFI"},
    {255, 255, 0, 22, 3, "SRSI"},
    {255, 255, 0, 22, 4, "SWI"},
    {255, 255, 0, 22, 5, "SMRI"},
    {255, 255, 0, 22, 6, "SDI"},
    {255, 255, 2, 6, 0, "URBCOVER"},
    {255, 255, 2, 6, 1, "ROADCOVER"},
    {255, 255, 2, 6, 2, "BUILDCOVER"},
    {255, 255, 2, 6, 3, "BUILDHGT"},
    {255, 255, 2, 6, 4, "VZAFRAC"},
    {255, 255, 2, 6, 5, "SDBUILDHGT"},
    {255, 255, 2, 6, 6, "DDROOF"},
    {255, 255, 2, 6, 7, "DIOWALL"},
    {255, 255, 2, 6, 8, "DDROAD"},
    {255, 255, 0, 0, 205, "ELMELT"},
    {255, 255, 0, 0, 206, "WETGLBT"},
    {255, 255, 0, 1, 122, "PIIDX"},
    {255, 255, 0, 1, 123, "DPTYPE"},
    {255, 255, 0, 1, 124, "PSHOW"},
    {255, 255, 0, 1, 125, "PBSNOW"},
    {255, 255, 0, 1, 126, "PBLIZZ"},
    {255, 255, 0, 1, 127, "ICEP"},
    {255, 255, 0, 1, 128, "TSPRATE"},
    {255, 255, 0, 1, 147, "CHPRECIP"},
    {255, 255, 0, 1, 150, "CEWVMF"},
    {255, 255, 0, 1, 151, "CNWVMF"},
    {255, 255, 0, 1, 152, "CECLWMF"},
    {255, 255, 0, 1, 153, "CNCLWMF"},
    {255, 255, 0, 1, 154, "CECIMF"},
    {255, 255, 0, 1, 155, "CNCIMF"},
    {255, 255, 0, 1, 156, "CERMF"},
    {255, 255, 0, 1, 157, "CNRMF"},
    {255, 255, 0, 1, 158, "CEFMF"},
    {255, 255, 0, 1, 159, "CNSMF"},
    {255, 255, 0, 1, 160, "CDWFMF"},
    {255, 255, 0, 1, 161, "CDCLWMF"},
    {255, 255, 0, 1, 162, "CDCIMF"},
    {255, 255, 0, 1, 163, "CDRMF"},
    {255, 255, 0, 1, 164, "CDSMF"},
    {255, 255, 0, 1, 165, "CDTWMF"},
    {255, 255, 0, 1, 166, "CWVF"},
    {255, 255, 0, 1, 167, "TCSLW"},
    {255, 255, 0, 1, 168, "SSPFHW"},
    {255, 255, 0, 1, 169, "TCISSPFHW"},
    {255, 255, 0, 2, 47, "SFRHEAT"},
    {255, 255, 0, 2, 48, "SFRMOIST"},
    {255, 255, 0, 2, 49, "WINDSTR"},
    {255, 255, 0, 2, 50, "EWINDSTR"},
    {255, 255, 0, 2, 51, "NWINDSTR"},
    {255, 255, 0, 2, 52, "UWINDSTR"},
    {255, 255, 0, 2, 53, "VWINDSTR"},
    {255, 255, 0, 2, 54, "NLSRLH"},
    {255, 255, 0, 2, 55, "NLSRLM"},
    {255, 255, 0, 2, 56, "UNWIND"},
    {255, 255, 0, 2, 57, "VNWIND"},
    {255, 255, 0, 2, 58, "TSFCSTR"},
    {255, 255, 0, 2, 59, "VDIV"},
    {255, 255, 0, 2, 60, "DTC"},
    {255, 255, 0, 2, 61, "DEC"},
    {255, 255, 0, 2, 62, "EASTTSS"},
    {255, 255, 0, 2, 63, "NRTHTSS"},
    {255, 255, 0, 2, 64, "EASTTSSOD"},
    {255, 255, 0, 2, 65, "NRTHTSSOD"},
    {255, 255, 0, 2, 66, "EASTTSSSR"},
    {255, 255, 0, 2, 67, "NRTHTSSSR"},
    {255, 255, 0, 3, 32, "SWATERVP"},
    {255, 255, 0, 3, 33, "GAMSL"},
    {255, 255, 0, 3, 34, "GHAGRD"},
    {255, 255, 0, 3, 35, "CDTMF"},
    {255, 255, 0, 3, 36, "CETMF"},
    {255, 255, 0, 3, 37, "CNTMF"},
    {255, 255, 0, 3, 38, "SDFSO"},
    {255, 255, 0, 3, 39, "CMATMOS"},
    {255, 255, 0, 3, 40, "CEGFLUX"},
    {255, 255, 0, 3, 41, "CNGFLUX"},
    {255, 255, 0, 3, 42, "CDWGFLUX"},
    {255, 255, 0, 3, 43, "CDGFLUX"},
    {255, 255, 0, 3, 44, "HWBT"},
    {255, 255, 0, 3, 45, "WOBT"},
    {255, 255, 0, 3, 46, "PRESDHS"},
    {255, 255, 0, 3, 222, "EFSH"},
    {255, 255, 0, 4, 15, "UVVEARTH"},
    {255, 255, 0, 4, 53, "USWRFCS"},
    {255, 255, 0, 4, 54, "DNSWRFLX"},
    {255, 255, 0, 4, 55, "UVALBDIF"},
    {255, 255, 0, 4, 56, "UVALBDIR"},
    {255, 255, 0, 4, 57, "UBALBDIRG"},
    {255, 255, 0, 4, 58, "UVALBDIRI"},
    {255, 255, 0, 4, 59, "UVBDIRV"},
    {255, 255, 0, 4, 60, "PHOARFCS"},
    {255, 255, 0, 4, 61, "DSWRFLXCS"},
    {255, 255, 0, 5, 9, "NIRALBDIF"},
    {255, 255, 0, 5, 10, "NIRALBDIR"},
    {255, 255, 0, 5, 11, "NIRALBDIRG"},
    {255, 255, 0, 5, 12, "NIRALBDIRI"},
    {255, 255, 0, 5, 13, "NIRALBDIRV"},
    {255, 255, 0, 6, 50, "FOG"},
    {255, 255, 0, 6, 51, "SUNFRAC"},
    {255, 255, 0, 7, 20, "TIIDEX"},
    {255, 255, 0, 7, 207, "E3KH"},
    {255, 255, 0, 7, 208, "STPC"},
    {255, 255, 0, 7, 209, "SIGH"},
    {255, 255, 0, 7, 210, "SCCP"},
    {255, 255, 0, 7, 211, "SIGT"},
    {255, 255, 0, 7, 212, "MLFC"},
    {255, 255, 0, 14, 204, "ALD2"},
    {255, 255, 0, 17, 5, "SLNGPIDX"},
    {255, 255, 0, 18, 19, "DEPACTA"},
    {255, 255, 0, 18, 20, "DEPACTE"},
    {255, 255, 0, 18, 21, "CLDACTA"},
    {255, 255, 0, 18, 22, "CLDACTE"},
    {255, 255, 0, 18, 23, "EFFDOSER"},
    {255, 255, 0, 18, 24, "THYDOSER"},
    {255, 255, 0, 18, 25, "GAMDOSER"},
    {255, 255, 0, 18, 26, "ACTEMM"},
    {255, 255, 0, 19, 38, "SKYIDX"},
    {255, 255, 0, 19, 39, "SEEINDEX"},
    {255, 255, 0, 19, 40, "SNOWLVL"},
    {255, 255, 0, 19, 41, "DBHEIGHT"},
    {255, 255, 0, 19, 42, "TLBHEIGHT"},
    {255, 255, 0, 19, 43, "TLTHEIGHT"},
    {255, 255, 0, 19, 44, "MEANVGRTL"},
    {255, 255, 0, 19, 45, "MINVGRTL"},
    {255, 255, 0, 19, 46, "NETRADFLUX"},
    {255, 255, 0, 19, 47, "GLIRRTS"},
    {255, 255, 0, 19, 48, "PCONTT"},
    {255, 255, 0, 19, 49, "PCONTB"},
    {255, 255, 0, 19, 50, "CITEDR"},
    {255, 255, 0, 20, 18, "POTHPH"},
    {255, 255, 0, 20, 78, "CEMF"},
    {255, 255, 0, 20, 79, "CNMF"},
    {255, 255, 0, 20, 80, "CDIVMF"},
    {255, 255, 0, 20, 81, "CNETS"},
    {255, 255, 0, 191, 4, "TCDTRACK"},
    {255, 255, 0, 191, 5, "HURTSV"},
    {255, 255, 0, 191, 6, "TSTSV"},
    {255, 255, 0, 191, 7, "TDTSV"},
    {255, 255, 1, 0, 17, "RVEROW"},
    {255, 255, 1, 0, 18, "FLDPOW"},
    {255, 255, 1, 0, 19, "FLDPATHOW"},
    {255, 255, 1, 0, 20, "WATSURF"},
    {255, 255, 1, 0, 194, "FHO"},
    {255, 255, 1, 0, 196, "AHD"},
    {255, 255, 1, 1, 196, "QPFARI"},
    {255, 255, 1, 1, 197, "QPFFFG"},
    {255, 255, 1, 2, 14, "LNDSNOWT"},
    {255, 255, 1, 2, 15, "LDEPTH"},
    {255, 255, 1, 2, 16, "RDEPTH"},
    {255, 255, 1, 2, 17, "FLDPDEPTH"},
    {255, 255, 1, 2, 18, "FLDPFLFR"},
    {255, 255, 1, 2, 19, "FLDPFLAR"},
    {255, 255, 1, 2, 20, "RVERFR"},
    {255, 255, 1, 2, 21, "RVERAR"},
    {255, 255, 1, 2, 22, "FRCRF"},
    {255, 255, 1, 2, 23, "ARCRF"},
    {255, 255, 2, 0, 40, "PEVAPTRAT"},
    {255, 255, 2, 0, 41, "SMRATE"},
    {255, 255, 2, 0, 42, "WRDRATE"},
    {255, 255, 2, 0, 43, "DRAINDIR"},
    {255, 255, 2, 0, 44, "UPSAREA"},
    {255, 255, 2, 0, 45, "WETCOV"},
    {255, 255, 2, 0, 46, "WETTYPE"},
    {255, 255, 2, 0, 47, "IRRCOV"},
    {255, 255, 2, 0, 48, "CROPCOV"},
    {255, 255, 2, 0, 49, "GRASSCOV"},
    {255, 255, 2, 0, 50, "SKINRC"},
    {255, 255, 2, 0, 51, "SURFRATE"},
    {255, 255, 2, 0, 52, "SUBSRATE"},
    {255, 255, 2, 0, 53, "LOVEGCOV"},
    {255, 255, 2, 0, 54, "HIVEGCOV"},
    {255, 255, 2, 0, 55, "LAILO"},
    {255, 255, 2, 0, 56, "LAIHI"},
    {255, 255, 2, 0, 57, "TYPLOVEG"},
    {255, 255, 2, 0, 58, "TYPHIVEG"},
    {255, 255, 2, 0, 59, "NECOFLUX"},
    {255, 255, 2, 0, 60, "GROSSFLUX"},
    {255, 255, 2, 0, 61, "ECORFLUX"},
    {255, 255, 2, 0, 62, "EMISS"},
    {255, 255, 2, 0, 63, "CANTMP"},
    {255, 255, 2, 0, 233, "LANDFRC"},
    {255, 255, 2, 0, 234, "LAKEFRC"},
    {255, 255, 2, 0, 235, "PAHFLX"},
    {255, 255, 2, 0, 236, "WATERSA"},
    {255, 255, 2, 0, 237, "EIWATER"},
    {255, 255, 2, 0, 238, "PLANTTR"},
    {255, 255, 2, 0, 239, "SOILSE"},
    {255, 255, 2, 3, 28, "SNOWTMP"},
    {255, 255, 2, 3, 29, "ICETEMP"},
    {255, 255, 2, 3, 30, "SWET"},
    {255, 255, 2, 3, 204, "MSTAVTOP"},
    {255, 255, 2, 4, 20, "BURNAREA"},
    {255, 255, 2, 4, 21, "BURNABAREA"},
    {255, 255, 2, 4, 22, "UNBURNAREA"},
    {255, 255, 2, 4, 23, "FUELLOAD"},
    {255, 255, 2, 4, 24, "COMBCO"},
    {255, 255, 2, 4, 25, "FUELMC"},
    {255, 255, 2, 4, 26, "WFIREPOT"},
    {255, 255, 2, 4, 27, "LLFL"},
    {255, 255, 2, 4, 28, "LWFL"},
    {255, 255, 2, 4, 29, "DLFL"},
    {255, 255, 2, 4, 30, "DWFL"},
    {255, 255, 2, 4, 31, "LFMC"},
    {255, 255, 2, 4, 32, "FDLMC"},
    {255, 255, 2, 4, 33, "DDLMC"},
    {255, 255, 2, 4, 34, "FDWMC"},
    {255, 255, 2, 4, 35, "DDWMC"},
    {255, 255, 2, 4, 36, "FRADPOW"},
    {255, 255, 3, 1, 30, "RFL04"},
    {255, 255, 3, 1, 31, "CLDREF"},
    {255, 255, 3, 1, 32, "CLRREF"},
    {255, 255, 3, 3, 0, "PBMVFRC"},
    {255, 255, 3, 3, 1, "PBLIFRC"},
    {255, 255, 3, 3, 2, "PBINFRC"},
    {255, 255, 3, 5, 0, "ISSTMP"},
    {255, 255, 3, 5, 1, "SKSSTMP"},
    {255, 255, 3, 5, 2, "SSKSSTMP"},
    {255, 255, 3, 5, 3, "FDNSSTMP"},
    {255, 255, 3, 5, 4, "EBSSTSTD"},
    {255, 255, 3, 5, 5, "EBSDSSTS"},
    {255, 255, 3, 192, 86, "SSMS1712"},
    {255, 255, 3, 192, 87, "SSMS1713"},
    {255, 255, 10, 0, 65, "PWPFSPAR"},
    {255, 255, 10, 0, 66, "PWPSSPAR"},
    {255, 255, 10, 0, 67, "PWPTSPAR"},
    {255, 255, 10, 0, 68, "PWDFSPAR"},
    {255, 255, 10, 0, 69, "PWDSSPAR"},
    {255, 255, 10, 0, 70, "PWDTSPAR"},
    {255, 255, 10, 0, 71, "PDWWAVE"},
    {255, 255, 10, 0, 72, "PDTSWELL"},
    {255, 255, 10, 0, 73, "WCAPFRAC"},
    {255, 255, 10, 0, 74, "MDTSWEL"},
    {255, 255, 10, 0, 75, "MDWWAVE"},
    {255, 255, 10, 0, 76, "CHNCK"},
    {255, 255, 10, 0, 77, "WAVESPSK"},
    {255, 255, 10, 0, 78, "WAVEFMAG"},
    {255, 255, 10, 0, 79, "WAVEFDIR"},
    {255, 255, 10, 0, 80, "RWAVEAFW"},
    {255, 255, 10, 0, 81, "FCVOCEAN"},
    {255, 255, 10, 0, 82, "AIRDENOC"},
    {255, 255, 10, 0, 83, "NEFW"},
    {255, 255, 10, 0, 84, "NSOCEAN"},
    {255, 255, 10, 0, 85, "NEFOCEAN"},
    {255, 255, 10, 0, 86, "SEVWAVE"},
    {255, 255, 10, 0, 87, "WAVEMSLC"},
    {255, 255, 10, 0, 88, "SPECWI"},
    {255, 255, 10, 0, 89, "EFWS"},
    {255, 255, 10, 0, 90, "USMFO"},
    {255, 255, 10, 0, 91, "VSMFO"},
    {255, 255, 10, 0, 92, "WAVETEFO"},
    {255, 255, 10, 0, 93, "EMIWAVE"},
    {255, 255, 10, 0, 94, "TDMCREST"},
    {255, 255, 10, 0, 95, "TDMWAVE"},
    {255, 255, 10, 0, 96, "STMCREST"},
    {255, 255, 10, 0, 97, "STMWAVE"},
    {255, 255, 10, 0, 98, "GODAPEAK"},
    {255, 255, 10, 1, 5, "EASTCUR"},
    {255, 255, 10, 1, 6, "NRTHCUR"},
    {255, 255, 10, 2, 14, "ALBDOICE"},
    {255, 255, 10, 2, 15, "SICEVOL"},
    {255, 255, 10, 2, 16, "SNVOLSI"},
    {255, 255, 10, 2, 17, "SICEHC"},
    {255, 255, 10, 2, 18, "SNCEHC"},
    {255, 255, 10, 2, 19, "ICEFTHCK"},
    {255, 255, 10, 2, 20, "ICEMPF"},
    {255, 255, 10, 2, 21, "ICEMPD"},
    {255, 255, 10, 2, 22, "ICEMPV"},
    {255, 255, 10, 2, 23, "SIFTP"},
    {255, 255, 10, 2, 24, "XICE"},
    {255, 255, 10, 2, 25, "YICE"},
    {255, 255, 10, 2, 27, "FRZMLTPOT"},
    {255, 255, 10, 2, 28, "MLTDATE"},
    {255, 255, 10, 2, 29, "FRZDATE"},
    {255, 255, 10, 3, 4, "DWHFLUX"},
    {255, 255, 10, 3, 5, "EASTWSS"},
    {255, 255, 10, 3, 6, "NORTHWSS"},
    {255, 255, 10, 3, 7, "XCOMPSS"},
    {255, 255, 10, 3, 8, "YCOMPSS"},
    {255, 255, 10, 3, 9, "THERCSSH"},
    {255, 255, 10, 3, 10, "HALOCSSH"},
    {255, 255, 10, 3, 11, "STERCSSH"},
    {255, 255, 10, 3, 12, "SEASFLUX"},
    {255, 255, 10, 3, 13, "NETUPWFLUX"},
    {255, 255, 10, 3, 14, "ESURFWVEL"},
    {255, 255, 10, 3, 15, "NSURFWVEL"},
    {255, 255, 10, 3, 16, "XSURFWVEL"},
    {255, 255, 10, 3, 17, "YSURFWVEL"},
    {255, 255, 10, 3, 18, "HFLUXCOR"},
    {255, 255, 10, 3, 19, "SSHGTPARM"},
    {255, 255, 10, 3, 20, "DSLIBARCOR"},
    {255, 255, 10, 3, 21, "SALINITY"},
    {255, 255, 10, 4, 29, "BPEH"},
    {255, 255, 10, 4, 30, "FWFSW"},
    {255, 255, 10, 4, 31, "FWFC"},
    {255, 255, 10, 4, 32, "VSFSW"},
    {255, 255, 10, 4, 33, "VSFC"},
    {255, 255, 10, 4, 34, "SWTTNR"},
    {255, 255, 10, 4, 35, "SWSTNR"},
    {255, 255, 10, 4, 36, "SWTTP"},
    {255, 255, 10, 4, 37, "SWSTP"},
    {255, 255, 10, 4, 38, "ESWVP"},
    {255, 255, 10, 4, 39, "NSWVP"},
    {255, 255, 10, 4, 40, "SWTTBC"},
    {255, 255, 10, 4, 41, "SWSTBC"},
    {255, 255, 10, 4, 42, "SEAMVT"},
    {255, 255, 10, 4, 43, "SEAZVT"},
    {255, 255, 10, 4, 44, "SEACMVT"},
    {255, 255, 10, 4, 45, "SEACZVT"},
    {255, 255, 10, 4, 46, "SEAMMT"},
    {255, 255, 10, 4, 47, "SEAZMT"},
    {255, 255, 10, 4, 48, "SEACMMT"},
    {255, 255, 10, 4, 49, "SEACZMT"},
    {255, 255, 10, 4, 50, "SEACPSALT"},
    {255, 255, 10, 4, 51, "SEACSALT"},
    {255, 255, 10, 191, 4, "BARDSF"}};

/**
 * Translate GRIB1 parameter to GRIB2 parameter.
 *
 * @param g1num The GRIB1 parameter.
 * @param g1ver The GRIB1 parameter table version number.
 * @param g2disc Pointer that gets the GRIB2 discipline
 * number. Ignored if NULL.
 * @param g2cat Pointer that gets the GRIB2 category
 * number. Ignored if NULL.
 * @param g2num Pointer that gets the GRIB2 parameter
 * number. Ignored if NULL.
 *
 * @return
 * - ::G2C_NOERROR No error.
 * - ::G2C_EFILE Error reading CSV file.
 * - ::G2C_ENOPARAM Parameter not found.
 *
 * @author Ed Hartnett @date 9/19/22
 */
int
g2c_param_g1tog2(int g1num, int g1ver, int *g2disc, int *g2cat, int *g2num)
{
    int p;

    /* Loop through array until matching values are found. */
    for (p = 0; p < G2C_MAX_NOAA_PARAMS; p++)
        if (param[p].g1num == g1num && param[p].g1ver == g1ver)
            break;

    /* Did we find the parameter? */
    if (p == G2C_MAX_NOAA_PARAMS)
        return G2C_ENOPARAM;

    /* Does the user want the answers? */
    if (g2disc)
        *g2disc = param[p].g2disc;
    if (g2cat)
        *g2cat = param[p].g2cat;
    if (g2num)
        *g2num = param[p].g2num;

    return G2C_NOERROR;
}

/**
 * Get NOAA abbreviation for a GRIB2 parameter.
 *
 * @param g2disc The GRIB2 discipline number.
 * @param g2cat The GRIB2 category number.
 * @param g2num The GRIB2 parameter number.
 * @param abbrev Pointer that gets the abbreviation. Ignored if NULL.
 *
 * @return
 * - ::G2C_NOERROR No error.
 * - ::G2C_EFILE Error reading CSV file.
 * - ::G2C_ENOPARAM Parameter not found.
 *
 * @author Ed Hartnett @date 9/19/22
 */
int
g2c_param_abbrev(int g2disc, int g2cat, int g2num, char *abbrev)
{
    int p;

    /* If this is NULL, the user doesn't care about the answer, so we're done. */
    if (!abbrev)
        return G2C_NOERROR;

    LOG((11, "g2c_param_abbrev g2disc %d g2cat %d g2num %d", g2disc, g2cat, g2num));

    /* Loop through array until matching values are found. */
    for (p = 0; p < G2C_MAX_NOAA_PARAMS; p++)
        if (param[p].g2disc == g2disc && param[p].g2cat == g2cat && param[p].g2num == g2num)
            break;

    /* Was the parameter missing? */
    if (p == G2C_MAX_NOAA_PARAMS)
        strcpy(abbrev, "UNKNOWN");
    else
        strncpy(abbrev, param[p].abbrev, G2C_MAX_NOAA_ABBREV_LEN + 1);

    LOG((12, "abbrev %s", abbrev));

    return G2C_NOERROR;
}

/**
 * Translate GRIB2 parameter to GRIB1 parameter.
 *
 * @param g2disc The GRIB2 discipline number.
 * @param g2cat The GRIB2 category number.
 * @param g2num The GRIB2 parameter number.
 * @param g1num Pointer that gets the GRIB1 parameter. Ignored if
 * NULL.
 * @param g1ver Pointer that gets the GRIB1 parameter table version
 * number. Ignored if NULL.
 *
 * @return
 * - ::G2C_NOERROR No error.
 * - ::G2C_EFILE Error reading CSV file.
 * - ::G2C_ENOPARAM Parameter not found.
 *
 * @author Ed Hartnett @date 9/19/22
 */
int
g2c_param_g2tog1(int g2disc, int g2cat, int g2num, int *g1num, int *g1ver)
{
    int p;

    LOG((2, "g2c_param_g2tog1 g2disc %d g2cat %d g2num %d", g2disc, g2cat, g2num));

    /* Loop through array until matching values are found. */
    for (p = 0; p < G2C_MAX_NOAA_PARAMS; p++)
        if (param[p].g2disc == g2disc && param[p].g2cat == g2cat && param[p].g2num == g2num)
            break;

    /* Did we find the parameter? */
    if (p == G2C_MAX_NOAA_PARAMS)
        return G2C_ENOPARAM;

    /* Does the user want the answers? */
    if (g1num)
        *g1num = param[p].g1num;
    if (g1ver)
        *g1ver = param[p].g1ver;

    return G2C_NOERROR;
}

/**
 * Return all the information about a parameter.
 *
 * @param param_idx Parameter index between 0 and ::G2C_MAX_NOAA_PARAMS.
 * @param g1num Pointer that gets the GRIB1 parameter. Ignored if
 * NULL.
 * @param g1ver Pointer that gets the GRIB1 parameter table version
 * number. Ignored if NULL.
 * @param g2disc Pointer that gets the GRIB2 discipline
 * number. Ignored if NULL.
 * @param g2cat Pointer that gets the GRIB2 category number. Ignored
 * if NULL.
 * @param g2num Pointer that gets the GRIB2 parameter number. Ignored
 * if NULL.
 * @param abbrev Pointer that gets the abbreviation.
 *
 * @return
 * - ::G2C_NOERROR No error.
 * - ::G2C_EINVAL Invalid input.
 * - ::G2C_EFILE Error reading CSV file.
 * - ::G2C_ENOPARAM Parameter not found.
 *
 * @author Ed Hartnett @date 9/19/22
 */
int
g2c_param_all(int param_idx, int *g1num, int *g1ver, int *g2disc, int *g2cat,
              int *g2num, char *abbrev)
{
    /* Check input. */
    if (param_idx < 0 || param_idx >= G2C_MAX_NOAA_PARAMS)
        return G2C_EINVAL;

    /* Return results to caller. */
    if (g1num)
        *g1num = param[param_idx].g1num;
    if (g1ver)
        *g1ver = param[param_idx].g1ver;
    if (g2disc)
        *g2disc = param[param_idx].g2disc;
    if (g2cat)
        *g2cat = param[param_idx].g2cat;
    if (g2num)
        *g2num = param[param_idx].g2num;
    if (abbrev)
        strncpy(abbrev, param[param_idx].abbrev, G2C_MAX_NOAA_ABBREV_LEN);

    return G2C_NOERROR;
}
