/*
 * Decompiled with CFR 0.152.
 */
package burp.faraday;

import burp.faraday.Workspace;
import burp.faraday.exceptions.http.ConflictException;
import burp.faraday.exceptions.http.UnauthorizedException;
import burp.faraday.models.requests.SecondFactor;
import burp.faraday.models.requests.User;
import burp.faraday.models.responses.CreatedObjectEntity;
import burp.faraday.models.responses.LoginStatus;
import burp.faraday.models.responses.ServerInfo;
import burp.faraday.models.vulnerability.Host;
import burp.faraday.models.vulnerability.Service;
import burp.faraday.models.vulnerability.Vulnerability;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.util.List;

public interface FaradayServerAPI {
    @RequestLine(value="GET /_api/v2/info")
    @Headers(value={"Content-Type: application/json"})
    public ServerInfo getInfo();

    @RequestLine(value="POST /_api/login")
    @Headers(value={"Content-Type: application/json"})
    public LoginStatus login(User var1) throws UnauthorizedException;

    @RequestLine(value="POST /_api/confirmation")
    @Headers(value={"Content-Type: application/json"})
    public LoginStatus verifyToken(SecondFactor var1) throws UnauthorizedException;

    @RequestLine(value="GET /_api/session")
    @Headers(value={"Content-Type: application/json"})
    public void getSession() throws UnauthorizedException;

    @RequestLine(value="GET /_api/v2/ws")
    @Headers(value={"Content-Type: application/json"})
    public List<Workspace> getWorkspaces() throws UnauthorizedException;

    @RequestLine(value="POST /_api/v2/ws/{workspace}/hosts/")
    @Headers(value={"Content-Type: application/json"})
    public CreatedObjectEntity createHost(@Param(value="workspace") String var1, Host var2) throws UnauthorizedException, ConflictException;

    @RequestLine(value="POST /_api/v2/ws/{workspace}/services/")
    @Headers(value={"Content-Type: application/json"})
    public CreatedObjectEntity createService(@Param(value="workspace") String var1, Service var2) throws UnauthorizedException, ConflictException;

    @RequestLine(value="POST /_api/v2/ws/{workspace}/vulns/")
    @Headers(value={"Content-Type: application/json"})
    public CreatedObjectEntity createVulnerability(@Param(value="workspace") String var1, Vulnerability var2) throws UnauthorizedException;
}

