1.75.5
======
2025-07-26

**Fixed**

- Fix possible hang on connect

1.75.4
======
2025-07-18

**Added**

- Implement map label support. Players now render on the map with name labels.
- Implement client side ticks to reduce network bandwidth
- Add pop-up dialog when unexpectedly disconnecting from server
- Add configuration option for "debounce". When disabled, it restores previous
  command buffering behavior.
- Add configuration widget for music volume
- Support loading MP3 music files

**Changed**

- Quit after disconnecting from a single-connect server
- Increase maximum count supported in the count spin box
- Reset auto-AFK as soon as main windows are hidden
- Improve music transitions
- For client scripting, only `monitor` commands that are actually sent to
  the server

**Fixed**

- Better handle errors in negotiation stage
- Fix inventory tab icons with recent gdk-pixbuf
- Fix save window positions; bars save onscreen

1.75.3
======
2024-04-10

**Added**

- Add 'mapedit' command to launch map editor on current map
- Implement smooth lighting for new Pixmap (Cairo) renderer
- Add additional protocol debugging flags
- Automatically set 'away' if idle for some time
- Add pop-up action menu when left-clicking on items. Can be disabled with the inv_menu configuration option
- Add default bindings for 'reply' and 'get all'
- Add "scriptkillall" command

**Changed**

- Lighting defaults to per-pixel lighting
- Improve movement prediction and enable it by default

1.75.2
======
2022-01-06

**Added**

- Added 'mapscale' command to change map scaling
- Right-click a tile to walk to it, double right-click to attack
- Spells window shows spell icons

**Changed**

- All commands, not just key bindings, are shown when command echo is enabled
- Improve text readability in the 'Black' theme
- Image caching has been disabled until some bugs can be fixed

**Removed**

- OpenGL and SDL renderers have been removed

**Fixed**

- Fixed several bugs in the Pixmap renderer
- Fixed mouse-click examine showing the wrong tile

1.75.1
======
2021-08-19

**Added**

- Remember the most recently-connected server
- Display "read" flag for books in the inventory that have been read
- Add JXClient-like mouse bindings to support inventory operations without
  middle-click
- Add local map scroll prediction (disabled by default)

**Changed**

- Request extended text information from older servers

**Fixed**

- Fixed several repeated error messages
- Fixed build on big-endian architectures
- Fixed keybindings and sounds on Windows
- Fixed several crashes

1.75.0
======
2021-01-01

**Added**

- Added '--script' command-line option to pre-launch scripts
- Added client scripting support for drop, take, and apply
- Added metaserver refresh button
- Added support for face sets of any reasonable size; 24x24 has been tested

**Changed**

- 'request map pos' for client scripting uses relative coordinates
- Item highlight color in inventory view is easier to read
- Sound works without a separate sound server binary

**Fixed**

- Correctly wrap long words when the message pane is narrow
- Fixed compile errors with recent compilers
- Fixed faceset drop-down menu
- Fixed some crashes
- Pixmap renderer smooths correctly
- Removed unused fields in all layouts except gtk-v1 and gtk-v2

1.74.0
======
2019-12-25

**Added**

- Add "--debug-protocol" command-line option
- Add "--profile-latency" command-line option
- Resurrect "--server" option to connect to a server directly

**Changed**

- Rename "--time-redraw" to "--profile-redraw"
- Report UI layout in client version string
- Trim trailing whitespace from spell descriptions
- Use one window for metaserver and login dialogs
- Change key handling to reduce lag after holding down a key
- Inventory table view no longer has a column limit

**Fixed**

- Handle previously unhandled 'newmapcmd' and 'tick' setup commands
- Functionality and performance fixes for inventory table view with large
  inventories

1.73.0
======
2019-01-06

**Added**

- Pass player and server name to client scripts

**Changed**

- Add text for blessed items in inventory views
- Client window stays hidden until after player selection
- Install sound files when SOUND is enabled
- Show open containers in unlocked inventory view

**Fixed**

- Enable sound with older (< 0.25.3) versions of Vala
- Fix delayed weight limit update when strength attribute changes
- Speed up inventory redraw when picking up and dropping many items

1.72.0
======
2017-08-13

**Added**

- Display numerical stats on HP, mana, grace, and experience bars
- Fade music in and out
- Highlight applied items in the inventory icon view
- Speed up Pixmap rendering using Cairo
- Update metaservers

**Changed**

- Clean up command-line arguments
- Enable smoothing by default
- Move music directory to *share/crossfire-client/sounds/music/*
- Reduce default logging verbosity. Run with '-v 0' to show all messages.
- Replace autoconf/automake build system with CMake
- Save client settings in .ini format
- Set default layout to *gtk-v2*
- Update UI dialogs
- Update sound effects
- Use XDG-compliant directories for configuration and cache files. Users who wish to keep their configuration files need to manually move them to the new location. For Unix-like systems, the new location is *~/.config/crossfire*.

**Removed**

- Remove old metaserver (metaserver1) support

**Fixed**

- Fix potential socket buffer overflows
- Fix various protocol-related bugs
- Hide character selection window reliably after logging in
- Update build for Windows

1.71.0
======

    2014-03-17	Kevin Zheng
        * gtk-v2/ui/gtk-v2.ui: Improve core stats display.

    2014-01-26	Kevin Zheng
        * configure.ac: Add `configure` flag to disable OpenGL.
        * configure.ac: Use pkgconf to find SDL_mixer and OpenGL.

    2014-01-02	Kevin Zheng
        * gtk-v2/src/keys.c: Fix various keybinding issues.

    2014-01-01	Kevin Zheng
        * gtk-v2/src/config.c: Do not store last server in gdefaults2.

    2013-12-30	Karla Stenger
        * gtk-v2/src/keys.c: Add character-specific keybindings.

    2013-12-26	Kevin Zheng
        * gtk-v2/: Convert widgets to use GtkBuilder.

    2013-09-05	Kevin Zheng
        * sound-src/cfsndserv.c: Drop support for legacy sound systems.

    2012-11-30	Karla Stenger
        * gtk-v2/src/inventory.c: draw_lists() was redrawing the look window
        every time it was called. This caused a jumping effect when scrolling
        the look window. Middle clicking could get you to apply the wrong item.
        It made it barely imposible to look at the next pages. Now it will get
        redrawn only if items are uptated "below".

1.70.0
======

    Apply patch #3428070: Autoreconf Warnings, by Steven Johnson.
    Nicolas Weeger 2011-10-27

    Fix metaserver not correctly displaying everything.
    Maurice Massar 2011-09-10

    Add timestamping option.
    Nicolas Weeger 2011-06-06

    Add account password change logic and dialogs.
    Nicolas Weeger 2011-05-23

1.60.0
======

    Minor bugfixes/improvements:
    common/cconfig.h: Turn off metaserver1 support - will remove code in future,
       but will see what effect this has.
    gtk-v2/src/create_char.c: Remove call setting starting map combox box active -
       this is done elsewhere, and that call generates an error since the widget
       isn't realized yet, so isn't doing anything in any case.
    gtk-v2/src/info.c: Handle client generated messages at startup - removes
       a bunch of errors going to console about invalid type/subtype.
    gtk-v2/src/gtk2proto.h: Add missing prototypes.
    gtk-v2/src/main.h: Change default layout to be gtk-v1
    MSW 2011-01-23


    Fix theme handling so it is properly loaded/processed at client start up.
    Remove the theme lookup from the init_...() routines and load the theme
    after all the initialization routines are done.
    MSW 2011-01-11

    common/client.h: Update race & class structures to hold choice information
       from server.
    common/commands.c: Add handling of choice information from server.
    gtk-v2/src/create_char.c: Add handling of choice option lists.
    gtk-v2/glade/dialogs.glade - add labels and combo boxes for the choice
       options.
    MSW 2010-11-14

    Fix client crash on empty magic map.
    This fixes bug #3098933: invoking magic mapping crashes client.

    Fix building client with build directory separate from source directory.
    Arvid Norlander 2010-10-24

    Commit client side support for new in client character creation.
    common/client.h: Add various new globals for map, race, and class info.
    common/commands.c: Move Race_Class_Info structure to header file, add
        new global declarations.  Add handling of requesting and storing
        starting map information from server.  Handle newcharinfo
        protocol command.
    common/external.h: Add new external calls.
    common/init.c: Add calls to free race and class data.
    common/proto.h: Add new prototype
    gtk-v2/glade/dialogs.glade: Update dialogs.glade file with new
       window for creating character.
    gtk-v2/src/Makefile.am: Add create_char.c file
    gtk-v2/src/account.c: Add calls for popups and to show the choose
       character window.  Add handling for new character creation method.
    gtk-v2/src/create_char.c: New file that handles character creation logic.
    gtk-v2/src/gtk2proto.h: Update with new functions
    gtk-v2/src/main.c: update loginmethod to 2, add call to
        init_create_character_window()
    gtk-v2/src/main.h: Add global reference to account password
    gtk-v2/src/stats.c: Make some widgets static to the file.
    MSW 2010-10-20

    Commit basic, functional music support via cfsndserv when the client is built
    with SDL_mixer sound support.  Music support is not presently planned for any
    of the legacy sound systems:  Alsa, Alsa9 (cfsndserv_alsa9), OSS, SGI, and
    Sun.  Neither cfsndserv nor cfsndserv_alsa9 yet support playing sound effects.
    NOTE:  `/configure --enable-sdl_mixer` is required to enable building with the
    SDL_mixer library since the present default is to not use it (but the default
    will change shortly as music is now functional, and since all other sound
    support is still broken for all of the sound systems (including SDL_mixer).
    NOTE:  cfsndserv looks for .ogg or .wav files based on whether the OS is WIN32
    or not.  The sound files are expected to be in either ${HOME}/sound.cache/
    or CF_DATADIR/sounds/.  No provision exists yet for sound file installation.
    Kevin Bulgrien 2010-10-13

    Fix some bugs found by static analysis (dead assignment, NULL dereference)
    using clang-analyzer.
    Arvid Norlander 2010-10-10

    Fix a number of serious compiler warnings (passing pointer to integer of
    different size, discarding const qualifiers).
    Arvid Norlander 2010-10-09

    gtk-v2/src/sound.c: Converted the Sound2Cmd() and play_sound() functions to
    correspond with the sound2 protocol.  Neither the client nor the server
    support the legacy sound protocol.  Sound has been broken in this client
    ever since the legacy protocol was removed.  This change is made in
    preparation for a cfsndserv re-write that is necessary to support sounds.
    Added a MusicCmd() function to accept music commands from the server and to
    pass them on to cfsndserv.
    Kevin Bulgrien 2010-10-06

    Fix out of tree build. common/Makefile.am called some scripts that were not
    properly handling the case of source directory and build directory differing.
    Arvid Norlander 2010-10-06

    Add 'containers' pickup menu item.
    Nicolas Weeger 2010-10-02

    configure.ac - Back out the 2.18.0 dependency by converting the dependent
    functions to code that is compatible with older GTK.  This was positively
    tested on both 2.20 and 2.14.  On both systems the spell dialog functions as
    intended... resizing the description column and reflowing the text into it.
    Kevin Bulgrien 2010-09-14

    configure.ac: - Use the gtk-2.0.m4 macro to test for a usable version of GTK+
    2.0.  mmetson found that build fails on Fedora Core 11.  It turns out the
    spells dialog uses two functions first provided by GTK+ 2.18.0 in the code
    that wraps the description and auto-grows/shrinks the column when the player
    resizes the dialog.  It is known that one of the calls is pretty easy to
    rewrite for build with pre-2.18.0, but converting the other call has not been
    reviewed.  Until further notice, GTK-V2 now requires GTK+ 2.18.0 or newer.
    Kevin Bulgrien 2010-09-13

    gtk-v2/src/spells.c: The spells dialog description text now dynamically alters
    line wrap width and table row heights when the dialog is re-sized by the user.
    Kevin Bulgrien 2010-08-25

    gtk-v2/src/spells.c: 1) The spells dialog now defaults to wrap the description
    at 300 pixels or so as before, but dynamically re-calculates the wrap width
    based on the dialog width and the width of the other columns.  Presently the
    code does not reclaim extra vertical height when the dialog is widened, so the
    dynamic wrap is a bit pointless except for shrinking the dialog down.  More
    work is needed to get the description field to shrink vertically. 2) Three of
    the columns now have their values centered under the column title to try to
    improve aesthetics.  3) The SP/Mana column title is renamed "Cast/Cost" as
    SP/Mana was redundant and Grace was unmentioned.  This new title also goes
    along with Spellmon 2 changes in the pipeline that support setting ingredients
    as additional casting costs.  Ingredient data is expected to merge with the
    mana/grace data in this dialog, and go in the same column as mana/grace cost.
    Kevin Bulgrien 2010-08-24

    gtk-v2/src/spells.c: Adjust the spell dialog to align all data in the top
    right corner, and to aauto-wrap the description (at a fixed width).  Though
    a dynamic wrap width would be ideal, this at least returns the dialog to a
    manageable width after the spell descriptions were purged of line breaks.
    Even with a fixed wrap width, the dialog is improved by the alignment change.
    Previously the alignment was in the middle, which put the spell name and
    data below the first line of the description.
    Kevin Bulgrien 2010-08-22

    gtk-v2/src/account.c:  Fix client malfunction on [X] closing of account system
    dialogs.  Though the dialogs have the Deletable property set to No, some
    window managers do not honor this setting, and put the [X] close icon on the
    window frame.  Added new on_window_delete_event() callback and connected it
    to all of the account system dialogs so their delete_events are trapped and
    ignored.  The dialogs now only dismiss in the manner the designer intended.
    Kevin Bulgrien 2010-08-19

    gtk-v2/src: about.c, config.c, info.c, keys.c, skills.c, spells.c: Fix
    segfault and/or client malfunction when [X] closing dialogs on window managers
    that do not honor setting their GTK deletable property to No.
    Kevin Bulgrien 2010-08-18

    gtk-v2/glade/*.glade: Change design up to support GTK 2.16 and add orientation
    properties so the files load up and render properly in Glade-3 ver 3.6.7.  Fix
    some more widget names to remove trailing whitespace.  Set the login dialog
    deleteable property to false so window (some) window managers do not show the
    [X] close icon.  The client can't handle the dialog being closed.  This is a
    partial fix only.  Some window managers (or whatever) do not honor the GTK
    property.  Clean up a widget name in the config dialog.
    Kevin Bulgrien 2010-08-16/17

    gtk-v2/glade/dialogs.glade: Fix for bug 3020531 - The Create Character
    button does nothing.  Trailing space in widget name resulted in code
    not finding the widget and attaching callback to it.
    MSW 2010-07-12

    Remove disabled GTK and X11 clients.
    Nicolas Weeger 2010-06-19

    gtk-v2/win32/gtkclient.nsi: Include theme files in the package script, these
    don't seem to actually work under a windows build yet though.
    Brendan Lally 2010-05-21

    gtk-v2/win32/gdefaults2: Use a better default value for map height on win32
    Brendan Lally 2010-05-20

    gtk-v2/win32: remove old-style icon and a compiled windows package I'd
    accidentally included.
    Brendan Lally 2010-05-20

    gtk-v2/win32/gtkclient.nsi: Merge some changes to the nsi file from the one
    from the 1.12 branch
    Brendan Lally 2010-05-20

    Win32Readme.txt, gtk-v2/win32/Running.txt: Merge the contents of win32Readme
    into the Running.txt file.
    Brendan Lally 2010-05-20

    common/client-types.h: Define sleep in a way that can be compilied for windows.
    Brendan Lally 2010-05-20

    common/client.h: Use a more explicit type in a struct definition (doesn't
    compile on windows otherwise)
    Brendan Lally 2010-05-20

    gtk-v2/win32: Remove .gladep files from the win32 nsi file, these are not
    needed by an end-user.
    Brendan Lally 2010-05-20

    gtk-v2/win32: Add some support files for building on win32
    Brendan Lally 2010-05-19

    common/commands.c: Add code to process & store race_info and class_info
       data.  Still TODO is actually write code that will use this information
       (new character creator)
    MSW 2010-05-17

    common/client.c: Fix connection logic which failed if system was using
    ipv6 + ipv4 (and trying ipv6 first) - code was not properly re-setting
    variables and trying the next protocol in the list.  Also clean up some
    formatting.
    MSW 2010-05-15

    GTK-V2 client now converts paths to WIN32 format as needed on such platforms.
    This should fix Bug ID: 2933761 and 2913885.
    Kevin Bulgrien 2010-05-06

    The GTK-V2 client now updates the player's ~/.crossfire/servers.cache file
    whenever a successful server connection is established.
    Kevin Bulgrien 2010-04-29

    Fixed a logic bug in the loader that reads player .crossfire/servers.cache
    files.  The loader wrongly ignored the last valid entry in a cache when it
    contained an odd number of lines.  I.e. if the servers.cache file had only one
    valid two-line entry, and an extra blank line, the loader ignored the the
    valid entry and it would not show up in the client.  With this change, it does
    show up.
    Kevin Bulgrien 2010-04-28

    In the case where HAVE_GETADDRINFO is available (not WIN32), a timeout is now
    implemented when establishing a connection with a server.  The timeout is
    presently hard-coded at 30 seconds.  Prior to this, if a connection attempt
    failed, the client was observed to lock up hard for three minutes.  Half a
    minute is still pretty harsh, but a DNS lookup failure can take 30 seconds, so
    it may be wiser to wait at least as long before bailing out on the attempt.
    Kevin Bulgrien 2010-04-28

1.50.0
======

    common/client.c: Send server deprecated 'newmpcmd 1' setup option - this lets
    the client work properly on old servers.
    MSW 2010-04-25

    Add missing code for account login to display character icons (note server
    code won't be checked in until after 1.50 release).  Add missing function
    declarations to external.h to remove compiler warnings.  Update common/shared
    to latest version.
    common/commands.c: Add support for new attribute.
    common/external.h: Add missing declarations.
    gtk-v2/src/account.c: Update update_character_choose() to display icon.
    MSW 2010-04-24

    Remove the Skills/Experience tab from the core stats notebook in gtk-v2.glade
    as the skills window is better to use.  Tested at 1400x1050, 640x480.  At
    640x480, the inventory/message panel is all the way to the left, but the hpane
    grab bar is visible.  At default client size with no gdefaults2 or gtk-v2.pos,
    the map is to small to work properly, but, if the corestats are pushed down or
    hidden at the bottom of the screen it is playable.
    Kevin Bulgrien 2010-04-23

    common/metaserver.c: Update the standalone metaserver code so that it works
    properly, merge the standalone versions of for both metaservers, and add a
    some more explanatory text to stdout.
    Brendan Lally 2010-04-24

    gtk-v2/src/main.c, common/client.h: Put the name of the glade layout file
    that is being used in the version string that the client sends to the server.
    Brendan Lally 2010-04-24

    - Remove the disfunctional scrollbars from around the map in most gtk-v2
      .glade files.  The layout acts better under different circumstances when
      they aren't there.  After all these years they've never been used, so no
      point in keeping them around as they just take up space.
    Kevin Bulgrien 2010-04-23

    gtk-v2/src/config.c
      Extend the client theme handling by adding support for player-accessible
      style file support.  load_theme() is modified to always look in the player
      ${HOME}/.crossfire folder for a gtkrc file even when the client theme is
      None.  This file can serve as a player's private theme file, or could be
      used just to tweak certain aspects of the client in the same way any other
      .gtkrc file would.  After looking for the gtkrc file, load_theme() also now
      looks for a <layout>.gtkrc file.  I.e.  If sixforty.glade is in use, a
      corresponding ${HOME}/sixforty.gtkrc is processed to make it possible to
      create layout-specific adjustments.  Both files have the same capabilities
      as a client theme file, and, in cases where a player might not have write
      access to the client theme folder, this modification allows the player to
      use themes by putting them in the .crossfire folder, albeit under fixed
      names.  This also sets up a mechanism by which the client could one day
      actually actively maintain (write/update) per-user GTK rc files, but the
      current goal is primarily to make it easier to customize the client's
      presentation without having to put a bunch of highly customized files in
      the distribution.  An in-client-selected theme is loaded last, so as to
      have a higher priority than either the gtkrc or layout-specific rc files.
    Kevin Bulgrien 2010-04-22

    gtk-v2/glade/vi-redux.glade
    gtk-v2/glade/un-deux.glade
    gtk-v2/glade/AUTHORS
    - Remove the skills/experience table from these layout as a result of the new
      skills window.  A significant design point for both of these layouts was to
      try to remove the vertical space constraints that the skills & experience
      information placed on the layout when it was used on smaller displays.
    - Update the AUTHORS notes for both of these layouts.
    Kevin Bulgrien 2010-04-19

    gtk-v2/glade/chthonic.glade
    gtk-v2/glade/AUTHORS
    - Remove the skills/experience table from this layout as a result of the new
      skills window.  At least one user desires this change also.
    - Give meaningful names to various widgets that had generic names.
    - Add a note to the AUTHORS file that notes a minor save/restore issue with
      the protections/core statistics notebook area in the lower right corner.
      It seems as though nesting hpaned or vpaned within each other may be part
      of why some layouts have restore issues that need to be dealt with.
    Kevin Bulgrien 2010-04-18

    gtk-v2/glade/sixforty.glade
    - Fix issue with spinbutton_count to avoid run-time message regarding non-zero
      page size.
    - Remove the table_skills_exp and enclosing structures now that the skills
      window is available.
    gtk-v2/glade/AUTHORS
    - Add note that sixforty.glade has save/restore window position issues at this
      time.  This issue has been present prior to this, so until it is fixed, just
      document it as a known issue so it doesn't get forgotten (again).   Also do
      not mention a map dimension less than allowed (8 vs. minimum 11), and add
      mention of use of map and icon scale to improve usability.
    Kevin Bulgrien 2010-04-18

    gtk-v2/glade/AUTHORS
      Update the description of oroboros.glade.
    gtk-v2/glade/oroboros.glade
      Removed the skills and experience table per creation of the new skills
      window.  This in turn allowed the four tab notebook in the top right to
      change to a 2 tab notebook to improve accessibility of vital statistics.
      This redesign also seems to improve the sizability of the client, possibly
      making it easier to shrink below the default 1024x768 dimensions and opening
      the door to improvements in other layouts.
    gtk-v2/glade/dialogs.glade
      A complete rework of the client configuration dialog to make it take up less
      vertical space.  Netbook users with a screen height of 600 pixels could not
      access all items in the dialog.  The dialog was also pretty ugly and the
      controls were not organized as well as they could be.  The overall design of
      the dialog now matches the design principles used for the account dialogs.
    Kevin Bulgrien 2010-04-17

    gtk-v2/src/skills.c
      Fix broken build (perhaps only on older gtk/libglade versions?).  Replaced
      gtk_widget_get_visible() with GTK_WIDGET_VISIBLE().
    gtk-v2/src/stats.c
      Allow the table_skills_exp to be missing from a main window .glade layout
      without generating stderr spew like (crossfire-client-gtk2:*): Gtk-CRITICAL
      **: gtk_label_set_text: assertion `GTK_IS_LABEL (label)' failed.  The new
      skills window means this table is optional, so there is no point to make
      noise or do extra work if it is absent from the window definition.
    Kevin Bulgrien 2010-04-17

    gtk-v2/src/Makefile.am
      Yet another attempt to fix builds after disable of x11 and gtk-v1 clients.
    configure.ac
      Second attempt to fix builds after disable of x11 and gtk-v1 clients.
    crossfire-client.spec
      First attempt at disabling x11 and gtk-v1 clients.
    Kevin Bulgrien 2010-04-17

    gtk-v2/src/stats.c, gtk-v2/src/skills.c
     If the player has left the skill window open whilst playing, update the
    exp/level values.
    Brendan Lally 2010-04-17

    gtk-v2/glade/dialogs.glade
      Dress up the dialogs related to the account code.  A few items are moved to
      make better use of space, but this mostly adds containers, attributes,
      padding, etc. that improves the dialog aesthetics.  Orientation properties
      are removed to reduce libglade spew when running on older versions.  They
      aren't needed anyway.  The other major change is that now all widgets have
      logical names.
    Kevin Bulgrien 2010-04-15

    common/client.c: File that was missed in the previous commit
    Brendan Lally 2010-04-15

    Add a skill window for the gtk-v2 client
    gtk-v2/src/skills.c: file added
    gtk-v2/src/stats.c, gtk-v2/src/gtk2proto.h
    gtk-v2/src/Makefile.am
    gtk-v2/src/menubar.c - add menu entry callback
    common/client.h
    gtk-v2/glade/dialogs.glade - new window
    gtk-v2/glade/*.glade - update layouts to include new menu entry
    Brendan Lally 2010-04-15

    Fix for bug 1845694 - improper inventory/map redraws in cache mode.
    gtk-v2/src/image.c: Add a variable to track if we have gotten new images.
    gtk-v2/src/image.h: Add declaration for above variable.
    gtk-v2/src/main.c: If we have new images, force full map and inventory
        redraws in main loop.
    MSW 2010-04-11

    gtk-v2/src/account.c: Clear new account names/status when activating
        window.  Otherwise, odd to have info filled in from account
        created on previous server.
    MSW 2010-04-11

    common/client.c: Mostly whitespace changes.  Make minor improvment to
       -download_all_faces to request 1 set more than being worked on.
    common/image.c: Whitespace change - fix formatting.
    common/newsocket.c: Whitespace change - fix formatting.
    gtk-v2/src/image.c: Fix for bug 2938906 - don't free pixmap data when
       using cache mode.
    gtk-v2/src/info.c: Remove useless message about not fine (sic) color.
    MSW 2010-04-11

    gtk-v2/src/info.c: Fix problem with crashes on some systems -
    initialization was outside of for loop which set the variable.  Should
    fix bug 2984398.
    MSW 2010-04-09

    Add error message and quit client if user has out of date dialog.glade file
    installed.  Make error_dialog non static so account.c can use this,
    add check in account.c to see if we found required window, and change
    order if initialization of account windows to do login window first (as
    that is where the check is).
    Files changed: gtk-v2/src/account.c gtk-v2/src/main.c gtk-v2/src/gtk2proto.h
    MSW 2010-04-09

    Add account based support to gtk2 client & common code.  Remove support
    for gtk1 and X11 clients
    ---
    configure.ac: Remove check for gtk1, cfgtk2 option, X11 libraries, and
       checks related to those clients.
    common/client.c: Add tracking of loginmethod.  Update setup to send
       loginmethod, update dispatch table for new commands.  Add
       close_server_connection() so duplicate code does not need to be
       repeated.  Don't send addme command when using new login method.
    common/client.h: Add globals for motd, news, rules, loginmethods,
       INFO_... types.
    common/commands.c: Add processing of requestinfo for motd, rules, news.
       Add handling of loginmethod setup. Add call to hde_all_login_windows()
       when play starts.  Add FailureCmd(), AccountPlayersCmd() to handle
       protocol commands.
    common/init.c:  Free motd/news/rules data when changing servers.
    common/metaserver.c: Move meta_sort() to this file, don't make it
       static - removes compiler warnings.
    common/metaserver.h: Remove static declaration of meta_sort, and
       function prototype for it.
    common/p_cmd.c: Update do_disconnect() to use close_server_connection()
    common/proto.h: Updated with new functions.
    gtk-v2/glade/dialogs.glade: Add new windows for account login code.
    gtk-v2/src/Makefile.am: Add account.c file.
    gtk-v2/src/gtk2proto.h: Update with new functions.
    gtk-v2/src/account.c: New file - does account logic.
    gtk-v2/src/info.c: Change order of includes.  Move some declarations
       from this file to info.h.  Generalize some of the handling so
       other functions can use textbuffer but take advantage of the markup
       processing provided in this file
    gtk-v2/src/info.h: New file - declarations from info.c moved here.
    gtk-v2/src/keys.c: Change order if include of main.h.  Update to use
       close_server_connection()
    gtk-v2/src/main.c: Change order of includes.  Add sample use of
       custom glib log handler.  Update to try and use loginmethod 1
    gtk-v2/src/main.h: Add extern for csocket_fd so a bunch of
       files don't have to declare it itself.
    gtk-v2/src/map.c: Change ordering of includes.
    gtk-v2/src/menubar.c: Update to sue close_server_connection()
    gtk-v2/src/metaserver.c: change order of includes.  Call
       hide_all_login_windows() when bringing up metaserver window.
    gtk-v2/src/opengl.c: Change order of includes.
    gtk-v2/src/pickup.c: Change order of includes.
    gtk-v2/src/spells.c: Change order of include of gtk2proto.h
    ----
    MSW 2010-04-08


    gtk-v2/glade/dialogs.glade
    - Convert tooltip_text fields to tooltip fields as mwedel reports that newer
      versions of glade3 have issues with it (though the version I have does not).
    - Remove has_tooltip settings not needed by the tooltip fields.
    - Make sure all the tooltips have a Translatable property.
    Kevin Bulgrien 2010-04-04

    common/commands.c
    common/client.c
    - Add debugged trunk server code for spellmon 2 request to handle the extended
      data in AddspellCmd().  The extended information is currently not exposed
      to the user interface, but this commit makes it available.
    - The original idea to look at data on the fly instead of tracking spellmon
      command response did not work out.  It turns out to be very easy to
      track server response anyway, so there is not much point in trying to
      figure things out dynamically.
    - These changes have been tested on old and new servers - including logging in
      and out of each on the same client session.  The data in the Spell struct
      has been confirmed to hold data (by testing with spells found in the
      test/spell_requirements map).
    - LOG message for spellmon FALSE is changed from WARNING to INFO.  It's not
      clear that a server's failure to support spellmon is really that bad.  It
      mostly seems to mean that spell information dialog will not be populated.
      Also with the addition of spellmon 2, it is normal for older servers to
      not support it, so that does not seem to warrant the error being a warning
      anymore.
    Kevin Bulgrien 2010-04-03

    gtk-v2/themes/Black
    gtk-v2/themes/Standard
    - Fix [  INFO  ] (spells.c::spell_get_styles) Unable to find style for
      spell_normal
    Kevin Bulgrien 2010-04-02

    common/client.h
    - Reformat of a lot of comments to ~ 80 cols to reduce vertical text spacing.
    - Fix some spelling/grammar issues in comments, and improve readability in
      various places.
    - Fill out the doxygen comments to the Spell structure by adding information
      found in the server documentation of the protocol.
    - Add usage and requirements members to the structure that will support the
      spellmon 2 extended information.
    - Convert some variable comments to doxygen style.
    common/client.c
    - Reformat of a lot of comments to ~ 80 cols to reduce vertical text spacing.
    - Add a TODO at the spot where spellmon 2 will be requested when the code is
      ready.
    common/commands.c
    - Update SetupCmd() to get ready to handle spellmon 2.  Non-functional changes
      are comment reformatting/rewriting, and addition of spellmon 2 comments.
      Code change to separate darkness and spellmon done, but presently no actual
      functional change occurs except there is a minor duplication of an identical
      LOG() call.
    - Update AddspellCmd() to get ready to handle spellmon 2.  Non-functional
      changes are comment reformatting/rewriting/addition.  Stubs are added
      to initialize the spellmon 2 data fields in the Spell structure.
    Kevin Bulgrien 2010-03-30

    common
    - Update the link to the server/trunk/include/shared folder to revision 12770
      to pull in a new revision of shared/newclient.h for the purpose of updating
      the message type/subtype for magic ears and magic mouths.
    common/msgtypes.h
    - Regenerate to capture the changes from the updated shared/newclient.h file.
    gtk-v2/themes/Standard
    gtk-v2/themes/Black
    - Rename msg_dialog_magic_mouth to msg_dialog_magic_ear to more accurately
      identify what is being themed.  Magic mouths are signs, not dialogs.  It is
      the magic ears that are dialogs.
    gtk-v2/src/info.c - Fix msgctrl_defaults[] to list magic ears as a subtype but
      not magic mouths.  Magic mouths are signs, so add that to the sign message
      descriptive text.  This results in a change to the message control dialog.
    Kevin Bulgrien 2010-03-30

    common/command.c - use the map2 type defines in the parsing code
    Brendan Lally 2010-03-28

    common/client.c
    common/commands.c
    common/client.h
    gtk/gx11.c
    x11/x11.c
    gtk-v2/sound.c: Remove the use of the setup flag sexp - The server doesn't
    respond to it any more and the clients don't use it.
    Brendan Lally 2010-03-18

    Protocol cleanup - remove code that supports protocol commands that are out
    of date.  Also change setup to only request current options.
    MSW 2010-01-18
    ---
    common/client.c: Remove handling of obsolete protocol commands.  Clean up
        setup logic - do it all in one setup command instead of several,
        don't send options to server which are now standard.
    common/client.h: remove extern command_inscribe declaration.
    common/commands.c: Fix up a lot of setup logic - remove fallbacks to
        protocol commands that predate the setup replacements.  Remove
        handling of settings which are now standard.
    common/init.c: Remove SendSetFaceMode()
    common/item.c: Presume all servers support inscribe protocol command.
    gtk/gx11.c: Presume all servers support inscribe protocol command.
    gtk/sound.c: remove SoundCmd()
    gtk/win32/porting.c: Remove SoundCmd()
    gtk-v2/src/sound.c: Remove SoundCmd()
    ---

    gtk-v2/src/info.c: off duplicate supression of command responses by default.
        Otherwise, things like statistics output ends up in what effectively
        looks like random order, which isn't good when you have a table.
    MSW 2009-12-07

    macros/ax_pthread.m4: Add a new m4 macro ax_pthread.m4 to (hopefully) better
      suport detection of pthreads.  See:  SF tracker ID 2850517 for info:
      crossfire-client-1.12.0 build failure under Slackware 12.2 - ID: 2850517.
      Note that ax_thread.m4 is itself licensed under GPLv3.  Note a possibility
      for license confusion, but also note that a review of various projects shows
      a fairly common precedent of allowing mixed licenses in the m4 macro
      directory - not all explicitly documenting the fact that different licenses
      are used.  Other projects maintain a file identifying copyright and
      licensing provisions for various parts of the project.  Whereas it is very
      likely other sources will be modified, it is highly unlikely anyone will
      expect to modify the .m4 macros in this project.
    aclocal.m4: Rebuilt file after incorporation of macros/ax_pthread.m4.
      configure.ac: Replace AC_CHECK_LIB(pthread, pthread_create) method of
      detecting pthreads with AX_PTHREAD().  Now halt the build if pthreads is not
      found since presently all clients are required to use metaserver code that
      uses pthreads.  Also modify the configure.ac file to create a configure
      script that reports if the x11 client is built.  There is no reason to avoid
      this since it reports other clients that are or are not built.  The notices
      at the end of the configure script that say "Will build * renderer" are
      changed to say "With * renderer" since it looks silly in the case where no
      clients are built that use the renderers.
    common/Makefile.am
    x11/Makefile.am
    gtk/Makefile.am
    gtk-v2/src/Makefile.am:
      - Modify files to use PTHREAD_CFLAGS and PTHREAD_LIBS variables as advised
        by the new macros/ax_pthread.m4 file.  It is advised that both CFLAGS and
        LIBS variables be used (even though on some systems both are not needed).

    gtk-v2/glade/un-deux.glade
    gtk-v2/glade/gtk-v1.glade
    gtk-v2/glade/v1-redux.glade: This is a resumption of the rework of all .glade
      layouts to support SVN revision 11699 changes to GTK-V2 client code.
      HP/SP/Grace/Food/Exp label is split up into four labels each, and the
      encumbrance data is also split.  This change fixes all zeroes reported by
      knotwork/mark metson.  The other layouts in the V1 theme need similar
      updates.
    Kevin Bulgrien 2009/09/04

    gtk-v2/glade/dialogs.glade:  The msgctrl_window now has more padding around
      the title label to improve aesthetics.  The header of the dialog is modified
      to make room for two new spinbutton controls: msgctrl_spinbutton_count and
      msgctrl_spinbutton_timer.  The spinbuttons allow user access to the output
      count and time controls previously hardcoded.  The controls have tooltips
      that explain what they are for.  Both spinbuttons allow pasting new values,
      clicking the value up/down, or using PgUp/PgDn to adjust the values in one
      second increments (8 client ticks).  The tooltips for all of the column
      labels are reworked.  Padding is added to numerous widgets to improve the
      overall appearance of the dialog.  Tool tips have been added to all the
      buttons to give some indication of what they do.
    gtk-v2/src/info.c:  Add output count and timer spinbutton control capability
      to the new message control dialog by adding a buffer_parameter_t struct
      typedef and buffer_control initialize structure that contains space for the
      pointer, state variable, and a default value.  The message_control struct
      is initialized with the #defines that controlled the system previously.
      Renamed checkbox_t to boolean_widget_t since it doesn't really matter what
      kind of control is used as we only care whether it supports some kind of
      on/off capability.  msgctrl_init() initializes the state and ptr members of
      the buffer_control structure.  Comments are also added to the function
      header.  update_msgctrl_configuration() now updates the count and timer
      spinbuttons.  save_msgctrl_configuration() has improved comments, and also
      reads the dialog to assure saving of the currently displayed settings and
      not just the last applied settings.  The save file format is modified to
      add the spinbutton values.  The format of the file is slightly changed to
      include a record type so that it is easier to validate the file format.
      load_msgctrl_configuration() is heavily modified to improve the savefile
      error detection, and to support the new file format.  The load process is
      a bit more strict about the file being in the right format.  Saved values
      are only read from records that are in the correct format.  Spinbutton
      initialization is added to default_msgctrl_configuration().  The comment
      header for read_msgctrl_configuration() is improved and spinbutton support
      added.  Comment improvements are made for all the button handlers, and now
      on_msgctrl_button_close_clicked() automatically applies the current values
      displayed on the control.
    Kevin Bulgrien 2009/09/03

    gtk-v2/src/info.c:  Support autoload of Message Control dialog settings by
      reading the configuration file in msgctrl_init().
    gtk-v2/src/main.c:  Move msgctrl_init() later in client start up so that auto-
      load of Message Control dialog settings does not segfault.
    Kevin Bulgrien 2009/09/02

    gtk-v2/src/info.c:  The Message Control dialog Load button is now functional.
      Changed some of the struct definitions to be compatible with use to allocate
      a buffer in load_msgctrl_configuration() by making them typedefs and then by
      declaring the msgctrl_widgets[] separately.  Remove various instances of
      end-of-line whitespace.  Fix the update_msgctrl_configuration() truncated
      header comment.  save_msgctrl_configuration() client message format changed
      to report the save file path/filename.  Add load_msgctrl_configuration()
      data parsing using strtok() and only report settings were loaded if at least
      some valid data records were processed.  If any data records are not in the
      expected format, the file is reported as corrupt.  Add comments to local
      variables in several message control system functions.
    Kevin Bulgrien 2009/09/01

    gtk-v2/src/info.c:  The Save and Load buttons are now enabled. The Save button
      is fully functional, but the Load button only opens the save file and scans
      it without actually loading the data.  The Load data parsing is not yet
      implemented.  For now, it counts the number of non-comment and non-blank
      lines and outputs a message if it does not match the number of message types
      the system supports.  msgctrl_init() no longer de-sensitizes the Save and
      Load buttons.  save_msgctrl_configuration() now supports saving the message
      control configuration to ./crossfire/msgs.  load_msgctrl_configuration()
      does read the ./crossfire/msgs file, but does not update the client message
      control configuration yet (though it does reset the control to match the
      msgctrl_widgets[] state variables).  on_msgctrl_button_load_clicked() now
      calls the load_msgctrl_configuration() function.
    Kevin Bulgrien 2009/08/31

    gtk-v2/glade/dialogs.glade:  Add Defaults and Load buttons to the Message
      Control dialog.  Add some space between the buttons so they are not crammed
      completely together when the dialog is small.
    gtk-v2/src/gtk2proto.h:  Update for addition of Defaults button support in the
      Message Control dialog.
    gtk-v2/src/info.c:  Rename msgctrl_data[] to msgctrl_defaults[] to better
      indicate current function and make all values const.  This data is never
      modified at run-time.  In msgctrl_init(), connect the Load and Defaults
      buttons, but in the case of the Load button, desensitize it until the
      functionality is present.  Replace widget and state variable initialization
      code with a call to a new default_msgctrl_configuration().  This is now the
      method by which msgctrl_widgets[] state is initialized, and is the method
      invoked when the Defaults button is pressed.  It invokes another new
      function, update_msgctrl_configuration(), that loads all msgctrl_widgets[]
      state variables with values stored in msgctrl_defaults[].  Added also are
      on_msgctrl_button_load_clicked() and on_msgctrl_button_defaults_clicked().
    Kevin Bulgrien 2009/08/30

    gtk-v2/src/info.c:  Rework the data structures for the Message Control dialog
      to prepare for supporting return to default.  msgctrl_data[] is now only
      used to hold the defaults.  Also convert the buffer empty code to use the
      flush function to centralize that operation in one place.
    Kevin Bulgrien 2009/08/30

    gtk-v2/glade/oroboros.glade
    gtk-v2/glade/lobotomy.glade
    gtk-v2/glade/gtk-v1.glade
    gtk-v2/glade/meflin.glade
    gtk-v2/glade/gtk-v2.glade
    gtk-v2/glade/v1-redux.glade
    gtk-v2/glade/caelestis.glade
    gtk-v2/glade/eureka.glade
    gtk-v2/glade/un-deux.glade
    gtk-v2/glade/sixforty.glade
    gtk-v2/glade/chthonic.glade:  Link the new Message Control dialog to the
      Client menu.
    gtk-v2/src/info.c:  Begin referring to the in-client output-count and message
      routing as the "Message Control System", and add support for in-client,
      player configuration via a new dialog to replace previously hard-coded
      settings.  Change some previously selected data types to GTK data types to
      make interfacing with the UI require fewer casts.  Instead of continuing to
      use the info_ prefix for this functionality, start using a msgctrl_ prefix.
      Added new functions to support the Message Control dialog: msgctrl_init()
      which does the dialog setup on client start; save_msgctrl_configuration(),
      and load_msgctrl_configuration() that are presently stubs, but are intended
      to be used to allow the message control configuration to be saved and
      restored.  read_msgctrl_configuration() obtains the state of the Message
      Control dialog checkboxes, and dynamically, at run-time, allows the player
      to reconfigure which message types undergo duplicate suppression, and to
      which message panels they are routed to.  on_msgctrl_button_save_clicked(),
      on_msgctrl_button_apply_clicked(), and on_msgctrl_button_close_clicked()
      support the dialog buttons (though presently the save button is disabled as
      saving and loading is not yet supported).  on_msgctrl_activate() displays
      the new dialog when the Client | Message Control menu option is selected.
      All data structures and functions are heavily commented in the doxygen
      style.
    gtk-v2/src/main.c:  Added a call to msgctrl_init() during client startup to
      construct the checkbox table and preset all the checkboxes to match the
      hardcoded defaults in info.c.
    gtk-v2/src/menubar.c:  Link the new Message Control dialog into the client
      menu.
    gtk-v2/src/gtk2proto.h:  Update to include prototypes for the new Message
      Control system in-client configuration support.
    gtk-v2/glade/dialog.glade:  Dress up the about, metaserver, spell, and
      keybinding dialogs by adding a couple of horizontal separator bars and by
      replacing an HBoxes with HButtonBoxes.  Adjust padding here and there as
      well (also on the config dialog).  Rename widget names that were
      "typenumber" to "dialog_type_description".  Add a new Message Control
      dialog that is for configuring the client-side output-count and message
      routing.
    Kevin Bulgrien 2009/08/29

    gtk-v2/src/info.c: Set up an info_control[] array of structs, one element for
      each message MSG_TYPE_* in common/shared/newclient.h.  This array contains
      enable/disable flags that determine whether or not a message shows up in any
      of the message panels (and it is possible to route message types to both
      panels).  The array also determines which of the message types are processed
      for duplicate message reduction.  There are still a few conditions that
      override the info_control[] settings.  Presently the array is filled with
      hard-coded defaults, but they will ultimately become defaults that can be
      over-ridden by an in-client control panel and, eventually, by settings saved
      to a configuration file.  message_callback() and draw_ext_info() are now
      modified to use info_control[] instead of the hard-coded settings they used
      previously.
    Kevin Bulgrien 2009/08/25

    Adjust the client-side output-count implementation to always output a message
    the first time it occurs when it first enters the buffering system.  After the
    initial display, the output-count and sync settings determine display time.
    With the new scheme, inactive buffers are also aged and discarded by age so
    that the content can be re-used if the message recurs before it is pushed out
    of the buffer.  The "initial" display of a message is not done if the message
    buffer is re-activated after having been inactivated by output-count or sync.
    Meflin also pointed out the trailing " (Nx)" differed from the original server
    implementation, so now the count is prefixed on the message as "N times ".
    This changed the size of the count buffer, and affected the output buffering
    method - making it more logical to avoid allocating the count buffer in each
    message buffer, but rather only one time in the info_buffer_flush() function.
    This implementation is a bit heavier since buffers are now processed more
    when they are inactive, but it does get unique messages to the player more
    quickly even if they happen to pass through the duplicate suppression system.
    gtk-v2/src/info.c
    Kevin Bulgrien 2009/08/23

    Implement a client-side replacement for the recently removed output-count and
    output-sync commands.  The client implementation matches the basic operation
    of the server feature.  Output-count determines the highest number of messages
    that can to coalesce into one.  The output-sync determines the maximum amount
    of time a message stays in a buffer until it is displayed.  The present code
    has output-count hardcoded to 16 (info.c: MESSAGE_COUNT_MAX) and output-sync
    to 16 client ticks, or about 2 seconds (info.c: MESSAGE_AGE_MAX).  Messages
    ARE NOT considered for duplicate suppression if:  define MESSAGE_COUNT_MAX <=
    1; the message is sourced from client code; the hinted color of the message is
    NDI_UNIQUE; the message length is greater than 56 characters.  Messages are
    displayed if either output-count or output-sync limits are reached.  Either or
    both client command configuration and GUI configuration is planned.  Probably
    GUI configuration will be implemented with an ability to configure message
    routing as well.
    gtk-v2/src/gtk2proto.h:  Re-ran `make proto` to update prototypes.
    gtk-v2/src/main.c:       Addied a call to the output-count/sync maintenance
      function info_buffer_tick() from client_tick().
    gtk-v2/src/info.c:       All output count/sync functionality is implemented
      in this file.  Presently the feature is configured by adjusting defines in
      this file.  The new defines, variables, and code are fully commented in the
      doxygen style.  The system is initialized by calling info_buffer_init() from
      info_init().  To further support the system, info_buffer_flush() ejects
      messages from the buffers to the client display, and info_buffer_tick() both
      ages the buffers and evaluates them to determine if they need to be flushed.
      The old message_callback() is renamed draw_ext_info() and all messages still
      pass through it for routing and styling.  The pre-existing draw_ext_info()
      function is removed.  A replacement message_callback() is the front-end for
      the buffering system, and all messages except client-sourced messages pass
      through it.
    Kevin Bulgrien 2009/08/17

    gtk-v2/glade/*.glade:  Finish an incomplete rename of ratio_pickup_off1 to
      ratio_pickup_off in the pickup menu.
    Kevin Bulgrien 2009/08/09

    common/metaserver.c: Fix bug 2806906- gcfclient hangs on exit when offline.
        Limit number of attempts to get metaserver2 data - was trying
        perpetually before.
    MSW 2009-07-27

    gtk-v2/src/keys.c: Always extract spinbutton count and send it to server
      when doing commands - fixes 'invoke dimension door' spacing issue.
    MSW 2009-07-13

    gtk-v2/glade/sixforty.glade:  This started out as a rework for the new stat.c
      and pickup.c code, but became a general improvement effort.  The layout has
      some issues in that saving windows position seems unreliable - possibly due
      to a need for constraining containers (viewport?) in the vpaned widgets. To
      debug, experimentation with scrolled windows can show when widgets might be
      have a size that subverts sizing.  The default layout with no sixforty.pos
      is sane.  The stats panel is changed the most with scroll bars added so the
      wide stats can be viewed in a small client.  Both message panels are not in
      a notebook anymore to support recent chat/tell/say changes.
    Kevin Bulgrien 2009/05/25

    gtk-v2/glade/lobotomy.glade
    gtk-v2/glade/oroboros.glade
    gtk-v2/glade/gtk-v1.glade
    gtk-v2/glade/gtk-v2.glade
    gtk-v2/glade/meflin.glade
    gtk-v2/glade/v1-redux.glade
    gtk-v2/glade/eureka.glade
    gtk-v2/glade/caelestis.glade
    gtk-v2/glade/un-deux.glade
    gtk-v2/glade/sixforty.glade
    gtk-v2/glade/chthonic.glade:  Fix an omitted change in the menubar edits made
      prior to support changes in pickup.c.
    Kevin Bulgrien 2009/05/24

    gtk-v2/glade/lobotomy.glade:  A significant dress-up of the layout and general
      reduction of various container widgets that are not necessary for one reason
      or another.  An issue with chat panels was discovered and fixed.  Under some
      circumstances, the vertical scroll bar would disappear due to the horizontal
      scroll bar policy being set to never.  The policy is now set to automatic to
      prevent the issue. Unused menu bar widgets are removed, and the menu widgets
      names are made more consistent.  This drove widget name changes in menubar.c
      and pickup.c.
    gtk-v2/src/pickup.c
    gtk-v2/src/menubar.c:  Menubar widgets are renamed to remove numeric suffixes
      and improve uniformity.
    gtk-v2/glade/oroboros.glade
    gtk-v2/glade/gtk-v1.glade
    gtk-v2/glade/meflin.glade
    gtk-v2/glade/gtk-v2.glade
    gtk-v2/glade/v1-redux.glade
    gtk-v2/glade/caelestis.glade
    gtk-v2/glade/eureka.glade
    gtk-v2/glade/un-deux.glade
    gtk-v2/glade/sixforty.glade
    gtk-v2/glade/chthonic.glade: All of the .glade files have the same menubar as
      made for lobotomy.glade to correspond with the above changes in menubar.c
      and pickup.c
    Kevin Bulgrien 2009/05/23

    gtk-v2/glade/oroboros.glade:  This update supports recent client code changes.
      The layout is basically the same as before the the update but viewports are
      added in a number of places to improve the aesthetics of the UI.  The stat
      bar numeric data has been moved to the left of the bars.
    Kevin Bulgrien 2009/05/23

    gtk-v2/glade/eureka.glade:  This update supports recent client code changes.
      The stat bar display is moderately reorganized to allow very long experience
      data to be covered by the neighboring hpane panel as needed.  The critical
      and normal message panels have swapped positions due to recent use of the
      critical panel for chat, tell, and say messages (placed nearer the command
      entry control).
    gtk-v2/glade/lobotomy.glade:  This update includes both stylistic changes and
      updates to support recent client code changes.  Though the lobotomy layout
      was unique in certain respects, the notorious skills and stats carry-overs
      from the original gtk-v2 layout were ugly.  This commit introduces statistic
      panels that are completely unique.  The skills and protections areas still
      take up the bulk of the bottom row, but they are designed to better avoid
      the overlap that so easily occurs in gtk-v2.  A stats cluster in the bottom
      right corner explores a new method of organizing all character stats and any
      related stat bars in a small area, while tending to avoid the width problems
      that can so easily crop up with the stat bar numeric data.  Another notable
      change is that all notebooks except the map/magic map notebook are gone.
      The critical and normal message panels have swapped positions to put chat,
      tell, and say messages closer to the command entry box.
    gtk-v2/glade/AUTHORS: The lobotomy.glade section has been updated to match the
      changes made to the layout.
    gtk-v2/glade/caelestis.glade
    gtk-v2/glade/chthonic.glade: Glade3 Designer apparently does not work well
      with single column tables, so a vbox was substituted to avoid misbehavior in
      the designer.  The presentation to the player is basically unchanged except
      the critical and normal message panels have swapped positions to put chat,
      tell, and say messages closer to the command entry box.
    Kevin Bulgrien 2009/05/22

    gtk-v2/glade/caelestis.glade
    gtk-v2/glade/chthonic.glade
    gtk-v2/glade/gtk-v2.glade: This is the beginning of the rework of all .glade
      layouts to support SVN revision 11699 changes to GTK-V2 client code.  All
      of the files are changed using Glade3 Designer, so are about half their
      former size.  The files target Glade 2.12 and do not contain deprecations
      or version conflicts.  The HP/SP/Grace/Food/Exp label is split up into four
      labels each, and the encumbrance data is also split.  Though gtk-v2.glade
      has been changed subtly, the data is still in the same relative location as
      the original layout.  The caelestis and chthonic relocate stat numeric data
      to the right side of the progress bars to achieve the same improvements
      originally developed for meflin.glade.  All layouts have had some viewports
      added in various places to give the UI an overall better, more polished
      appearance.
    Kevin Bulgrien 2009/05/21

    The following commit introduces a code incompatibility with existing .glade
    layouts.  All layouts must be updated to match this code to retain encumbrance
    display and the numerical data next to the stat progressbar widgets.  This
    change is made because it allows much greater flexibility in the UI layout.
    The motive was to reduce bad UI behavior when a character had very large
    amounts of XP, but a side-effect is that layout density can be improved for
    those wanting a small UI footprint.  The existing .glade layouts may still
    be used, but some numeric data will not be available until the layout is
    updated.  meflin.glade rework sparked the idea for this change, and was used
    to test the code, so is hereby committed.  The other layouts will be changed
    in relatively short order.

    gtk-v2/src/stats.c: The stat_label pointer was split into two pointers called
      stat_current and stat_max.  The widget that stat_label pointed to used to be
      set with a programmatically defined stat name, current value/max value all
      as a single string.  With the Exp: data in particular, this resulted in a
      very wide string that tended be be quite problematic.  Not only that, but it
      forced client layouts to use a hardcoded name for stats instead of allowing
      the layout to define (or omit) the name.  In the .glade file, the change
      corresponds with the splitting of the label_stats_* widgets each into four
      separate widget sets wth the names: label_stat_name_*, label_stat_current_*,
      label_stat_ratio_*, and label_stat_max_*.  label_stat_name_* is no longer
      programmatically set by the client code.  The current/max data formerly in
      the split widget is now divided between the other newly created widgets.
      The *_ratio_* widgets are generally defined in the .glade file as a "/", and
      the client code does not modify it.  Various block comments were reformatted
      to wider margins to reduce vertical height of the comments. One spelling
      error was fixed in a code comment.
    gtk-v2/src/inventory.c: The changes closely match the changes described for
      stats.c except that they change the behavior of the weight or encumbrance
      data shown in the client.  The pointer weight_label is split into two
      pointers:  encumbrance_current and encumbrance_max.  This makes it possible
      to split the two numbers formerly displayed as current/max in a single
      string.  The widget name label_inv_weight was replaced by widgets with the
      the names label_stat_encumbrance_current, label_stat_ratio_encumbrance, and
      label_stat_encumbrance_max.  The stat name label was not programmatically
      set for encumbrance, but was renamed to label_stat_encumbrance_name to match
      the stats.c changes.  Block comments were reformatted to wider margins to
      decrease their vertical height.
    gtk-v2/glade/meflin.glade:  The stats panel has been reorganized to make use
      of and test the above changes.  The stat labels for the progressbars are
      still to the left of the progress bar, but the associated numeric ratio is
      now to the right of the progress bar.  This allows the player adjust the
      hpane to cover extremely long experience/next_level strings to increase the
      area available for critical messages.  The stat columns are moved from the
      right side of the progress bars to the left side.  Fire/Run and the active
      ranged skill are now shown below the progress bars and separated from them
      by a blank line (to improve readability).  The overall appearance of this
      layout was also improved by introducing into the design more viewports with
      borders.
    Kevin Bulgrien 2009/05/21

    gtk-v2/glade/meflin.glade: Swapped position of Messages and Look/Inventory at
      Meflin's request.  The Range: slot in the stats table caused some expanding
      and contracting of the stats panel when rotating through ranged skills, so
      it is now assigned a row of its own.  After adding this row, the table now
      has seven rows, so the Str/Dex/Con/Int/Wis/Pow/Cha can now be laid out in a
      vertical fashion.  The addition of a row also leaves a cell above WSp blank,
      so Run/Fire is moved from the menubar to this cell.  The cell where Range:
      used to be is now blank.  Added separators between the menu and the player
      information items in the menu bar.  Now that the look/inventory panel is at
      the bottom, it makes more sense to put the notebook tabs next to the command
      input, so the tabs are change to the bottom of the notebook, and to maintain
      a consistent appearance, the stats/prot/skills notebook also has the tabs
      moved to the bottom.
    Kevin Bulgrien 2009/05/17

    gtk-v2/glade/meflin.glade: Reworked this layout which was not used (probably
      because messages were not visible when clicking or examining items with the
      mouse).  The changes from sixforty involve making sure critical messages and
      regular messages are both visible at the same time.  The critical messages
      are put on the stats pane below the maps.  The other big change is to try
      putting ground view and inventory on their own tabbed notebook with the
      ground view the default.  This layout makes more use of viewports to make
      the UI look nicer.  There are still areas for improvement like the menubar.
      The command input box seems small too, but its worth getting other feedback
      before messing around too much more with it.
    gtk-v2/glade/sixforty.glade
    gtk-v2/glade/sixforty.gladep: Add a four-quadrant layout that seems workable
      at a 640x480 screen resolution.  It has some innovations for tightening up
      stats display, and will likely be nice for larger resolutions also.  This
      layout actually appears to be different enough to inspire some ideas on
      how to make a few code changes to improve the ability to tighten up the
      displays even more.  This layout was developed with glade2, but resaved
      using glade3 prior to commit.  The XML targets GTK+ 2.12 and fully passes
      glade3s deprecation and version mismatch checks.
    gtk-v2/glade/Makefile.am: Incorporate the new sixforty.glade into the build.
    gtk-v2/glade/AUTHORS: Add a descriptive summary of the new sixforty layout.
    crossfire-client.spec: Add sixforty.glade to the package, and update the
      internal changelog.
    gtk-v2/glade/meflin.glade: Open in glade3 and save changes after verifying
      GTK+ target 2.12 and that deprecation and version mismatch checks pass.
    Kevin Bulgrien 2009/05/16

    gtk-v2/glade/dialogs.glade: Set the About dialog window_position property to
      center for more logical and natural positioning of an infrequently viewed
      dialog.  The other dialogs seem to try to position themselves in corners
      of the screen, which makes sense so they do not overlay each other, but it
      doesn't make a lot of sense for the About dialog, and looks better this way.
    Kevin Bulgrien 2009/05/15

    gto-v2/glade/dialogs.glade: Set the deletable property False on all dialogs to
      fix Tracker ID: 2784779 GTK-V2 loses dialogs if closed with X control.  It
      looks like glade3 is going to be annoying.  The diff is huge, but if you
      sort the old file and new file, the real difference is only one line of
      text for each dialog.
    Kevin Bulgrien 2009/05/14

    gtk-v2/glade/dialogs.glade: Open/save using glade3 so that later modifications
      may be better identified in a diff.  Glade3 appears to save widgets in alpha
      order.  Glade3 also seemed to remove quite a bit of content, but so far what
      I have seen indicates that glade2 to glade3 migration is pretty safe.
    Kevin Bulgrien 2009/05/14

    crossfire-client.spec: Change some of the RPM .spec file BuildRequires to be
      more flexible after after testing on Mandriva 2009.0 (local machine) and
      Centos (Invidious).  Centos build failed with requires libcurl-devel and
      libglade2.0-devel but both succeed if the requires are changed to curl-devel
      and libglade2-devel.  These new requires also work on fedora10.
    Kevin Bulgrien 2009/05/10

    common/shared/newclient.h:  After coming to the realization that this file is
      better sourced in the server so that different client codebases could
      conceptually use different versions of the file depending on their
      development state, this file is now moved to server/include/shared.
    common/shared: Removed to allow the server/include/shared directory to be made
      and external reference here.
    common:  Added an svn:externals property to use server/include/shared revision
      11676 to create and populate client/common/shared so that newclient.h is a
      direct copy of the file maintained in the server area.
    Kevin Bulgrien 2009/05/09

    common/shared/newclient.h:  Removed comment that talked about the file being
      separately controlled in client and server.  Add a comment to the #ifdef
      that switches the content of one typedef depending on where it is compiled.
    Kevin Bulgrien 2009/05/09

    common/newclient.h: Moved to the new common/shared subdirectory because svn
      externals work on a directories only.  It is planned to share this file
      between the server and client to assure synchronization.
    common/shared/newclient.h: Moved from common.
    common/item.c
    common/msgtypes.pl
    common/client.h
    common/newsocket.h
    common/Makefile.am
    sound-src/alsa9.c
    sound-src/cfsndserv.c: changed all #includes to reference newclient.h in its
      new location (common/shared/newclient.h).
    common/msgtypes.h: Changes resulting from merge of server newclient.h with the
      client newclient.h.
    Kevin Bulgrien 2009/05/08

    common/newclient.h:  Merge differences from server/trunk/include/newclient.h
      in preparation for correcting the fact that the two files are separately
      maintained - allowing divergence in implementation.  One apparent required
      conflict is handled by detecting a define present only in the client.
    Kevin Bulgrien 2009/05/08

    The following commit converts all common code and GTK-V2 draw_info() calls to
    draw_ext_info() calls so that support for untyped draw_info() messages can be
    completely removed from GTK-V2.  While converting the draw_info() calls, also
    get rid of the deprecated draw_color_info() use in common so that the clients
    can have this deprecated function removed.  This conversion also requires all
    clients provide a draw_ext_info() for common code to use.  In the X11 and the
    GTK-V1 client, draw_ext_info() discards the message type information and just
    uses its existing draw_info() function.  To support this change, new message
    types and subtypes have been added to support client-sourced messages.  More
    than likely the client-side message subtypes could be fine tuned, but GTK-V2
    also has changed to allow the draw_info() colors to be used until style data
    is set up for the client message types.  draw_info() is removed from GTK-V2.

    common/item.c:          draw_info() --> draw_ext_info().
    common/commands.c:      draw_info() --> draw_ext_info(); Remove
                            draw_color_info().
                            Remove commented code used to develop skills report.
    common/script.c:        draw_info() --> draw_ext_info().
    common/client.c:        draw_info() --> draw_ext_info().
    common/msgtypes.h:      Regenerated with `make msgtypes.h`.
    common/p_cmd.c:         draw_info() --> draw_ext_info().
    common/image.c:         draw_info() --> draw_ext_info().
    common/player.c:        draw_info() --> draw_ext_info().
    common/script_lua.c:    draw_info() --> draw_ext_info().
    common/metaserver.c:    draw_info() --> draw_ext_info(); comment updates.
    common/external.h:      Remove draw_info(); remove draw_color_info(); add
                            draw_ext_info().
    common/newclient.h:     Add/tweak comments for pre-existing message types.
                            Add a new message type for client-sourced messages
                            along with some subtypes that seemed reasonable when
                            reviewing the kinds of messages the client spawns.
    x11/x11proto.h:         Regenerated with `make proto`.
    x11/x11.c:              Remove draw_color_info().  Add draw_ext_info().
    gtk/gtkproto.h:         Rebuilt file with `make proto`.
    gtk/gx11.c:             Remove draw_color_info().  Add draw_ext_info().
    gtk-v2/src/gtk2proto.h: Regenerated with `make proto`.
    gtk-v2/src/config.c:    draw_info() --> draw_ext_info().
    gtk-v2/src/keys.c:      draw_info() --> draw_ext_info().  Fix a misspelling
                            in a message.
    gtk-v2/src/info.c:      Fix the message_callback() prototype to match the
                            function declaration and add a draw_ext_info()
                            prototype.  Modify message_callback() to honor the
                            orig_color parameter in cases where a style has not
                            been set for a particular message type/subtype so
                            that draw_info() texts converted to draw_ext_info()
                            will not lose their color just because the themes
                            are not updated.  To make this work, the message
                            routing code was moved to run earlier.  draw_info()
                            is removed from the GTK-V2 client to strongly show
                            that any new client messages need to be typed. This
                            enhances the value and coverage of the theme support
                            in the client.  In fact, draw_info() comments hinted
                            that draw_info() has been considered questionable in
                            various ways before this conversion was conceived.
                            Add a draw_ext_info() call that simply uses the
                            message_callback().  Really the message_callback()
                            should probably be renamed draw_ext_info() instead
                            of putting this extra call in.
    gtk-v2/src/pickup.c:    draw_info() --> draw_ext_info().
    gtk-v2/src/inventory.c: draw_info() --> draw_ext_info().
    Kevin Bulgrien 2009/04/22

    gtk-v2/src/info.c: After some play-testing, its kind of wierd for say to go to
      one window and NPC/Magic Mouth stuff to go to the other, so MSG_TYPE_DIALOG
      is now also routed to the critical messages pane.
    Kevin Bulgrien 2009/04/16

    gtk-v2/src/info.c: Per mailing list discussion on or about 2008/12/22, route
      MSG_TYPE_ATTRIBUTE (Changes to attributes: stats, resistances, etc),
      MSG_TYPE_COMMUNICATION (Communication between players), and MSG_TYPE_VICTIM
      (Something bad is happening to the player) to the critical messages pane.
      As stated on the ML, there are other potentially superior solutions to chats
      tells not getting drowned out by other messages, but this is a very simple
      one.  The critical messages pane gets very little activity, unlike the
      regular messages pane.  Addition of a chat-specific panel, or client-side
      routing configuration is not considered precluded by this quick fix.
    Kevin Bulgrien 2009/04/16

    Fix typo in scripting protocol: send "watch stats maxsp" rather than
      "watch stats maxspp".
    Andreas Kirschbaum 2009-01-19

    Send correct coordinates for "request map pos" script command.
    Do not crash for "request items cont" if there is no opened container.
    Report weight in grams in "request items" commands. Previously a localized
      floating point number in kg was passed.
    Add checks for incorrect parameters to scripttell command. Do not pass the
    script ID to the script.
      common/script.c
    Andreas Kirschbaum 2009-01-18

    Various fixes and improvements, mostly related to map handling in gtk2 client.
    Main change is that the map area can now be resized during play and it will
    draw things as expected.  Note server change is needed for map to not appear
    jumbled after initial resize.  Fix bug 2476715: Image display problem when not
    sized to a multiple of 32
    --
    configure.ac: Move evaluation of extra includes and extra linker flags (
       --with-..) options before lua/opengl checks - if those libraries are not
       in usual location, still want to be able to use them.
    gtk-v2/src/gtk2proto.h: callback for configure event added.
    gtk-v2/src/map.c:  map_init(): Remove explicit call to set map area size.
        display_mapcell(): Fix drawing of images not a multiple of 32.
        resize_map_window(): Additional processing after resize event.
        on_drawingarea_map_configure_event(): New function - gets resize event
            and makes necessary updates.
    gtk-v2/glade/gtk-v2.glade: Remove explicit size value from layout.  This
        gives more resize flexibility.
    MSW 2009-01-04

    gtk-v2/src/info.c: Add missing initializer to pane variable.  Without it,
        we are passing in garbage value to functions, which results in crashes.
    MSW 2008-12-29

    make proto in the GTK-V2 source directory yielded an error about a missing
    about.h file.  Additional includes are passed to cproto to remove this
    error.
      gtk-v2/src/Makefile.am
    Kevin Bulgrien 2008-12-21

    The GTK-V2 client for some reason saved the window positions file multiple
    times per use of menubar Client | Save Window Position.  Adding a call to
    g_signal_stop_emission_by_name() in on_save_window_position_activate()
    puts this silliness to an end.  The file is now only saved one time.
      gtk-v2/src/config.c
    Kevin Bulgrien 2008-12-21

    Remove "(crossfire-client-gtk2:2088): Gtk-WARNING **: GtkSpinButton: setting
    an adjustment with non-zero page size is deprecated run-time warnings for the
    GTK-V2 client.
      gtk-v2/glade/lobotomy.glade
      gtk-v2/glade/oroboros.glade
      gtk-v2/glade/gtk-v1.glade
      gtk-v2/glade/gtk-v2.glade
      gtk-v2/glade/meflin.glade
      gtk-v2/glade/v1-redux.glade
      gtk-v2/glade/eureka.glade
      gtk-v2/glade/caelestis.glade
      gtk-v2/glade/dialogs.glade
      gtk-v2/glade/un-deux.glade
      gtk-v2/glade/chthonic.glade
    Kevin Bulgrien 2008-12-20

    Complete fixing GTK-V1 issue [ 1876788 ] Doubled characters in GTK clients
    (unusable).  Tested with --enable-cfgtk2 compiled as RPM.
      gtk/keys.c
    Kevin Bulgrien 2008-12-16

    Misc compilation tweaks, no functional change.
     common/init.c mapdata.c: remove redundant Win32 macros.
     common/metaserver.c: add dummy return values to make the compiler happy.
    Nicolas Weeger 2008-12-14

    gtk_signal_emit_stop_by_name() was poorly placed and is moved to a location
    where it will help fix the [ 1876788 ] Doubled characters in GTK clients
    (unusable) for the GTK-V1 client.
      gtk/keys.c
    Kevin Bulgrien 2008-12-13

    Fix for [ 2022488 ] 2.x GTKv1 client built with --enable-cfgtk2 cannot login
    and for [ 1862055 ] GTKv1 client built with --enable-cfgtk2 cannot login so
    it is no longer necessary to run the client with Popup Windows.
      gtk/keys.c
    Kevin Bulgrien 2008-12-13

    Pending fix for [ 1876788 ] Doubled characters in GTK clients (unusable).
    mwedel noted gtk_signal_emit_stop_by_name() was not used consistently
    everywhere keypresses were consumed by the client.  Patches were written
    and tested to show that consistent use of gtk_signal_emit_stop_by_name()
    caused the doubled character problem to disappear.  Then a new patch was
    written to replace redundant call/return pairs with fall-through logic.
    http://www.gtk.org/api/2.6/gtk/gtk-Signals.html#gtk-signal-emit-stop-by-name
    also states this is a deprecated function, g_signal_stop_emission_by_name()
    is now used instead of gtk_signal_emit_stop_by_name().
      gtk-v2/src/keys.c
    Kevin Bulgrien 2008-12-04

    To satisfy rpmlint and remove the error "E: no-packager-tag", add the packager
    tag and define it to a sane default.
      crossfire-client.spec
    Kevin Bulgrien 2008-11-28

    To satisfy rpmlint and remove the error "E: non-standard-group X11/Games", all
    package groups are changed from "X11/Games" to "Games/Adventure".  Choices
    offered by rpmlint were "Games/Adventure", "Games/Arcade", "Games/Boards",
    "Games/Cards", "Games/Other", "Games/Puzzles", "Games/Sports", and
    "Games/Strategy"
      crossfire-client.spec
    Kevin Bulgrien 2008-11-28

    Update all client .desktop files so they do not trigger rpmlint messages like
    ".desktop file is not valid, check with desktop-file-validate":  Terminate
    the Categories key/value with a semicolon; remove the deprecated Encoding key.
    Unify the Comment for all three clients.  Add an appropriate GenericName key.
    Add [en] localestrings for the Name, GenericName, and Comment keys to help
    make it more obvious that translations may be placed in this file.  Put the
    keys in order as listed in http://standards.freedesktop.org/desktop-entry-spec
    These changes are tested with desktop-file-validate.
     x11/crossfire-client.desktop
     gtk/crossfire-client.desktop
     gtk-v2/crossfire-client.desktop
    Kevin Bulgrien 2008-11-28

    Eliminate rpmlint message W: mixed-use-of-spaces-and-tabs (spaces: line 159,
    tab: line 169) by converting tabs to spaces.  No functional change.
      crossfire-client.spec
    Kevin Bulgrien 2008-11-28

    Remove remaining vestiges of the old gcfclient/gcfclient2 naming convention.
    This does also slightly change the default gdefaults2 file generated by the
    client, and removes a blank line from the help output of the gtk-v2 client.
      INSTALL
      gtk-v2/src/config.c
      gtk-v2/src/main.c
    Kevin Bulgrien 2008-11-26

    Win32 updates.
     common/commands.c: variables declaration at top
     gtk/sound.c: empty stubs
     gtk/win32/config.h: vsnprintf exists under another name
     gtk/win32/GTKClient.dsp: update
     gtk/win32/GTKClient.dsw: update
     gtk/win32/gtkclient.nsi: update
     gtk/win32/Win32Changes.txt: update
    Nicolas Weeger 2008-08-04

    Update crossfire-client.desktop files by using consistent names; making sure
    all have categories; and adding a new file for the X11 client.
      x11/crossfire-client.desktop
      x11/Makefile.am
      gtk/crossfire-client.desktop
      gtk-v2/Makefile.am
      gtk/crossfire-client.desktop
    Change the default version for the client to 2.0.dev instead of 2.0-dev as the
    dash is incompatible with modern RPM tools.  Dash is reserved for separating
    things in the RPM file name, and must not be embedded in the version string.
    Also rework datadir computation, and report where client data files will be
    placed.  Improve reporting of the bindir to be used.
      configure.ac
    Fix RPM creation for the client release procedure.  Add new .desktop files and
    package them with the clients rather than in the common package.  Change the
    location for the .desktop files to /usr/share/applications.  Update the list
    of .glade files for the GTK client V2.  Correct the RPM build process by
    adding a _datadir definition, and modify all file specifications accordingly.
    Fix the build specs so a crossfire-client-x11 package is made.  Swap the gtk
    client build to use GTK V2 by default.  Change versions to 2.0.dev instead of
    2.0-dev, which is invalid for current versions of rpmbuild.
      crossfire-client.spec
    Kevin Bulgrien 2008/07/19

    Fix Makefile.am per use of configure.ac vs. configure.in.
      Makefile.am
    Fix release procedure support (make dist) for script_lua.h.
    Fix release procedure support (make dist) for msgtypes.h.
      common/Makefile.am
    GTK-v1 client name changes from gcfclient to crossfire-client-gtk.
      gtk/crossfire-client.desktop
      gtk/config.c
      gtk/gx11.c
      gtk/win32/config.h
      gtk/crossfire-client-gtk.man
    Add -popups to the default startup options as a partial workaround for
    Bug #2022488 2.x GTKv1 client built --enable-cfgtk2 cannot login.
      gtk/crossfire-client.desktop
    Spelling, capitalization, and some whitespace modifications.  No functional
    code changes.
      gtk/gx11.c
      common/init.c
    Override common/init.c default for popups for GTKv1 client only as a
    partial workaround for Bug #2022488 2.x GTKv1 client built --enable-cfgtk2
    cannot login.  This actually changes the behavior to agree with the
    man page that states popups on is the default.  Naturally this will not
    work if a player has a ~/.crossfire/gdefaults file with popups off, but
    this ensures a new player with have a working client with popups on.
      gtk/gx11.c
    Kevin Bulgrien 2008-07-19

    common/newsocket.c: Improve error message (print out actual error) on failed
    write.  Also, try to write again on errno==EAGAIN - fixes problem for systems
    that return EAGAIN instead of 0 when a write fails on a non blocking device.
    MSW 2008-07-07

    Allow scripts to retrieve information that was previously unavailable: tag of
    the player object (used in move commands), title, list of known spells, names
    of the known skills, and attuned/repelled/denied spell paths.
     common/script.c
    Raphael Quinet 2008-06-22

    Clean up configure.ac and add a missing test for size_t.
     configure.ac
     common/config.h.in
    Arvid Norlander 2008-06-05

    Fix a valgrind error (uninitialised value) in smoothing code.
     gtk-v2/src/config.c
     gtk-v2/src/map.c
    Arvid Norlander 2008-06-03

    Fix a valgrind error in the common metaserver code. For some reason sc_version
    and cs_version fields were not always properly initialized when check_server_version()
    was called.
     common/metaserver.c
    Arvid Norlander 2008-06-03

    Add stub support for sound2/music commands, I was unable to make server send
    the actual commands except "music NONE" (and jxclient that do have sounds don't
    get these commands either, but decides locally to play some sounds it seems) so
    was not able to debug it beyond making sure it compiled and ran. When the server
    actually sends these commands someone need to fill in the implementations and
    check the parsing code is correct for sound2.
     gtk/gtkproto.h
     gtk/sound.c
     common/commands.c
     common/client.c
     common/external.h
     x11/x11proto.h
     x11/sound.c
     gtk-v2/src/gtk2proto.h
     gtk-v2/src/sound.c
    Arvid Norlander 2008-06-02

    Unbreak LUA check in configure. Also update autogen.sh to mention that
    autoreconf should be used instead and make the call aclocal in the script correct.
     autogen.sh
     configure.ac
    Arvid Norlander 2008-06-01

    Remove acinclude.m4 and add macros/libcurl.m4 (as acinclude.m4 just contained
    a copy of what should have been in macros/libcurl.m4).
     aclocal.m4
    Added:
     macros/libcurl.m4
    Removed:
     acinclude.m4
    Arvid Norlander 2008-06-01

    Normalize the *.xpm and *.xbm files by opening them in gimp and resaving them.
    Then readd "const" as needed in a text editor. Also had to update some source
    files because the name of the array for the xpm changed in some cases.
     pixmaps/applied.xpm
     pixmaps/magic.xpm
     pixmaps/unpaid.xpm
     pixmaps/cursed.xpm
     pixmaps/lock.xpm
     pixmaps/bg.xpm
     pixmaps/skull.xpm
     pixmaps/unlock.xpm
     pixmaps/mag.xpm
     pixmaps/question.xpm
     pixmaps/clear.xbm
     pixmaps/hand.xpm
     pixmaps/damned.xbm
     pixmaps/sign_east.xpm
     pixmaps/stipple.111
     pixmaps/nonmag.xpm
     pixmaps/stipple.112
     pixmaps/test.xpm
     pixmaps/locked.xbm
     pixmaps/dot.xpm
     pixmaps/close.xbm
     pixmaps/damned.xpm
     pixmaps/coin.xpm
     pixmaps/hand2.xpm
     pixmaps/applied.xbm
     pixmaps/locked.xpm
     pixmaps/crossfiretitle.xpm
     pixmaps/magic.xbm
     pixmaps/sign_west.xpm
     pixmaps/unpaid.xbm
     pixmaps/question.111
     pixmaps/close.xpm
     pixmaps/sign_flat.xpm
     pixmaps/cursed.xbm
     pixmaps/all.xpm
     gtk/gx11.c
     x11/clientbmap.h
     gtk-v2/src/about.c
     gtk-v2/src/map.c
     gtk-v2/src/image.c
    Arvid Norlander 2008-06-01

    Run protoize on code to add missing void in prototypes. Run the png_compress
    script from arch on some *.png files in the tree to reduce their size.
     pixmaps/48x48.png
     pixmaps/32x32.png
     pixmaps/16x16.png
     gtk/config.c
     gtk/keys.c
     gtk/map.c
     gtk/gx11.c
     gtk/image.c
     gtk/inventory.c
     common/item.c
     common/init.c
     common/mapdata.c
     common/image.c
     common/player.c
     common/metaserver.c
     x11/xutil.c
     x11/x11.c
     gtk-v2/src/stats.c
     gtk-v2/src/spells.c
     gtk-v2/src/config.c
     gtk-v2/src/keys.c
     gtk-v2/src/map.c
     gtk-v2/src/metaserver.c
     gtk-v2/src/image.c
     gtk-v2/src/opengl.c
     gtk-v2/src/main.c
     gtk-v2/src/info.c
     gtk-v2/src/inventory.c
    Arvid Norlander 2008-06-01

    Some changes to use snprintf instead of sprintf.
     gtk-v2/src/stats.c
     gtk-v2/src/spells.c
     gtk-v2/src/config.c
     gtk-v2/src/keys.c
     gtk-v2/src/sdl.c
     gtk-v2/src/sound.c
     gtk-v2/src/info.c
     gtk-v2/src/pickup.c
     gtk-v2/src/inventory.c
    Arvid Norlander 2008-06-01

    Set svn:eol-style to native on *.c and *.h files that were missing it.
     common/msgtypes.h
     common/script_lua.c
     common/script_lua.h
     common/version.h
    Arvid Norlander 2008-06-01

    Add some missing "extern" keywords that caused warnings. Remove some extern
    variable definitions in source file that were already found in headers.
     gtk/map.c
     gtk/image.c
     common/client.c
     common/client.h
     x11/xutil.c
     gtk-v2/src/image.c
     gtk-v2/src/main.c
     gtk-v2/src/main.h
    Arvid Norlander 2008-06-01

    Run make proto in subdirs. Make sure make doesn't error out on some subdirs
    when running make proto in top directory.
     pixmaps/Makefile.am
     gtk/gtkproto.h
     help/Makefile.am
     utils/Makefile.am
     x11/x11proto.h
     gtk-v2/src/gtk2proto.h
    Arvid Norlander 2008-06-01

    Use the -combine option of gcc to find code (mostly extern inside source instead
    of headers), where the definitions didn't agree with each other. Fix most of them.
    One (hard to fix) is left, I will look at it later. Also use cproto in common/.
    Two sprintf changed to snprintf as well.
     gtk/keys.c
     gtk/gx11.c
     common/proto.h
     x11/x11proto.h
     x11/png.c
     x11/xutil.c
     gtk-v2/src/gtk2proto.h
     gtk-v2/src/keys.c
     gtk-v2/src/info.c
     gtk-v2/src/inventory.c
    Arvid Norlander 2008-06-01

    Some changes to use snprintf instead of sprintf.
     common/item.c
     common/commands.c
     common/script.c
     common/client.c
     common/image.c
     common/p_cmd.c
     common/player.c
     common/script_lua.c
     common/metaserver.c
     common/misc.c
    Arvid Norlander 2008-06-01

    Run a script to clean up trailing whitespaces. In this list below "ChangeLog"
    is listed due to script cleaning up some whitespaces.
     gtk/gx11.c
     ChangeLog
     help/about.h
     help/shelp.h
     common/item-types.h
     common/mapdata.c
     common/metaserver.c
     gtk-v2/src/stats.c
     gtk-v2/src/spells.c
     gtk-v2/src/config.c
     gtk-v2/src/about.c
     gtk-v2/src/keys.c
     gtk-v2/src/map.c
     gtk-v2/src/metaserver.c
     gtk-v2/src/magicmap.c
     gtk-v2/src/image.c
     gtk-v2/src/png.c
     gtk-v2/src/opengl.c
     gtk-v2/src/main.c
     gtk-v2/src/sound.c
     gtk-v2/src/main.h
     gtk-v2/src/menubar.c
     gtk-v2/src/info.c
     gtk-v2/src/pickup.c
     gtk-v2/src/inventory.c
     gtk-v2/glade/README
    Arvid Norlander 2008-06-01

    Reorder some structs to waste less memory, also cosmetic changes to struct
    definitions.
     common/client.h
     gtk-v2/src/image.h
    Arvid Norlander 2008-06-01

    More changes of char* to const char*.
     common/item-types.h
     common/items.pl
     gtk-v2/src/stats.c
     gtk-v2/src/config.c
     gtk-v2/src/image.c
     gtk-v2/src/main.c
    Arvid Norlander 2008-06-01

    Change some char* to const char*. This reduces memory usage when serveral copies
    are running as const data can be shared between the copies.
     gtk/config.c
     gtk/keys.c
     gtk/map.c
     gtk/gx11.c
     gtk/image.c
     gtk/sdl.c
     gtk/text.c
     gtk/png.c
     gtk/sound.c
     common/item.c
     common/commands.c
     common/init.c
     common/script.c
     common/msgtypes.pl
     common/proto.h
     common/client.c
     common/msgtypes.h
     common/image.c
     common/client.h
     common/player.c
     common/newsocket.c
     common/script_lua.c
     common/metaserver.c
     common/misc.c
     gtk-v2/src/stats.c
     gtk-v2/src/spells.c
     gtk-v2/src/config.c
     gtk-v2/src/about.c
     gtk-v2/src/keys.c
     gtk-v2/src/metaserver.c
     gtk-v2/src/map.c
     gtk-v2/src/magicmap.c
     gtk-v2/src/image.c
     gtk-v2/src/sdl.c
     gtk-v2/src/main.c
     gtk-v2/src/opengl.c
     gtk-v2/src/png.c
     gtk-v2/src/sound.c
     gtk-v2/src/menubar.c
     gtk-v2/src/info.c
     gtk-v2/src/pickup.c
     gtk-v2/src/inventory.c
    Arvid Norlander 2008-06-01

    Move configure.in to configure.ac (the new name since a few years). Update
    configure.ac syntax with autoupdate. Make help strings use AS_HELP_STRING.
     common/config.h.in
     aclocal.m4
     configure.ac
    Moved:
     configure.in to configure.ac
    Arvid Norlander 2008-06-01

    Yet more fixes of Makefile.am/aclocal stuff: Make aclocal install needed macros
    into the macros directory.
     Makefile.am
     aclocal.m4
    Added:
     macros/pkg.m4
    Arvid Norlander 2008-06-01

    Fix Makefile.am so aclocal.m4 generation works correctly.
     Makefile.am
     aclocal.m4
    Arvid Norlander 2008-06-01

    Seems like the autotools define for LUA changed, update source to properly
    use LUA.
     common/commands.c
     common/p_cmd.c
     common/script_lua.c
     common/config.h.in
     aclocal.m4
    Arvid Norlander 2008-06-01

    More cleanup of autotools mess. Also update svn:ignore where needed.
    svn:ignore updated:
     .
     pixmaps
     gtk
     help
     common
     utils
     x11
     gtk-v2
     gtk-v2/themes
     gtk-v2/src
     gtk-v2/glade
     sound-src
    Removed:
     utils/mkinstalldirs
     utils/depcomp
     utils/missing
     utils/install-sh
    Arvid Norlander 2008-06-01

    Remove some auto generated autotools files from the tree. Just run autogen.sh
    to create them. This prevents the mess of different developers using different
    versions of autotools, making commits a mess.
     utils/Makefile.in
     utils/config.guess
     utils/config.sub
     x11/Makefile.in
     gtk-v2/Makefile.in
     gtk-v2/themes/Makefile.in
     gtk-v2/src/Makefile.in
     gtk-v2/glade/Makefile.in
     sound-src/Makefile.in
     pixmaps/Makefile.in
     configure
     Makefile.in
     gtk/Makefile.in
     common/Makefile.in
     help/Makefile.in
    Arvid Norlander 2008-06-01

    Fix bug #1871476:] client script 'watch stats' error.
     common/script.c: don't work on initial length, as it'll affect other scripts.
      Make parameters const to avoid issues.
     common/script.h: change function definition.
    Nicolas Weeger 2008-05-09

    Apply patch by Jochen Suckfüll to move recently updated skills to top of list for
    X11 client (could possibly be used for other clients).
     common/client.c client.h commands.c init.c
     x11/x11.c
    Nicolas Weeger 2008-05-07

    configure.in: detect lua 5.0 and 5.x as the build broke on some systems if the
      liblua stuff was loaded.  For 5.0, libm and libdl are added to LUA_LIBS for
      liblualib to be usable.  The summary report for ./configure now reports if
      lua scripting support is included in the build.
    gtk/Makefile.am, gtk-v2/src/Makefile.am, x11/Makefile.am: Add @LUA_LIBS@ into
      the link library list to fix build problems when lua is detected.
    Kevin Bulgrien 2008-04-26

    gtk-v2/src/main.c
    gtk-v2/src/sound.c: Move the signal handler for SIGPIPE in main so that it
    can be used both for sounds and for scripts.
    Raphael Quinet 2008-04-26

    Apply patch #1878451: Let crossfire client compile with OSS4's soundcard.h
    Courtesy anonymous.
     sound-src/cfsndserv.c
    Nicolas Weeger 2008-03-29

    gtk-v2/src/main.c: Change the minimum window size to 640x480 since a window
      layout has been made that shows it is possible.  There seem to be people
      out there that like small...
    Kevin Bulgrien 2008-02-17

    gtk-v2/glade/gtk-v2.glade: Primarily a rename of widgets that had generic
      names (Eg. vbox2 --> vbox_all).  The corestats tab changed to cuddle the
      stat value with the stat name for readability.  Numeric values beside the
      stat bars is now left justified.  Fire/Run indicator positions slightly
      altered.  Presently the window will not shrink smaller than 800x600. This is
      due to the size set in main.c (geometry.min_width and geometry.min_height).
    Kevin Bulgrien 2008-02-17

    gtk-v2/glade/AUTHORS: Update the descriptions of recently modified client
      layout files.
    Kevin Bulgrien 2008-02-12

    gtk-v2/glade/un-deux.glade: This is an aethsetic overhaul, adding viewports
      with insets to set different screen elements off.  Key widgets are moved to
      a common centerline below the map notebook to keep critical information at
      a consistent eye-level to improve visibility during play.  The encumbrance
      and count box is now between the inventory and ground view, and the fire/run
      indicators are just below the command entry box.
    Kevin Bulgrien 2008-02-12

    gtk-v2/glade/v1-redux.glade: Roll in the changes from gtk-v1.glade that make
      the layout more true to the original GTK V1 layout while keeping the tab
      notebook improvement.  The encumbrance display and count box has had a
      slight aesthetic improvement also.
    Kevin Bulgrien 2008-02-12

    gtk-v2/glade/gtk-v1.glade, gtk-v2/glade/gtk-v2.gladep: A major facelift brings
      this client layout much closer to the appearance of the GTK V1 client layout
      with a few exceptions like the XP bar and the Magic Map in the tab notebook.
    Kevin Bulgrien 2008-02-12

    gtk-v2/glade/meflin.glade, gtk-v2/glade/meflin.gladep: Miscellaneous fixes to
      add previously invisible or missing widgets: Run/Fire labels, Count input,
      and encumbrance.
    Kevin Bulgrien 2008-02-12

    gtk-v2/crossfire-client-gtk2.man
    gtk/crossfire-client-gtk.man
    x11/crossfire-client-x11.man: Escape the apostrophe when it starts a line to
      avoid confusing man or nroff ('help -> \'help). Reported by Kari Pahula.
    Raphael Quinet 2008-02-11

    gtk-v2/crossfire-client-gtk2.man: Change more instances of gcfclient to
      crossfire-client-gtk2, and change the title to specify that this client is
      a second-generation GTK client.  Update the client option list, and add or
      remove descriptions to match the client's capabilities.  Some additional
      work may be needed to be sure the information is up to date and accurate,
      but this is a first pass at an update.  Change some capitalization, and
      document the new window position save file conventions.
    gtk-v2/src/main.c: Add some doxygen comments to variable definitions. LOG()
      calls are reformatted to break long lines and convert instances of "gtk::"
      to "main.c::" for consistency with other LOG() messages.  Change the title
      bar of the client from "GTK2 ... Client" to "GTK V2 ... Client" to make it
      a little less likely that people will assume that the 2 means GTK version
      2 (especially since this client may eventually be built with a different
      version of GTK).
    gtk-v2/src/config.c: Reformat LOG() calls to break long lines, and convert all
      instances of "gtk::" to "config.c::" for better consistency with other LOG()
      messages.  Also change all "config.c:" to "config.c::".  Player visible
      change in load_winpos() and save_winpos() changes the window position save
      file from gwinpos2 to a name based on the window layout file name.  For
      example, if the default window layout (gtk-v2.glade) is used, the window
      positions are now saved to gtk-v2.pos.  This allows retention of saved
      window sizes for all window layouts, and has a side benefit of making sure
      that the default window positions are all used the first time a window
      layout is selected.  Providing that the player's screen size is large
      enough, this will tend to reduce difficulty in setting up window positions
      for the first time.
    Kevin Bulgrien 2008-02-10

    Doxyfile: Remove the .xpm files from the list of files to parse as it is
      painfully slow to do so.
    Kevin Bulgrien 2008-02-06

    gtk-v2/src/info.c: Factor out redundancy in draw_info() in both cases of an
      if/else statement.
    Kevin Bulgrien 2008-02-05

    gtk-v2/src/info.c: Prepare to work on this file.  Break long lines; indention
      fixes; commenting changes; addition of new doxygen content. No code changed
      in this commit.
    Kevin Bulgrien 2008-02-05

    common/Makefile.am:  Use hint at http://www.in-ulm.de/~mascheck/various/echo/
      to try to remove a portability issue regarding use of echo -n.
    Kevin Bulgrien 2008-01-29

    gtk-v2/glade: gtk-v1.glade, un-deux.glade: Rename widgets to use a proper name
      instead of the numbered names.
    gtk-v2/glade/v1-redux.glade: Add missing label_cha for Charisma stat.  Rename
      widgets to use a proper name instead of the numbered names.
    gtk-v2/glade: gtk-v1.gladep, v1-redux.glade, un-deux.glade: Edit program_name
      to see if it shows up in the title bar.
    Kevin Bulgrien

    gtk-v2/glade/Makefile.am: Fix non portable usage of foreach, use makes
      built in variable substitution instead.
    MSW 2008-01-27

    gtk-v2/glade/un-deux.glade: Fix missing label_cha for Charisma value to be
      shown.
    gtk-v2/glade/un-deux.glade: The original design did not allow the ground view
      to be expanded optimally, the layout was changed to remove this limitation.
    gtk-v2/glade/AUTHORS: Update the description of the un-deux layout.

    gtk-v2/glade/README: Updated this file with new hints and information.  Some
      spelling fixed.
    gtk-v2/glade/un-deux.glade, gtk-v2/glade/un-deux.gladep: This layout is a
      heavily modified v1-redux that places the critical messages, stat bars,
      protections, and ground view all in horizontally adjustable boxes.  It
      still vaguely reminiscent of the original GTK V1 client, but only slightly
      so.  The message boxes are to the left of the map, and the inventory view is
      to the right.  The command input box is between the tall message pane and
      the short critical message pane, at the bottom left corner of the map.  This
      puts chat messages right next to the command input box.  The window size
      defaults to 1180x925 and comfortably handles a 19x17 map pane.
    gtk-v2/glade/Makefile.am: Add support for un-deux.glade
    gtk-v2/glade/AUTHORS: Describe the un-deux window.
    Kevin Bulgrien

    gtk-v2/glade/lobotomy.glade, gtk-v2/glade/lobotomy.gladep: A slightly variant
      layout that challenges the tradition of those that came before.
    gtk-v2/glade/AUTHORS: Describe the lobotomy layout.
    gtk-v2/glade/Makefile.am: Lobotomize me?
    Kevin Bulgrien

    gtk-v2/glade/gtk-v1.glade, gtk-v2/glade/AUTHORS, gtk-v2/glade/eureka.glade:
      Standardize these layouts at 1180x925 so they easily fit 1280x1024 screens
      and allow for a either a vertical or horizontal menu bar.  Document the
      map pane sizes and overall window sizes for the different layout files.
    Kevin Bulgrien

    gtk-v2/glade/v1-redux.glade, gtk-v2/glade/v1-redux.gladep: Add a new layout
      that revisits the legacy GTK V1 client look, but saves on vertical space by
      using a tab notebook for the character and skill information.
    gtk-v2/glade/eureka.glade, gtk-v2/glade/eureka.gladep: Add a new layout to SVN
      that has just been sitting on my system for ages.
    gtk-v2/glade/AUTHORS: Add and describe the eureka and v1-redux layouts.
    gtk-v2/glade/Makefile.am: Add support for the eureka and v1-redux layouts.
    gtk-v2/glade/README: Remove no longer relevant comment about inability to
      restore screen positions.
    Kevin Bulgrien

    General cleanup with propset svn:ignore && fixup oops due to not quite getting
    how svn:ignore works.
    Kevin Bulgrien

    Packaging update work.
    crossfire-client-spec: An initial attempt to bring the .spec file up to date
      with the libglade/libcurl/pthread requirements and for packaging the theme
      and window layout files.  It has not been tested yet and probably needs
      more work.
    gtk-v2/crossfire-client-gtk2.man: For now, this is really only a slightly
      modified copy of gtk/crossfire-client-gtk.  It needs an update, but then
      so do all the other client man pages.
    gtk-v2/crossfire-client.desktop: An executable file name change.  Really, I
      think this file needs a rename to be correct.
    gtk-v2/Makefile.am: Support for the new crossfire-client-gtk2.man file.
    gtk/crossfire-client-gtk.man: Client name changes for trunk, and a number of
      spelling errors fixed and .crossfire file names fixed like winpos->gwinpos.
    x11/crossfire-client-x11.man: Client name changes for trunk, and a number of
      spelling errors fixed.
    Kevin Bulgrien

    [ 1839894 ] Keybind editor flaw (gtk2, gtkv2) appears fixed by prior commit.
    This is basically a doxygen documentation commit.
    gtk-v2/keys.c: Remove erroneous comment.  Document Key_Entry struct typedef.
      Fix @defgroup syntax.  Fix @todo items with #if 0 in description by quoting
      the hash mark. Line length adjustments and notation consistency fixes for
      LOG() calls.  Other miscellaneous line length adjustments.  Add descriptions
      for more functions.  Enhance one function descriptions.
    Kevin Bulgrien

    This should fix remaining issues in [ 1527973 ] bind command does not work, &
      also is a general doxygen update for keys.c files.
    help/chelp: Add the additional flags supported by the GTK V2 client and a note
      that says each client may not support all flags, and to use bind w/o any
      parameters for client specific help, otherwise there is no verbose help
      for the GTK V2 enhancements, and no explanation for why -g doesn't work.
    gtk/keys.c: doxygen @file added.
    gtk-v2/keys.c: In parse_keybind_line(), A is for all flags, so add KEYF_META
      and KEYF_ALT when it is the flag in a keybinding entry.  Add function
      descriptions for various previously undocumented one, or improve/add detail
      to others.  Various minor reformatting including spacing and line length
      changes.  In bind_key(), remove spurious line break and whitespace from
      bind help text.  Indentation fixes.  In keybinding_get_data() change up
      the logic for use of the checkboxes in the keybinding dialog so that flags
      are set consistently.  The new logic is very intuitive.  KEYF_NORMAL is
      set if none or all of the Run/Fire/Alt/Meta checkboxes are checked.  In
      update_keybinding_list(), "All " is now used to indicate when all of these
      flags are set to differentiate from only the normal flag being set.
    Kevin Bulgrien 2008-01-21

    gtk-v2/src/keys.c: Saved work-in-progress. Long lines shortened. Added doxygen
      modules definition.  More comments converted to doxygen form. Improved the
      style of some previously converted commenting. Reordered some declarations
      to move them with other similar ones.  Started to use column 41 for end-of-
      line comments where reasonable for cleaner read.  Rewrote some function
      comment descriptions.  Added new function and parameter descriptions. Some
      indentation corrections.
    Kevin Bulgrien 2008-01-20

    gtk-v2/src/keys.c: Fix for [ 1875657 ] Bogus keybinding too long errors. Made
      more truncation messages consistent, and fixed an inconsistently formatted
      LOG message. Fixed case and shortened message when keybinds are saved.
    Kevin Bulgrien 2008-01-20

    gtk-v2/glade/dialogs.xml: Change Update Keybindings button to Update Bindings
      for consistency with the Remove Bindings button.
    Kevin Bulgrien 2008-01-19

    gtk-v2/glade/dialogs.xml: Dress up the dialog for the libglade client by
      adding some padding in various places.  Fixed some spelling and reworked
      various texts on the dialogs.
    Kevin Bulgrien 2008-01-19

    Per-character keybind support.
    gtk-v2/src/keys.c: In save_keys() and keys_init(), a pointless #ifdef WIN32
      was used to attempt to implement per-character keybind files but keys_init()
      is called long before a player can log in, so this had the effect of writing
      keybinds to a file that cannot be loaded.  Oddly, this was under a #ifdef
      WIN32 which is quite inappropriate as if supported, it should be for all
      platforms.  The support is commented out with #if 0 until it can be fixed
      and then re-enabled for all clients. Meanwhile, it surely fixes a WIN32 bug.
    General doxygen update:
    gtk/sound.c: Convert function description comments to doxygen form.
    common/client.h: Convert comments to doxygen form.
    x11/sound.c: Add doxygen file header.
    Makefile.am: Add target dox to generate doxygen files and output errors to
      doxygen.err
    gtk-v2/src/stats.c: Add doxygen file header.  Convert function description
      comments to doxygen form.  Fix missing doxygen @param for update_stat().
      Add stubs for missing function descriptions.
    gtk-v2/src/spells.c: Add doxygen file header.  Convert comments to doxygen
      form.  Convert function description comments to doxygen form.
    gtk-v2/src/about.c: Whitespace only.
    gtk-v2/src/keys.c: Convert comments to doxygen form.  Convert function
      description comments to doxygen form.  Define groups for the functions in
      this file.  In parse_keybind_line, add a parameter description.  In
      init_default_keybindings, add to the function description.
    gtk-v2/src/image.c: Minor reformatting.  In image_update_download_status()
      description, remove erroneous @param items.
    gtk-v2/src/sdl.c: Add doxygen file header.  Convert comments to doxygen form.
      Convert function description comments to doxygen form.  Add stubs for missing
      function descriptions.  Move some defines from between a function description
      and the function code to above the description to help out doxygen.
    gtk-v2/src/png.c: Add doxygen file header.  Convert comments to doxygen form.
      Add stubs for missing function descriptions.  Move some defines from between
      a function description and the function code to above the description to help
      out doxygen.
    gtk-v2/src/sound.c: Rework the doxygen file header.
    Kevin Bulgrien 2008-01-19

    Undo unintentional change from prior commit.
    gtk-v2/glade/caelestis.glade
    Kevin Bulgrien 2008-01-18

    Fix: [ 1806282 ] Libglade client screen position saving faulty
    The root window "visible" property must be set to "no" in order for saved
    screen size settings to be restored when the application starts up.
    gtk-v2/glade/*.glade
    gtk-v2/glade/README
    Kevin Bulgrien 2008-01-18

    Fix for bug [ 1810609 ] menu items don't work if metaserver is bypassed -
    move call to enable_menu_items() into main.c, and call it even if we
    are doing direct connection (-server option).
    gtk-v2/src/metaserver.c: Remove call to enable_menu_items()
    gtk-v2/src/main.c: Add calls to enable_menu_items()
    MSW 2008-01-15

    Various bugfixes mostly:
    common/client.c: If servername is (null), don't both trying to connect - this
      happens when the NULL value is saved out on some systems.
    common/client.h: Update VERSION_SC to 1029
    common/metaserver.c: Add more code since this client (at version_sc 1029) can
      still play on 1027 and 1028 servers.
    gtk-v2/src/stats.c: Fix stat bar handling for exp - it now shows a progression
      relative to currently level (so the instance you gain a new level, stat
      bar goes back to zero) - this is more how things are expected to work.
      Also, handle weapon_speed properly based on sc_version.
    gtk-v2/src/gtk2proto.h: Rebuilt
    MSW 2008-01-15

    common/image.c, README: Rename client '.crossfire/crossfire-images/' to
      '.crossfire/image-cache/' to make backups avoid backing it up with a
      generic exclude like "*/*cache*/*" that works for many other packages
      that employ caching.
    Kevin Bulgrien 2008-01-04

    Win32 compilation fixes. Remove superflous includes messing everything.
    (merge from 1.x)
     common/client.c commands.c item.c metaserver.c newsocket.c p_cmd.c player.c script.c
     gtk/win32/config.h porting.c
    Nicolas Weeger 2008-01-03

    Fix smoothing code so it take into account smoothing on layers >0 if there is something drawn at lower layers.
    gtk-v2/src/map.c
    gtk-v2/src/sdl.c
    gtk-v2/src/opengl.c
    Tchize 2007-12-24

    Fix for bug #1825653: Odd number problem with nrof.
     common/item.c: nrof is unsigned int32.
    Nicolas Weeger 2007-12-01

    gtk/text.c: Add missing write_media() calls in handling of admin messages.
       Results in news and rules not being displayed.  Fixes bug 1657000
    MSW 2007-10-03

    gtk-v2/src/info.c
      - Change error message when the client gets a message with a [] text format
        tag that is not valid to make it more obvious what is wrong.  This can
        help determine the error faster if the server inadvertently sends the
        client a message with displayed text that has square brackets around it.
    Kevin Bulgrien 2007-09-30

    Fix for bug 1800702  - gdk_draw_drawable: assertion `src != NULL' failed.
    gtk/gx11.c:  Call sdl_gen_map() or gtk_draw_map() based on displaymode in use.
    gtk-v2/src/main.c: Call draw_map() instead of gtk_draw_map().  draw_map()
      will figure out what function (sdl, opengl, gtk) to call do actually
      draw the map.
    MSW 2007-09-25

    gtk-v2/src/info.c
    gtk-v2/src/inventory.c
    gtk-v2/src/keys.c
    gtk-v2/src/magicmap.c
    gtk-v2/src/main.c
    gtk-v2/src/menubar.c
    gtk-v2/src/metaserver.c
    gtk-v2/src/opengl.c
    gtk-v2/src/pickup.c
      - Spelling/grammar fixes.
      - Doxygen commenting work.
      - Some indentation adjustments.
      - Reformat block comments to use 79 columns.
      - else block structures changed to comply with project coding standards.
    Kevin Bulgrien 2007-09-25

    gtk-v2/src/about.c
      - Doxygen commenting work.
    gtk-v2/src/config.c
    gtk-v2/src/image.c
      - Spelling/grammar fixes.
      - Doxygen commenting work.
      - Some indentation adjustments.
      - Reformat block comments to use 79 columns.
    Kevin Bulgrien 2007-09-24

    gtk/text.c: Remove call to void_callback() for MSG_TYPE_MONUMENT - if there
      is no code to handle it, no reason to set the callback.  Fixes bug 1759860 -
      gravestone messages go to stdout and not client window.
    MSW 2007-09-23

    gtk-v2/src/map.c
      - Doxygen commenting work.
      - Spelling fix visable --> visible.
      - Reformat block comments to use 79 columns.
    Kevin Bulgrien 2007-09-23

    gtk-v2/src/metaserver.c: Modify metaserver_connect_to so it can connect to
      servers running on different ports (eg, localhost:13328).  Gtk1 client
      already handles this fine, so this is only a change for the gtk2 client.
    MSW 2007-09-16

    gtk-v2/src/stats.c
    gtk-v2/src/spells.c
    gtk-v2/src/keys.c
    gtk-v2/src/map.c
    gtk-v2/src/metaserver.c
    gtk-v2/src/magicmap.c
    gtk-v2/src/image.c
    gtk-v2/src/sdl.c
    gtk-v2/src/opengl.c
    gtk-v2/src/png.c
    gtk-v2/src/sound.c
    gtk-v2/src/main.h
    gtk-v2/src/info.c
    gtk-v2/src/pickup.c
      - Tabs --> spaces.
    gtk-v2/src/config.c
    gtk-v2/src/inventory.c
      - Tabs --> spaces.
      - End-of-line whitespace removed.
    Kevin Bulgrien 2007-09-16

    gtk-v2/src/map.c
    gtk-v2/src/main.c
      - Fix for SourceForge Bugs Tracker #1794455 Libglade client Magic Map:
        cannot return to Map.  During the libglade conversion, and incorrect
        g_signal_connect() call was placed in map.c.  The corrected connection
        is now made in main.c where the magic_map pointer is initialized.
    gtk-v2/glade/README
      - Add a note for glade file developers concerning the MAGIC_MAP_PAGE
        define that constrains the tab on which magic maps must appear.
    Kevin Bulgrien 2007-09-14

    Improve metaserver handling some - in particular, if server is listed
    on both metaserver 1 & 2, listed it only once.  Also, for gtk2 client,
    fix handling of not showing cached entries if they are listed on the
    metaserver.  Add filtering of protocol versions, so we only show player
    compatible servers.
    --
    common/metaserver.c: Add check_server_version() to do version checking.
      Add checks to find duplicate server entries.
    gtk-v2/src/metaserver.c: Move retrieval of data from metaserver before
      adding cached entries to table - otherwise, can not detect duplicates.
      Add check to proper version information.
    MSW 2007-09-13

    common/client.h
    - Add doxygen file header.
    gtk-v2/src/gtk2proto.h
    gtk-v2/src/main.c
    gtk-v2/src/metaserver.c
    - Remove unused return value for get_metaserver().
    gtk-v2/src/metaserver.c
    - Doxygen commenting, and add comment headers for all functions.
    - Remove commented-out IP Address column formerly shown in metaserver dialog.
    Kevin Bulgrien 2007-09-05

    gtk-v2/src/menubar.c
      - Doxygenification of source/comments.
    Kevin Bulgrien 2007-09-04

    gtk-v2/src/about.c
    gtk-v2/src/image.h
    gtk-v2/src/sound.c
    gtk-v2/src/main.h
      - Doxygenification of comments and files.
    Kevin Bulgrien 2007-09-03

    gtk-v2/glade/AUTHORS
      - Adjust some glade file descriptions.
    gtk-v2/glade/oroboros.glade
      - Reorder character data tabs.
    Kevin Bulgrien 2007-09-03

    gtk-v2/glade/AUTHORS
      - Add oroboros.glade and add short paragraph descriptions of each of the new
        layout files.
    gtk-v2/glade/Makefile.am
    gtk-v2/glade/Makefile.in
    gtk-v2/glade/oroboros.glade
    gtk-v2/glade/oroboros.gladep
      - A layout designed expressly for clients running with 1024x768 resolution.
    Doxyfile
      - Copied from server; modified and added for client.
    prop svn:ignore
      - Add autom4te
    gtk-v2/src/main.c
      - Tabs --> spaces, commenting, and doxygenation. No functional code changes.
    Kevin Bulgrien 2007-09-03

    configure
    configure.in
      - Tabs --> spaces, indenting uniformity, and typo corrections only.
    Kevin Bulgrien 2007-09-02

    aclocal.m4
    configure
    Makefile.in
    common/Makefile.in
    gtk/Makefile.in
    gtk-v2/Makefile.in
    gtk-v2/themes/Makefile.in
    gtk-v2/src/Makefile.in
    gtk-v2/glade/Makefile.in
    help/Makefile.in
    pixmaps/Makefile.in
    sound-src/Makefile.in
    utils/Makefile.in
    x11/Makefile.in
      - Result of new and fixed m4 files.
    autogen.sh
      - Point aclocal at macros so that undefined macros do not crash ./configure
    macros/gtk.m4
    macros/sdl.m4
      - ./configure should never crash, so add to remove errors as follows:
        aclocal:configure.in:?: warning: macro `AM_PATH_GTK' not found in library
        ./configure: line ?: syntax error near unexpected token `1.0.0'
        ./configure: line ?: `             AM_PATH_GTK(1.0.0)'
        aclocal:configure.in:?: warning: macro `AM_PATH_SDL' not found in library
        ./configure: line ?: syntax error near unexpected token `1.1.3'
        ./configure: line ?: `  AM_PATH_SDL(1.1.3)'
    macros/curses.m4
    macros/gnome-print-check.m4
    macros/gnome-gettext.m4
    macros/linger.m4
    macros/need-declaration.m4
      - Update .m4 files from a newer glade package to remove many warnings like
        the following:
        macros/linger.m4:4: warning: underquoted definition of AC_STRUCT_LINGER
    Kevin Bulgrien 2007-09-02

    gtk-v2/src/main.c
      - Add error_dialog() to notify the user via a graphical dialog that a Glade
        layout file failed to open.  The dialog displayed the client version
        information, a brief error description, and the file that failed to load.
    Kevin Bulgrien 2007-09-02

    gtk-v2/glade/AUTHORS
      - Add attribution for caelestis.glade project files.
    Kevin Bulgrien 2007-09-01

    ChangeLog
      - Summarize gtk-v2-libglade branch merge to trunk.
    Kevin Bulgrien 2007-09-01

    This is a merge of client/branches/gtk-v2-libglade to trunk.  It converts the
    GTK-V2 client to a libglade-2.0 client that supports changing the UI layout
    with glade-2 generated .glade XML files.  Various alternate client layouts
    are included.
    AUTHORS
      - Reformatted for aesthetics.
      - Added libglade-2.0 conversion author.
    common/init.c
      - Typo corrected in LOG message (inic.c --> init.c).
    configure
      - LIBGLADE_CFLAGS/LIBS addition.
      - gtkv2 checks converted to HAVE_GTK2.
      - gtk-v2/glade directory addition now supported.
      - V2 client now depends on libglade2.0 instead of GTK+ 2.0.
      - Some reformatting resulting from autoconf/automake changes flowing down.
    configure.in
      - gtk-v2/glade directory addition now supported.
      - Update indenting; tab->space conversion for readability.
      - Minor message updates for consistency like GTK2 -> GTK+ 2.0.
      - V2 client dependency checks changed to require libglade-2.0 vs. gtk+-2.0.
    gtk-v2/glade
    gtk-v2/glade/Makefile
    gtk-v2/glade/Makefile.am
    gtk-v2/glade/Makefile.in
      - A fully autoconf/automake supported directory to be used for the control
        of glade-2 layouts compatible with this client.
    gtk-v2/glade/AUTHORS
      - A file to attribute the authors of the glade-2 XML layout projects in this
        directory.
    gtk-v2/glade/README
      - A help file for prospective glade-2 XML layout creation that describes how
        to create a new layout and workarounds for various issues that may arise.
    gtk-v2/glade/caelestis.glade
    gtk-v2/glade/caelestis.gladep
    gtk-v2/glade/chthonic.glade
    gtk-v2/glade/chthonic.gladep
    gtk-v2/glade/gtk-v1.glade
    gtk-v2/glade/gtk-v1.gladep
    gtk-v2/glade/meflin.glade
    gtk-v2/glade/meflin.gladep
      - New layout files for the V2 client.  make install places the .glade files
        in the crossfire-client data directory, where they are detected by the
        client in order to allow a user to select a new layout from the
        configuration popup dialog.
    gtk-v2/glade/dialogs.glade
    gtk-v2/glade/dialogs.gladep
      - This glade-2 XML layout project contains pop-up dialogs formerly contained
        in the ../gtk-v2.glade files.  It was created to reduce the overhead in
        setting up a new main window layout.  The client allows a user to specify
        a new file at the command-line, but does not attempt to support in-client
        selection of an alternate file.
      - Various modification to the original pop-up dialogs have been made to
        support the libglade-2.0 conversion.  The generated code allowed the XML
        file to have variations in it that cause problems for libglade.
      - Minor alterations have been mode to appearance and/or text on various
        dialogs.
    gtk-v2/glade/gtk-v2.glade
    gtk-v2/glade/gtk-v2.gladep
    gtk-v2/gtk-v2.glade
    gtk-v2/gtk-v2.gladep
      - Moved to gtk-v2/glade sub-directory.
      - This is the original gtk-v2 client layout by mwedel.
      - All popup dialogs have moved into gtk-v2/glade/dialogs.glade.
    gtk-v2/Makefile.am
    gtk-v2/Makefile.in
      - LIBGLADE_CFLAGS/LIBS addition
      - gtk-v2/glade directory addition now supported.
      - DIST_COMMON modifications by autoconf/automake to remove files not under
        SVN control.
      - Remove gtk-v2/gtk-v2.glade and gtk-v2/gtk-v2.gladep from EXTRA_DIST as they
        are now located in the gtk-v2/glade subdirectory.
    gtk-v2/README-dev
      - Reformat for aesthetics and readability.
      - Various updates to content based upon IRC or mailing list discussions.
      - Rework content to third-party point-of-view to make it easier for other
        developers to modify the document.
    gtk-v2/src
      - Inexplicable property changes to svn:ignore simply reposition .deps entry.
    gtk-v2/src/about.c
    gtk-v2/src/inventory.c
    gtk-v2/src/keys.c
    gtk-v2/src/map.c
    gtk-v2/src/metaserver.c
    gtk-v2/src/spells.c
      - Include glade.h
      - Remove includes of glade-2 generated source files.
      - Conversion to libglade-2.0 requires use of glade_get_widget_tree() and
        change from lookup_widget() to glade_xml_get_widget() and insertion of
        g_signal_connect() to replace functionality previously found in glade-2
        generated source files.
    gtk-v2/src/config.c
      - Include glade.h
      - Various code comment improvements.
      - Remove includes of glade-2 generated source files.
      - All functions without a comment header now have one.
      - Significant code comment reformatting to use of a 79 character line width
        and to reduce line lengths over 80 characters.
      - Add static char pointers themedir and gladedir to better support loading
        combo box widgets from the crossfire-client data directory, and to reduce
        the number of redundant hard-coded strings.
      - The configuration popup dialog now supports in-client selection of an XML
        layout file to redefine the root window appearance.  Modified functions
        include load_defaults(), save_defaults(), setup_config_window(), and
        read_config_window().  New functions are scandir_glade_filter,
        fill_combobox_from_datadir() which is derived from code factored out of
        setup_config_window() so it can be used multiple times.  Modifications to
        save_winpos() and load_window_positions() alters screen position saving to
        remove hard-coded copy/pasted code and more flexibly support multiple XML
        UI layout files.
      - Conversion to libglade-2.0 requires use of glade_get_widget_tree() and
        change from lookup_widget() to glade_xml_get_widget() and insertion of
        g_signal_connect() to replace functionality previously found in glade-2
        generated source files.
      - scandir_filter() renamed to scandir_theme_filter() for more consistent
        naming for multiple scandir filter functions now required since the window
        layout combo box also requires on.
    gtk-v2/src/image.c
    gtk-v2/src/opengl.c
    gtk-v2/src/sdl.c
      - Include glade.h
    gtk-v2/src/info.c
    gtk-v2/src/pickup.c
    gtk-v2/src/stats.c
      - Include glade.h
      - Remove includes of glade-2 generated source files.
      - Conversion to libglade-2.0 requires use of glade_get_widget_tree() and
        change from lookup_widget() to glade_xml_get_widget().
    gtk-v2/src/interface.c
    gtk-v2/src/interface.h
    gtk-v2/src/callbacks.h
    gtk-v2/src/support.c
    gtk-v2/src/support.h
      - Remove glade-2 generated source files.
    gtk-v2/src/magicmap.c
      - Include glade.h
      - Remove includes of glade-2 generated source files.
    gtk-v2/src/main.c
    gtk-v2/src/main.h
      - Include glade.h
      - General changes to support the conversion to libglade-2.0 require runtime
        processing of the glade-2 XML layout file names and locations.
      - Add support for command-line specification of glade-2 generated XML files
        that describe the UI windows and pop-up dialogs.
      - Conversion to libglade-2.0 requires use of glade_get_widget_tree() and
        change from lookup_widget() to glade_xml_get_widget() and insertion of
        g_signal_connect() to replace functionality previously found in glade-2
        generated source files.
    gtk-v2/src/Makefile.am
    gtk-v2/src/Makefile.in
      - LIBGLADE_CFLAGS/LIBS addition.
      - Replace GTK2_CFLAGS/LIBS with LIBGLADE_CFLAGS/LIBS.
      - Changes resulting from removal of glade-2 generated source files.
    gtk-v2/src/menubar.c
      - Include glade.h
      - Remove includes of glade-2 generated source files.
      - Include image.h and gtk2proto.h as support the libglade-2.0 conversion.
      - Conversion to libglade-2.0 requires use of glade_get_widget_tree() and
        change from lookup_widget() to glade_xml_get_widget() and insertion of
        g_signal_connect() to replace functionality previously found in glade-2
        generated source files.
    gtk-v2/TODO
      - Reformat for aesthetics and readability.
      - Add todo for non-functional scroll bar handles on the map display.
      - Adjust todo for lower screen resolution support since the libglade-2.0 port
        at least partially addresses usability on smaller desktops.
    help/about.h
      - EOL whitespace removed.
      - Minor reformat for aesthetics.
      - Added libglade-2.0 conversion author.
    Makefile.in
    common/Makefile.in
    gtk/Makefile.in
    gtk/themes/Makefile.in
    help/Makefile.in
    pixmaps/Makefile.in
    sound-src/Makefile.in
      - LIBGLADE_CFLAGS/LIBS addition
    x11/Makefile.in
      - LIBGLADE_CFLAGS/LIBS addition
      - DIST_COMMON modifications by autoconf/automake to remove files not under
        SVN control.
    Kevin Bulgrien 2007-09-01

    common/metaserver.c: Update to use official and not test metaserver2 location.
    MSW 2007-08-31

    Fix map not updated at tick causing items to appear non animated.
     gtk/gx11.c
     gtk-v2/src/main.c
    Nicolas Weeger 2007-08-15

    Partial fix for bug #1772759: Too much alchemy causes client crash.
     common/item.c: find item in container too.
    Nicolas Weeger 2007-08-15

    Make metaserver1 gather it's data in its own thread.
    common/metaserver.c: Add ms1_is_running flag, re-work some of the metaserver1
      logic so the function structure makes it easy to spawn the thread,
      rename metaserver2_check_status() to just metaserver_check_status()
    gtk-v2/src/metaserver.c: Change call to metaserver_check_status(), resort
      data after getting all info from sever.
    SMW 2007-08-14

    gtk-v2/src/metaserver.c: Add missing pthread_mutex_unlock() - resulted in
      client hanging after disconnecting from server.
    MSW 2007-08-14

    Add support for metaserver2 in client.  For the X11/C clients, they use basic
    interface (drawn in text window, select a number), so no changes to the GUI
    portions of those clients was done - gtk2 uses window, so some extra work
    there.
    --
    acinclude.m4: New file - added for LIBCURL_CHECK_CONFIG macro support.
    aclocal.m4: Rebuilt
    configure: Add --disable-metaserver2 option, check for Curl, pthread.  Make
      sure user either has curl installed or has used --disable-metaserver2
    configure, */Makefile.in:  Rebuilt with Curl support
    common/cconfig.h: Add note about METASERVER2 (controlled via configure)
    common/client.c: Add metaserver2 global
    common/client.h: Add metaserver2 global
    common/config.h.in: Rebuilt by autoheader.
    common/init.c: Add call to init_metaserver()
    common/metaserver.c: Support for metaserver2.  More fields in Meta_Info.
      Re-arrange file a little so logical functions are together.
    common/metaserver.h: New fields in Meta_Info, some renamed to keep
      it consistent accross all of metaserver2.
    common/proto.h: rebuilt
    gtk-v2/src/metaserver.c: Add support for threaded metaserver2 retrievals -
      need to make sure data is accessed in thread safe way, also need to
      add check for status of retrieval thread.
    MSW 2007-08-08

    Fix bug #1735271: Version numbers of client and server do not match.
     common/client.h: make S->C version 1028 for coherence with server.
    Nicolas Weeger 2007-08-05

    gtk-v2/src/stats.c
    - Applied patch by "Olivier Huet" <huet.o@free.fr> to fix experience label and
      progress bar for high levels (int -> sint64, %d -> %"FMT64").
      Kevin R. Bulgrien 2007-07-24

    gtk-v2/gtk-v2.glade
    gtk-v2/src/interface.c
      - Minor rework of prompt texts.
      - Add Escape key accelerator for the Quit button.
      - Add tooltip to the Quit button to tell a user about the accelerator.
      - Cosmetic improvement to the metaserver dialog done by adding padding or
        border width to some widgets so there is spacing between them.
    gtk-v2/src/metaserver.c
      - Make more room for "Server Comments" by removing the redundant "IP Addr"
        field, renaming "Last Update (Sec)" to "Updated (Sec)", and renaming
        "# Players" to "Players".
    gtk-v2/src/callbacks.h
      - Glade generated changes.
    Kevin R. Bulgrien 2007-07-22

    gtk-v2/src/inventory.c: Adjust GTK2 client setup_list_columns() so "Weight"
    column titles are no longer truncated (on some systems).
    Kevin R. Bulgrien 2007-07-22

    gtk/gx11.c: fix memory leak.
    Nicolas Weeger 2007-07-11

    gtk-v2/src/inventory.c: Add support for client side animation of look window.
    MSW 2007-07-09

    Fix various GAIM/GTK links.
     gtk/win32/gtkclient.nsi Running.txt
    Nicolas Weeger 2007-07-05

    utils/mdk.sh: Make script work again.
    Andreas Kirschbaum 2007-06-27

    Remove Gnome client, which is not built anyway.
    Deleted:
     gnome
    Modified:
     aclocal.m4 configure configure.in
    Nicolas Weeger 2007-06-18

    Trash obsolete junk.
     common/client.c image.c item.c misc.c p_cmd.c proto.h
    Nicolas Weeger 2007-06-18

    Remove 'map1cmd' variable which is always 1.
     common/client.c client.h commands.c
     gnome/map.c
    Nicolas Weeger 2007-06-18

    Remove map1cmd, face, face1, item1 and some obsolete stuff.
     common/client.c commands.c image.c mapdata.c mapdata.h proto.h
    Nicolas Weeger 2007-06-18

    common/p_cmd.c: remove 'resist' command, duplicates server-side 'resistances' giving more info.
    Nicolas Weeger 2007-06-18

    configure.in: Add another eval $ndatadir line so properly resolve all
    the shell variable names so that CF_DATADIR is set properly in common/config.h
    --
    MSW 2007-06-11

    gtk-v2/src/inventory.c: Add tooltips to the inventory tabs, to make it
    clearer what the different tabs do.
    --
    MSW 2007-06-11

    Add pick up menu updating support for gtk2 client - when you log in, it
    will get your character pickup mode and update the check boxes accordingly.
    ---
    gtk-v2/gtk-v2.glade: Change "don't_pickup1" widget name to "do_not_pickup"
    gtk-v2/src/interface.c: Rebuilt
    gtk-v2/src/main.c: Remove empty client_pickup() function, add pickup_init()
    gtk-v2/src/pickup.c: Bunch of new code to support pickup updating - mostly
      a mapping from menu items to pickup modes, since glade doesn't let us
      store those attributes in the menu item.
    MSW 2007-06-11

    Remove obsolete mapredraw command (empty on server-side).
     common/p_cmd.c
     gnome/map.c
     gtk/config.c map.c
     gtk-v2/src/config.c map.c
     x11/xutil.c
    Nicolas Weeger 2007-06-02

    Apply patch #1720388: data len in client.c is calculated wrong
     courtesy Jürgen Kahnert.
    common/client.c
    Nicolas Weeger 2007-05-16

    gtk/text.c: fix callback that was eating a word.
    Nicolas Weeger 2007-05-03

    Change the version string from 1.9.1 to 2.0-dev for trunk.
    Alex Schultz 2007-04-28

    Implement feature request #1560389: improve inscription logic.
     gtk/gx11.c inventory.c
     common/client.c client.h commands.c item.c item.h proto.h
    Nicolas Weeger 2007-04-23

    Fix memory overrun errors.
    ---
    gtk/gx11.c: Allocate enough space in pickup_menus/value to store all
       allocated entries.
    gtk-v2/src/stats.c: Allocate enough skill boxes to store MAX_SKILL skills.
    gtk-v2/src/info.c: Allocate enough memory in info_pane[] to not cause memory
       overruns.
    gtk-v2/src/config.c: Allocate enough memory to not cause memory overrun when
       loading gtk rc files.
    Andreas Kirschbaum 2007-04-23

    autogen.sh: Add script to rebuild autoconf files.
    configure, aclocal.m4, */Makefile.in: Rebuilt.
    common/Makefile.am: Rewrite commands to build svnversion.h to not generate an
       error message the first time they are run.
    configure.in: Remove duplicate use of AC_CONFIG_SRCDIR.
    configure.in: Add template comments to AC_DEFINEs. Now autoheader and
       ./configure --enable-maintainer-mode does work again.
    ---
    Andreas Kirschbaum 2007-04-16

    Use #include <config.h> instead #include "config.h" to support multiple
    configurations outside the source directory.
    ---
    Andreas Kirschbaum 2007-04-16

    Rename DATADIR to CF_DATADIR to avoid name clashes when cross-compiling to
    Win32.
    ---
    gtk/win32/config.h, configure.in, common/image.c, common/config.h.in,
    gnome/gnome.c, gnome/gnome-sound.c, gtk-v2/src/config.c: Replace DATADIR by
       CF_DATADIR.
    Andreas Kirschbaum 2007-04-16

    Add theme support to the gtk2 client spell window.
    gtk-v2/gtk-v2.glade: Remove the drawingarea boxes, add eventboxes and put
      the labels in the eventbox - the labels now act as key, as it is easier
      to do all of foreground, background, and font style there.
    gtk-v2/src/config.c: Add calls to set spell styles and redraw spell window
    gtk-v2/src/interface.c: Rebuilt
    gtk-v2/src/inventory.c: Declare Style_Names static, since it is a generic
       name and spells.c uses same name.  Linewrap a long line.
    gtk-v2/src/spells.c: Add theme handling - load up theme data, set entries
      in the treeview widget, update code to draw keys.
    gtk-v2/themes/Black, gtk-v2/themes/Standard: Add style information for the
      spells.
    MSW 2007-02-25

    configure, configure.in:  Fix broken check for liblua - not all systems have
    liblualib, so assuming they do if liblua exists breaks compilation.  And
    separate check for lualib.
    MSW 2007-02-25

    Fix missing liblua when linking.
    configure,configure.in: rebuilt
    */Makefile.am, */Makefile.in: rebuilt
    Ryo 2007-02-23

    Remove hard dependancy of LUA - instead, have configure check for it and
    just don't compile in the LUA bits if we don't have lua installed.
    --
    configure,configure.in: Add lua checks.
    */Makefile.am, */Makefile.in: Remove hard coded links of -llua
    common/config.h.in: Add HAVE_LIBLUA define
    common/commands.c, common/p_cmd.c, common/script_lua.c: Add #ifdef
         HAVE_LIBLUA checks
    MSW 2007-02-20

    Implement feature request 1025952: GTK Client - Save Pickup options.
    New external command, 'client_pickup(uint32 pickup)', which is called
    when player logged in.
     common/client.c commands.c external.h proto.h
     gtk/gx11.c
     gtk-v2/src/gtk2proto.h main.c
     x11/xutil.c
    Ryo 2007-02-18

    Apply patch #1560052: LUA client-side support. New commands: lua_list,
    lua_load, lua_kill.
     pixmaps/Makefile.in
     configure
     gtk/Makefile.am Makefile.in
     common/commands.c Makefile.am Makefile.in proto.h p_cmd.c Makefile.am
     help/Makefile.in
     utils/Makefile.in
     x11/Makefile.am Makefile.in
     gtk-v2/Makefile.in
     gtk-v2/src/Makefile.am Makefile.in
     sound-src/Makefile.in
    Ryo 2007-02-10

    gtk-v2/gtk-v2.glade: Apply patch 1636013 - standardize on underscored
       widget names.  Patch by Veli-Matti Valtonen - maligor.
    MSW 2007-02-06

    Add support for different themes in the gtk2 client.  A lot of compiled
    in defaults have also moved to the the theme file.
    ---
    INSTALL: Added file - wanted by automake.
    README: Move install directions to INSTALL file.
    configure.in, configure: Add gtk-v2/themes/Makefile to list of Makefiles.
    common/Makefile.in, common/Makefile.am:  Add rule to make msgtypes.h file.
    common/client.h: Add Msg_Type_Names file, used by msgtypes.h file.
    common/msgtypes.h: File that holds names for the message type/subtype
       values.
    common/msgtypes.pl: Script to make msgtypes.h file - basically parses
       newclient.h, pulling out the MSG_ structures.
    common/newclient.h: Update to match server version.
    gtk-v2/Makefile.am, gtk-v2/Makefile.in: Add themes to list of subdirectories.
    gtk-v2/gtk-v2.glade: Add theme selection to config window.
    gtk-v2/src/config.c: Add support for loading/saving theme to gdefaults2 file.
       Add support for getting theme from config window, and changing appearance
       without need for restart.
    gtk-v2/src/gtk2proto.h: rebuilt for theme related functions.
    gtk-v2/src/info.c: Remove hard coded font values.  Add code to load
       color, font, and msg type/subtype from theme file.  Remove
       a lot of the hardcoding for having 2 textviews - removes a lot
       of redundant code.  Change processing for adding messages to
       to text buffers - don't create a new text tag - use the various
       textags we have that match.
    gtk-v2/src/interface.c: Rebuilt with theme selection for config window.
    gtk-v2/src/inventory.c: Remove hard coded values for color on
       inventory status.  Add ability to specify more than just background
       color for different status - can now also change font & foreground
       color.  Add code to load up style information.  Change processing
       for getting row style.  Update code that adds entries to the rows.
    gtk-v2/src/main.c: Ad usercolorname global array that provides a name
       to color number mapping to be used in theme files.  Add code to
       load up user theme.
    gtk-v2/src/stats.c: Add support for parsing theme data.  Remove hard coded
       color values for the stat bars.  Removed hard coded value on number
       of stat bars in lots of places.
    gtk-v2/themes:  New directory to hold the theme files.
    ---
    MSW 2007-02-04

    Fix for bug #1538948: Assertion failure for map2 command.
    Add checks for x,y and layer validity in the Map2Cmd.
    Note that invalid values are not discarded, but clipped to valid ones.
     common/commands.c: add checks.
     common/mapdata.[ch]: move #define to header for access outside .c.
    Ryo 2007-01-07

    Improve command completion: display matching commands.
     common/p_cmd.c
    Fix bug with autocompletion: don't change focus, don't select text.
     gtk/gx11.c keys.c
    Ryo 2007-01-01

    Merge patch #1558073: newpickup flesh courtesy bencha
     gtk/gx11.c
     gtk-v2/gtk-v2.glade
     gtk-v2/src/callbacks.h gtk2proto.h interface.c pickup.c
    Ryo 2006-11-29

    common/Makefile.am: Change svnversion.h generation to not update the file
       unless it needs updating.
    Alex Schultz 2006-11-09

    Fix problem in display logic when the size of the image was not a multiple
    of the map_image_size.  This shows up when using tall character images.
    It also shows up when using different -mapscale options due to rounding
    errors - in both cases now, things are drawn correctly.
    --
    gtk/map.c: Add size parameters to draw_pixmap().  Add logic to figure out
      proper offsets for drawing odd sized images.
    gtk/sdl.c: Add logic to figure out proper offsets for drawing these odd
      sized images.
    gtk-v2/src/map.c: Add size parameters to draw_pixmap().  Add logic to figure
      out proper offsets for drawing odd sized images.
    gtk-v2/src/sdl.c: Add logic to figure out proper offsets for drawing these
      odd sized images.
    MSW 2006-11-05

    gtk/image.c: Fix bug that results in SDL mode not working if map_scale and
      icon_scale are the same - can't use GDK pixmaps for SDL drawing.
    MSW 2006-11-05

    Fix bug 1559804 - unable to drop items from inventory into open container
    on the ground.
    gtk-v2/src/inventory.c: Add check to see if container is on the ground in
      addition to being in the player inventory as a valid drop target.
    MSW 2006-11-03

    Add ability for client to get exp table from server.  Add exp progressbar
    to GTK2 client.
    --
    common/client.c: Add declarations for exp_table, exp_table_max, and call to
      send 'requestinfo exp_table' to server.
    common/client.h: Add extern declarations for exp_table, exp_table_max
    common/commands.c: Add get_exp_info() function to get exp table from
      server in replyinfo command.  Fix crash bug in ReplyInfoCmd() if replyinfo
      with no parameters is sent to client.
    common/init.c: Add code to clear/initialize exp_table, exp_table_max
    gtk-v2/gtk-v2.glade: Add exp progessbar widget.
    gtk-v2/src/gtk2proto.h: rebuilt
    gtk-v2/src/interface.c: Rebuilt
    gtk-v2/src/stats.c: Add code to draw/update the exp progressbar.  Replace
       some static numeric constants with #define values instead.  Add
       can_alert option to update_stat()
    MSW 2006-11-03

    common/newclient.h: Merge/copy over file from server to get it synced up.
    gtk-v2/src/info.c: Modify so that it sets the text manager for all the
      types so it can use extended markup language.
    MSW 2006-10-30

    Fix annoying bug where popups appear all the time.
     common/newclient.h: add some missing message types.
     gtk/text.c: by default, admin commands are just sent to draw_info. This
      prevents annoying popups.
    Ryo 2006-10-29

    common/Makefile.am: Make sure svnversion.h rebuilds every time.
    Alex Schultz 2006-10-29

    gtk/rcs-id.h, common/rcs-id.h, x11/rcs-id.h, gtk/gx11.c, x11/x11.c: Remove
       rcs-id code.
    gtk/Makefile.am, common/Makefile.am, x11/Makefile.am: Remove references to
       rcs-id.h files.
    --
    configure.in, common/Makefile.am: Generate svnversion.h to define SVN_REV from
       running the svnversion command if avaliable.
    common/version.h: Add FULL_VERSION macro, to include SVN_REV if avaliable.
    gtk/gx11.c, x11/x11.c, gtk-v2/src/main.c: Use FULL_VERSION instead of VERSION.
    Alex Schultz 2006-10-20

    common/client.c, gtk-v2/src/main.c: Remove excess log messages that flood
       console.
    Alex Schultz 2006-10-12

    Apply patches #1562945, #1562947, #1563796, and #1566467 to allow the gtk2
       client to be built in mingw. Courtesy of Kurt Fitzner.
    ---
    configure.in, gtk-v2/src/Makefile.in: Clean up build system a little and add
       mingw supports.
    common/item.c, common/commands.c, common/init.c, common/script.c,
       common/mapdata.c, common/client.c, common/p_cmd.c, common/player.c,
       common/newsocket.c, common/metaserver.c: Add mingw/win32 support.
    gtk-v2/src/keys.c, gtk-v2/src/map.c, gtk-v2/src/image.c,
       gtk-v2/src/sdl.c, gtk-v2/src/main.c, gtk-v2/src/opengl.c, gtk-v2/src/png.c,
       gtk-v2/src/Makefile.am, gtk-v2/src/sound.c, gtk-v2/src/menubar.c: Add win32
       support to gtk2 client code, including for sdl and opengl.
    Alex Schultz 2006-10-07

    common/mapdata.c, common/proto.h: Move clearing of old map data from
       mapdata_set_face_layer() to a new mapdata_clear_old() function.
    common/commands.c: Call mapdata_clear_old() in Map2Cmd() instead of relying on
       mapdata_set_face_layer() to clear it. Fixes bug #1559683.
    x11/x11.c: Fix display_mapscroll() to handle scrolling by greater than 1 tile
       at a time. Fixes bug #1564584.
    Alex Schultz 2006-09-26

    gtk-v2/src/info.c: Add some notes about downloading font.  Add support
      for underline in extended text modes.
    MSW 2006-09-17

    configure.in: Fix opengl checks.
    Alex Schultz 2006-09-17

    Fix bug 1531060 - metaserver selection button is improperly activated.
    Fix this by clearing the text box if an entry in the tree widget is selected -
    if text is entered in the text box, unselect any selection - keeps it
    very consistent what the connect button does.  Have it greyed out until
    there is either text in the text box or something selected in the treeview.
    --
    gtk-v2/gtk-v2.glade: add callback for key press events for text entry
      box.
    gtk-v2/src/callbacks.h,gtk-v2/src/interface.c: Rebuilt
    gtk-v2/src/metaserver.c: Add code to activate/disable button based on
      status.  Add code to clear text box when treeview selected.  Add code
      to deselect treeview if data is entered in textbox.
    MSW 2006-09-05

    gtk-v2/src/stats.c: Fix bug 1527966 - protections window not properly
       updated.  Wrong variable was being used in loop.
    MSW 2006-09-05


    gtk-v2/src/map.c: Clear clipmask and clear window in draw_splash() so that
       splash is correctly redrawn.
    gtk-v2/src/metaserver.c: Add call to draw_map() in metaserver selection just
      to make sure splash is drawn correctly.
    MSW 2006-09-04

    gtk-v2/src/inventory.c: Fix bug 1528014 - when dropping all objects, display
      isn't updated correctly.  Remove checks for cpl.ob->inv - relying on
      cpl.ob->inv_updated appears to work fine.
    gtk-v2/src/keys.c: Fix bug 1527988 - message about unused keys isn't very
       useful.  Include meta and alt information about unused keys.  Add
       warning message to bind when trying to bind a key that may conflict
       with an existing binding.
    MSW 2006-09-04

    Add suggestion from bug 1528536 - some menu items should be disabled during
    metaserver selection.
    --
    gtk-v2/gtk-v2.glade: Fix some incorrect name (meny vs menu)
    gtk-v2/src/interface.c: Rebuilt
    gtk-v2/src/menubar.c: Add enable_menu_items(), which enables/disables some
       menu items.
    gtk-v2/src/metaserver.c: Add calls to enable_menu_items() to disable
      some menu items before metaserver selection, and to enable them after.
    MSW 2006-09-04

    gtk-v2/gtk-v2.glade: Add callback for pressed event on metaserver quit button -
       allows alt-Q to work - fix for bug 1551373
    gtk-v2/src/interface.c: Rebuilt
    --
    gtk-v2/server/metaserver.c: Make some changes related to bug 1548290 - cached
       entries show 0 value in players.  Add code to check list of servers from
       metaserver - if we have a match in the cached server list, don't display
       the cached entry - use the one from the metaserver instead. Also, add
       logic to not display empty server if the default server is null.
    --
    gtk-v2/src/config.c: Make save_winpos() do actual saving, have
        on_save_window_position_activate() call save_winpos() - fixes
        bug 1551395 where savewinpos command does not work.
    gtk-v2/src/main.c: Remove empty function save_winpos()
    MSW 2006-09-04

    gtk-v2/src/stats.c: Remove extra Player: in the player name.  Fixes bug
    1528011.  MSW 2006-09-03

    This change mainly adds support for the extended info messages for the gtkv2
    client.  Note that unlike the gtkv1 client, the gtkv2 client doesn't in any
    way try to do pop up windows or fancy graphics - rather, the support is there
    just so it can do font changes, color changes, etc, within the normal text
    window.
    --
    common/newclient.h: Sync it back up with server version.  Several new
      MSG_ types added.
    gtk-v2/src/info.c: Redo info pane handling - move all the relevant variables
       into a structure - this should make it easier to add more panes in the
       future, but right now, it means an integer can be passed in to functions
       to control what pane to draw in.  Add support for extended draw info -
       notably, this means listing alternative fonts, and adding support
       for different tags.  Add callsbacks for the different message types.  Add
       code to process extended text message tags.
    gtk-v2/src/keys.c: Change the grab focus after user enters command to use
       the treeview_look widget instead fo the textview - given that the textview
       is now stored away in a structure, harder to get to that variable.
    MSW 2006-09-03

    common/client.c: fix Win32 compilation.
    Ryo 2006-09-03

    gtk-v2: Fix bug 1528540 - if metaserver window is closed, client is unusable.
    Take suggested fix - if metaserver window is closed, exit client.  Just
    another hook to last commit.
    gtk-v2/gtk-v2.glade: Add callback for destroy event on metaserver window.
    gtk-v2/src/interface.c: rebuilt.
    MSW 2006-08-21

    gtk-v2: Fix bug 1530024 - errors when manually closing a window.
    gtk-v2/gtk-v2.glade: Add callback for destroy event on main window.
    gtk-v2/src/callbacks.h, gtk-v2/src/interface.c: Updated by glade with new
        callback
    gtk-v2/src/main.c: Code to handle callback
    MSW 2006-08-20

    gtk/gx11.c: if cpl.no_echo is set, hide input.
    Ryo 2006-08-08

    configure: add --enable-cfgtk2 flag, to build gtk1 client with gtk2.
    configure.in: add --enable-cfgtk2 flag. Add getaddrinfo check.
    common/commands.c: check buffer length.
    common/init.c: free allocated memory.
    gtk/gx11.c: replace some WIN32 with CFGTK2.
    gtk/win32/config.c: add #define CFGTK2.
    Ryo 2006-07-29

    Make common/cconfig.h act as the default server if set, if not set, connect
    to metaserver.  Prior to this, it always went to the metaserver unless
    -server option was given.
    --
    common/cconfig.h: Comment out SERVER so by default it connects to metaserver
    common/client.c: Add handling to initialize server from SERVER if defined,
       null otherwise.
    common/metaserver.c: Don't present default server in metaserver selection
       default is null.
    gtk/gx11.c, gtk-v2/src/main.c, x11/x11.c: Change command line handling -
       if server is set, use that as default to connect to.
    --
    MSW 2006-07-17

    gtk-v2/src/inventory.c: Add another invisible column to inventory/look
       lists for sorting based on name without nrof clogging results.  Comment
       out code that makes image fixed width.
    MSW 2006-07-17

    x11/xutil.c: Use snprintf() to avoid possible buffer overflows.
    gtk/image.c gtk-v2/src/image.c gtk-v2/src/opengl.c: Remove superfluous casts.
    common/item.h, gnome/gnome.c, gtk/gx11.c, x11/x11.c: Remove unused macros.
    common/commands.c: Unify/fix calls to LOG().
    common/commands.c: In DeleteItem() and DeleteInventory() do not crash if an
       invalid object tag was received.
    Andreas Kirschbaum 2006-07-16

    Fix problem in gtk1 & gtk2 client when player issues disconnect command -
    client would hang and consume all CPU time.
    ---
    common/external.h: Add declaration to cleanup_connection()
    common/p_cmd.c:  In disconnect command, add call to cleanup_connection()
    gtk/gx11.c, gtk-v2/src/main.c: Add cleanup_connection() - removes socket
       from one of the gdk input device, call gtk_main_quit so it returns
       to metaserver selection.
    x11/x11.c: Add empty cleanup_connection() - x11 client doesn't need to
      do anything special.
    MSW 2006-07-06

    More changes related to default logging.  Able to specify default log level
    with configure.  Note:  you will need to re-run configure after this change,
    as otherwise MINLOGLEVEL will not be defined in config.h.
    ---
    configure.in, configure:  Add --with-loglevel=<val> to specify default
        loglevel.
    crossfire-client.spec: Update to include --with-loglevel for building RPMs
    common/config.h.in: Add MINLOGLEVEL #define.
    common/misc.c: Modify to use the MINLOGLEVEL #define
    MSW 2006-07-05

    Clean up some compile warnings.  They generally fall into either wrong form
    for variable (%lld vs %ld), or cast for data (char* vs uint8*)
    ---
    common/client-types.h: Add FMT64 defines like done in the server.  Removes
       need for #ifdef WIN32 in many places.
    common/client.c: Remove unneeded cast for ReplyInfoCmd().  Change type
       of length parameter passed to getsockopt() to be a socklen_t.
    common/commands.c: Change ReplyInfoCmd() to take a uint8*.  Add several
      char*/uint8* casts.  Change TickCmd() to also take uint8*
    common/external.h: Add extern void client_tick(uint32 tick).
    common/image.c: load_image() so that its fourth param (checksum) is a uint32.
        In finish_face_cmd() change filename to be a char*.  Add some casts in
       ImageCmd() & Image2Cmd().  Change display_newpng() so its first param
       (face) is just a int, not a long.  Change get_image_info() to take in
       a uint8* for data, add some casts.  Change get_image_sums() to take in
       a char*
    common/item.c: Change several buffers used by the socklist structure to
       be uint8, add casts as needed.
    common/newsocket.c: Change SockList_Init() so that the passed in buffer
       is a uint8*, so that is what the target buffer type is.  Add some
       casts and update some types within the program.
    common/player.c: Change a buffer from char to uint8.
    common/proto.h: Rebuilt.
    common/script.c: Change it to take in a uint8 for data.  Change %lld
       to use FMT64
    common/script.h: Update declaration of script_watch()
    gtk/config.c: Remove const from titles.  While they may be used as a const,
       the gtk function they are passed to isn't declared that way.
    gtk/gx11.c: Remove unused function end_windows().  Replace %lld with
       FMT64.  Removed const from title declaration.
    gtk/inventory.c: Remove const from titles declaration.  re-enable cast
       for image creation for tabs.
    gtk/keys.c: Add note about compiler warning and bad code technique for
       for getting the selection.
    gtk/png.c: Removed unused variables/function - png_to_gdkpixmap()
    gtk/text.c:  Change void_callback() to match format of other callbacks
       to prevent warning.
    gtk-v2/src/gtk2proto.h: Rebuilt.
    gtk-v2/src/png.c: Remove unused variable.
    gtk-v2/src/stats.c: Replace %lld with FMT64.
    pixmaps/question.111, pixmaps/stipple.111, pixmaps/stipple.112: Change
        types to be char and not unsigned char, since that is what
       the function tha uses this data expects.
    x11/x11.c: Replace %lld with FMT64
    ---
    MSW 2006-07-04

    Changes related to logging of version information.
    aclocal, Makefiles.*: Rebuilt for new file in gtk-v2/src.
    common/misc.c: Change MINLOG to be a variable so it can be changed via
       command line options.
    gtk/gx11.c: Have bug window display rcsid versions.  Add -loglevel command
       line option.  Move printing of some log messages until after we process
       command line options since that can change the log level.
    gtk-v2/gtk-v2.glade: Add an about window for the gtkv2 client.
    gtk-v2/src/Makefile.am: Add about.c file.
    gtk-v2/src/about.c: file for about window.
    gtk-v2/src/callbacks.h: on_about_close_clicked() added by glade.
    gtk-v2/src/interface.c, interface.c: New logic for about window.  New
       function - create_about_window()
    gtk-v2/src/main.c: Add -loglevel command line option.  Move printing of some
       log messages after we process command line options.
    gtk-v2/src/menubar.c: remove menu_about() - now in about.c
    MSW 2006-07-04

    common/misc.c: Make default log level 2 when not in debug mode.  Normal users
      probably don't want all the INFO log messages, and it never makes a good
      impression about stability/quality if a program spews out lots of errors
      or other messages.
    MSW 2006-07-01

    Make some changes to the defaults so that the game is a bit more user friendly
    to completely new users (eg, those that don't have a settings file):
    --
    common/init.c: Turn off popups (gtkv1 client) by default - general seems
      that it isn't popular, and placement of the popups needs to be fixed.
    gtk-v2/src/main.c: Change default map size to ask from server to be
       25x25 - the gtkv2 client has default window size for that, so lets use
       it.
    x11/x11.c: Turn on scroll of text by default - non scroll is really ugly
       and doesn't make any sense give the power of even very slow cpus now.
    MSW 2006-07-01

    gtk-v2/src/config.c: Fix bug resulting in a crash when opening the
       configuration dialogue if you have an empty gdefaults2 file.
    MSW 2006-06-30

1.9.1
=====

    sound-src/alsa9.c: Fix up sound for alsa9+.  Not positive exact change that
      fixed the problem, but following changes made: Add SOUND_DEBUG_WRITES to
      separate the debug from writes vs all the other debug messags.  If using
      16 bit data, always use unsigned no matter wit the sign config option
      says.  In alsa_recover(), if error is EAGAIN, just do nothing and return.
      In audio_play(), don't write more bytes than chunk size (basically
      largest block that alsa wants at one time).  In play_sound(), don't
      decrease volume based on maximum number of sounds that may be played
      at once - this makes things too quiet.
    MSW 2006-06-25

    gtk/gx11.c, gtk-v2/src/main.c: Add checks for csocket.fd==-1 after return
       of DoClient.  With change in DoClient to close the socket, the network
       routines are not called again (like they used to be), and thus the
       GUI was't really aware the socket was closed, and wouldn't prompt for
       metaserver selection.
    MSW 2006-05-21

    Make socket handling more robust.
    ---
    common/client.c: In DoClient() properly close the socket if an invalid packet
       was received.
    common/newclient.h: Increase the receive buffer size to 65535 bytes. This
       allows the client to receive any valid packet (even if no currently
       existing server is supposed to send such big packets).
    common/newsocket.c: Fix definitions of llevDebug and llevError to make error
       messages visible.
    Andreas Kirschbaum 2006-05-21

    common/mapdata.c: fix unitialized variable.
    Ryo 2006-05-17

    This commit adds client side support for the map2 & tick protocol commands.
    In additional the the necessary decode logic, more layers are also added
    to the map.
    --
    common/Makefile.am/.in: Fix proto directive
    common/client.c: Add global tick variable.  Add links to handle map2
        and tick protocol commands.  Update setup request sent to server
        to request to use the tick and map2 commands.
    common/client.h: Add additional fields to Animations structure.	 Increase
        MAX_MAP_OFFSET to match the value on the server.
    common/commands.c: Add parsing of return of map2 failures on setup command
        so that client can fall back.  Add additional initializations for
        new fields in AnimCmd().  Change definition of NUM_LAYERS to match
        what the map1 command wants/expects.  Add Map2Cmd() to decode
        map2 protocol command.  Do some whitepsace clean of ExtSmooth().
        Add TickCmd()
    common/init.c:  Add seeing of random number generator.
    common/mapdata.c: Rewrite CLEAR_CELLS macro to handle additional layers.
       Clear animation data in expand_clear_face().  Change MAXLAYERS to
       MAP1_LAYERS since map2 increase MAXLAYERS.  Add support functions for
       setting data in the map2 command.
    common/mapdata.h: Increase MAXLAYERS, add MAP1_LAYERS define to old number
       of layers.  Add animation data to MapCellLayer.
    common/newclient.h: Add various defines related to the map2 data.
    common/proto.h: Rebuilt
    gtk/gx11.c: Add cleint_tick() to handle map animations.  Update
       do_timeout() to not do animations if we are getting tick data.
    gtk-v2/src/config.c: Fix bug in config code where it wasn't enabling
       darkness when player switched back from no darkness mode to some
       mode.
    gtk-v2/src/main.c: Add client_tick() to handle animations.  Update
       do_timeout() to not do animations if tick is set.
    gtk-v2/src/opengl.c: Fix drawing logic where objects which were visible
       but in which the bottom right corner was off the map was not being
       drawn - only a problem in opengl since it only draws the object
       when it finds the head, does not draw each piece.
    sound-src/Makefile.am/.in: Fix creation of sounds file - was using
       wrong variable name.
    x11/xutil.c: Add basic client_tick() that is a callback from the common code.
    MSW 2006-05-14

    common/image.c: use the same image hashing algorithm that the server uses
    for archetypes, increase the table size to 8192 to reduce collisions
    Brendan Lally 2006-04-12

    common/item.c: fix unitialized variable.
    common/p_cmd.c: fix memory leak.
    gtk/keys.c: fix memory leak.
    Ryo 2006-03-14


    Yet more changes for gtkv2 clients, mostly aimed at making it usable on lower
    resolution displays.  Window can now be resized to 800x600, added save window
    positions so it will remember where you moved the panes to (as well as root
    window size).  Unrelated change to this is that now the inventory list is
    sortable like the metaserver and spell lists are - you can sort by name,
    weight, or by item type (click on the icon for item type).
    --
    gtk-v2/gtk-v2.glade:  Add new menu item for save window positions.  Change
      statbar area so there is a pane between stat bar and stat notebooks.
      Change statbars so they resize smaller/larger.
    gtk-v2/src/callbacks.h: callback for on_save_window_position_activate() added.
    gtk-v2/src/config.c: Add on_save_window_position_activate() and
      load_window_positions()
    gtk-v2/src/interface.c: rebuilt.
    gtk-v2/src/inventory.c: Add LIST_TYPE column for sorting.  Change
      table definitions so columns are sortable.
    gtk-v2/src/main.c: Add code to allow resizing down to 800x600.  Add
      call to load_window_positions()
    gtk-v2/src/map.c: Try to set map size based on window size - save
      some memory.
    ---
    MSW 2006-03-10

    More updates for the gtkv2 client.  Add a config window to change the
    config options.  Note this isn't quite as cluttered as the gtkv1 config
    window because only the options that affect the gtkv2 client are presented.
    ---
    common/client.h: Add CFG_LT_NONE to use instead of 0.
    common/init.c: Change 'sdl' config name to 'displaymode'.  the CONFIG_
      parameter was changed a while back, but still used this old name in the
      save file.
    gtk/config.c: Add some logic to handle 'sdl' legacy config mode.
    gtk-v2/gtk-v2.glade: Updated with new config window.
    gtk-v2/src/callbacks.h: rebuilt by glade-2
    gtk-v2/src/config.c: Lots of new code to handle setting/getting of config
      values in config window.
    gtk-v2/src/gtk2proto.h: Rebuilt.
    gtk-v2/src/interface.c: Rebuilt by glade-2
    gtk-v2/src/interface.h: Rebuilt by glade-2
    gtk-v2/src/main.c: Add call to config_init() to initialize config window.
    MSW 2006-02-27

    sound-src/Makefile.in: replaced SOUNDDIR with SOUND_DIR, so that
       --with-sound-dir will work now
    Klaus Elsbernd 2006-03-07

    common/p_cmd.c: Update command table for auto-completion to all (non-DM)
       server side commands. Also check for client side commands. Add a space
       after a completed command so the player can enter arguments.
    Andreas Kirschbaum 2006-03-04

    Fix bug #1442523 (Crash when pressing TAB during login). Also fix undefined
    behavior due to overlapping strings passed to strncpy().
    common/p_cmd.c: In complete_command() remove hack for x11 client and return
       NULL if no match was found.
    gtk/gx11.c, gtk-v2/src/keys.c, x11/x11.c: Adapt to changes in
       complete_command().
    x11/x11.c: Replace strncpy() with memmove() to cope with overlapping strings.
    Andreas Kirschbaum 2006-03-04

    Apply patch #1424583 (IPv6 patch for client) courtesy  Christoph Hohmann -
    (reboot)
     common/client.c
     common/config.h.in
    Ryo 2006-02-26

1.9.0
=====

    Fix server cache which was broken for some reason.
     common/metaserver.c
    Ryo 2006-02-25

    Apply patch #1433271 (code-cleanup) by Stefan Huehner: Add const and static,
    remove unused variables
    ---
    Affected files: common/{client.c,commands.c,image.c,init.c,item.c,metaserver.c},
    common/{misc.c,newsocket.c,player.c,proto.h,rcs-id.h,script.c,script.h},
    gtk/{config.c,gtkproto.h,gx11.c,image.c,inventory.c,keys.c,map.c,png.c},
    gtk/{rcs-id.h,sdl.c,sound.c,text.c,win32/soundsdef.h},
    gtk-v2/src/{main.c,sdl.c}, x11/{png.c,rcs-id.h,sound.c,x11.c,xutil.c}
    Andreas Kirschbaum 2006-02-23

    More improvements to the gtk-v2 client:
    - Add spell selection window similar to that in the gtk-v1 client.
    - Make it so that clicking on the headers in the metaserver and keybinding
      selection windows will result in table be sorted by that header.
    --
    */Makefile.in: Rebuilt by automake.
    aclocal.m4: Updated by aclocal.
    gtk-v2/TODO: Remove things that have been done, add other things mentioned
      on mailing list that should be done.
    gtk-v2/gtk-v2.glade: Updated with new spell selection window.
    gtk-v2/src/Makefile.am: Add spells.c file
    gtk-v2/src/spells.c: File that handles spell selection window.
    gtk-v2/src/callbacks.h: Updated by glade
    gtk-v2/src/gtk2proto.h: rebuilt
    gtk-v2/src/interface.c: Updated by glade.
    gtk-v2/src/interface.h: Updated by glade.
    gtk-v2/src/keys.c: Add necessary calls to enable sorting of table by
      clicking on headers.
    gtk-v2/src/main.c: Add call to update_spell_information() if spell information
      has changed.
    gtk-v2/src/metaserver.c: Add necessary calls to enable sorting of table by
      clicking on headers.  Convert the idletime and number of players columns
      to be ints - this makes the sort work as expected, and actually simplifies
      the code a little.
    gtk-v2/src/support.h: Rebuilt by glade.
    MSW 2006-02-22


    common/player.c: Fix bug in that spell data wasn't being cleared when
      logging on.  Thus, if you logged on as one character, then another,
      etc, it would just keep adding to the spell list, not being a
      representative list of spells character knows.
    MSW 2006-02-20

    gtk/gx11.c: when no skill is sent in a addspell packet, display the skill as
       'generic' in the Spell window
    Brendan Lally 2006-02-20


    Improvements to the gtkv2 client - Add free form text box to metaserver
    selection window so server name can be manually entered, add keybinding
    interface window to client similar to one in gtkv1 client, and disconnect
    menu item to client.  Note that this keybinding interfaces allows for
    ALT and META modifiers in addition to SHIFT and CONTROL, hence minor changes
    to the common code.
    ---
    common/client.h: Add meta_on, alt_on to player structure.
    gtk-v2/gtk-v2.glade: Updated with new elements - keybinding window, new
      menubar, text box for metaserver window.
    gtk-v2/src/callbacks.h: Generated by glade for new function prototypes
    gtk-v2/src/gtk2proto.h: rebuilt for new function definitions.
    gtk-v2/src/interface.c: Generated by glade for new features.
    gtk-v2/src/interface.h: Generated by glade for new function prototypes
    gtk-v2/src/keys.c: New initialization code for keybinding window.  New
      KEYF_ modifiers.  New handling for meta and alt keys.  Many new callbacks
      for new code.
    gtk-v2/src/main.c: Remove unused extern declartions.
    gtk-v2/src/menubar.c: Add function for disconnect menu item.
    gtk-v2/src/metaserver.c: Add metaserver_connect_to() to handle common
      connection logic (pulled from on_treeview_metaserver_row_activated().
      Add on_metaserver_text_entry_activate() for text entry server connections.
    MSW 2006-02-19

    Apply modified patch #1432404 (Solve bug in watch stats script function) by
    Benjamin Lerman: make watch stats command work if more than one stat changes
    simultaneously.
    ---
    common/script.c: In script_watch() do not overwrite but append multiple watch
       stats commands.
    Andreas Kirschbaum 2006-02-17

    Apply patch #1430279 (code-cleanup: const, static, etc) by Stefan Huehner.
    ---
    Affected files: common/{client.c,client.h,commands.c,def-keys.h,external.h,
    init.c,item-types.h,item.c,metaserver.c,misc.c,p_cmd.c,player.c,proto.h},
    gtk/{config.c,gtkproto.h,gx11.c,help.c,inventory.c,keys.c,png.c,sdl.c,sound.c,
    text.c,win32/soundsdef.h},
    gtk-v2/src/{inventory.c,keys.c,magicmap.c,main.c,sdl.c,sound.c,stats.c},
    pixmaps/{all.xpm,close.xpm,coin.xpm,crossfiretitle.xpm,hand.xpm,hand2.xpm,
    lock.xpm,mag.xpm,nonmag.xpm,question.xpm,sign_east.xpm,sign_flat.xpm,
    sign_west.xpm,skull.xpm,unlock.xpm}, sound-src/{alsa9.c,cfsndserv.c,common.c},
    utils/mdk.sh, x11/{sound.c,x11.c,xutil.c}
    Andreas Kirschbaum 2006-02-16

    Apply patch #1429975 (patch to support port numbers in metaserver host names)
    by Marc Lehmann.
    ---
    common/metaserver.c: In metaserver_select() allow a port number in the server
       string.
    Andreas Kirschbaum 2006-02-12

    common/metaserver.c, common/metaserver.h: Make cached_servers_loaded static
       since it is not used elsewhere.
    Andreas Kirschbaum 2006-02-12

    gtk/inventory.c, gtk-v2/src/inventory.c, x11/x11.c:
    Make the message displayed for locked items more descriptive.
    Brendan Lally 2005-02-09

    Remove unscrollable single column resistances option from gcfclient.
    Change the setting name in the config file and convert old values.
    Reduce MAX_BUTTONS to 33. Replace radio buttons with a single push button.
    Remove legacy lighting save code. Remove SHOW_RESISTS, use NUM_RESISTS
    instead (this reduces the blank space at the bottom of the resistances
    window). Call resize_resistance_table from get_message_display, remove
    duplicated code from the latter.
    Affected files:
    gtk/gx11.c, config.c
    common/init.c
    --
    Remove coloured inventory and text options, as well as all supporting code
    for them. Make text always print in colour. Remove special code for
    initialising black and white monitors in cfclient, and change its background
    colour to colour number 9 (to not be the same as so many draw_info's from the
    server). Change colour number 9 to a pale grey to make text show up better.
    Affected files:
    common/client.h, init.c
    gtk/config.c, gtkproto.h, gx11.c, inventory.c
    gtk-v2/src/info.c, inventory.c
    x11/x11.c, x11proto.h, xutil.c
    Brendan Lally 2006-01-31

    gtk-v2/src/opengl.c: For opengl mode, create a subwindow of the map window
      with the needed visual.  On many systems, the visual that glXChooseVisual()
      returns doesn't match the default visual of the system, thus resulting
      in opengl not being able to create a context.
    MSW 2006-01-28

    gtk/gx11.c: add a 'spell options' box to allow extra options to be passed to
    spells, make any mouse button change the spell description, not just the
    left one and reorder some gtk function calls to improve clarity
    Brendan Lally 2006-10-21

    Fixed compilation for some compilers.
    gtk/gx11.c inventory.c
    Ryo 2006-01-19

    common/commands.c: actually read the right amount of data on an updspell
    --
    Add spell listing support to gcfclient and common, in particular:
    common/client.c: addspell, updspell, delspell function pointers, send
       spellmon in setup
    common/client.h: Spell struct, add attuned, repelled, denied to stats, add
       spelldata and spells_updated to player struct
    common/commands.c: parse stat details concerning spell paths, addspell,
    delspell, and updspell packet handling
    common/newclient.h: new flags related to this
    common/proto.h: function declarations
    gtk/gx11.c: make the client->spells menu option show a window displaying all
       spells known to the player, have a function update_spell_list to update it,
       add a call to this to do_timeout.
    Brendan Lally 2006-01-19

    gtk/gx11.c: make skills display in a scroll pane, display all known skills,
       not just those with exp
    Brendan Lally 2006-01-17

    gtk/inventory.c: grey out close button when it won't do anything
    Brendan Lally 2006-01-16

    common/commands.c: In DeleteItem() properly handle more than one item.
    Andreas Kirschbaum 2006-01-13

    x11/png.c: Add same workaround from gtk/png.c to make it work on 64 bit
    systems.
    MSW 2006-01-01

    Made item's nrof uint32, like server-side. Fix a crash in get_number if nrof < 0
     (not supposed to happen, server bug, but still).
    Modified files:
     common/commands.c item.c item.h proto.h
    Ryo 2005-12-27

    gtk-v2/src/image.c: Remove call to free fog pixels (SDL) - with call in place,
       client crashes on double free in SDL mode after disconnecting from
       server.
    MSW 2005-12-11

    gtk/{map.c,sdl.c}, x11/x11.c: General cleanup - just whitespace changes.
    Andreas Kirschbaum 2005-12-11

    Apply patch 1352490 "newpickup rings/amulets client side" courtesy anonymous.
    Modified files:
     gtk/gx11.c
    Ryo 2005-11-12

    common/player.c: Properly ignore received comc commands with invalid length.
    gtk/gx11.c, gtk-v2/src/image.c: Initialize smooth_face field when allocating
       pixmaps array.
    Andreas Kirschbaum 2005-11-02

    Add support for newpickup PU_NOT_CURSED (ignore cursed items) flag.
    --
    gtk/gx11.c: Add flag #define and menu entry.
    gtk-v2/gtk-v2.glade: Add menu entry.
    gtk-v2/src/{callbacks.h,interface.c}: Rebuilt.
    gtk-v2/src/gtk2proto.h: Add prototype for menu callback.
    gtk-v2/src/pickup.c: Add #define and menu callback function.
    Andreas Kirschbaum 2005-11-01

    gtk/config.c: fallback to PIXMAP display mode when SDL is not built in.
    Ryo 2005-11-01

    Fix bug #1288647 (typing text in password mode). Now hidden input (for
    password entry) is reliably turned off afterwards.
    --
    common/command.c: Enable hidden input before printing the query; this allows
       the gtk client to enable it in his callback function. Also: reset hidden
       input mode after sending a reply to the server.
    gtk/gx11.c: Enable/disable hidden input in non-popup input area even if popup
       mode is enabled. Otherwise hidden input mode will not be disabled when
       switching to popup mode while entering a password.
    Andreas Kirschbaum 2005-10-29

    common/p_cmd.{c,h}: Remove superfluous "const" from get_num_commands() return
       value.
    Andreas Kirschbaum 2005-10-29

    gtk/text.c: Print MOTD into text window if using -nopopups mode. Previously it
    was discarded in -nopopups mode.
    Andreas Kirschbaum 2005-10-28

    Documentation/Scripting.html: Clarify the repeat parameter for the issue
    command.
    Andreas Kirschbaum 2005-10-28

    common/script.c: Make parameters passed to scripts work again.
    Andreas Kirschbaum 2005-10-28

    common/script.c: fix Win32 that didn't detect end of script correctly.
    Ryo 2005-10-16

    Avoid using c++ reserved words, in case one wants to link a c++ program to
    client.h
    Alex Schultz 2005-09-22

    common/{client.h, init.c}, gtk/{config.c, gx11.c}: Add configuration option
    to allow clients to timestamp incoming coloured messages. This implements RFE
    #1090049
    Brendan Lally 2005-09-22

    gtk-v2/src/image.c copy part of gtk1 image.c to fix a compile issue on
    mac.
    Brendan Lally 2005-09-21

    common/external.h: add definition of addsmooth.
    gtl/inventory.c: explicit cast of parameters.
    Ryo 2005-09-10

    configure, configure.in: Move check for X11 early in the process so that
      gtk dependencies on them should be resolved.
    MSW 2005-09-05

    x11/x11.c: Fix similar problem for x11 client: need_update needs to be cleared
        too.
    Andreas Kirschbaum 2005-09-04

    gtk/map.c: need_resmooth needs to be cleared too, else drawing routines called
     all the time.
    common/misc.c: LOG buffer made static to avoid stack creation/destruction.
    common/script.c: removed unused variable/call.
    gtk/gx11.c: no need to refresh game area when window gets focus.
    gtk/gx11.h: add cache fields for listinfo.
    gtk/inventory.c: don't refresh list labels if not changed.
    common/mapdata.c: remove parasite #define NDEBUG
    gtk/image.c: if icon and map scales are the same, just gdk_pixmap_ref image and mask.
     This saves graphical resources and time.
    gtk/map.c: don't draw black rectangle if no face with transparency.
    Ryo 2005-09-04

    *Makefile.in, aclocal.m4, configure: Rebuilt.
    Andreas Kirschbaum 2005-09-03

    Fix bug #1102991 (Duplicate grapical display of the same monster):
    common/Makefile.am: Add new files mapdata.c and mapdata.h.
    common/{client.c, commands.c}: Tell mapdata module the current display size.
    common/commands.c: Remove functions to handle map updates. Rewrite
       map1_common() to pass information into mapdata module.
    common/init.c, gtk/gx11.c: Add new config options -mapscroll and -nomapscroll
       to enable/disable scrolling the map view with bitmap operations.
    common/mapdata.[ch]: Add new module to handle all updates to the_map.
    gtk/gx11.c: Remove code for #if ALTERNATE_MAP_REDRAW. Initialize question mark
       face for fog of war. Remove code to allocate the_map.
    gtk/image.c: Do not clear the_map in reset_image_data() anymore.
    gtk/map.c: Move code to update map data into mapdata module.
       draw_pixmap(): New function to draw one face.
       drawsmooth(): Check correct layer instead of fixed layer zero. Fix out of
          bounds array access.
       display_mapcell(): New function to draw one cell.
       gtk_draw_map(): Move map drawing code into display_mapcell().
    gtk/sdl.c: Basically the same changes as in gtk/map.c
    gtk-v2/src/image.c: Basically the same changes as in gtk/gx11.c.
    gtk-v2/src/main.c: Add config options -smooth/-nosmooth to enable/disable
       smoothing. Remove code to allocate the_map.
    gtk-v2/src/map.c: Basically the same changes as in gtk/map.c.
    gtk-v2/src/opengl.c: Fix out of bounds array access. Initialize question mark
       face for fog of war.
    gtk-v2/src/sdl.c: Basically the same changes as in gtk/map.c.
    x11/x11.c: Implement map scrolling by using XCopyArea(). Add config options
       -mapscroll/-nomapscroll to enable/disable this. Remove code to allocate or
       clear the_map. Add new function display_mapcell() to draw one cell. Move
       map drawing code from display_map_doneupdate() into display_mapcell().
       Remove two pixel border around map window; is was used inconsistently, and
       the window size was four pixels too small.
    x11/xutil.c: Move code to update map data into mapdata module.
    Andreas Kirschbaum 2005-08-31

    Fix bug #1245535 (negative grace showss up as positive amount):
    gtk-v2/src/stats.c: Clip negative stat values to zero.
    Andreas Kirschbaum 2005-08-30

    Fix sound compilation so it only tries to compile alsa9 helper if we
    in fact have alsa 9 libs.
    */Makefile.in: Rebuilt
    configure.in, configure: Add ALSA9_TARGET, replacing SOUND_TARGETS which
       was no longer being used.
    sound-src/Makefile.am: add EXTRA_PROGRAMS line for cfsndserv_alsa9 so
       don't get errors from automake, add @ALSA9_TARGET@ to bin_PROGRAMS.
    MSW 2005-08-28

    gtk/config.c, gtkproto.h, gx11.c, inventory.c:
    Commit patch #1265199 from Kevin Rudat to fix client crash when using split
    window mode
    Brendan Lally 2005-08-21

    common/misc.c, gtk/{gx11.c,sdl.c,text.c}, gtk-v2/src/sdl.c, x11/sound.c:
       Fix non-Ansi C89 code: remove "inline" function specifier, replace "//"
       comments.
    common/metaserver.c: Fix buffer overflow in metaserver_get_info().
    x11/x11proto.h, x11/xutil.c: Use correct parameter type "uint16" for
       addsmooth().
    Andreas Kirschbaum 2005-08-14

    This commit adds full automake support for the client - previously, only the
    gtk-v2 directory used automake, rest was Makefile.in - now everything is
    automake - makes maintenance and distributions easier.
    --
    common/Makefile.am gtk/Makefile.am help/Makefile.am pixmaps/Makefile.am
     sound-src/Makefile.am utils/Makefile.am x11/Makefile.am pixmaps/Makefile.in
     utils/Makefile.in help/Makefile.in: New Makefiles
    Makefile.am, Makefile.in: Removed unneeded rules, move pixmap, help, util
       handling to makefiles in their own directories.
    configure, configure.in: Update to include pixmap, help, util as
       directories.
    gtk-v2/Makefile.am, gtk-v2/Makefile.in: Clean up some rules in this makefile.
    common/Makefile.in, gtk/Makefile.in, sound-src/Makefile.in, x11/Makefile.in:
       Rebuilt as part of automake.
    gtk-v2/src/Makefile.am, gtk-v2/src/Makefile.in: Add banner copyright, remove
       uneeded rules.
    MSW 2005-08-11

1.8.0
=====

    Makefile.am, Makefile.in: Add missing pixmaps, change CHANGES to ChangeLog,
       update archive directive so it works.
    aclocal.m4: updated
    configure, configure.in: Updated for 1.8.0 release. Remove gnome/Makefile
       from list of Makefiles to create.
    gtk-v2/Makefile.am, gtk-v2/Makefile.in: Add archive directive.
    gtk-v2/src/Makefile.{am|in}: Add missing soruces to list so that archive
       works correctly. Add archive directive.
    MSW 2005-08-10

    gtk/keys.c: don't select text in widget under Windows.
    Ryo 2005-07-30

    gtk/gx11.c: fix a crash if closing login window. Weird behaviour, but no crash.
    Ryo 2005-07-29

    gtk/image.c: Remove stray '+' at beginning of line.
    Andreas Kirschbaum 2005-07-21

    x11/x11.c: Fix crash if display cannot be opened.
    common/script.c: Properly terminate string with '\0' in script_init().
    Andreas Kirschbaum 2005-07-18

    gtk/sdl.c, gtk-v2/src/sdl.c: Fix printf like format specifiers.
    Andreas Kirschbaum 2005-07-16

    common/init.c: Win32 should use %APPDATA% instead of . for home directory.
    Ryo 2005-07-10

    Bulk of this change is the addition of a pop up window in the gtk-v2
    client for metaserver selection, as well as other updates.  The files
    to the common area was really to pull the metaserver defines and data
    structures from the C file to a header file so that the gtk-v2 code
    can access them:
    --
    AUTHORS: New file, required by automake, data pulled README file.
    NEWS: New file, required by automake.
    Makefile.in, aclocal.m4: Rebuilt
    README: Remove author info from this file, move it to AUTHORS.
    common/Makefile.in: add metaserver.h file
    common/metaserver.h: New file containing metaserver defines and structures.
    common/metaserver.c: Pull out defines/structures from this file, moved to
       metaserver.h.  Have it strip packets/byte count info from comment
       section that metaserver reports.
    gtk-v2/Makefile.in: Rebuilt.
    gtk-v2/gtk-v2.glade: Added new metaserver window.
    gtk-v2/src/Makefile.am: Add metaserver.c as a standalone file that gets
       compiled
    gtk-v2/src/Makefile.in: Rebuilt
    gtk-v2/src/callbacks.h, gtk-v2/src/interface.c, gtk-v2/src/interface.h: Updated
        by glade2
    gtk-v2/src/main.c: Remove metaserver.c inclusion.  Initialize
        cached_server_file.  Change metaserver selection/display code.
    gtk-v2/src/metaserver.c: Lots of new code - have it display window,
       handle selections, connect to server, etc.
    MSW 2005-07-04

    gtk-v2/src/info.c: Remove extra lines of code for scrolling.  Have
       newlines be inserted in the correct place for the color info tab.
    gtk-v2/src/inventory.c: Remove call to check to display object in inventory
        tab for container objects - if we show the container object, so
        all objects within the container (bug 1226968)
    gtk-v2/src/keys.c: Move initialization of global widges to before loading
        keybindings - otherwise, they can end up not being initialized.
    MSW 2005-06-29

    Add inventory animation to the gtk2 client.
    gtk2proto.h: rebuilt
    inventory.c: Add new function that animates inventory.  Have draw_table() take
       a second param that determines if it is doing an animation run or just
       a normal draw.
    main.c: Move PACKAGE_DATA_DIR to be within WIN32 defines.  Add call to
       inventory_tick() in do_timeout()
    MSW 2005-06-26

    common/metaserver.c: wrong number displayed for cached servers.
    Ryo 2005-06-25

    configure.in, configure: Turn of the use of dmalloc as the default - if
       dmalloc is disabled, it has to be intentionally set.  gtkv2 client runs
       dog slow if dmalloc is used, so that isn't a good default
    common/item.c: Fix bug that resulted in the item names not being updated
       properly - bug introduced in patch 1197437.
    MSW 2005-06-04

    crossfire-client.spec, gnome/Makefile.in, x11/Makefile.in: Patch from Kari
       Pahula to fix manpage paths.
    gtk/gx11.h: Patch from Kari Pahula to remove incorrect variable declaration.
    Andreas Kirschbaum 2005-06-01

    Committed patch #1197437 courtesy Kevin Rudat (krudat).
    This patch moves inventory-related functions in GTK client to
     one specific file. Also makes inventory refresh less often.
    Affected files:
     * common: client.h item.c item.h p_cmd.c proto.h
     * gtk: config.c gtkproto.h gx11.c gx11.h inventory.c Makefile.in
     * x11: x11.c x11proto.h

    common/metaserver.c: add server cache.
    gtk/gx11.c: initialize server cache filename.
    Ryo 2005-05-23

    gtk/gx11.c: Windows has player-specific keys, get'em (was broken with new
     login window)
    Ryo 2005-05-12

    Add newpickup support to the gtkv2 client.  Didn't add old support (still
    available by specific commands) as I think the interface gets confusing
    to have them both - would be better to extend newpickup logic if necessary
    to support anything old pickup does that newpickup doesn't.
    --
    gtk-v2/Makefile.in: Rebuilt
    gtk-v2/gtk-v2.glade: Add menu options for newpickup
    gtk-v2/src/Makefile.am, gtk-v2/src/Makefile.in: Add pickup.c file
    gtk-v2/src/callbacks.h, gtk-v2/src/interface.c: Rebuilt by glade-2
    gtk-v2/src/pickup.c: New file - handles pickup logic.
    MSW 2005-04-17

    gtk/image.c: Apply patch from bug 1120881 that fixes pointer operations
       on netbsd/macppc.  Changed code still works on linux/x86.
    MSW 2005-04-16

    Improve behaviour of information windows on gtkv2 client - before this patch,
    they would always scroll to bottom when getting new output, making it
    difficult to look at shop listings or other long listings that require
    going back in the scroll buffer.  With this change, if the buffer isn't
    at the end, the scroll position isn't changed.  IF it it at the end, it
    keeps it at the end.
    --
    gtk-v2/gtk-v2.glade:  Chane scrolledwindows used by the textbuffers to
      have a meaningful name.
    gtk-v2/src/info.c: Add code that gets position of scroll bar (adjustment)
      and compares it with maximum, and if not at end, don't scroll window.
    gtk-v2/src/interface.c: Rebuilt.
    MSW 2005-04-11

    Fix so that magic map works properly on the gtkv2 client.
    gtk-v2/gtk-v2.glade: change name of map notebook to map_notebook.  Add
      signal to handle expose events of the magic map area.
    gtk-v2/src/callbacks.h: Rebuilt with addition of expose callback.
    gtk-v2/src/interface.c: Rebuilt with addition of expose, change of name.
    gtk-v2/src/magicmap.c: Have magic map switch the notebook page to the
      magic map page to ensure widget is realized - also good for expected
      behaviour.  Add some checks for null values so if user switches
      before getting magic map data, doesn't crash.  Add check in
      magic_map_flash_pos() to see if still on the magic map notebook page.
      Add expose callback.
    gtk-v2/src/main.h: Add MAGIC_MAP_PAGE which defines which notebook page
      is the magic map one.
    gtk-v2/src/map.c: Have it look up the map_notebook widget.
    MSW 2005-04-05

    Various minor bugfixes:
    configure.in, configure: Add warning message if we can't find gtk+ 2.0 or
       later, but continue configure process instead of exiting.
    common/misc.c: Fix code so that it compiles with older C compilers.
    gtk-v2/src/map.c:  Change code on need_recenter_map() - use MAX_MAP_OFFSET
       instead of hard coded value of 2 - found a crash here when running
       around the world map - could have been caused by a big image and/or
       the fact my character moved 2 spaces in one tick.  either way, this
       change shouldn't impact things, as it is seldom the virtual map needs
       to be recentered.
    MSW 2005-03-27

    This patch fixes a few memory leaks related to image caching in all clients.
    common/image.c: Declare facetoname[] as static. Add all code accessing this
       array. Print warning if image cannot be created.
    gtk/gx11.c, gtk/image.c, gtk-v2/src/image.c, x11/x11.c, x11/xutil.c: Remove
       code accessing facetoname[].
    gtk/gx11.c, gtk-v2/src/main.c, x11/x11.c: Always call init_cache_data() to
       initialize pixmaps[] array.
    gtk/image.c, gtk-v2/src/image.c, x11/png.c: Reject invalid face
       numbers and fix resource leak in create_and_rescale_image_from_data().
    gtk/image.c, gtk-v2/src/image.c, get_map_image_size: Pretend invalid faces to
       be of size 1x1 in get_map_image_size().
    gtk-v2/src/image.c: Properly free opengl resources in free_pixmap(). Fix
       resource leak when freeing old pixmaps in reset_image_data().
    x11/png.c: Properly free resources if an error occurs.
    x11/x11.c: Ignore invalid face numbers.
    x11/x11.h Remove duplicate definition of MAXPIXMAPNUM and facetoname[].
    x11/xutil.c: Initialize size of pixmaps[0].
    Andreas Kirschbaum 2005-03-27

    gtk-v2/src/map.c: Fix typo to make it compile without opengl.
    Andreas Kirschbaum 2005-03-26

    Main change of this is addition of opengl drawing for the map in the gtk-v2
    client.  On my system, the opengl code is about 10 times faster than the
    sdl code was, making it so I can turn on all the bells and whistles (smoothing,
    best lighting) and still use less than 10% cpu time.  As part of this, I
    redid the smoothing logic, so the client now requires a new server for
    smoothing to work (needs push logic, as client won't request smoothing
    info as that adds a lot of complication).  This change was done because
    the old smoothing code wasn't that efficient - now, we store the smoothing
    face along with the face it smooths, so finding the smoothing info is
    much faster.
    --
    configure.in, configure: Add check for -lglut - indication we have opengl
      libraries available.
    common/client.h: Remove Smooths struct.  Change CONFIG_SDL to
       CONFIG_DISPLAY, and add CFG_DM_... to denote different display modes,
       since there is more than just sdl and not sdl now.
    common/commands.c: Don't have SmoothCmd try to update what spaces need
       to be redrawn - for opengl, it doesn't care about that, and for
       most other maps, it will figure it out when it needs to redraw
       anyways.
    common/config.h.in: Addition of HAVE_OPENGL line.
    common/image.c: Remove getsmooth() - rely on push logic.
    common/init.c: Update  want_config[CONFIG_SDL] to
       want_config[CONFIG_DISPLAYMODE]
    gtk/config.c: Change access to CONFIG_DISPLAYMODE
    gtk/gx11.c: Change access to CONFIG_DISPLAYMODE. Add -smooth command line
      option.
    gtk/gx11.h: Add smooth_face to PixmapInfo struct.
    gtk/image.c: Change access to CONFIG_DISPLAYMODE.  When getting new
       PixmapInfo struct, use calloc so we are sure all fields are initialized
       to zero.  Add addsmooth().
    gtk/map.c: Change access to CONFIG_DISPLAYMODE.  Change how we access
      smooth face info.
    gtk/sdl.c: Change how we access smooth face info.
    gtk-v2/src/Makefile.am, gtk-v2/src/Makefile.in: Add addition of OPENGL_LIBS
       to link libs.  Add opengl.c file.
    gtk-v2/src/config.c: Add image.h include.
    gtk-v2/src/gtk2proto.h: Rebuilt.
    gtk-v2/src/image.c: Change access to CONFIG_DISPLAYMODE. Add hooks for
      opengl image generation.  Change call for pixmap creation from malloc
      to calloc.  Add addsmooth().
    gtk-v2/src/image.h. If we have opengl, include GL/gl.h.  Add fields
      for opengl texture maps.
    gtk-v2/src/info.c: Update so text line wraps if it is too long.
    gtk-v2/src/inventory.c:  Add checks to make sure object face is
      valid before trying to draw.  In icon mode, add code to cleanup
      old fields (if you drop an item, it wouldn't erase the list item
      in the list).  Also, free callbacks, as they effectively stack,
      and we were using incorrect object pointers (pointer from first
      callback, which didn't match current one).
    gtk-v2/src/keys.c: Add image.h to includes.
    gtk-v2/src/main.c: Add image.h to includes. Change access to
        CONFIG_DISPLAYMODE.  Add -opengl command switch.  Remove
        +sdl and popups command line options.  Relocate setup of
       cache call setup to after we know all windows have been created.
    gtk-v2/src/map.c: Change access to CONFIG_DISPLAYMODE.  Add opengl
       drawing hooks.  Change access for smooth info.  Implement
       button press code for map window (basically grabbed from
       gtk/map.c)
    gtk-v2/src/opengl.c: New file containing opengl draw code.
    gtk-v2/src/png.c: Remove some unused code resulting in compile warnings.
    gtk-v2/src/sdl.c: Remove some commented out code.  Change access method
       for smoothing code.
    x11/xutil.c: Change access to CONFIG_DISPLAYMODE.  Add addsmooth()
       function.
    MSW 2005-03-20

    Applied patch #1161817 (cowboyatheart): Add wands/staves/rods/horns to new
       pickup (client).
    gtk/gx11.c: add new 'magic devices' menu option.
    Ryo 2005-03-13

    More improvements for the gtkv2 client, mostly adding SDL support:
    gtk-v2/TODO: updated
    gtk-v2/src/logfile: Removed - don't need dmalloc logfile.
    gtk-v2/src/Makefile.am, gtk-v2/src/Makefile.in: Change program name from
       'gtk-v2' to 'gcfclient2'.  Add sdl.c to list of files.
    gtk-v2/src/gtk2proto.h: Rebuilt
    gtk-v2/src/inventory.c: Fix bug in show_nonmagical() (which corresponds
       to inventory tab) - was showing unpaid objects, not nonmagical objects.
    gtk-v2/src/main.c: Remove time_map_redraw declaration from function, since
       it is declared in map.c.  Change map logic to draw when we finish processing
       network data.  Change client naem as it reports itself to server to GTK2
       ... Client.
    gtk-v2/src/map.c: Add map_updated variable which is set by display_map_doneupdate -
       used by map draw function to know if anything has changed.  Clean up some
       formatting, remove unused code.
    gtk-v2/src/sdl.c: New file containing sdl support.
    MSW 2005-03-07

    Commit for GTKv2 client - please read gtk-v2/README before using this client.
    The bulk of the changes are limited to the gtk-v2 directory (addition),
    but some changes elsewhere as related to using automake.  You will need
    to run configure for the gtk-v2 client to be built (it should be built
    automatically if you have the needed libraries)
    --
    Changelog: Replaces CHANGES file to meet automake standards.
    Makefile.am: New file for use with automake.
    Makefile.in: rebult from Makefile.am
    aclocal.m4: Updated with macros to check for gtk-v2.
    configure.in: checks for gtk-v2 added.  Chane SUBDIRS to CF_SUBDIRS as
        using SUBDIRS causes conflicts.
    utils/config.guess, utils/config.sub, utils/missing: Updated as part of
        automake changes.
    gtk-v2/*, gtk-v2/src/*: Files related to gtk-v2 client.
    MSW 2005-03-01

    crossfire-client.spec: Update for 1.7.1 release, make some other changes that
       better match my system since I don't think anyone else is using it.
    gtk/Makefile.in: Add crossfire-client.desktop to list of files to add
      to distribution.
    README.rpm: removed - had info that didn't really apply to me making RPM
      files
    configure.in, configure: Add --disable-dmalloc option to configure.
    MSW 2005-02-28

1.7.1
=====

    configure, configure.in: Rev for 1.7.1 release
    sound-src/Makefile.in: Add files to EXTRA_DIST, fix typo so that make
      arhive works.
    MSW 2005-02-27

    Add 'show' command back in to list of commands.
    common/external.h: Change prototype of command_show() to match p_cmd.c
       prototype.
    common/p_cmd.c: Add 'show' to command dispatch table.
    gtk/gtkproto.h: rebuilt
    gtk/gx11.c: change declaration of command_show() to take const char *.
    gtk/sdl.c: Make drawsmooth_sdl() static so it won't be put into gtkproto.h
       file, which causes compilations to fail.
    x11/x11.c: change declaration of command_show() to take const char *.
    x11/x11proto.h: rebuilt
    MSW 2005-02-26

    common/metaserver.c: Once we have read in limit of number of
      metaservers, don't do anymore processing - otherwise, client just
      crashes.
    MSW 2005-02-19

    Sound cleanup and redo for ALSA9.  The bulk of this is to break out the
    alsa9 code from the cfsndser.c and compile its own separate cfsndserv-alsa9
    executable.  Add options to config file/gtk client to support setting
    which sound daemon to use.  Note that ALSA9 sound now works all
    properly - significant changes had to get made to the code for this
    to happen.
    --
    configure, configure.in:  The existence of ALSA9 sound does not preclude
       compilation of OSS sound support (or others for that matter), so change
       the logic accordingly to set variables only used for ALSA9.  Add
       SOUND_TARGETS that can be used by the makefile, change logic of
       setting SUBDIRS so we don't put sound-src in multiple times.
    common/client.c, common/client.h: Add sound_server variable.
    gtk/config.c: Add support for loading/saving sound_server line in gdefaults
       file.
    gtk/gcfclient.man: Update about -sound_server option.
    gtk/gx11.c: Update help and command line processing to support -sound_server
       option.
    gtk/sound.c: Change initialization of sound pipe to use sound_server variable
       (set by options above) instead of hard coded cfsndserv.  Path can be
       either be absolute or relative to to bindir.  Also change code so that
       pipe is set for non blocking output, so if the sound daemon gets hung
       up, won't effect rest of the client.
    sound-src/Makefile.in: Redone to handle cfsnserv-alsa9 binary.  uses
       SOUND_TARGETS to know what to build.
    sound-src/cfsndserv.c: Remove all ALSA9 code, since that is now in
       alsa9.c file.
    sound-src/alsa9.c, sound-src/common.c: Nwe files - alsa9.c contains
       logic for playing sound.  common.c is common routines.  Idea being
       that other code could get pulled from cfsndserv.c and use the common.c
       routines for parsing sound file, etc.
    MSW 2005-02-13

    common/script.c: fix broken script with a parameter change.
    gtk/help.c: use 'const gchar' instead of 'gchar' as widget text.
    gtk/win32/config.h: snprintf => _snprintf
    Ryo 2005-02-12

    Makefile.in, common/Makefile.in, gnome/Makefile.in, gtk/Makefile.in,
        sound-src/Makefile.in, x11/Makefile.in: Add ${DESTDIR} prefix for
        installation into other directories.  Patch from sourcefore #1061895
        MSW 2005-02-09

    common/external.h, common/init.c, common/player.c, common/proto.h,
        common/script.c, common/script.h, common/p_cmd.c (new file),
        common/p_cmd.h (new file), gtk/gtkproto.h, gtk/gx11.c, gtk/help.c (new
        file), gtk/keys.c, help/chelp.h, x11/x11.c, x11/x11proto.h, x11/xutil.c:
        Install command table for client side commands - makes adding commands a
        little easier, but also makes it easier to have better help.  Bulk of the
        changes are in p_cmd.c file, which pulled some code out of player.c.
        Other source files modified to clean up function parameters (all now take
        const char * as the command options).  Patch from sourceforge 1022245,
        with some work done by me.  Addition fix in gtk/keys.c unbind - buffer
        overflow would result if unbinding very long binding.
        MSW 2005-02-09

    common/client-types.h: use char instead of __int8 under Windows.
    common/commands.c: use 'const' for strings when possible.
    common/misc.c: use 'const' for strings when possible.
    common/newsocket.c: use 'const' for strings when possible.
    common/player.c: use 'const' for strings when possible.
    common/proto.h: use 'const' for strings when possible.
    gtk/gx11.c: use 'const' for strings when possible.
    gtk/keys.c: fix a buffer overflow in 'unbind' when displaying keys. Use
       'const' for strings when possible.
    gtk/win32/config.h: don't define 'G_DISABLE_CONST_RETURNS' anymore, strings
       are now correctly const.
    Ryo 2005-02-05

    Makefile.in: Fix up distclean directive to go into all directories.
    configure.in, configure: Fix configure so the --enable-feature and
       --disable-feature flags follow proper standard (from patch on
       sourceforge).  Add check for -lossaudio.  Modify check for
       -lSDL_image library - don't require it for SDL support (if we
       have it, we'll use it, but for newer versions of SDL, it doesn't
       seem to exist anymore)
    common/client-types.h: Minor formatting change.
    common/script.h:  add defines for PF_LOCAL and AF_LOCAL if they are
       missing.
    gtk/Makefile.in: Install man page into section 6.
    sound-src/Makefile.in: Fix up depend command - had wrong variable.
        Fix up distclean to remove automatically generated files.
    x11/Makefile.in: Install man page into section 6.
    MSW 2005-02-04

    gtk/gx11.c: send text first, then close popup. Else won't work under
      some circumstances, text is empty. Fix party password dialog containing
      only ':' (missing case in dialog handling).
    Ryo 2005-01-07

    common/script.c: add 'signal.h' header, needed for NetBSD.
    gtk/keys.c: fix buffer overflow when binding a very long command.
      This fixes bug #1085729.
    gtk/win32/config.h: fix S_ISDIR macro, even if not used.
    Ryo 2004-12-21

    gtk/win32/config.h: Add parentheses around arguments of sleep and usleep
      macros.
    Andreas Kirschbaum 2004-09-19

    common/script.c: warn when script start failure (Linux), patch courtesy Kevin Rudat.
      Check there actually is a parameter to 'script', else that'd crash nicely.
    Ryo 2004-08-16

    gnome/gnome.c, gtk/gx11.c: Fix improper access to history buffer variable.
    Andreas Kirschbaum 2004-05-24

    gtk/gx11.c: Comment out printing of size when we receive config event.
    gtk/image.c: Remove some superfluos LIL_ENDIAN code that would never
      be used because it was already in an #ifdef LIL_ENDIAN/#else block.
      Fix up freeing of data - need to free the pixel info before freeing
      the surface, don't free the fog pixels since SDL will do that for us.
    MSW 2004-05-15

    gtk/image.c: Patch from bug list to fix compilation on big endian
      machines.
    MSW 2004-05-11

    gtk/gx11.c: Fix configure_event() to only allocate new data structures if
      the size of the map area has in fact change.  This fixes a major memory
      leak, as it seems gtk erroneously generates configure events.
    gtk/map.c: Clean out some commented out code, clean up the formatting of the
      draw_map function - no actual code change.
    MSW 2004-05-08

1.7.0
=====

    common/client.h: synced client version to 1023.
    gtk/win32/config.h: changed version numbers.
    gtk/win32/gtkclient.nsi: added scripting documentation. Checks for GTK.
    gtk/win32/Win32Changes.txt: updated.
    Ryo 2004-04-25

    gtk/win32/porting.c: tweaked SDL's sound support to use panning information.
       Added missing header files.
    Ryo 2004-04-11

    gtk/win32/porting.c: implemented basic sound with PlaySound.
    gtk/win32/gtkclient.dsp: added winmm.lib to link list.
    Ryo 2004-04-11

    This is related to Win32 scripting. It now works correctly thanks
    to archaios's patch. I tweaked it some, so if it doesn't work,
    my mistake :)

    common/metaserver.c: call 'script_killall' under Win32 when exiting.
    common/script.c: some Win32-specific magic to make it work.
    common/script.h: add Win32-specific function.
    gtk/gtkproto.h: Win32-specific function.
    gtk/gx11.c: call the scripting functions for Win32, not like other platforms.
    Ryo 2004-04-04

    common/metaserver.c: use 'draw_info' to report being unable to connect
       to metaserver. Also changed failure color from red to black, so it appears
       after the 'trying to connect' even in split window mode.
    gtk/gx11.c: correctly refresh text windows so failure messages appear.
    Ryo 2004-03-12

    gtk/keys.c: Windows now uses default 'keys' file if player file not found for
       key loading.
    Ryo 2004-03-04

    configure.in: Remove checks for gnome libraries, since we no longer use
    gnome/build a gnome client.
    aclocal.m4: downgrade requirement for needed autoconf version.
    MSW 2004-02-05

    common/init.c: changed 'printf' to 'LOG' for HOME Win32-warning
    Ryo 2004-02-01

    common/image.c: fix stupid crashing mistake.
    common/rcs-id.h: remove ; after #define
    gtk/rcs-id.h: remove ; after #define
    gtk/sound.c: #ifndef WIN32 for cfsndserv specific parts
    Ryo 2004-01-30

    all .c files:
    all Makefile.in:
    all rcs-id.h:
       Basic logging is now complete. All console messages sent by
       client are now sent to LOG(). All source files versions have
       are sent to LOG() at startup too (except for the still non
       compilable gnome client!). Gtk client can show the Logs in
       'Help -> Report a Bug' along with a small doc on how to bug report
    Tchize 2004-01-30

    Documentation/
       Have added a Documentation directory. It contains a first
       basic how-to related to client side scripting with two examples.
    Tchize 2004-01-29

    Those fixes are all Win32-specific, except the last one on keys.c
    common/commands.c: Use correct Win32 function for closing socket.
    common/image.c: Added missing headers, use correct mkdir syntax.
       Change a call to 'read', to be on the safe side.
    common/misc.c: Added missing headers, use correct mkdir syntax, stub
       functions not yet ported.
    common/player.c: Use correct Win32 function for closing socket.
    gtk/gx11.c: Disabled bug window font setting, as GTK2 apparently doesn't
       use the same fonts. Use correct function for closing socket.
    gtk/keys.c: Don't display 'Key unused' for left-alt & windows key
       (as they are often used to switch away from CF).
       Also fix a potential use of a variable not initialized (rare
       line corruption case)
    Ryo 2004-01-29

    common/client.c: Win32-specific fixes.
    common/metaserver.c: small Win32 fixes, explicitely cast meta_sort
       in qsort.
    gtk/config.c: Win32-specific fixes.
    gtk/map.c: added Win32-specific <time.h> header.
    Ryo 2004-01-27

    common/item.c: check supplied argument to remove_item_inventory is
       not NULL.
    Ryo 2004-01-25

    gtk/map.c, gnome/map.c: Apply patch by kirschbaum@myrealbox.com which fixes
    improper coordinate comparision.
    gtk/gx11.c: Remove some unused declarations.
    gtk/map.c: always set the cleared flag as spaces come into view.
    MSW 2003-11-28

    gtk/gx11.c: fixed invalid level display for skills under Win32
        (int64 issue, %lld doesn't work under Win32)
        Also removed dumb Win-newlines from previous commits.
    Ryo 2003-11-22

    common/client.h: readded (Win32 only) player's name. Used for specific
       key bindings file loading/saving.
    common/script.c: made dummy functions to correctly compile under Win32.
       Actual implementation will come someday :)
    Ryo 2003-11-10

    x11/x11.c: Fix button pressing in the game window so it properly deals with
       non standard size maps.
    MSW 2003-10-26

    Those fixes are for Windows compilation ('for Windows' is implicit everywhere).
    Most code was borrowed from Philip aka Somebdy's previous GTK port.
    Note: the changed code is embedded in #if(n)def WIN32 / #endif.
    ---
    Win32-Readme.txt: added to tell about supported clients under Windows.
    common/client-types.h: Windows-specific typedefs.
    common/client.c: missing include fixed, changed fcntl for ioctlsocket.
    common/image.c: forced opening of files in binary mode to avoid bad troubles.
    common/init.c: make sure HOME is set, to correctly find paths.
    common/metaserver.c: made it work, with a specific function (fgets can't work).
    common/newsocket.c: fix GetInt64_String. Make write_socket and SockList_ReadPacket work.
    gtk/config.c: use correct header file
    gtk/gx11.c: fix bad header files. Fix g_free() / free() issue. Catch player's name
        to load specific keys. Fix score display issue. Other specific stuff.
    gtk/gx11.h: fix undefined X-Window specific type (Window).
    gtk/image.c: fix headers.
    gtk/keys.c: fix headers. Key file uses player's name, when known. Fix input
        issue with 'entrytext'. Fix missing KeyCode type.
    gtk/map.c: fix headers.
    gtk/png.c: fix headers.
    gtk/win32: Windows specific files.

    Ryo 2003-10-26

    common/client.h, common/newsocket.c: Remove 'extern in errno' lines -
      errno.h is included, which takes care of the problem.
    MSW 2003-10-25

1.6.0
=====

    common/commands.c: Clean up some formatting.
    common/item.c: Add num_free_items() to try and help see some memory
       laakage.
    common/player.c: Add num_free_items command which calls above routine.
    gtk/gx11.c: Fix movement/firing by using mouse pointer.  Map size was
       hard coded in, so didn't work correct if non standard map size was used.
    MSW 2003-10-09

    Add an option to the gtk client which controls what happens when you use apply
    to cycle through containers.  It used to be closed->applied->open->applied.
    Now, if you select the config option, it goes closed->applied->open->close->..
    common/client.h: Add new config variable.
    common/commands.c: Remove some dead commented out code.
    common/init.c: Update save name for config value.
    gtk/config.c: Update to have menu option in config window.
    gtk/gx11.c: Change close_container() to send/not send apply based on setting.
       Add close_container_callback() which is used for the 'close' button,
       which has to always send the apply command.
    MSW 2003-10-08

    common/commands.c: improve expand_face() - there was the problem if multipart
       object that overlapped not always being drawn properly.  This is because
       expand_face would basicaly put the first one it received on the lower
       stack - this is fine if you came from above, but was incorrect if you
       approached from the south.  expand_face() now checks to see which one
       should overlap the other, based on where the coordinates would put it.
    MSW 2003-10-07

    Bulk of this commit is to fix big image support for the X11 client.
    common/client.h: Add a couple new defines to denote how big the largest
       image may be, minimum reasonable map size for the_map structure,
       and how far off the map a head could be.
    x11/png.c: Remove hard coded values of images being 32 pixels wide/high.
       Also, store away actual size of images, needed for big image stuff
       to get filled in properly.
    x11/x11.c: Add an error handler to make it easier to catch bugs
       (gets real stack trace instead of the program exiting).  Fix
       up the gen_draw_face to properly draw big images, change
       call to allocate map to pass in new larger values.
    x11/x11.h: Add width, height values to Pixmap data structure.
    x11/xutil.c: Change the routine to recenter virtual map some - we need
       to take into account that there can be big images, so include that
       value in when seeing if we are too close to the map edge.
    MSW 2003-10-05

    common/commands.c: Add call to reset_player_data() - necessarily for
        data to be sanely displayed for next time player logs in.
    common/init.c: add reset_player_data - clears out skill data.
    gtk/gx11.c: Add code to erase skills that current player doesn't know.
       Some alternative map drawing code also in place, but disabled.
    gtk/gx11.h: Add ALTERNATE_MAP_REDRAW define.
    gtk/sdl.c: Add check for ALTERNATE_MAP_REDRAW.
    MSW 2003-09-12

    common and gtk:
       Client understand the smoothing protocol and the gtk client is
       able to draw the smoothing information.
    Tchize 2003-07-08

    gtk/gx11.c: Change skill experience display - instead of skill
       name and exp/level being the same string and same table element,
       add additional columns, so the skill name is in one, the exp/level
       in another.  IMO, this makes for cleaner display, as the exp
       totals for the different skills then line up better.  Also, fix
       some display bug when new skills need to be displayed.
    x11/x11.c: Fix bug where stipple patterns where being improperly
       displayed/retained in fog of war and darkness modes.
    x11/xutil.c: always set cleared and need_update flag for map scrolls -
       fixes bug of big objects (griffons for example) not being drawn
       properly.
    MSW 2003-05-25

    x11/x11.c: Add darkness and fog of war tiling stipling, so it is now
       clearer what spaces are dark and which spaces are fog of war
       spaces.  Add -fogofwar and -nofogofwar command line options.
    MSW 2003-05-18

    Bulk of this change is to support the upcoming split skill experience system.
    skill names are now sent to the client.  Backwards compatibility with older
    servers is in place - however, the client will now only show those skills
    which the player has a non zero exp total in the stat window.
    --
    configure, configure.in: Add checks for size of long and long long - needed to
       have 64 bit types.
    common/Makefile.in: modify proto to define CPROTO so we can avoid including
       proto.h when cproto runs.
    common/client-types.h: Add checks to define uint64/sint64 types.
    common/client.c: Modify setup command to send 'exp64' request.  Change
       definition of skill_names.
    common/client.h: Make MAX skilled tied in with CS_NUM_SKILLS.  update exp and
       skill_exp to 64 bit types.  Don't include proto.h if CPROTO is defined.
    common/commands.c: Add get_skill_info() which gets skill number->name mapping.
       Add code to handle exp64 setup request/failure.  Update StatsCmd to support
       64 bit exp for new skill mapping, as well as 64 bit overall exp for player.
    common/config.h.in: Add SIZEOF_LONG and SIZEOF_LONG_LONG for autoconf.
    common/external.h: Add menu_clear() protoype.
    common/init.c:  Add code to init skill values/names.
    common/newclient.h: Resync from server code.
    common/newsocket.c: Add GetInt64_String() function.
    common/proto.h: rebuilt.
    gtk/gx11.c: always include errno.h.  Modify layout of skill exp table
       (properly set up rows/columns).  Add some padding to the entries, and don't
       pre-set the names.  Modify draw logic to handle 64 bit values.  Modify draw
       to only draw skills which player has exp in.
    x11/x11.c: update draw logic to handle 64 bit exp values, only draw
       skill exp when player has exp in the category.
    MSW 2003-05-17


    common/client.c: Add some usleeps()  in negotiate_connection() - this reduces
       cpu load when negotiating the connection (given 10 ms for data to actually
       come in before checking for new data).  Also, add a count and if we don't
       get a response back from the server in the time frame, bail out.
    MSW 2003-03-24

    configure.in, configure: checks added for alsa9 sound - update for cfsndserv.c
       should come shortly.
    common/client.c: Fix setup problem - it was using FOGWAR setting when
       determining if client wanted darkness - should have been using darkness
       setting.  This was resulting in darkness not being used if fog of war was
       turned off.
    x11/x11.c: Modify handling of mouse button press logic - rather than only
       modifier being shift, do appropriate logic if the shift mask is set,
       but does not have to be only modifier set.
    --
    The following bits changes how fog of war looks in SDL mode.  Now, fog of
    war spaces are drawn in greyscale, instead of half darkness.  This makes
    it clearer what the status of the space is (fog of war/darkness).  This change
    probably uses less cpu to draw, but uses more memory for the images (as it
    now has to store a rendered greyscale image).  If not using SDL, you'll still
    have the old behaviour (dimmed spaces for fog of war), and no significant
    amount of extra memory will be used.
    --
    gtk/gx11.h: Add fog_image pointer to PixmapInfo structure.
    gtk/image.c: Add code to render greyscale image.  Also add code to free
       greyscale image.
    gtk/sdl.c: Modify map draw code to use grey fog image if space is fog of
       war space.  Disable dimming of fog spaces - no longer necessary as
       space now looks different.
    MSW 2003-03-24

1.5.0
=====

    gtk/png.c, x11/png.c: Fix bug in rescale_rgba_data() that was potentially
        causing a 1 byte overrun of malloc'd data, that could result
        in crashes or other odd problems.
    MSW 2003-02-19

    common/init.c: Make sure we initalize all the config values.
    gtk/gx11.c: fix foodbeep - now only beep when food is low, and continue
       to beep when food reaches 0.
    sound-src/Makefile.in: Remove gx11.c in depend statement.
    MSW 2003-02-04

    gtk/config.c, gtk/gx11.c: remove including some files which we don't need included.
    gtk/keys.c: Modify to not use X11 for keybinding - instead, uses gdk
        functionality - this should make it more portable.
    MSW 2003-01-22

    Patch by scachi@gmx.de to add different display options for the players
    resistances.
    common/client.h: increase CONFIG_NUMS and add CONFIG_RESISTS
    common/init.c: extend resists_table, initialize resist value to proper
       value.
    gtk/config.c: Add config option for selecting different options for
       resistance displays.  Add comment about radio button usage.  Increase
       size of config window.
    gtk/gtkproto.h: rebuilt.
    gtk/gx11.c: Update get_message_display to support different resistance
       display options.  Add resisze_resistance_table function.  Disable
       code the causes the message window to get relocated next to the
       stats display on wide displays.
    MSW 2003-01-12

    x11/x11.c: Patch by Jochen Suckfuell that fixes problem of lines
       printed out while entering extended commands causes the extended command
       line to get overwritten - the extended command line is now copied to the
       next line.
    common/client.c: Add handling of client if it loses its connection to
       server during setup phase.
    common/newsocket.c: Have SockList_ReadPacket return -1 if it gets
       a real error on read - in this way, callers can tell if error is
       terminal or retryable (return code 0)
    MSW 2003-01-03

    common/player.c: Break out some of the extended commands into there
       own function to make the extended_command function more readable.
       Alphabetize strcmps in extended_command.  Add special processing
       for the 'take' command so that it handles open containers properly.
    gtk/gx11.c: Add version information to the About dialogue box.
    gtk/key.c: Fix bug in that extended commands (') didn't work right and
       would crash the client if not entered in info window.  Entering
       these now works properly, and crashes are removed.  Clean up formatting
       of affected function keyfunc().
    help/about.h: Add extra newline to text to make it look better with
       the version string above.
    MSW 2002-11-30

    gtk/gx11.c: Add patch by jshelley@ictransnet.com that fixes save window
       positions.  MSW 2002-10-03

1.4.0
=====

    common/image.c: Fix bug of not fulling clearing the cache entry
       data after allocation.  This resulted in various random crashes
       when using cached image mode.
    x11/x11.c: Add note about -facset.
    CHANGES, Makefile.in, configure, configure.in: Update for 1.4 release
    MSW 2002-09-14

    common/item.c: Update comment about possible sorting improvements.
    gtk/gx11.c: Add missing foodbeep functionality to GTK client.
    MSW 2002-08-13

    gtk/config.c: Fix crash when trying to apply config changes when compiled
       with SDL support but user is not using it.  Fix bug where settings
       were not being properly updated.
    gtk/sound.c: initialize sound_pipe to NULL, and have init_sounds close
       the sound pipe if there is currently one open - fixes bug when switching
       sound control many times in that multiple cfsndserv processes could get
       started.
    MSW 2002-07-25

    Makefile.in: if no makedepend, don't run make depend directive.
    README: Add not about ALSA revisions and possible problems compiling.
    MSW 2002-07-10

    This commit adds graduated colored statbars to the gtk client.  What
    this means is that the color of the statbar goes smoothly from red to yellow
    to green depending on what percentage of your hp/sp/grace/food is compared
    to your maximum.  To use this, you need to go to the config pane and hit
    the 'gradually change stat bar color' button.
    common/client.h:  Add CONFIG_ value for this, increase CONFIG_NUMS.
    common/init.c: Add "grad_color_bars" to config_names array.
    gtk/config.c: Add button to select this behaviour.  Move all the
       special config checks to beyond the for loop that checks the values
       in apply_config().   There is no need to check all the values on each
       loop.
    gtk/gtkproto.h: Rebuilt for inclusion of reset_stat_bars()
    gtk/gx11.c: Add two styles to the Vitals (stat bar) structure so we can
       alternate between them.  Default is to initialize one for green and the
       other for red (in non graduated color mode).  This should be more efficient
       then allocating a new one each time we need to change the value.  add
       reset_stat_bars() to reset the colors of the styles to red and green -
       needed because the graduated color code will change the colors of these.
       Remove code that freed these styles.  Modify draw_stat_bar() to draw them
       in color or simple mode, in simple mode, we now just need to use the
       appropriate style and not allocated a new one.  Modify
       draw_message_window() to pass bar values greater than 1 to the
       draw_stat_bar() function - in graduated color mode, we draw such values
       with a blue tinting (more blue the more over it is).  draw_stat_bar() knows
       how to properly deal with these higher values.
    MSW 2002-07-04


    gtk/config.c: Fix setting of radio button set state - it was always setting
       the same (last) radio button as the active button, which did not match
       state - now it sets the proper button active - this is for the lighting
       control toggle.
    gtk/map.c: Add/subtract 2 to the need_recenter_map function - in this
       way, code that checks known display position +/-1 will still be within
       map array.
    gtk/sdl.c: Fix per pixel (fastest and best) lighting code - this got
       broken quite a while - it was looking to see if the coordinates for the
       map structure where within range, and not the real coordinates.  Since
       the map coordinates would almost never be within range, the effect was
       that the per pixel effects more ore less looked like the per tile
       effects.
    MSW 2002-07-03

1.3.0
=====

    Add support for the 'item2' command.  This lets us get the item type
    from the server so that we don't need to figure it out for ourselves.
    Also, remove support for the 'item' command - that has long since
    been obseleted by the 'item1' command.
    --
    common/client.c: Remove 'item' from dispatch table, add 'item2'.
       Add 'itemcmd 2' as part of setup command we send to server.
    common/commands.c: Add handling for response of 'itemcmd' setup command from
       server.  Remove ItemCmd() function.  Add type to calls to update_item().
       Change Item1Cmd() function to be called common_item_command() since both
       item1 and item2 use almost exactly the same logic.  Add Item1Cmd() and
       Item2Cmd() which just call common_item_command()
    common/item.c: Init item types to 'NO_ITEM_TYPE'.  Remove get_nrof() as it was
       no longer being used.  Add type argument to set_item_values() and
       update_item().  Simplify code in case of name handling, since we know that
       we will be using at least the 'itemcmd'.  Don't worry about getting proper
       nrof for the player object - its nrof isn't really meaningful anyways.
    common/item.h: Add #define NO_ITEM_TYPE.  Update type field in item
       to be 16 bits.
    common/proto.h: rebuilt.
    MSW 2002-05-30

    The bulk of this checkin adds support in the client for the map1a protocol
    command and the display of big images properly in the map window.  A lot
    of code cleanup was also done however, including removal for the support
    of the 'map' (original) command.  The map1 has been in the server code for
    quite a while.

    TODO: Update what needs to be done for the x11 client.
    common/client.c: Remove map command, add map1a command to dispatch table.
      Modify setup we send to server to always try to use the map1a command -
      there is no reason not to use it.
    common/client.h: Change some of the CONFIG_ values - basically, change it
      so that there is just one entry for lighting configuration, but it can
      have any number of values.  Modify MapCell so that instead of having
      multiple arrays for the different values (faces, sizes), add a MapCellLayer
      structure that contains the specific face information for that layer.
      Move the PlayerPosition struct and value to this function so that more
      of the map decompress logic can be handled in the common code.
      Remove count value from MapCell since it wasn't really being used.
    common/commands.c: Add code to set the use_config[CONFIG_CACHE] value based on
      what we get back from the server.  Add code to check the setup response for
      the for the map1a and map1 options.  Add code to deal with expanding big
      images into appropriate spaces.  Move some functions from the gui portion to
      (display_map_clearcell, set_map_face).  Add code for map1_common function to
      deal with map1a extensions.
    common/external.h: Remove display_map_clearcell and set_map_face from list of
      external functions.  Add get_map_image_size function.
    common/init.c: change some values of the config values.  Update initialization
      of config values for lighting.
    common/proto.h: rebuilt.
    gtk/config.c:  Add new button for lighting - best per pixel. Modify code
      to properly deal with how lighting preference is now stored.  Add legacy
      support for loading of per_tile_lighting and per_pixel_lighting values
      from config file.  Add diagnostic of bad value if selected map/width
      is out of range.
    gtk/gtkproto.h: rebuilt.
    gtk/gx11.c: Change formatting of draw_list.  Modify it so that it adjusts
      the column/row width based on the largest image it needs to display - In
      this way, if a player stands on a big building, the entire building is
      displayed in the look list.  add row_height and column_width values so we
      only need to call the function to change them if they are in fact different.
      Add +sdl command line option to disable sdl code.  Modify gtk_draw_map to
      include redraw parameter.
    gtk/gx11.h: remove PlayerPosition structure. add row_height, column_width
      elements to itemlist structure.
    gtk/image.c: Add table that is used to determine the scaling used for big
      images in the look list - in this way, big images still appear big, but not
      necessary 2 or 3 times bigger.  Modify create_and_rescale_image_from_data to
      use this logic.  Add get_map_image_size which the common code uses to
      determine the number of spaces an image may be.
    gtk/map.c: remove display_map_clearcell and set_map_face functions - now in
      common code.  Modify the dump map/darkness routines to use the new format of
      the MapCell structure.  Modify set_darkness to only set adjoining spaces for
      needing an update if lighting type is set that needs this.  Remove
      display_map_addbelow - only used for 'map' command.  Modify logic of
      fog of war code to have it done all at display time - not when setting/clearing
      a cells contents.  Modify gtk_draw_map - this basically follows the same
      logic of sdl_draw_map - it is now better optimized to only draw the spaces
      that have changed, and not the entire map - this should improve performance
      considerably.
    gtk/sdl.c: Remove #if 0 around putpixel - used for best lighting.  Change
      indention of init_SDL - modify it so that if just_lightmap is true,
      that really is the only thing that is changed.  Modify per_pixel_light
      code to use both methods of per pixel lighting depending on player prefernce.
      Modify sdl_gen_map to properly handle draw portion of big images.
    x11/png.c: Add get_map_image_size function.
    x11/x11.c: modify display_mapcell_pixmap to use new format of MapCell
      structure.  Remove reference to count in MapCell structure.
    x11/x11.h: Remove PlayerPosition information - now in common code.
    x11/x11proto.h: rebuilt.
    x11/xutil.c: Remove display_map_clearcell and set_map_face functions.  Modify dump map
      code for new MapCell structure layout.  Remove display_map_addbelow funtion.
    MSW 2002-05-21


1.2.1
=====

    Makefile.in: Add pixmaps/question.sdl to archive list.
    configure, configure.in: Update for 1.2.1 release.
    MSW 2002-04-28

    gtk/config.c: Allocate string data for want_faceset - data returned by
       gtk_entry_get_text is non persistent.  MSW 2002-04-28

    gtk/gx11.c: Fix bug in that the wrong variable was being passed to
       negotiate_connection, resulting in the sound not being properly
       communicated to the client.  MSW 2002-04-19

    Main change is to make all the configuration options now available in the
    configure window in the gtk client.  The way all the various values was
    stored was changed around, so it is now pretty trivial to add any future
    options.  For the most part, most of the logic of the other code is
    unchanged - one thing that is different is that the clients use the larger
    virtual maps that are normally used for fog of map - this means that fog
    of war can be turned on and off.
    There are probably some bugs in this, but it seems to basically work -
    no horrendous bugs that I noticed that prevent it from working at all.
    -
    common/client.c: replaced config values with new system.  Always
       send setup mapredraw 1 to server to make toggling for fog of war easier,
       and it doesn't use any significant bandwidth.
    common/client.h: Add new value configuration system/defines.  remove
       the old values.
    common/commands.c, common/image.c,common/metaserver.c,common/player.c
        : update for new configuration value system
    common/init.c: Add config_names which is used for the load/save logic.
       update the init and clear functions to set up new values.
    gtk/Makefile.in: add config.c file.
    gtk/gtkproto.h: rebuilt.
    gtk/config.c: New file - holds the config creating code, as well as the
       load and save for the gdefaults file.
    gtk/gx11.c: Remove some widgets now in config.c, move itemlist to
        gx11.h, remove some other values that are in the new configuration
        scheme.
    gtk/gx11.h: Moved several structures and externs from gx11.c to gx11.h
        so they are available to config.c.  Remove several values that
        are done with the new config arrays.
    gtk/image.c, gtk/keys.c, gtk/sdl.c, gtk/sound.c:
        : update for new configuration value system
    gtk/map.c: update for new configuration value system, modified so that
        fog of war map logic is used all the time.  Change allocate_map to
        no longer refer to map_size global - use the x and y values in the
        map structure.
    x11/x11.c: update for new configuration value system - the x11 portion
        still uses the old load/save method - this should get converted.
        Many of the options available in the gtk client have no corresponding
        use in the x11 client.
    x11/x11.h: update for new configuration value system
    x11/xutil.c: update for new configuration value system.  Most of the map
        logic is now synced up with the gtk/map.c
    MSW 2002-04-03


    configure.in, configure:  Fix the --disable-sound configure option (when used,
    it won't look for sound support, and will not build the sound-src directory).
    Likewise, if that option is not used but configure does not find any supported
    sound systems, it also will not build the sound-src directory.  MSW 2002-03-31


    Various fixes/enhancements:
    1) For the files stored in the players cache, include the image set suffix
       (eg, base, clsc) when saving the file.
    2) Add a gui update element to the gtk client when running with -download_all_faces.
       For the cfclient, print the updates to the window.
    3) Apply patch by 'Alfie' that shows skill experience in the cfclientp
    4) Fix caching bugs with the cfclient that caused it to not work right.
    common/client.c: Add callbacks to image_update_download_status from the
        download all image routine.  It is this callback that provides whatever
        update mechanism for the player.
    common/external.h: add image_update_download_status
    common/image.c: Modify display_newpng to put in the image set name of the
        saved cache files if that information is available.
    gtk/gtkproto.h: rebuilt.
    gtk/gx11.c: Make get_window_coord non static so other files can use it.
    gtk/image.c: Add image_update_download_status that draws a progress bar.
       Convenient side effect is that other GUI elements are now updated
       as part of this, so player can access other menu items.
    x11/png.c: Fix some bugs when using cached images - rgba_to_xpixmap was
       using initialized bpp value - we now know this is always 4.
       create_and_rescale_image_from_data did not match the parameters
       as the common routines use.  Also missing some logic for
       allocating the data and linking it back to the cache entry.
    x11/x11.c: Add display for skill experience.  This necessitated making
       some of the windows bigger.
    x11/x11.h: Remove now unused fields from PixmapInfo structure (fg, bg,
        bitmap)
    x11/x11proto.h: rebuilt
    x11/xutil.c: Remove code that was storing data into the unusued
        fields in the PixmapInfo structure.  Add missing call to
        init_common_cache_data.  Add image_update_download_status
        function that just does a draw info.
    MSW 2002-03-26

    Many changes to image handling.  The most noteworthy are:
    1) Ability to use different image sets.
    2) Ability to get checksums of all images and download missing images
       before play starts.
    3) Storing cache information for images in a bmaps.client file so that
       it can know if it has a match without needing to load the image
       and checksum it.
    4) Can use crossfire-image archives to bootstrap the client with a large
       number of images to save the time of downloading them later.
    README: Update some out of data information about sounds, add section
       describing the image handling.
    configure,configure.in: Make the SOUNDDIR be based and datadir and not
       an absolute path - this means using a different -prefix changes
       the location of where it will find the sound file.  Moved some
       of the defines into the config.h file so that we don't need to pass
       them as -D compiler options.  Add code to properly substitute
       DATADIR and BINDIR values.
    common/Makefile.in: Add image.c to list of files.  Fix depend
       directive.
    common/cconfig.h: Remove some options that no longer did anything.
    common/client.c: clean up some unused global variables, add a few new ones.
       and support for replyinfo protocol command.  Modify negotiate connection
       to issue requestinfo requests, set up face set to use, use
       setup command to set caching behaviour, and support for it to download
       all image sums and missing images before play starts.
    common/client.h: Update VERSION_SC to 1027.  Remove some unused
       global externs.  Add FaceSets structure, Face_Information structure,
       the later which holds some user preferences.  Add Cache_Entry
       structure, as well as some state when negotiating the connection.
    common/commands.c: Add ReplyInfoCmd function.  Move FaceCmd
       to common/image.c.  Add handling of received setup command for
       faceache and faceset information.  Remove some dead code.
    common/config.h.in: Add BINDIR and DATADIR defines so we don't need to
       pass them on the command line.
    common/external.h: Add some more functions that are called back from the
       common area.
    common/image.c: New file - cache logic, png image load code, and protocol
       image related commands in this file.  This removes some of the code
       that was previously in the GUI area of the client into a common area.
    common/init.c: Add TEST_FREE_AND_CLEAR macro.  Add code to clear
       some of the newly added structures.
    common/proto.h: rebuilt.
    gnome/gnome-cf.h: remove cache_images extern.
    gtk/gcfclient.man: Update man page for new options (-download_all_faces,
       -faceset)
    gtk/gtkproto.h: rebuilt.
    gtk/gx11.c: add redraw_needed flag so the map window is properly redrawn
       when caching images and new images show up.  Change some other
       variables to deal with new image code.  pixmaps changed to a pointer
       so that a copy can be held in the common cache structure.  Add support
       for new options.  Remove some code that is now in the common/image.c
       file.
    gtk/gx11.h: Remove keepcache, change cache_images, add redraw_needed,
       and change type of pixmaps to be a pointer.
    gtk/image.c: Move requestface to the common/image.c, change pixmaps
       to pointer type.  remove finish_face_cmd and ReadImages command.
    gtk/map.c: Change pixmaps to pointer types.
    gtk/sdl.c: add redraw paramter to sdl_gen_map.  change pixmaps type
       to pointer.
    gtk/sound.c: Add missing / when running cfsndserv.
    x11/png.c: Remove gdk related code from the file.  Add rgba_to_xpixmap
       data so tha the common area can load the png file.
    x11/sound.c: Add missing / when running cfsndserv.
    x11/x11.c: change pixmap type to pointer.  Add new options (-faceset and
        -download_all_faces).  Remove -keepcache option.  change
        cache_images to face_info.cache_images.  Change how the
        pixmaps are generated
    x11/x11.h: remove keepcache and cache_images variables.  Change
       pixmaps to pointer type.
    x11/x11proto.h: rebuilt.
    x11/xutil.c: remove keepcache option.  Change pixmap type to pointer.
        Move requestface and finish_face_cmd to common/image.c
    MSW 2002-03-25

1.2.0
=====

    Makefile.in: add missing pixmaps file for archive.
    crossfire-client.spec, configure.in: Update for 1.2.0 release.
    MSW 2002-03-19

    Most of the changes are by Edgar Toernig - I've just applied them and
     checked them in.  The stripping out of the display_mode variable is
     my doing however.
    configure.in, configure: Add check for zlib before png lib check, as on
       some systems, png requires -lz.
    common/client-types.h: Add #ifdef check for SOL_TCP
    common/client.c: Add fast_tcp_send variable, comment out printing of error
       from socket EOF.  Use TCP_NODELAY for sending data to the server
       if TCP_NODELAY is available.  cs_write_string modified to use
       cs_print_string.
    common/client.h: Remove display_mode enum, add fast_tcp_send extern.
    common/commands.c, common/init.c,gtk/image.c, gtk/map.c
        cs_write_sting modified to use cs_print_string
    common/external.h: set_autorepeat extern added.
    common/newsocket.c: Modified to be better optimized for using TCP_NODELAY -
      cs_print_string function added.
    common/player.c: modified to use cs_print_string , autorepeat client side
      command added.
    common/proto.h, gtk/gtkproto.h: updated with new functions
    gnome/gnome.c: display_mode variable removed, cs_write_string
      replaced with cs_print_string
    gtk/gx11.c: display_mode variable removed, cs_write_string replaced with
      cs_print_string, -nofog option added
    pixmaps/question.111: Resized to be 32x32
    pixmaps/*.xbm - used for inventory icons in X11 client, replacing xpm
      files
    sound-src/cfsndserv.c: Better error handling, include time.h
    x11/cfclient.man: -font and -noautorepeat options added.
    x11/png.c: better error checking for rescaling images
    x11/x11.c: noautorepeat variable added, display_mode removed, image icon
      functionality re-enabled, images now created from xbm files,
      set_autorepeat function added, add ability to set font, add mouse
      wheel support
    x11/x11.h: remove screen_num extern.
    x11/x11proto.h: Updated with new functions.
    x11/xutil.c: Modified to use image_size instead of hardcoded 24x24 value
      for the status icons.  cs_write_replaced with cs_print_string, no
      auto repeat functionality added.
    MSW 2001-01-14

1.1.0
=====

    README: Update notes on needing png (and not xpm) library.  Update mailing
        alias.
    configure.in, configure: As the separate sound program (cfsndserv) is the
        only supported sound configuration, remove new_sound_system defines
        and ability to use the old (now non existant) sound system.
        Have configure exit with error message if png library is not found,
        as it is critical to the build process.  Change it so that
        gnome/Makefile is always built so that making of releases works.
    gnome/gnome-cfclient.man, help/about.h, x11/cfclient.man: Update mail address.
    gtk/gtkproto.h, x11/x11proto.h: Rebuilt, prototypes for some changed for
        signed to unsigned characters.
    gtk/gx11.c, gtk/png.c, pixmaps/stipple.111, x11/png.c, x11/x11.c, x11/xutil.c,
        pixmaps/stipple.111 pixmaps/stipple.112:
        Mostly changes to fix compile warnings and make sure we are passing the
        right types to the various image creation functions (8 bit data).
    sound-src/Makefile.in: Add soundsdef.h to list of things to build.
    x11/x11.h: Remove extra semicolon.
    MSW 2001-12-28

    common/config.h, gnome/gnome-cfclient.soundlist, sound-src/sounds,
        sound-src/soundsdef.h: Remove from CVS as it gets automatically generated
       as part of configure/build process.
    common/player.c, gtk/keys.c: Send valid count values when sending a fire
       command.  Some spells use the count value (eg dimension door).
    gtk/gx11.c: Minor change to the trim_info_window code - still causes
       periodic crashes in the gtk code however.  Modify style code so that
       if we don't get a valid style, we don't crash the client.
    MSW 2001-11-25

    gtk/gx11.c: Made the inventory lists respect the user's GTK font settings,
      and made the various window parts use the font size to decide what size
      to make the displays and the window.  TSB 2001-11-21

    configure.in, configure: Modified so that if not compiling the
      gnome client, we don't create the gnome Makefile.  MSW 2001-11-05

    gtk/gcfclient.man: Add -timemapredraw documentation to man page.
    gtk/gx11.c: Update size of buffers to 100k, instead of 10k.  Add some
       debugging information to when info window is trimmed.  Add -timemapredraw
       command instead of it being a compile time option.
    gtk/gx11.h: Add extern for time_map_redraw.
    gtk/map.c,gtk/sdl.c: use time_map_redraw variable instead of define option.
    MSW 2001-11-04

    gtk/gcfclient.man: Update man page to include all options supported
       by gtk client.
    gtk/gx11.c: remove some unused #defines.  add -trim_info_window option which
       takes place of compile time option.  Re-order command line switches to
       be in alphabetical order.  Add support for client to load/save most all
       new options to the gdefaults file.
    gtk/map.c: Some refinements to fog of war so if a space is empty, don't
       mark it as a fog space to improve performance.  Modify gdk draw routine
       so that it also supports fog of war.  There is still some problem in
       that the client will really bog down in some circumstances when
       drawing the map.
    x11/Makefile.in: Add cfclient.man to list of files.
    MSW 2001-11-03

    Complete client re-org.  Create common, gtk, gnome, sounds, and x11 subdirs.
    Gtk client: only image support is png.  Also add resizing options for
    the images (-mapscale/-iconscale), remove pngximage, update sdl
    image and normal draw image to support arbitrary image sizes.
    sound: Only support new sound system.
    MSW 2001-11-01

    gx11.c: Modified to know about new pickup mode (frontend - most all the
    work is still done on the server).  Patch by Nils Lohner.
    MSW 2001-08-28

    Add reset_map_function into xutil.c that gets called after we lose a
    connection to the server.  This fixes a problem of some leftover images
    from the previous session appearing in the map windows.  MSW 2001-08-12
    client.c: add call to reset_map_data
    proto.h: rebuilt
    xutil.c: Add reset_map_function (mostly a copy of reset_map), make some
       other functions 'static' so they don't show up in proto.h


    Fog of war code checkin. This is a fairly complex check in so
    hopefully not too much breaks. This adds the feature where
    tiles that have been seen but have since moved out of LOS
    are still shown on screen but with a 50% transparent black
    tile over it show it is no longer in LOS.  Whatever was in that
    tile is still shown until a new update comes in from the server at
    which point the tile is cleared of all old info.
    The old way was to just paint an opaque black tile.  To do this
    the client now keeps state of as many tiles as it can and remembers
    which tiles have been marked as cleared.  This is a fair amount
    of memory so when -fog is not specified, the code reverts back to
    a much smaller in memory map. To allow this, the map structure
    is now dynamically allocated.  I also had to add a new protocol
    command "newmap" so the client knows when to reinit its map state.
    NOTE: This feature only works when the client is using SDL. No
          reason the other blitters can't take advantage of it, just
          hasn't been done yet.
    client.c: fog_of_war global variable and newmap cmd added to CmdMapping
              Added "newmapcmd" to SetUp command.
    client.h: FOG_MAP_SIZE macro and Player_Position struct
    commands.c: handled "newmapcmd" sent from server, added NewmapCmd
                  which just calls display_map_newmap();
    gnome.c: stub function for display_map_newmap();
    gx11.c: Modified all commands that take x,y coordinates to convert
              to the virtual coordinate system if fog_of_war is active.
            Added code to sdl_add_png_face to paint a fog_of_war cell
              over cleared but still in view tiles.
            Added handling of Control-shift-i to simulate a newmap cmd.
            Added -fog cmd line option.
            Added display_map_newmap() function that resets the virtual map state.
            Correctly deal with dynamically allocate map structure.
    proto.h: Added new prototypes by hand.
    x11.c: Added code to dynamically allocate map structure.
           Added stub function for display_map_newmap();
    xutil.c: Modified functions to convert to virtual coordinate system
             when fog_of_war is active.
             Modified display_map_clearcell to not clear cell when fog_of_war
               is active, now just marks the tile as cleared.
             New function "allocate_map" to dynamically allocate a new
               map structure and setup the 2 dimensional array pointers
               correctly.
             New function, reset_map that clears out the map structure and
               resets to coordinate system if fog_of_war is active.
             Changed map_scroll to only update the virtual coordinates
               on scroll instead of moving memory around if fog_of_war is
               active. Also checks if the view is close to the edge of the
               virtual map and recenters it if so.
    SMACFIGGEN 2001-07-21


    Speed optimization to the SDL rendering code. sdl_add_png_face
    now exits when all 5 dark[] array values are set to full bright.
    gx11.c: Added a line in the per_pixel lighting section that exits
            right away if all darkness values are set to 255.
    SMACFIGGEN 2001-06-23

    Quick fix to the get_metaserver function. It was originally calling
    gtk_main_interation() in a while loop. This is really really really
    slooooow. I replaced it with a call to gtk_main(). gtk_main_quit
    for this invocation of gtk_main is called in enter_callback() when
    the user types in the metaserver he wants to play on. This is WAY
    faster then the old method.

    gx11.c: Changed get_main_interation to gtk_main in get_metaserver.
            Added call to gtk_main_quit() in enter_callback() when
            state changes from Metaserver_Select to Playing.
    SMACFIGGEN 2001-06-19

    Fix for the sdl/pngximage clients where the client would draw
    stale data on blank squares after a mapscroll. Basically if you
    had say an image of a wall on the bottom of your screen and
    you walked down one tile. If the new tile on the bottom of
    the screen is now blank, the client would have drawn the wall
    again and you get a funky recursive effect. The fix is in
    the display_mapscroll function in xutil.c.

    xutil.c: Modifed display_mapscroll so that new cells just coming onto
    the screen would be marked as the_map.cells[ax][ay].need_update= 1.
    For cells that are already on screen and just moving, we still leave
    need_update= 0.
    SMACFIGGEN 2001-06-19

    This checkin puts Scott MacFiggen's SDL support into the gtk client.
    I've made some enhancements to the code - it can now co-exist with
    the other image formats (so if all the libraries are available, you can
    choose from -xpm, vanilla -png, -png -pngximage or -sdl (which also
    forces -png).
    aclocal.m4, configure, configure.in: Add checks for SDL.
    client.man: Update with -sdl option.
    config.h, config.h.in: Add HAVE_SDL define
    gx11.c, xutil.c: Support for SDL drawing.  A lot of the code in
        xutil.c is command with that of pngximage.  gx11.c adds some additional
        options beyond just the drawing - per tile darkness and gridline options
        available under the client config window.
    MSW 2001-06-17

    client.c,client.h: Add want_darkness global variable, include when in setup
       command we send server.
    client.man,gx11.c,x11.c: Update to include -darkness/-nodarkness command
        line options
    commands.c: Change handling of negative results from server on setup
       command.
    MSW 2001-06-16

    The main thing this fixes is a major memory corruption problem when using
    -pngximage with the client.  Better darkness display is also when
    using -pngximage, but it depends on a server change (the change basically
    lets the client do blending from completely dark spaces.
    ++
    cconfig.h: add METASERVER define option which determines if client should
       try to contact metaserver or not (useful to turn off if behind a firewall
       so you don't have to wait for the timeout)
    client.c: add metaserver_on, map1cmd to global variables
    commands.c: divide by mapy value instead of 11 when using old map
       command - needed if playing with smaller maps.  set map1cmd
       value on/off depending on type of map command we receive from server.
    gx11.c: Add BPP define for internal testing to see if using 4 bytes/pixel
       gives any speed of 3 (answer is performance is the same or slightly
       worse with 4bpp).  when run with mapsize with x>15, create windows
       with bigmap outlook (message & stats above map, and not above/below).
       Fix bug in -mapsize processing which would set invalid sizes.
       Various cleanups to use image_size instead of 32.  Changes in
       drawing to also use BPP define value instead of 3 is various
       areas.  Optimizations for darkness rendering.  Use map1cmd global
       variable to know the packing form instead of looking at map size.
       Improved darkness handling to know if adjoining spaces have valid
       darkness information instead of looking at number of tiles.
    metaserver.c: if metaserver_on isn't set, don't try to get metaserver
       information.
    png.c: remove end_ptr processing - wasn't getting used, so not allocating/
       freeing it should improve performance a little.  Also, move
       png_set_filler call to before calling png_read_update_info - this
       fixes a memory corruption problem.
    x11.c: use map1cmd for determine packing information in map,
       fix bug in -mapsize command processing which could result in invalid
       values being used.
    xutil.c: add have_darkness value to mapcell structure.  Set
       value when we have valid darkness information for this space.  This
       allows the client to use darkness for blocked spaces if the server
       provides it.  update to use BPP instead of 3 for copies of image
       data.
    MSW 2001-06-12

    This is actually a fairly big checkin:
    1) add large map support into the client (use -mapsize option)
    2) using GdkRgb structure for drawing the map.  This prevents some more
       advanced map handling functions (like true alpha) as well as much
       better darkness support (use -pngximage option)

    cconfig.h: add TIME_MAP_REDRAW define.  I originally used this to benchmark
       my improvements with the gdkrgb code, but throught it may be useful to
       others
    client.c: add map sizing global variables.  Add map1 protocol pointer.
       request different mapsize of server.
    client.h: add map sizing variables to extern declarations.
    client.man: add description of -mapsize and -pngximage
    commands.c: Make it more forgiving about extra spaces in setu command.
       and support for mapsize option of setup command.  Add option
       to map_doneupdate which controls if we want a full redraw or not.
       Add Map1Cmd command which handles map1 protocol command.
    gx11.c: Add support for big maps as well as gdkrgb backing images.
       Add support for -mapsize and -pngximage command line options.  Lots
       of new image drawing code for pngximage.  Add resize_map_window
       function which is called when new map size is negotiated with server -
       depending on new and old values, re-arrange some windows.
    png.c: add png_to_data function which takes the png image and and returns
       rgba data.  used by pngximage code.
    x11.c Add big map support (-mapsize option).  It otherewise lacks many
       of the other features I added to gx11.c
    xutil.c: add png_data to image structure, and have data put here when
       using pngximage mode.  Move some of the basic map handling functions
       here - not the stuff that draws the map, but what sets up the
       server idea of wha the map looks like in terms of spaces.
    MSW 2001-06-04


    The three main things this checkin does:
        Ability to save relative sizes of gtk subwindows, and have those restored
          when re-running the client.
        Use of the setup protocol command to set configuration values.
        Receipt of skill experience information, and display of that in the
          gtk client.
    ++
    Makefile.in: Remove Protocol entry
    Protocol: Removed - now located in server/doc directory.
    client.c: Add value to determine if we want this option, initialize global
        array that maps the number to skill names.  Add support for 'setup'
        protocol command.  Send sound selection using new setup command.
    client.h: add MAX_SKILL to no max number of skills.  And skill experience
        and level total to Stats structure, put extern for skill_names
        array and want_skill_exp value.
    commands.c: Add SetupCmd function which handles processing of
        'setup' protocol command.  If sound setting fails with setup command,
        fall back to old method.  In StatsCmd, add code to get skill
        experience and level totals.
    gx11.c: Add ability to save window size and relative pane positions
        in non split mode, as well as loading and setting of those
        values (required moving pane information widgets from create_windows
        to global values) - while at it, renamed this to be more descriptive.
        Have client now display skill experience totals in stats window.
    metaserver.c: Make meta_sort a static function so that it does not
        get put into proto files.  Its only used within the metaserver.c
        file in any case.
    newclient.h: Add CS_STAT_SKILL* values (to keep in sync with server
        version of this file)
    proto.h: automatic rebuild needed for SetupCmd function.
    MSW 2001-05-28

    gx11.c: remove some unused code.  Add color for cursed/magic items in
       the unlocked inventory pane (makes it easier to sort items picked up)
       Add support for trimming the info window buffers - now gtk just has
       to be fixed.  Have the second information window do the seem freeze
       logic as the first.  Fix problem of trying to access to many resistance
       labels (may fix some reliability problems).  Remove -scrolllines command
       line option since the client does not use it.
    xutil.c: Don't load/save scrolllines line in config file when included
       with gx11.c - gtk client has no use for it.  Add newline to error
       message about lines in default file we did not process.
    MSW 2001-05-25

    client.c: update call to metaserver_show
    client.h: make meta_server, meta_port vars available to other files.
    gx11.c: clear echo hiding after user completes entry in text
        window.
    metaserver.c: Add parameter to metaserver_show which determines if
        we display instructions for selecting metaserver.  Re-get
        metaserver information if user hits enter on metaserver selection.
    player.c: Add metaserver command that gets updated metaserver information.
    proto.h: rebuilt.
    MSW 2001-04-29

    gx11.c: Add disconnect menu item and callback function to disconnect
       from server.
    player.c: Fix/improve firing logic.  Was problem with gtk client in
       that it would stop firing after a little while when holding shift
       direction.  This was because the outgoing command queue got filled
       up and never emptied because it still sent fire_stop commands.
       Add 'disconnect command to disconnect from server.
    MSW 2001-04-28

    Makefile.in: Add gx11.c to depend directive, so it recompiles properly
       on changes to png.c, xutil.c
    command.c: clear no_echo instead of letting the graphic handler do this.
       also add call to x_set_echo - this fixes cases in nopopups mode of
       it not switching to echo things properly.
    gx11.c: Add nopopups/splitinfo options to configure menu.  Add x_set_echo
       function, and remove detection of this from do_timeout.
    proto.h: automatic rebuild.
    x11.c: Add setup x_set_echo function.
    xutil.c: Add saving/loading of splitinfo and nopopups value to/from
       ~/.crossfire/gdefaults file.
    MSW 2001-04-27

    Note: by default, the command history forward/back keys are not bound
       to anything.  At least on Sparc/Solaris systems, the up key in
       the cluster of 4 arrow keys is the same keysym as the the
       key on the keypad, so by automatically binding these, you basically
       make it so the player can not move north/south, so I figure its better
       to let players bind them safely.
    gx11.c: Make the command completion key as well as history move backwards/
       forwards custom settable by the player.  Also, resize the width of the
       name/weight window for the look window the same way we do for the inv
       window.
    xutil.c: Add support for binding command completion and history scroll
       keys.  Also, add support of loading/saving these bindings (As well
       as those for fire keys, run keys, command keys.
    MSW 2001-04-20

    gx11.c: Have it hide password entered when using -nopopups mode.
      Add command completion with tab.
      remove some dead code.
      Add command history.  Accessible through the up/down arrow keys
       (the 4 keys between the standard keys and the keypad, not the
       arrow keys on the keypad.)  This feature is barely tested.
      Most of the editing functionality used here is what gtk provides.
    MSW 2001-04-20

    client.c: add image_file declaration.  Also, properly handle cases where
      the option given by -server (or config file) is not a valid server -
      go back to metaserver selection instead of looping infinitely.
    client.h: add image_file declaration.
    gx11.c: Lots of changes.  remove duplicate code between this file
      and xutil.c. Add show_unlocked inventory tab selection.
      Add -nopopups command line option which prevents pop up windows.  Also
        results in the count value getting cleared when used.
      Add -splitinfo command line option that results in two info (Text)
        windows - one for colored text, one for normal text.
      When resizing pane that has inventory listing, now updates inventory
        headings so weight keeps constant width so that the space for the
        name increases.
      Implement command_show options so that 'show' command will rotate
        through tabs (or goes directly to tab if right name is given)
        of inventory display options.
      Add handling for -pngfile option.
    player.c: add complete_command function that returns complete
      server command when partial string is passed to it
      (currently only used by x11.c)
    x11.c: Add unlocked inventory show option.
      Add command completion via tab key when entering an extended
        command.
      Add -pngfile support processing.
    xutil.c: Modified with #ifdef GDK_XUTIL so the gx11.c file
      can include this file to reduce duplicate code.
      Have cache code look in gfx directory first for images to load.  Also
        have cache code then look at images loaded by -pngfile for match
        before looking in images previously download, then request image
        from server if we still don't have an image.
    MSW 2001-04-19

1.0.0
=====

    player.c: Fix for client crashes if player enters really long commands
    (like say .....).  MSW 2001-05-08

    gx11.c,command.c: Remove some debug statements which really should not be
       there for 1.0, and which are not really useful anyways.
    items_types, item_types.h: Varioius minor updates.
    MSW 2001-05-04

    gx11.c: Fix bug that causes gtk client not to update weapon speed.
    metaserver.c: Have the listing get sorted by hostname to make it easier to
       find the host the user may want.
    MSW 2001-05-02

0.98.0
======

    item_types,item_types.h: Change matching for sword - hopefully this should
    fix problems with dancing sword spellbooks.  MSW 2001/04/06

    gx11.c, item.c: move animations of the look window to the client.  All
    the necessary was already being sent to the client - it was just needed
    for the client to use this information.  Also remove some
    #if 0 code from gx11.c.  MSW 2001/03/28

    item.c: set_item_values - only resort items based on name if the name
       has changed.  This fixes a problem with items moving around in the
       inventory if you lock/apply/unapply/unlock them.  MSW 2001/03/23

0.97.0
======

    MSW 2001/03/18
    Change so that containers on the ground still keep proper contents even if the
    map space itself changes (spells or other objects going onto the space).  This
    is done by using the cpl.container pointer and when getting an updated map
    space, seeing if one of the map space object tags match that.
    commands.c: update the cpl.container tags when opening/closing containers.
    item.c: Have locate_object see if the container matches the tag.  Don't have
        remove_item remove the object contents of other attributes if it is the
        container, but still remove it from the list it is on.
    item.h: remove function prototypes - these are in proto.h

    MSW 2001/03/13:
    png.c: New png -> X11 (or gdk) creation routines that are much faster.  This
       should make a noticable difference in performance.  Note that the X11
       and gdk implementations are very different now - the gdk implementation
       lets the gdk library do most of the work.
    gx11.c: remove some dead code, add call to gdk_rgb_init() if using
       png images - needed by new png loader.
    x11.c: Add call to init_pngx_loader if running in png mode.  Also pass colormap
       by pointer so png_to_xpixmap can modify it.
    xutil.c: pass colormap by pointer to init_pngx_loader (same reason as above)

    MSW 2001/03/06:
    Makefile.in: Add DMALLOC_LIB definition instead of it going in with the
        the default libraries.  cfsndserv will now get properly linked with
        dmalloc.
    configure.in, configure: add --disable-sound option, and make relevant
        changes to use that option (which basically amounts to not checking
        for any of the sound systems).  Add check for dmalloc.h.  change
        substitution for -ldmalloc.


    cfsndserv.c: Modified so it now compiles with the modern ALSA sound system.
        No idea if it actually works.  MSW 2001/03/04

    metaserver.c: Modified so it uses the value of -port if that command
        line option is given by a user.  MSW 2001/03/01

    x11.c: Fixes for info window resizing.  This should fix some crashes
         and the code is a bit simpler now.  MSW 2001/02/28

    Makefile.in: Modify so that it installs the target (cfclient, gcfclient,
        cfsndserv) one at a time so it works with the install script.
    item.c: add insert_item_before_item function.  Modify the sorting function
        so it first sorts by type, then by locked/unlocked status, and then
        by alphabetical order (not including the number prefix).
    item_types, item_types.h: More updates of missing objects or ones that
        need more specific matching rules.
    x11.c: Remove a lot of duplicate code that was in place for metaserver
        support - instead, just add checks to the existing X event handling
        code to know not to do some things if we're in metaserver selection
        mode.  This fixes a bug in that resize events would not be handled
        if in metaserver selection mode.
    MSW 2001/02/22

0.96.0
======

    MSW 2001/02/02:
    Protocol: Update with new face1 command that includes checksum.
    client.c: add face1 protocol command.
    client.h: Update version_sc to 1026.
    commands.c: Move FaceCmd from gx11.c/x11.c to this file, since it
        now only does decoding of data and passes rendering off to appropriate
        file.  Also add Face1Cmd function that deals with checksum.  Both
        of these functions pass off the rendering to the same function.
    gx11.c: add keepcache variable, re-do facing loading/caching - if
        we have local version of face, generate checksum of it and compare
        to that against what server has.  finish_face_command added to
        do this - called by the face functions in commands.c.  Add
        -keepcache command line option which will have it not request
        images from server if checksum is different.  Add usleep
        in metserver selection area to prevent client from hogging all the cpu
        time.
    item.c: Add support for ^ in items file to say only match at start of
        line.  Useful for 'bolt' - doing substring also matched against firebolt.
    item_types, item_types.h: make bolt ^bolt, add Head and hauberk to matching
        criteria.
    proto.h: automatic regen.
    x11.c: As gx11.c above, plus: Use one font for all windows - reduces
        complexity.  Add easy selection of font to use with -font command
        line option.
    xutil.c: As gx11.c for relevant functions that are located in this file
        and not x11.c
    End of MSW 2001/02/02 checkin.

    MSW 2001/01/31:
    client.c: Clear player inventory and look windows after disconnection
       from server.  Prevents client crashes.
    gx11.c: various fixes - window placement no longer always centered on screen
       (very obnoxious if running xinerama), various prototypes fixed up,
       clear map data after clearing image data.
    player.c: Add suport for 'mapredraw' command.  Not that this should ever
       really be needed, but the server supports it, so its nice to be able to
       use it.
    x11.c: Fixes prototype/casting problems when clearing pixmaps.  Like gx11.c,
       clear map data.
    xutil.c: add better description to the unbind command.


    MSW 2001/1/13 (except as mentioned, all changes by MSW):
    Makefile.in: Create destination dirs, remove extra tab.  Patch also by Dave.
    Protocol: typo fixed.
    config.h, config.h.in: Add HVAE_DMALLOC_H #ifdefs.  Checks currently
        disable in configure.in, as with it, the sound won't like properly since
        it needs -ldmalloc, and I haven't bothered investing that much time
        into fixing the Makefile.
    gx11.c: Patches by Dave Peticolas - mostly code cleanup, but one new feature is
        support of wheel mice to move the scrollbars.
    png.c: No real code change, just adjustments in some ordering which I think
        makes the code appear a little simpler.
    x11.c: Minor code cleanups, some formatting changes, some to make better
        error messages.
    End of MSW 2000/1/13 checkin.

    MSW 2001/1/8:
    client.h: Change damage type to be 16 bits.

    MSW 2000/12/24:
    png.c: Fix a major memory corruption issue - the png function
    was re-allocing for a larger hunk of data, but did not update the
    pointer and was still using the pointer to the smaller hunk.
    Severity of this bug depended on luck - if the first png downloaded
    happened to have the full 4 bytes/pixel, it never needed to do a realloc
    so would work fine.  Otherwise, a matter of luck what data got stomped
    over.  Also, modified the main function in this file so that it
    you can compile against it and it now works with the new in memory
    data read.

    MSW 2000/12/19:
    Metaserver update.  Most files updated.  This change has the client
    connect the metaserver and lets the user choose which server to connect
    to.  Also, if the client loses a connection (either because the player
    has quit playing or the server died), the client will no longer exit and
    instead go back to the server selection screen.
    A few unrelated changes (cfclient):  when running cache, non downloaded
    images should look better.  Also, client starts up with larger window in
    Png mode to take into account the extra space png images takes up in the
    game window.

    Changes by file:
    Makefile.in: Add metaserver.c file.
    cconfig.h:  Add metaserver configuration information.
    client.c: Add meta_ variables, move resists_name to this file, no longer
        have DoClient exit if it gets an error on the socket (instead
        mark the fd as -1 and return), change main loop such that if
        connection to server has been lost, go through loop to establish
        a new connection.
    client.h: Add Metaserver_Select input state.  Change resists_name from
        a static to extern.
    gx11.c:  Remove some unused code, various code cleanups, and additions to
        support the metaserver connection process.
    init.c: Add reset_client_vars - call it between connections to servers.
    proto.h: rebuilt for new functions.
    x11.c: Update for metaserver connection status.  If running Png mode,
        have windows created larger.
    xutil.c: When creating default images for cache, create 32x32 images for
        png mode, not 24x24 images.
    metaserver.c: New file for metaserver code.
    End MSW 2000/12/19 checkin.

    MSW 2000/12/10:
    png.c, gx11.c, x11.c, xutil.c: modified to use in memory loading of
    png's.  This means that if not caching images, we don't need to write it out
    to a temp file.  This should result in a minor performance gain, but
    also remove the need of using tmpnam.  Also, modified gx11.c so that
    it uses same logic as the x11 client for extended command key (').
    Before gx11.c client would use both ' and ", and there was no way to unbind
    the later - since one can always bind the command key, I found that a bit
    annoying.

    Updated to display resistance values in the message window.  Except for
    armour, this is only displayed when running against serves with PR
    code.  Change for both cfclient and gcfclient. Files affected:
    Protocol client.h commands.c gx11.c newclient.h player.c
    sounds soundsdef.h x11.c
    MSW 12-3-2000

0.95.8
======

    Checkin on 2000-11-7 by MSW:
    item.h:  Update NAME_LEN to 128, as the server may send us names that
    long.  Also, terminate the name after we copy it.

    Checkin on 11/3 by MSW:
    Remove remaining font support for x11 client.
    Allow setting default display mode and server to connect to in the
    cconfig.h file.
    Files affected: CHANGES, cconfig.h, client.c, client.h, gx11.c, x11.c,
        xutil.c


0.95.7
======

    Makefile.in:  Update to include png.c when packing up distributions.

    configure.in, configure:  Move check for -lm before png check, and
    libpng on sparc/solaris systems require math library for proper linking.
    Also, change the -with-xpm* to -with-ldflags and -with-includes to be
    more general since extra values may be needed for more than just xpm
    library.
    client.man: Updated for information about png images and
    cwindow command.
    README:  Updated with changes mentioned above with the --with-png options.
    gx11.c: Remove all support for pixmap images.  They didn't work anyways,
    but you could specify -pix on the command line and get no images -
    now it will at least result in an error message.  Also, savedefaults
    will now save png status properly.
    xutil.c: Modified so that it will save png status when savedefaults
    is issued.
    MSW 8/24/2000

    The following change removes imlib as are png loading/rendering library -
    instead, we use our own local function located in png.c.  libpng is
    still needed, but it removes the dependancy on imlib.  Also, my home
    spun function renders all the png images crossfire uses correctly, while
    imlib had several it did not do properly.  MSW 8/13/2000
    Files affected:
    config.h, config.h.in:  Change HAVE_IMLIB_H to HAVE_LIBPNG
    configure, configure.in: Change check from imlib to libpng.
    gx11.c,x11.c,xutil.c: Changed to use our functions and not imlib.
    png.c: new file that has our png support in it.

    cfsndserv.c: Make some changes so that sound on ultrasparc systems is played
    properly.  Missing FD_SET call to re-add the soundfd, as well as a missing
    wrap check for first_free_buffer.  MSW 8/10/2000

    The following matches a change made to the server which includes two
    piece item names to make the item names in the client appear more perfect.
    Protocol: Updated to document the new item name transmission method.
    client.h: Update SC version to 1024.
    item.h: Remove name and o_name from item structure, instead there is now
      d_name, s_name, and p_name, representing the display name, singular name,
      and plural name.  display name is derived from the s/p names plus nrof value.

    commands.c: Chance strncpy to memcpy, as a null character is used to separate
      the two name values.  UpdateItemCmd is also modified to supply an empty
      string to set_item_values instead of the same name if the name is unchanged.
    gx11.c, player.c, x11.c: use d_name instead of name to correspond with
      changes to item.h
    item.c: Update item initialization and clearing functions with new name
      elements.  Update set_item_values with new two piece name support.
      remove adding 'a' and 'an' prefix to singular objects, as it generally
      doesn't look good in the look window and isn't all that useful in the
      inventory window either.
    Mark Wedel 8/6/2000

    item_types, item_types.h:  Update with new item types - MSW 7/19/2000

    player.c: Comment out command buffering output - MSW 7/19/2000

0.95.6
======

    configure.in: Update for 0.95.6 release.

    x11.c: Change MAX_BUF definition in to match that in config.h

    Update README for necessary libraries.
    configure.in, configure: Re-order testing of Xext, Imlib where we still
    have the any special link flags set.  Also, when finding these, explicity
    set them in the X_LIBS variable and not the default, since they are only
    needed for the X11 client.  MSW 6/16/2000

    Protocol: Update for png information - addition of image command.
    client.c: Add support for image command.  Change initializing so we get
        the protocol from the server early on - we need to know it before
        we tell it what facemode we want, as it may not support png
        images.  do protocol version check and if the server does not
        support it and the user request png, fail out.
    client.h: Increase versions of protocol.  Add Png_Display to possible display
        modes.
    command.c: Add ImageCmd function which processes the image command
        (used for receipt of png images).  the use of the image command
        can be abstracted in the future for other image formats quite easily.
    config.h.in (& config.h): Add HAVE_IMLIB_H define which lets us know if
        the imlib is available.
    configure.in (& configure): Add detection for imlib and set the appropriate
        variables so that they get linked properly.  Also add check
        for Imlib.h
    gx11.c: Update for png support - add display_newpng command, change
        XPM_SIZE to image_size and make it a variable and not a define.
        Pull in appropriate imlib support, as well as rendering of
        png data.  Some dead code removed.  display_usepng,
        display_usxpm, and display_newpng functions added.
    newclient.h: Add CF_FACE_PNG constant for CS communication.
    proto.h: Updated for new png functions.
    x11.c: Many of the same changes as gx11.c above.  More work was done here
        as the 24 image size was hardcoded into this file - it is
        now a variable also, so supporting other image sizes in the future
        should also be quite easy.  Once the Png's are rendered, they are
        drawn the same was as the Xpm's are, so many checks for
        display_mode==Xpm_Display also check for Png_Display.
    xutil.c: Support for PNG images added.  Changes are mostly related to
        caching code.
    Changes by Mark Wedel, 6/2/2000

    Makfile.in:  Have cfsndserv.o removed when make clean is done.
    Also add a 'distclean' directive which removes the config.cache/log/status
    files as well as the executables.  MSW 5/29/2000

    x11.c: Fix bug introduced in 4/20 update which would cause xpm display
    mode to fail with no such face warnings - code check was in the
    wrong place - MSW 5/7/2000

    xutil.c:  Improve logic for built in keybindings - if the
    def_keys specifies a unique keycode, we don't update the keycode - this
    is necessary for some keyboards to have working keybindings (for example,
    sun Type 5 keyboards use the Up keysym for both the arrows and the keypad,
    so we can't get the keycode for both with the XKeysymToKeycode file -
    MSW 5/7/2000

    Add key ring to item_types and item_types.h file in the container
    category. MSW 4/21/2000

    Change Makefile.in to use perl that configure has found when
    running items.pl script - MSW 4/21/2000

    License: Add license file for the client - MSW 4/20/2000

    cfsndserv.c: Various changes
    1) Add support for sound on Sun (solaris) systems - another init_audio
    function added.
    2) If in SOUND_DEBUG mode, also print out the audio device we would try to
    use.  Also, add x,y coordinates when printing debug information when
    playing a sound.
    3) Add various casts to reduce compiler warnings on going from
    signed char to unsigned char data types.
    4) For 16 bit output, big endian (sparc) should now work - have two
    sections when packing the sound information to pack it the write direction
    depending on endianess of the machine.
    5) Ignore the device entry in the .crossfire/sndstat file - using that
    resulted in incompatibilities between system types.  If player needs
    to use a specific audio device, the AUDIODEV environmental variable
    can be used.
    --MSW 4/20/2000

    configure.in (and configure): Many fixes:
    1) On solaris, add -R flag to linker options if --with-xpm-lib=dir is
    used - needed to run the client when dynamic linking is used.
    2) Add AC_C_BIGENDIAN check - we need to know the byte order for sound
    to work on both sparc and other systems properly.  NOTE - when running
    autoconf, you will get a warning about that line.
    3) Add detecition for solaris audio include, and add appropriate declarations
    to use it.
    4) Fix for xpm check - if X11 includes are in a nonstandard place,
    it would fail to find xpm.h since that includes some standard X11 files.
    Add X_CFLAGS which includes any necessary -I options for this to work.
    --MSW 4/20/2000

    config.h, config.h.in: Add WORDS_BIGENDIAN define to file.  MSW 4/20/2000

    x11.c, xutil.c, client.h, client.man:  Only update keycodes for the
    local keyboard for standard keybindings.  Custom keybindings will keep their
    old/original keycodes, which is often needed.  Add -updatekeycodes option so
    have it update all keycodes. client.man updated to describe the
    -updatekeycodes command.  MSW 4/20/2000

    gx11.c: Above update for keycodes added.  Also, update so that it
    has the same set of command line options that x11.c does (-nocache, -nosound)
    MSW 4/20/2000

    x11.c:add closing comment - the missing close comment was just resulting in
    warnings of 'comment detected inside comment' - the change does not affect the
    execution of the code.  MSW 4/20/2000

    item.c: Remove extra semicolon that was resulting in compiler warnings.
    Update mail address/copyright date.  Mark Wedel 4/18/2000

    Makefile, config.cache, config.status: Removed from CVS tree it should not be
    distributed - rather each person should generate it on their own by using the
    configure script. One advantage of removing these is that a 'cvs diff'
    of the directory won't show the diffs of these automatically generated
    files.  Mark Wedel, 4/12/2000

    commands.c, client.h: Change animation code to dynamically allocate space
    needed for animations instead of using a statically defined/sized array to
    contain the face information.  This fixes a bug with icors causing the client
    to crash (it had more animations than the static array had), and this method
    is just generally a good idea.  Mark Wedel, 4/12/2000

    x11.c: Add code into gen_draw_face so if a request to draw a nonexistant face
    is performed, it will handle the problem gracefully.  Mark Wedel, 4/12/2000

0.95.4
======
- README updated to give better install directions - msw.
- Add checks to xutil.c to verify we have a valid keysym before trying
  to convert it to a string and print it out.  Before, this could result
  in trying to print null strings, which would cause a crash - msw.
- fix unbind and bind in xutil.c so they properly skip over leading spaces - msw.
- fix Makefile.in so make depend will pick up x11.c dependencies - msw.
- Fix 'help command so that the draw info commands are formatted to fit
  on the default window width (player.c - msw).
- Fix so that cwindow without options results in a message that an option
  is needed instead of causing the program to crash (player.c - msw)
- Update Makefile.in so that make install works again - msw
- Updated gtk client with speedups in text handling and drawing. It should
  now remain responsive during massive text updates on slower machines.
  Prepared with a single define (XPM_SIZE) for 32x32 graphic tiles.
  /David

0.95.3
======
Don't link in -lnsl -lsocket on sgi systems.  Don't link in -lnsl on
linux systems.  This list probably needs to be expanded.

Gracefully handle failures of the sound daemon for whatever reason (most
likely because there is no good sound support).  Client should now
detect write errors and just stop trying to write stuff to the sound
daemon.

Improve logic in cfsndserv when adding to the buffers.  Prior, it would
actually skip over buffers, and logic on determine the amount of
data was faulty if a short sound was played after a long song.

Fix in cfsndserv.c so that it will read the device entry in the
~.crossfire/sndconfig properly.

Include sys/select.h if we have it in cfsndserv.c.  Some systems appear
to need to for proper compilation of that file.  Also, #ifdef for checks
already done to determine if we should include some includes or not.

Status line should now show hp/sp/gr successfully when player has totals
greater than 100 in those stats (From Timo Kokkonen)

Option to have system beep when low on food - setable via foodbeep command.
(From Timo Kokkonen)

Better logic to prevent 'You can not issue commands - state is not ST_PLAYING'
warning from Timo Kokkonen)

Various non functional changes that should prevent warnings during
compile (From Timo Kokkonen)

Have client create the ~/.crossfire directory if needed prior to saving
keys.

Change client help command so it will not display client side help information
if the user is requesting help on a specific command.

Ability to specify location of sound files at the configure state with
--with-sound-dir=/some/path

Support for SGI sound system added by Paul Mikell, configure detection
for sgi sound by Pertti Karppinen (both untested by me since I don't have
an sgi handy)

0.95.2
======
Improve item_actions so it can handle getting pashed null objects (just
return then)

In create_item, only add to an objects environment if we actually have
an environment to add to.

configure.in changes - special check for alpha systems.  Add configure
option for new/old sound, and auto detection of alsa (hopefully - untested)
Build both gcf and cfclient if possible.

Improved Makefile.in - more dependancies and automatic defaults have
rules.  Support for building both the gcfclient and cfclient with the same
common object files.  Support for building in other directories.  Include
aclocal.m4 file in distribution so autoconf can be re-run

Improved fire/run handling.  Previously, due to the auto repeat of the
x-server, numerous fire starts and stops would be continuously sent because
the code would see a keypress and keyrelease events.  Logic changed to
eliminate that constant sending - only send the actual run/fire stop if
when all x-events have been processed, the specific key is no longer
being pressed.  This also seems to improve interact performance when
using run to move in the game.  This is only fixed in the X11 client -
wasn't able to figure out where in the gtk client to call the functions
after all events had been processed.

Size of command window setable.  The command window is the number of commands
the client will let go unanswered before it stops sending commands.
This is setable with the 'cwindow' command, and will be saved into the
defaults file so it stays constant across multiple runs.

Fixes to work on black and white systems (cfclient, both pixmap and
xpm)

Change update_item function to update open/close containers if the
flags change.

Remove rotateinventory from default keybindings - no reason to keep
it around, since it isn't used anymore.

Increase buffer size used when reading in key bindings.

Fix for x11.c to hopefully prevent FPE's - it seems that at times
the players weapon speed could be zero, and dividing by that resulted
in the Fpe.  If the players weapon speed is zero, then we just display
0 as the speed.

Remove instruction from README telling the player to copy the
def_keys into their custom key file.  Not needed, and clutters up the
unbind list quite a bit.

Patches from Tero Kivinen:  Fix help files so that they do not
have embedded new lines (under ansi C, strings can not span multiple
lines unless continued with a \ - gcc lets this behaviour go through
however).  Also, change to configure.in to add -std1 to cc on digital
unix.

Include aclocal.m4 in distribution so end users can remake configure.in

Strip leading spaces when sending complex commands.  Parsing of complex
commands made a bit cleaner (patch from Maciej Kalisiak)

GTK changes by David Sundqvist:

Compiles for both gtk+-1.0 and development gtk+-1.1.12 and onwards.

Close button for open things in the look window added.

Included various patches by Maciej Kalisiak for locking and marking in
inventory, as well as coloring damned items too. Some cosmetic code
cleanups by Charles Duffy.

Tearoff menus for development version of GTK.

Some small tooltips. I'd like more, but gtk is picky about what widgets it
accepts tooltips for.

Some fixup for drop count. Not entirely sure how that should work to be
practical.

Menu choice to clear info window.

Speedup for image creation in non-cached mode.

Main loop moved into gx11.c to allow both clients to be built at once.


0.95.1
======

Add 'depend' directive to makefile.  remove 'includes.h' as a distributed
file.

-nosplit option added to x11 client.  Useful if you don't want split
modes but your default file is set for it.

resizing of main window in non split mode for x11 client supported.  The
sub windows will try to be maintained in the same proportions.

use autoconf to determine if we have sysconf instead of by system type.

Check to see if the item has an environment before setting the
inv_updated flag of that environment.  This should fix some crashes.

Add #ifdef of SOUND_DEBUG so we don't get verbose notifications in the
sound code unless we want them.

Clear item attributes after the item has been freed.  When the items
are first created, they are initialized to sane values, and many areas
of the code expect that new item will be initialized properly.  This change
seems to fix the problem with item names being incorrect (ie, "two" and
the like).

Expanded item_types file to be more complete.

GTK changes by David Sundqvist:

    981127
      Further GUI configuration (keybindings too, needs more work tho)

      XPM caching now implemented

      Color text in info window (warning: this may trigger a bug in pre 1.0.5
      gtk, but you can turn it off in the GUI config :) )

      Menu reorganizations and additions

    981114

     Split windows mode
       For those who want new fun layouts. (still has some problems with focus
       here)
     Color coded inventory
       Now you can see cursed and magic items in color coding.
     Smart dialogs
       It will actually try to figure out what options you have in dialogs.
     Fix for inventory count
       Now pressing 0-9 should update count.
     Configuration dialog
       GUI configuration for some options.

0.94.4
======
- Set receive socket buf to 64K.
- Added item type detection and sorting (prior, items basically appeared
  in the inventory in which they were sent.)  Ordering can be changed/extended-
  see item_types file.
- Incorporate gtk version 0.94.3auto into this release to have one common
  client source base.
- Support for complex keybindings (more than one command bound to the same
  key, separated by semicolons)
- added -nocache command line option (default behaviour, but option needed
  if your defaults file is set to cache).
- When receiving new xpm image from server, create xpm data from the
  data provided instead of saving it to a file and creating it from the
  file.  This should be much faster.  If we are caching images, we still
  save the data to a file but use the buffer to create the image (this
  is the same thing that pixmap display does).  This is only true for
  the x11 client - I am not sure what the gtk client does.
- Added support in the client to understand the 'goodbye' command from
  the server.  This is to allow the client clean exits.  SC protocol
  updated for 1022 for this.  'goodbye' will be in the 0.95.0 server.

0.94.3
======
- Only print debugging output on runs if compiled with -DDEBUG option.
  Most fprintf(stderr,...) changed to use the LOG call instead.
- Updated protocol version to 1021.  This is for the ncom and commc
  commands (command windowing).
- Support for the ncom and comc functions above added to client.   Client
  will now stop sending repeat commands at a certain point.
- README cleaned up - README now contains more of the first level type
  instructions, where README.old contains some of the older discussion
  and background notes.
- README now includes very good notes on extracting keybindings from save
  files for use with client.

0.94.2
======
- Change Version command to include 2 versions strings - version of
  of C->S commands and version of S->C commands.  Allows for better handling
  when versions are mismatched.  Current versions for both set to 1020.
  Also, version command can now take an optional string describing
  the client and server (ie, X11 C client, or Java client, etc)
- Client query command now will handle multi line text fields (separated
  by newlines) as sent in the query command.  Before, it was never explicity
  set that this should be done, and was never an issue because there
  never was multiple lines sent.  However, to make input handling on
  some clients easier, text describing what the query is for is not sent
  via drawinfo, but now sent via the query command.
- When user enters the help command, send any options along to the
  server (ie, send 'help asdf' to server.  Before, it only
  sent the help.
- Added ability to mark items similar to server.  'mark' command added
  to protocol.
- Bug fix when using commans bound with 'bind -e'.Prior, when hitting return
  to finish the command, it would not advance to a new line.  It now does.
- nrof and item name with nrof now properly updated in inventory window
  when server sends and update command (prior, the client internally know
  the correct nrof, but the item name in the window was not properly
  updated)
- Changed local showicons command to showicon instead.  The later is what it
  should have been in the first place.

0.94.1
======
- CS_STAT_WEIGHT_LIM added to stats command.  Client will store value, and print
  it at top of inventory window (carried weight/limit)
- Handling of dmalloc library in makefiles better done.
- Don't assume gcc on mips machines.
  Minor updates to protocol file (more accurate, no change in actual commands
  save for weight limit above)
- Only send fire start/stop commands if in play state.
- cleaned up overly verbose messages in sound.c (comment out).  Also, soundcard.h
  assumed to only exist on linux systems.

0.94.0
======
- Client will handle item1, upditem, face, sound, and anim commands from
  server (new commands)
- Client will now animate objects.
- Fully handles caching of images - should be a big speed improvement over
  slow links.
- Client now handles numbering of commands on its own (item1 will send
  nrof)
- Handling of locked items now also handled on client.
- Created misc.c file - handles things like strdup, and creation of directories.
- Client will now send lookat command to server.
- sound.c file added - handles playing of sounds.  This should work on
  most systems that have a /dev/audio which can play .au files.  On linux
  (open sound system), more sophisticated handling is added (stereo support
  and volume control).  soundsdef.h file added which contains default
  sound information. -nosound option added to disable sounds.
- Added inventory show options (ie, magical, nonmagical, etc) - equivalant
  of 'x' command on oldserver.
- Bug fix that would cause grace bar to always be drawn same color as
  sp bar.
- Print fire on/run on informatin in the message window.
- Add KEYF_STANDARD flag to keybindings, so when do an unbind, we can
  only show custom keybindings.
- Can now save window positions (in -split mode) accross runs.  Saved
  in ~/.crossfire/winpos
- Can now save standard defaults (sound, scrollboard, port, tec) in
  ~/.crossfire/defaults
- Protocol file updated with new commands.
- Added some client side 'help command - shows commands the client
  handles locally.
- New local commands added: savewinpos, savedefaults, help, show.

0.93.7
======
- Fixed make proto directive to exclude inline functions in the proto.h
  file.
- Added support to using debug malloc library (dmalloc.)  Change Extra_Flags,
  LOCAL_LIBRARIES in the Imakefile to disable this.
- made update_item a non static function in item.c.  Also, no will probably
  find the player object for weight updates.
- Removed carrying field in the item structure.
- Fixed bugs in resizing the info window which would cause program to crash -
  left over problems from when the scrollbar was added.
- Can now drop a portion of a group of objects (ie, 50 of 100 arrows)

0.93.6
======
- Change the select loop to reset the timeout each time - looks like linux
  select resets this to zero (undocumented feature?)
- Use correct length in SendAddMe function.
- Started adding code for local face caching.
- Protocol file updated to be more accurate/complete.

0.93.5
======
- Added support for multi line input.

0.92.2-a
========
- Scrollback buffer for the info window added.
