import { Component } from 'react';
export interface OverflowMenuProps extends React.HTMLProps<HTMLDivElement> {
    /** Any elements that can be rendered in the menu */
    children?: any;
    /** Additional classes added to the OverflowMenu. */
    className?: string;
    /** Indicates breakpoint at which to switch between horizontal menu and vertical dropdown */
    breakpoint: 'sm' | 'md' | 'lg' | 'xl' | '2xl';
    /** A container reference to base the specified breakpoint on instead of the viewport width. */
    breakpointReference?: HTMLElement | (() => HTMLElement) | React.RefObject<any>;
}
export interface OverflowMenuState extends React.HTMLProps<HTMLDivElement> {
    isBelowBreakpoint: boolean;
    breakpointRef: HTMLElement;
}
declare class OverflowMenu extends Component<OverflowMenuProps, OverflowMenuState> {
    static displayName: string;
    constructor(props: OverflowMenuProps);
    observer: any;
    getBreakpointRef(): any;
    componentDidMount(): void;
    componentDidUpdate(prevProps: Readonly<OverflowMenuProps>, prevState: Readonly<OverflowMenuState>): void;
    componentWillUnmount(): void;
    handleResize: () => void;
    handleResizeWithDelay: (...args: any[]) => void;
    render(): import("react/jsx-runtime").JSX.Element;
}
export { OverflowMenu };
//# sourceMappingURL=OverflowMenu.d.ts.map