// Copyright 2026 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by MockGen. DO NOT EDIT.
// Source: ingest.go
//
// Generated by this command:
//
//	mockgen -copyright_file=../../../../../LICENSE.header -destination=./mocks/ingest.go -package=mocks -source=ingest.go
//

// Package mocks is a generated GoMock package.
package mocks

import (
	context "context"
	reflect "reflect"

	changelog "github.com/specterops/bloodhound/cmd/api/src/daemons/changelog"
	graph "github.com/specterops/dawgs/graph"
	gomock "go.uber.org/mock/gomock"
)

// MockChangeManager is a mock of ChangeManager interface.
type MockChangeManager struct {
	ctrl     *gomock.Controller
	recorder *MockChangeManagerMockRecorder
	isgomock struct{}
}

// MockChangeManagerMockRecorder is the mock recorder for MockChangeManager.
type MockChangeManagerMockRecorder struct {
	mock *MockChangeManager
}

// NewMockChangeManager creates a new mock instance.
func NewMockChangeManager(ctrl *gomock.Controller) *MockChangeManager {
	mock := &MockChangeManager{ctrl: ctrl}
	mock.recorder = &MockChangeManagerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockChangeManager) EXPECT() *MockChangeManagerMockRecorder {
	return m.recorder
}

// ClearCache mocks base method.
func (m *MockChangeManager) ClearCache(ctx context.Context) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "ClearCache", ctx)
}

// ClearCache indicates an expected call of ClearCache.
func (mr *MockChangeManagerMockRecorder) ClearCache(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClearCache", reflect.TypeOf((*MockChangeManager)(nil).ClearCache), ctx)
}

// FlushStats mocks base method.
func (m *MockChangeManager) FlushStats() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "FlushStats")
}

// FlushStats indicates an expected call of FlushStats.
func (mr *MockChangeManagerMockRecorder) FlushStats() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushStats", reflect.TypeOf((*MockChangeManager)(nil).FlushStats))
}

// ResolveChange mocks base method.
func (m *MockChangeManager) ResolveChange(change changelog.Change) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResolveChange", change)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResolveChange indicates an expected call of ResolveChange.
func (mr *MockChangeManagerMockRecorder) ResolveChange(change any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResolveChange", reflect.TypeOf((*MockChangeManager)(nil).ResolveChange), change)
}

// Submit mocks base method.
func (m *MockChangeManager) Submit(ctx context.Context, change changelog.Change) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Submit", ctx, change)
	ret0, _ := ret[0].(bool)
	return ret0
}

// Submit indicates an expected call of Submit.
func (mr *MockChangeManagerMockRecorder) Submit(ctx, change any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Submit", reflect.TypeOf((*MockChangeManager)(nil).Submit), ctx, change)
}

// MockBatchUpdater is a mock of BatchUpdater interface.
type MockBatchUpdater struct {
	ctrl     *gomock.Controller
	recorder *MockBatchUpdaterMockRecorder
	isgomock struct{}
}

// MockBatchUpdaterMockRecorder is the mock recorder for MockBatchUpdater.
type MockBatchUpdaterMockRecorder struct {
	mock *MockBatchUpdater
}

// NewMockBatchUpdater creates a new mock instance.
func NewMockBatchUpdater(ctrl *gomock.Controller) *MockBatchUpdater {
	mock := &MockBatchUpdater{ctrl: ctrl}
	mock.recorder = &MockBatchUpdaterMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockBatchUpdater) EXPECT() *MockBatchUpdaterMockRecorder {
	return m.recorder
}

// Nodes mocks base method.
func (m *MockBatchUpdater) Nodes() graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Nodes")
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Nodes indicates an expected call of Nodes.
func (mr *MockBatchUpdaterMockRecorder) Nodes() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Nodes", reflect.TypeOf((*MockBatchUpdater)(nil).Nodes))
}

// Relationships mocks base method.
func (m *MockBatchUpdater) Relationships() graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Relationships")
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Relationships indicates an expected call of Relationships.
func (mr *MockBatchUpdaterMockRecorder) Relationships() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Relationships", reflect.TypeOf((*MockBatchUpdater)(nil).Relationships))
}

// UpdateNodeBy mocks base method.
func (m *MockBatchUpdater) UpdateNodeBy(update graph.NodeUpdate) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateNodeBy", update)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateNodeBy indicates an expected call of UpdateNodeBy.
func (mr *MockBatchUpdaterMockRecorder) UpdateNodeBy(update any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateNodeBy", reflect.TypeOf((*MockBatchUpdater)(nil).UpdateNodeBy), update)
}

// UpdateRelationshipBy mocks base method.
func (m *MockBatchUpdater) UpdateRelationshipBy(update graph.RelationshipUpdate) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateRelationshipBy", update)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateRelationshipBy indicates an expected call of UpdateRelationshipBy.
func (mr *MockBatchUpdaterMockRecorder) UpdateRelationshipBy(update any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateRelationshipBy", reflect.TypeOf((*MockBatchUpdater)(nil).UpdateRelationshipBy), update)
}
