"use strict";

exports.__esModule = true;
exports.createStoreHook = createStoreHook;
exports.useStore = void 0;

var _Context = require("../components/Context");

var _useReduxContext = require("./useReduxContext");

/**
 * Hook factory, which creates a `useStore` hook bound to a given context.
 *
 * @param {React.Context} [context=ReactReduxContext] Context passed to your `<Provider>`.
 * @returns {Function} A `useStore` hook bound to the specified context.
 */
function createStoreHook(context = _Context.ReactReduxContext) {
  const useReduxContext = // @ts-ignore
  context === _Context.ReactReduxContext ? _useReduxContext.useReduxContext : // @ts-ignore
  (0, _useReduxContext.createReduxContextHook)(context);
  return function useStore() {
    const {
      store
    } = useReduxContext(); // @ts-ignore

    return store;
  };
}
/**
 * A hook to access the redux store.
 *
 * @returns {any} the redux store
 *
 * @example
 *
 * import React from 'react'
 * import { useStore } from 'react-redux'
 *
 * export const ExampleComponent = () => {
 *   const store = useStore()
 *   return <div>{store.getState()}</div>
 * }
 */


const useStore = /*#__PURE__*/createStoreHook();
exports.useStore = useStore;