---
bh-rfc: <!-- choose the next integer value that is one greater than the greatest RFC number in `main` in the repo's rfc/ folder. This number may need to change if other RFCs merge into main before it. -->
title: <!-- choose a succinct title -->
authors: |
    <!-- [Author 1](auther1@domain.com) -->
    <!-- [Author 2](author2@domain.com) -->
status: DRAFT <!-- DRAFT, ACCEPTED, SUPERSEDED BY <RFC identifier> -->
created: 2025-04-15
audiences: |
    <!-- Optional: list the indended audience -->
---

<!--
    Use this RFC template when:
    - Proposing a significant architectural change
    - Introducing or modifying core processes or policies
    - Standardizing behaviors that require cross-team alignment
    For small changes, consider if a GitHub issue or PR is sufficient.
-->

# Title <!-- make this the same as the title in the YAML section at the top -->

<!-- an optional image or high level diagram may be placed here -->

## 1. Overview

A high-level summary of what the RFC covers must follow the overview heading. The summary should be succinct and limited to a few sentences.

## 2. Motivation & Goals

Include contextual information about the proposal (e.g., current state, challenges, reasons, etc.) and a bulleted list of succinct goals.

-   **Goal 1** - Describe goal 1
-   **Goal 2** - Describe goal 2

## 3. Considerations

This section is optional and may contain several subsections titled with [third-level headings](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax#headings) with sequential sub-section numbering (e.g., 3.1, 3.2, 3.3). Each subsection should detail the specific context that was taken into account when authoring the proposal.

#### 3.1 Recommended subsections

The recommended subsections are optional and not limited to:

-   **Impact on Existing Systems**
    -   state how the proposal affects current workflows, systems, repositories, architecture, etc.
    -   include recommendations for migration or impact mitigation
-   **Security & Compliance**
    -   describe security risks or enhancements
    -   describe impact to compliance standards
    -   describe impact to data privacy
-   **Drawbacks & Alternatives**
    -   outline drawbacks to the proposal
    -   describe alternative solutions
    -   describe any trade-offs
-   **Quality**
    -   describe the potential impact to stability, performance, and user experience
    -   describe mitigations that prevent deviations from quality standards
-   **Audience**
    -   when applicable to specific audiences, describe who the target audiences are for the proposal
-   **Implementation Plan**
    -   describe a plan for how to introduce the proposed changes

## 4. Details of the Proposal

Flesh out your detailed proposal here. Each section must begin with a [second-level heading](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax#headings) containing the next sequential section number followed by an appropriate title.

### 4.1 Proposal sub-headings

You can add subsections titled with [third-level headings](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax#headings) with sequential sub-section numbering (e.g., 4.1, 4.2, 4.3). The organization of the proposal's sections and subsections is at your discretion.
