// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0
import { GraphData } from 'js-client-library';

export const cypherTestResponse = {
    data: {
        node_keys: [
            'admincount',
            'description',
            'displayname',
            'distinguishedname',
            'domain',
            'domainsid',
            'dontreqpreauth',
            'email',
            'enabled',
            'gmsa',
            'hasspn',
            'isaclprotected',
            'lastcollected',
            'lastlogon',
            'lastlogontimestamp',
            'lastseen',
            'msa',
            'name',
            'objectid',
            'ownersid',
            'passwordnotreqd',
            'pwdlastset',
            'pwdneverexpires',
            'samaccountname',
            'sensitive',
            'serviceprincipalnames',
            'sidhistory',
            'system_tags',
            'title',
            'trustedtoauth',
            'unconstraineddelegation',
            'whencreated',
        ],
        edges: [],
        nodes: {
            '108': {
                label: 'T1_TONYMONTANA@PHANTOM.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2697957641-2271029196-387917394-2110',
                isTierZero: false,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.306Z',
                properties: {
                    admincount: true,
                    displayname: 'T1_TonyMontana',
                    distinguishedname: 'CN=T1_TONYMONTANA,OU=USERS,OU=TIER1,DC=PHANTOM,DC=CORP',
                    domain: 'PHANTOM.CORP',
                    domainsid: 'S-1-5-21-2697957641-2271029196-387917394',
                    dontreqpreauth: false,
                    enabled: true,
                    hasspn: false,
                    isaclprotected: true,
                    lastcollected: '2025-07-09T00:28:46.055264963Z',
                    lastlogon: 1674216447,
                    lastlogontimestamp: 1673626093,
                    lastseen: '2025-07-09T00:28:46.306Z',
                    name: 'T1_TONYMONTANA@PHANTOM.CORP',
                    objectid: 'S-1-5-21-2697957641-2271029196-387917394-2110',
                    ownersid: 'S-1-5-21-2697957641-2271029196-387917394-512',
                    passwordnotreqd: false,
                    pwdlastset: 1664381451,
                    pwdneverexpires: true,
                    samaccountname: 'T1_TonyMontana',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1664356251,
                },
            },
            '489': {
                label: 'ZZZIGNE@PHANTOM.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2697957641-2271029196-387917394-2216',
                isTierZero: false,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.292Z',
                properties: {
                    admincount: false,
                    displayname: 'zzzigne',
                    distinguishedname: 'CN=ZZZIGNE,OU=USERS,OU=TIER1,DC=PHANTOM,DC=CORP',
                    domain: 'PHANTOM.CORP',
                    domainsid: 'S-1-5-21-2697957641-2271029196-387917394',
                    dontreqpreauth: false,
                    enabled: true,
                    hasspn: false,
                    isaclprotected: false,
                    lastcollected: '2025-07-09T00:28:46.055264963Z',
                    lastlogon: 0,
                    lastlogontimestamp: -1,
                    lastseen: '2025-07-09T00:28:46.292Z',
                    name: 'ZZZIGNE@PHANTOM.CORP',
                    objectid: 'S-1-5-21-2697957641-2271029196-387917394-2216',
                    ownersid: 'S-1-5-21-2697957641-2271029196-387917394-512',
                    passwordnotreqd: false,
                    pwdlastset: 1707939756,
                    pwdneverexpires: true,
                    samaccountname: 'zzzigne',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1707910956,
                },
            },
            '490': {
                label: 'SVC_SHS@PHANTOM.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2697957641-2271029196-387917394-2165',
                isTierZero: false,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.292Z',
                properties: {
                    admincount: false,
                    displayname: 'svc_shs',
                    distinguishedname: 'CN=SVC_SHS,OU=SHARPHOUND TEST,DC=PHANTOM,DC=CORP',
                    domain: 'PHANTOM.CORP',
                    domainsid: 'S-1-5-21-2697957641-2271029196-387917394',
                    dontreqpreauth: false,
                    enabled: true,
                    hasspn: false,
                    isaclprotected: false,
                    lastcollected: '2025-07-09T00:28:46.055264963Z',
                    lastlogon: 0,
                    lastlogontimestamp: -1,
                    lastseen: '2025-07-09T00:28:46.292Z',
                    name: 'SVC_SHS@PHANTOM.CORP',
                    objectid: 'S-1-5-21-2697957641-2271029196-387917394-2165',
                    ownersid: 'S-1-5-21-2697957641-2271029196-387917394-512',
                    passwordnotreqd: false,
                    pwdlastset: 1678309565,
                    pwdneverexpires: true,
                    samaccountname: 'svc_shs',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1678280765,
                },
            },
            '491': {
                label: 'NETWORK SERVICE@PHANTOM.CORP',
                kind: 'User',
                objectId: 'PHANTOM.CORP-S-1-5-20',
                isTierZero: false,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.055264963Z',
                properties: {
                    domain: 'PHANTOM.CORP',
                    domainsid: 'S-1-5-21-2697957641-2271029196-387917394',
                    lastcollected: '2025-07-09T00:28:46.055264963Z',
                    lastseen: '2025-07-09T00:28:46.055264963Z',
                    name: 'NETWORK SERVICE@PHANTOM.CORP',
                    objectid: 'PHANTOM.CORP-S-1-5-20',
                },
            },
            '569': {
                label: 'TOM@GHOST.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2845847946-3451170323-4261139666-1105',
                isTierZero: true,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.525Z',
                properties: {
                    admincount: true,
                    displayname: 'tom',
                    distinguishedname: 'CN=TOM,CN=USERS,DC=GHOST,DC=CORP',
                    domain: 'GHOST.CORP',
                    domainsid: 'S-1-5-21-2845847946-3451170323-4261139666',
                    dontreqpreauth: false,
                    enabled: false,
                    hasspn: false,
                    isaclprotected: true,
                    lastcollected: '2025-07-09T00:28:46.504907963Z',
                    lastlogon: 1352620493,
                    lastlogontimestamp: 1352620493,
                    lastseen: '2025-07-09T00:28:46.525Z',
                    name: 'TOM@GHOST.CORP',
                    objectid: 'S-1-5-21-2845847946-3451170323-4261139666-1105',
                    ownersid: 'S-1-5-21-2845847946-3451170323-4261139666-512',
                    passwordnotreqd: false,
                    pwdlastset: 1294408493,
                    pwdneverexpires: true,
                    samaccountname: 'tom',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    system_tags: 'admin_tier_0',
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1107163853,
                },
            },
            '570': {
                label: 'WALTER@GHOST.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2845847946-3451170323-4261139666-1106',
                isTierZero: true,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.525Z',
                properties: {
                    admincount: true,
                    displayname: 'walter',
                    distinguishedname: 'CN=WALTER,CN=USERS,DC=GHOST,DC=CORP',
                    domain: 'GHOST.CORP',
                    domainsid: 'S-1-5-21-2845847946-3451170323-4261139666',
                    dontreqpreauth: false,
                    enabled: false,
                    hasspn: false,
                    isaclprotected: true,
                    lastcollected: '2025-07-09T00:28:46.504907963Z',
                    lastlogon: 1221657838,
                    lastlogontimestamp: 1221657838,
                    lastseen: '2025-07-09T00:28:46.525Z',
                    name: 'WALTER@GHOST.CORP',
                    objectid: 'S-1-5-21-2845847946-3451170323-4261139666-1106',
                    ownersid: 'S-1-5-21-2845847946-3451170323-4261139666-512',
                    passwordnotreqd: false,
                    pwdlastset: 1117877458,
                    pwdneverexpires: true,
                    samaccountname: 'walter',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    system_tags: 'admin_tier_0',
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1107164693,
                },
            },
            '571': {
                label: 'ADMINISTRATOR@GHOST.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2845847946-3451170323-4261139666-500',
                isTierZero: true,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.525Z',
                properties: {
                    admincount: true,
                    description: 'Built-in account for administering the computer/domain',
                    distinguishedname: 'CN=ADMINISTRATOR,CN=USERS,DC=GHOST,DC=CORP',
                    domain: 'GHOST.CORP',
                    domainsid: 'S-1-5-21-2845847946-3451170323-4261139666',
                    dontreqpreauth: false,
                    enabled: true,
                    hasspn: false,
                    isaclprotected: true,
                    lastcollected: '2025-07-09T00:28:46.504907963Z',
                    lastlogon: 1702913193,
                    lastlogontimestamp: 1702913054,
                    lastseen: '2025-07-09T00:28:46.525Z',
                    name: 'ADMINISTRATOR@GHOST.CORP',
                    objectid: 'S-1-5-21-2845847946-3451170323-4261139666-500',
                    ownersid: 'S-1-5-21-2845847946-3451170323-4261139666-512',
                    passwordnotreqd: false,
                    pwdlastset: 1674763808,
                    pwdneverexpires: true,
                    samaccountname: 'Administrator',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    system_tags: 'admin_tier_0',
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1656555664,
                },
            },
            '572': {
                label: 'GUEST@GHOST.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2845847946-3451170323-4261139666-501',
                isTierZero: false,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.525Z',
                properties: {
                    admincount: false,
                    description: 'Built-in account for guest access to the computer/domain',
                    distinguishedname: 'CN=GUEST,CN=USERS,DC=GHOST,DC=CORP',
                    domain: 'GHOST.CORP',
                    domainsid: 'S-1-5-21-2845847946-3451170323-4261139666',
                    dontreqpreauth: false,
                    enabled: false,
                    hasspn: false,
                    isaclprotected: false,
                    lastcollected: '2025-07-09T00:28:46.504907963Z',
                    lastlogon: 0,
                    lastlogontimestamp: -1,
                    lastseen: '2025-07-09T00:28:46.525Z',
                    name: 'GUEST@GHOST.CORP',
                    objectid: 'S-1-5-21-2845847946-3451170323-4261139666-501',
                    ownersid: 'GHOST.CORP-S-1-5-32-544',
                    passwordnotreqd: true,
                    pwdlastset: 0,
                    pwdneverexpires: true,
                    samaccountname: 'Guest',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1656555664,
                },
            },
            '82': {
                label: 'ALICE@PHANTOM.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2697957641-2271029196-387917394-2173',
                isTierZero: true,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.292Z',
                properties: {
                    admincount: true,
                    displayname: 'alice',
                    distinguishedname: 'CN=ALICE,OU=USERS,OU=TIER1,DC=PHANTOM,DC=CORP',
                    domain: 'PHANTOM.CORP',
                    domainsid: 'S-1-5-21-2697957641-2271029196-387917394',
                    dontreqpreauth: false,
                    enabled: true,
                    hasspn: false,
                    isaclprotected: true,
                    lastcollected: '2025-07-09T00:28:46.055264963Z',
                    lastlogon: 0,
                    lastlogontimestamp: -1,
                    lastseen: '2025-07-09T00:28:46.292Z',
                    name: 'ALICE@PHANTOM.CORP',
                    objectid: 'S-1-5-21-2697957641-2271029196-387917394-2173',
                    ownersid: 'S-1-5-21-2697957641-2271029196-387917394-512',
                    passwordnotreqd: false,
                    pwdlastset: 1681286877,
                    pwdneverexpires: true,
                    samaccountname: 'alice',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    system_tags: 'admin_tier_0',
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1681261677,
                },
            },
            '9': {
                label: 'CERTMAN@PHANTOM.CORP',
                kind: 'User',
                objectId: 'S-1-5-21-2697957641-2271029196-387917394-2201',
                isTierZero: true,
                isOwnedObject: false,
                lastSeen: '2025-07-09T00:28:46.292Z',
                properties: {
                    admincount: true,
                    displayname: 'certman',
                    distinguishedname: 'CN=CERTMAN,OU=USERS,OU=TIER0,DC=PHANTOM,DC=CORP',
                    domain: 'PHANTOM.CORP',
                    domainsid: 'S-1-5-21-2697957641-2271029196-387917394',
                    dontreqpreauth: false,
                    enabled: true,
                    hasspn: false,
                    isaclprotected: true,
                    lastcollected: '2025-07-09T00:28:46.055264963Z',
                    lastlogon: 1695966948,
                    lastlogontimestamp: 1695966443,
                    lastseen: '2025-07-09T00:28:46.292Z',
                    name: 'CERTMAN@PHANTOM.CORP',
                    objectid: 'S-1-5-21-2697957641-2271029196-387917394-2201',
                    ownersid: 'S-1-5-21-2697957641-2271029196-387917394-512',
                    passwordnotreqd: false,
                    pwdlastset: 1695966321,
                    pwdneverexpires: true,
                    samaccountname: 'certman',
                    sensitive: false,
                    serviceprincipalnames: [],
                    sidhistory: [],
                    system_tags: 'admin_tier_0',
                    trustedtoauth: false,
                    unconstraineddelegation: false,
                    whencreated: 1695941121,
                },
            },
        },
    },
} satisfies { data: GraphData };
