# Contributing

Contributions are always welcome, no matter how large or small. Before contributing, please read the [code of conduct](CODE_OF_CONDUCT.md).

**First**: if you're unsure or afraid of anything, just ask or submit the issue or pull request anyways. You won't be yelled at for giving your best effort. The worst that can happen is that you'll be politely asked to change something. We appreciate any sort of contributions, and don't want a wall of rules to get in the way of that.

Much of the [prelude of Babel's Contributing guide](https://github.com/babel/babel/blob/master/CONTRIBUTING.md) also applies here since babel-minify is just a set of babel plugins, a preset and tools built on top of these things with babel itself.

## Useful links

+ [AST Explorer](https://astexplorer.net)
+ [Babel plugin handbook](https://github.com/thejameskyle/babel-handbook/blob/master/translations/en/plugin-handbook.md#babel-plugin-handbook)

## Chat

Feel free to check out the [#minify](https://babeljs.slack.com/messages/minify/) channel on our Slack. You can request access here - https://slack.babeljs.io

## Developing

To help develop babel-minify, check out the [`docs/`](docs) directory.

When you feel ready to jump into babel-minify source code, a good place to start is to look for issues tagged with [help wanted](https://github.com/babel/minify/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22) and/or [good first issue](https://github.com/babel/minify/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22).
