// Copyright (C) 2022 Specter Ops, Inc.
//
// This file is part of AzureHound.
//
// AzureHound is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// AzureHound is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

package azure

import "github.com/gofrs/uuid"

// Represents a password credential associated with an application or a service principal.
// For more detail see https://docs.microsoft.com/en-us/graph/api/resources/passwordcredential?view=graph-rest-1.0
type PasswordCredential struct {
	// Friendly name for the password. Optional.
	DisplayName string `json:"displayName,omitempty"`

	// The date and time at which the password expires represented using ISO 8601 format and is always in UTC time.
	// For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Optional.
	EndDateTime string `json:"endDateTime,omitempty"`

	// Contains the first three characters of the password. Read-only.
	Hint string `json:"hint,omitempty"`

	// The unique identifier for the password.
	KeyId uuid.UUID `json:"keyId,omitempty"`

	// Read-only; Contains the strong passwords generated by Azure AD that are 16-64 characters in length.
	// The generated password value is only returned during the initial POST request to addPassword. There is no way to
	// retrieve this password in the future.
	SecretText string `json:"secretText,omitempty"`

	// The date and time at which the password becomes valid. The Timestamp type represents date and time information
	// using ISO 8601 format and is always in UTC time.
	// For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Optional.
	StartDateTime string `json:"startDateTime,omitempty"`
}
